local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local radialblur = {}

function radialblur:SetBlurCenter(center)
  --print("Blur Center is: " .. tostring(center));
  --print("Blur Size is: " .. tostring(self.size));
  self.Dn:SetParameter(self.BLUR_CENTER, mathfunction.vector2( center:x()/self.size:x(), center:y()/self.size:y() ) );
end

function radialblur:SetBlurScale(scale)
  self.Dn:SetParameter(self.BLUR_SCALE, mathfunction.vector1(scale:x() * 0.00018) );
end

function radialblur:Initialize(host, size)
  self.Dn = 0;
  self.Queue = 100;
  --self.size = size;
  self.size = mathfunction.vector2(size:x(),size:y());
  self.BlurCenter = mathfunction.vector2(size:x()/2, size:y()/2);
  self.BlurScale = mathfunction.vector1(0);
    --<!--  set the center parameters in fragment shader -->
  self.BLUR_CENTER = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"UNIFORM_BLUR_CENTER");
    
  self.BLUR_SCALE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"UNIFORM_BLUR_SCALE");

  self.POST_EFFECT_ALPHA = apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,
    "POST_EFFECT_ALPHA");

  self.Dn = host:CreateRenderObject("comm:documents/material/radialblur.material" );
  
  self:SetBlurCenter(self.BlurCenter);
  self:SetBlurScale(self.BlurScale );

  self.Dn:SetParameter(self.POST_EFFECT_ALPHA, mathfunction.vector1(1.0));
  
  host:RegisterScriptParameter(self,"BlurScale");
  host:RegisterScriptParameter(self,"BlurCenter");
  return self.Queue;
end

function radialblur:Resizeview(size)
  --self.size = size;
  self.size = mathfunction.vector2(size:x(),size:y());
  print("Resizeview size is: " .. tostring(self.size));
  self.center = mathfunction.vector2(size:x()/2, size:y()/2);
  self:SetBlurCenter(self.center);
end

function radialblur:Process(pipeline, Original, Scene, Output)
  self:SetBlurCenter(self.BlurCenter);
  --print("Blur Center is:" .. tostring(self.BlurCenter));
  self:SetBlurScale(self.BlurScale );
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Dn:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.Dn:Draw(pipeline);
end

return radialblur;