local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local OutlineExpand = {}
OutlineExpand.Do = 0;
OutlineExpand.Queue = 310;

function OutlineExpand:Initialize(host, size)
  self.sigma = mathfunction.vector1(0.0);

  self.SIGMA = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "SIGMA");
  self.TARGETSIZE = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "TARGETSIZE");

  local pathout = venuscore.IFileSystem:PathAssembly("comm:documents/material/outline_expand.material");
  self.Do = host:CreateRenderObject(pathout);

  self.Do:SetParameter(self.TARGETSIZE,size);
  self.Do:SetParameter(self.SIGMA, self.sigma);

  host:RegisterScriptParameter(self, "sigma");
  return self.Queue;
end



function OutlineExpand:Resizeview(size)
  self.Do:SetParameter(self.TARGETSIZE,size);
end

function OutlineExpand:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Do:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );

  self.Do:SetParameter(self.SIGMA, self.sigma);
	self.Do:Draw(pipeline);
end

return OutlineExpand;