local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local Outline = {}
Outline.Do = 0;
Outline.Queue = 310;

function Outline:Initialize(host, size)
  self.TARGETSIZE = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "TARGETSIZE");

  local pathout = venuscore.IFileSystem:PathAssembly("comm:documents/material/outline.material");
  self.Do = host:CreateRenderObject(pathout);

  self.Do:SetParameter(self.TARGETSIZE,size);

  return self.Queue;
end



function Outline:Resizeview(size)
  self.Do:SetParameter(self.TARGETSIZE,size);
end

function Outline:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Do:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );

	self.Do:Draw(pipeline);
end

return Outline;