local ae = require "apolloengine"
local mf = require "mathfunction"
local vc = require "venuscore"

local MedianBlur = {}

function MedianBlur:_UpdateParameter()
  local rad = self.angle / 180.0 * math.pi
  self.step = mf.vector2(
    math.cos(rad),
    math.sin(rad)
  ) * self.length
end

function MedianBlur:Initialize(host, size)
  local uniforms = 
  {
    "_MainTex", "_MainSize", "_Step",
  }
  for i = 1, #uniforms do
    self[uniforms[i]] = ae.IMaterialSystem:NewParameterSlot(
      ae.ShaderEntity.UNIFORM,
      uniforms[i]
    )
  end

  self.angle = 0
  self.length = 0.0
  self.step = mf.vector2(0.0, 0.0)
  
  self:_UpdateParameter()
  
  self.roMedian = host:CreateRenderObject("comm:documents/material/median.material")
  self.roMedian:SetParameter(self._MainSize, size)
  self.roMedian:SetParameter(self._Step, self.step)
  
  host:RegisterScriptParameter(self, "angle")
  host:RegisterScriptParameter(self, "length")

  return 310
end



function MedianBlur:Resizeview(size)
  self.roMedian:SetParameter(self._MainSize, size)
end

function MedianBlur:Process(pipeline, Original, Scene, Output)
  self:_UpdateParameter()
  Output:PushRenderTarget()
  Output:ClearBuffer(ae.RenderTargetEntity.CF_COLOR)
  self.roMedian:SetParameter(self._Step, self.step)
  self.roMedian:SetParameter(
    self._MainTex,
    Scene:GetAttachment(ae.RenderTargetEntity.TA_COLOR_0)
  )
  self.roMedian:Draw(pipeline)
end

return MedianBlur