local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local laplacesharp = {}
laplacesharp.Do = 0;
laplacesharp.Queue = 310;

function laplacesharp:Initialize(host, size)
  self.sharpStrength = mathfunction.vector1(0);
  
  self.SHARPEN_STRENGTH = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "SHARPEN_STRENGTH");
    
  self.TARGETSIZE = apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,
    "TARGETSIZE");
  
  self.LAPLACE_COORDNATE = apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.INTERNAL,
    "LAPLACE_COORDNATE");
  
  local pathout = venuscore.IFileSystem:PathAssembly("comm:documents/material/laplacesharp.material");  
  self.Do = host:CreateRenderObject(pathout);
  
  self.Do:SetParameter(self.TARGETSIZE,size);
  self.Do:SetParameter(self.SHARPEN_STRENGTH,mathfunction.vector1(self.sharpStrength:x()/40));
  
  host:RegisterScriptParameter(self,"sharpStrength");
  return self.Queue;
end



function laplacesharp:Resizeview(size)
  self.Do:SetParameter(self.TARGETSIZE,size);
end

function laplacesharp:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Do:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  
  self.Do:SetParameter(self.SHARPEN_STRENGTH,mathfunction.vector1(self.sharpStrength:x()/40));
	self.Do:Draw(pipeline);
end

return laplacesharp;