local venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local bloom = {}
bloom.RoLumi = 0
bloom.RoGuassX = 0
bloom.RoGuassY = 0
bloom.RoCombine = 0
bloom.Rt1 = 0;
bloom.Rt2 = 0;

bloom.Queue = 500;

function bloom:Initialize(host, size)
  
  self.step = mathfunction.vector2( 2.0, 2.0 );

  self.combineweight = mathfunction.vector2( 1.0, 2.0 );
  self.scale1 = mathfunction.vector2( 0.25, 0.25 );
  self.scale2 = mathfunction.vector2( 0.125, 0.125 );
  
  self.COMBINE_WEIRHT = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "COMBINE_WEIRHT");
    
  self.GAUSSIAN_STEP = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "GAUSSIAN_STEP");
    
  self.LUMINACE_THRESHOLD = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "LUMINACE_THRESHOLD");
    
  self.GAUSSUAN_COORDNATE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.INTERNAL,
      "GAUSSUAN_COORDNATE");      
  
  
  self.bloomtex = apolloengine.TextureEntity();
  
  self.targetsize = size / 4;
  self.targetsize2 = size / 8;
  local GuassStep = mathfunction.vector2( 2.0, 2.0 ) / self.targetsize;

	
	
	self.RoGuassX = host:CreateRenderObject( "comm:documents/material/gaussianblur.material" );
	self.RoGuassX:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep:x(), 0 ) );
	
	self.RoGuassY = host:CreateRenderObject( "comm:documents/material/gaussianblur.material" );
	self.RoGuassY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep:y() ) );
	
	self.RoCombine = host:CreateRenderObject( "comm:documents/material/combine.material" );
	self.RoCombine:SetParameter( self.COMBINE_WEIRHT, self.combineweight );
	
  self.Rt1 = host:CreateRenderTarget( 
      apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_A,
        mathfunction.vector4(self.targetsize:x(),self.targetsize:y(),0,0),
        self.targetsize,
        self.scale1), 
      apolloengine.TextureRenderMetadata(
        apolloengine.RenderTargetEntity.ST_SWAP_A,
        self.targetsize));
    
  self.Rt2 = host:CreateRenderTarget( 
     apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_B,
        mathfunction.vector4(self.targetsize:x(),self.targetsize:y(),0,0),
        self.targetsize,
        self.scale1), 
      apolloengine.TextureRenderMetadata(
        apolloengine.RenderTargetEntity.ST_SWAP_B,
        self.targetsize));
    
  self.Rt3 = host:CreateRenderTarget( 
      apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_C,
        mathfunction.vector4(self.targetsize2:x(),self.targetsize2:y(),0,0),
        self.targetsize2,
        self.scale2), 
      apolloengine.TextureRenderMetadata(
        apolloengine.RenderTargetEntity.ST_SWAP_C,
        self.targetsize2));
    
  self.Rt4 = host:CreateRenderTarget( 
      apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_D,
        mathfunction.vector4(self.targetsize2:x(),self.targetsize2:y(),0,0),
        self.targetsize2,
        self.scale2), 
      apolloengine.TextureRenderMetadata(
        apolloengine.RenderTargetEntity.ST_SWAP_D,
        self.targetsize2));

  host:RegisterScriptParameter(self,"bloomtex");
  
  host:RegisterScriptParameter(self,"step");

  host:RegisterScriptParameter(self,"combineweight");
  
  host:RegisterScriptParameter(self,"combineweight");
  
  return self.Queue;
end

function bloom:Resizeview(size)
	self.targetsize = size / 4;
	local GuassStep = mathfunction.vector2( 2.0, 2.0 ) / self.targetsize;

	self.RoGuassX:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep:x(), 0 ) );
	self.RoGuassY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep:y() ) );
end


function bloom:Process(pipeline, Original, Scene, Output)
	
  self:_Updateparameters()
  

		
	self.Rt2:PushRenderTarget();
	self.Rt2:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  --[[
	self.RoGuassX:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );]]
  self.RoGuassX:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.bloomtex );
  
  
  
	self.RoGuassX:Draw(pipeline);
		
	self.Rt1:PushRenderTarget();
	self.Rt1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
	self.RoGuassY:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.RoGuassY:Draw(pipeline);
	
	self.Rt2:PushRenderTarget();
	self.Rt2:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
	self.RoGuassX:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.RoGuassX:Draw(pipeline);
	
	self.Rt1:PushRenderTarget();
	self.Rt1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
	self.RoGuassY:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.RoGuassY:Draw(pipeline);	
  
  self.Rt3:PushRenderTarget();
	self.Rt3:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
	self.RoGuassX:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.RoGuassX:Draw(pipeline);	
  
  self.Rt4:PushRenderTarget();
	self.Rt4:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
	self.RoGuassY:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.Rt3:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.RoGuassY:Draw(pipeline);	
		
	Output:PushRenderTarget();
	Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
	self.RoCombine:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.RoCombine:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_GLOSSINESS,
		self.Rt4:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.RoCombine:Draw(pipeline);
end

function bloom: _Updateparameters()
    local GuassStep = self.step / self.targetsize;
    self.RoGuassX:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep:x(), 0 ) );
    self.RoGuassY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep:y() ) );
    --self.RoLumi:SetParameter(self.LUMINACE_THRESHOLD, mathfunction.vector1( self.luminace:x()) );
    self.RoCombine:SetParameter( self.COMBINE_WEIRHT, self.combineweight );
end

return bloom;