
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local brightenscale = {}

brightenscale.renderObject = nil
brightenscale.queue = 100
brightenscale.BrightenScale = mathfunction.vector1(0.0)

function brightenscale:Initialize(host, size)

  self.BRIGHTEN_SCALE = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "BRIGHTEN_SCALE")

  self.renderObject = host:CreateRenderObject("comm:documents/material/brighten_scale.material")
  self:UpdateParameters()
  host:RegisterScriptParameter(self,"BrightenScale");
  
  return self.queue
end

function brightenscale:Resizeview(size)

end

function brightenscale:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget()
  Output:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR)

  self.renderObject:SetParameter(
          apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
          Scene:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0));

  self:UpdateParameters()
  self.renderObject:Draw(pipeline)
end

function brightenscale:UpdateParameters()
  self.renderObject:SetParameter(self.BRIGHTEN_SCALE, mathfunction.vector1(self.BrightenScale:x()*0.01))
end

return brightenscale;