local apollocore = require "apollocore"
local mf = require "mathfunction"
local cv = require "computervisionfunction"
local EventDispatcher = require "bluecore.eventdispatcher"

local _nativeUpdate = apollocore.IComponent.Update;

local gLastEvent = {}
local _fNativeDestroy = apollocore.IComponent.Destroy;
rawset(cv.ClassifyComponent, "Destroy", function(self)
  local staticID =  self:GetContentPath();
  --for id, _ in pairs(gLastEvent) do
  --  ERROR("Classify LastEvent staticID: "..tostring(id))
  --end
  gLastEvent[staticID] = nil
  _fNativeDestroy(self);
end);

rawset(cv.ClassifyComponent, "ResetCached", function(self)
  local staticID =  self:GetContentPath();
  gLastEvent[staticID] = nil
end);

local CONST_DEFAULT_VEC2 = mf.vector2(0,0);

local _Updatefunc = function(self, dt)
  _nativeUpdate(self, dt);

  local staticID =  self:GetContentPath() ;

  if EventDispatcher:HasCompListener(staticID) then -- 只有对于这个Component有监听者才dispatch

    local size = self:GetDetectSize();
    local width = size:x();
    local height = size:y();

    local currentEvents = {}
    local lastEvents = gLastEvent[staticID];

    local results = self:GetResult(); -- results[bodyIndex] 第bodyIndex人的表情和手势集合
    if next(results) ~= nil then
      for bodyIndex, actions in pairs(results) do
        for index, action in pairs(actions) do --  results[bodyIndex][i] 第bodyIndex人的第i个表情/手势
          local eventType = action.ActionID ;

          -- 根据是否有事件处理 然后找到事件进行分发
          if EventDispatcher:HasEventListener(staticID, eventType) then

            local isEdge = true ;
            if lastEvents and lastEvents[eventType] and lastEvents[eventType][bodyIndex] then
              lastEvents[eventType][bodyIndex] = false -- 代表这次update有这个事件 不会触发release
              isEdge = false
            end

            local event = {
              staticID = staticID,
              eventType = eventType,
              params = {
                humanId = bodyIndex,
                point = mf.vector2(action.Rect[1]/width, action.Rect[2]/height),
                size = mf.vector2(action.Rect[3]/width, action.Rect[4]/height),
                indexPoint = mf.vector2(action.Rect[5]/width, action.Rect[6]/height),
                isHigh = true ,    -- 电平触发(提供事件节点执行哪个流程)
                isEdge = isEdge,   -- 边沿触发(有可能后续需要手掌或者人脸框信息更新贴纸位置)
                isFingerUp = action.HandFingerUp,
                curType = action.ActionID,
                numHand = table.getn(results)
              }
            };

            --LOG("---- " ..tostring(width)..","..tostring(height))
            --LOG("------ "..tostring(action.Rect[1])..","..tostring(action.Rect[2]))
            --LOG("------ "..tostring(event.params.point:x())..","..tostring(event.params.point:y()))

            EventDispatcher:PushEvent(event);

            -- 把自己分发过的事件存储起来
            currentEvents[eventType] = currentEvents[eventType] or {}
            currentEvents[eventType][bodyIndex] = true

          end
        end
      end
    end

    gLastEvent[staticID] = currentEvents;

    if lastEvents then
      for eventType, bodys in pairs(lastEvents) do
        -- 如果是上次发送的事件 这次不处理
        -- if EventDispatcher:HasEventListener(staticID, eventType) then
        for bodyIndex , flag in pairs(bodys) do
          if flag then -- 代表上次update有这个事件 这次update没有这个事件
            local event = {
              staticID = staticID,
              eventType = eventType,
              params = {
                humanId = bodyIndex,
                point = CONST_DEFAULT_VEC2,
                size = CONST_DEFAULT_VEC2,
                indexPoint = CONST_DEFAULT_VEC2,
                isHigh = false ,
                isEdge = true,      -- release事件(低电平)只有边沿触发
                isFingerUp = false
              }
            }
            EventDispatcher:PushEvent(event);
          end
        end
      end
    end
  end -- HasCompListener

end
rawset(cv.ClassifyComponent, "Update", _Updatefunc);
