

#DEFPARAMS
TEXELSIZE = { "TexelSize", VEC2, "0.0,0.0" },
#END

#DEFTAG
ShaderName = "SuperMeBlur"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE;
float2 TEXELSIZE;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
    float2 aroundCoord[4];
    float4 d = float4(-TEXELSIZE.x, -TEXELSIZE.y, TEXELSIZE.x, TEXELSIZE.y);
    
    aroundCoord[0] = i.uv + d.xy;
    aroundCoord[1] = i.uv + d.zy;
    aroundCoord[2] = i.uv + d.xw;
    aroundCoord[3] = i.uv + d.zw;
    
    fixed4 out_SurfaceColor;
    out_SurfaceColor  = tex2D( TEXTURE_DIFFUSE, aroundCoord[0] );
    out_SurfaceColor += tex2D( TEXTURE_DIFFUSE, aroundCoord[1] );
    out_SurfaceColor += tex2D( TEXTURE_DIFFUSE, aroundCoord[2] );
    out_SurfaceColor += tex2D( TEXTURE_DIFFUSE, aroundCoord[3] );

    out_SurfaceColor = out_SurfaceColor * 0.25;
    return out_SurfaceColor;
}
ENDCG
#END
