

function DefineParams()
	Properties = 
	{
		
_MainTex = {"main Color", TEXTURE2D, "white" },
_MaskTex = {"Move Mask", TEXTURE2D, "white"},
_Phase = { "Wave Phase", FLOAT, "0.02"},
_OffsetMount = {"Offset Mount", FLOATRANGE, "0.0, 1.0, 0.0"},
_FrameIndex = { "Frame Index", FLOAT , "1.0"},
_RegionCount = { "Frames Count", FLOAT, "4.0"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "WaveFilter"
RenderQueue = "POSTEFFECT"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_OffsetMount",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FrameIndex",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_RegionCount",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Phase",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _OffsetMount;
uniform highp float _FrameIndex;
uniform highp float _RegionCount;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = sin((3.141593 * _OffsetMount));
  xlv_TEXCOORD2 = ((1.0/(_RegionCount)) * (float(
    int(_FrameIndex)
  ) + 0.5));
  gl_Position = (tmpvar_1 * _glesVertex);
}

]===],
		psShader = [===[uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform highp float _Phase;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec2 maskCol_2;
  highp vec2 tmpvar_3;
  tmpvar_3.x = xlv_TEXCOORD2;
  tmpvar_3.y = xlv_TEXCOORD0.y;
  lowp vec2 tmpvar_4;
  tmpvar_4 = texture2D (_MaskTex, tmpvar_3).xy;
  maskCol_2 = tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = dot (vec2(1.0, -1.0), maskCol_2);
  highp float tmpvar_6;
  if ((tmpvar_5 > 0.0)) {
    tmpvar_6 = 1.0;
  } else {
    tmpvar_6 = tmpvar_5;
  };
  highp float tmpvar_7;
  if ((tmpvar_6 < 0.0)) {
    tmpvar_7 = -1.0;
  } else {
    tmpvar_7 = tmpvar_6;
  };
  highp vec2 tmpvar_8;
  tmpvar_8.x = (xlv_TEXCOORD0.x + ((xlv_TEXCOORD1 * _Phase) * tmpvar_7));
  tmpvar_8.y = xlv_TEXCOORD0.y;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, tmpvar_8);
  tmpvar_1 = tmpvar_9;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
}

end
