#DEFPARAMS
FRAME_SIZE     = {"FRAME_SIZE", VEC2, "16.0, 16.0"},
BLOCK_SIZE     = {"BLOCK_SIZE", VEC2, "16.0, 16.0"},
HISTOGRAM_SIZE = {"HISTOGRAM_SIZE", VEC2, "16.0, 16.0"},
CUR_FRAME      = {"CUR_FRAME", TEXTURE2D, "CUR_FRAME"},
#END

#DEFTAG
ShaderName = "HistogramGenStep"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE   = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
    float4 vertex : POSITION;
    float2 uv : TEXCOORD0;
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 vertex : SV_POSITION;
};

sampler2D CUR_FRAME;
float2    FRAME_SIZE;
float2    BLOCK_SIZE;
float2    HISTOGRAM_SIZE;

v2f vert(appdata v)
{
    v2f o;
    o.vertex = UniformNDC(v.vertex);
    o.uv = v.uv.xy;

    return o;
}

float4 frag(v2f i) : SV_Target
{
    float out_frag_idx_x = i.uv.x * HISTOGRAM_SIZE.x;
    float out_frag_idx_y = i.uv.y * HISTOGRAM_SIZE.y;
    int block_idx_x = int(out_frag_idx_x / 16);
    int block_idx_y = int(out_frag_idx_y / 16);
    int hist_entry_x = int(out_frag_idx_x - block_idx_x * 16);
    int hist_entry_y = int(out_frag_idx_y - block_idx_y * 16);
    int hist_entry = hist_entry_y * 16 + hist_entry_x;
    int in_frag_idx_start_x = block_idx_x * BLOCK_SIZE.x;
    int in_frag_idx_start_y = block_idx_y * BLOCK_SIZE.y;
    int in_frag_idx_end_x = in_frag_idx_start_x + BLOCK_SIZE.x;
    int in_frag_idx_end_y = in_frag_idx_start_y + BLOCK_SIZE.y;
    float2 in_tex_size_inv = float2(1.0 / FRAME_SIZE.x, 1.0 / FRAME_SIZE.y);
    float4 hist_entry_val = float4(0.0, 0.0, 0.0, 1.0);
    for(int idx_x = in_frag_idx_start_x; idx_x < in_frag_idx_end_x; ++idx_x)
    {
        for(int idx_y = in_frag_idx_start_y; idx_y < in_frag_idx_end_y; ++idx_y)
        {
            float2 in_tex_coord = float2(idx_x * in_tex_size_inv.x, idx_y * in_tex_size_inv.y);
            in_tex_coord.x = clamp(in_tex_coord.x, 0.0, 1.0);
            in_tex_coord.y = clamp(in_tex_coord.y, 0.0, 1.0);
            float4 color = tex2Dlod(CUR_FRAME, float4(in_tex_coord, 0., 0.));
            int luminance_level = int((0.299 * color.x + 0.587 * color.y + 0.114 * color.z) * 255 + 0.5);
            hist_entry_val.x += (luminance_level == hist_entry ? 1.0 : 0.0);
        }
    }
    hist_entry_val.x *= (1.0 / (BLOCK_SIZE.x * BLOCK_SIZE.y));
    return hist_entry_val;
}
ENDCG
#END