
function DefineParams()
	Properties = 
	{
		
BRIGHT_TEXTURE = { "Bright Tex", TEXTURE2D, 0.0,0.0 },
UNIFORM_LIGHT_COLOR = { "Offset", VEC3, "0.0,0.0,0.0" },
SAMPLES = { "Samples", FLOAT, "0.0" },
STEP = { "Step", FLOAT, "0.0" },
CENTER = {"Center", VEC2, "0.0, 0.0"},
RATIO = {"Ratio", FLOAT, "0.0"},

POST_EFFECT_ALPHA = {"post_effect_alpha", FLOAT, "0.0"},

	}
	Attributes = 
	{
		POST_EFFECT_ALPHA = "Keywords(POST_EFFECT_ALPHA_ON,POST_EFFECT_ALPHA_OFF)", 
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "ShineVolumnLight"
RenderQueue = "PostEffect"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {"POST_EFFECT_ALPHA_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "BRIGHT_TEXTURE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CENTER",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SAMPLES",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STEP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RATIO",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_1 * _glesVertex);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D BRIGHT_TEXTURE;
uniform highp vec3 UNIFORM_LIGHT_COLOR;
uniform highp vec2 CENTER;
uniform highp float SAMPLES;
uniform highp float STEP;
uniform highp float RATIO;
in highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 rgba_1;
  highp int i_1_2;
  highp float cur_dis_3;
  highp float delta_step_4;
  highp vec4 sum_brightness_5;
  highp vec2 dTuv_6;
  highp vec2 uv_7;
  highp int samples_8;
  highp int tmpvar_9;
  tmpvar_9 = int(SAMPLES);
  samples_8 = tmpvar_9;
  uv_7 = xlv_TEXCOORD0;
  highp vec2 tmpvar_10;
  tmpvar_10.x = CENTER.x;
  tmpvar_10.y = -(CENTER.y);
  highp vec2 tmpvar_11;
  tmpvar_11 = (xlv_TEXCOORD0 - tmpvar_10);
  highp float tmpvar_12;
  tmpvar_12 = sqrt(dot (tmpvar_11, tmpvar_11));
  highp vec2 tmpvar_13;
  if ((tmpvar_12 > (float(tmpvar_9) * STEP))) {
    tmpvar_13 = (normalize(tmpvar_11) * STEP);
  } else {
    tmpvar_13 = (tmpvar_11 / float(tmpvar_9));
  };
  dTuv_6 = tmpvar_13;
  sum_brightness_5 = vec4(0.0, 0.0, 0.0, 0.0);
  delta_step_4 = (1.0/(float(tmpvar_9)));
  cur_dis_3 = 1.0;
  i_1_2 = 0;
  for (; i_1_2 < samples_8; i_1_2++, uv_7 = (uv_7 - dTuv_6), cur_dis_3 = (cur_dis_3 - delta_step_4)) {
    lowp vec4 tmpvar_14;
    tmpvar_14 = texture (BRIGHT_TEXTURE, uv_7);
    sum_brightness_5 = (sum_brightness_5 + ((tmpvar_14 * 0.05) * (cur_dis_3 * cur_dis_3)));
  };
  lowp vec4 tmpvar_15;
  tmpvar_15 = texture (BRIGHT_TEXTURE, xlv_TEXCOORD0);
  rgba_1 = tmpvar_15;
  highp float tmpvar_16;
  tmpvar_16 = clamp (RATIO, 0.0, 1.0);
  highp vec3 tmpvar_17;
  tmpvar_17.x = (1.0 - tmpvar_16);
  tmpvar_17.y = (1.0 - tmpvar_16);
  tmpvar_17.z = (1.0 - tmpvar_16);
  highp vec4 tmpvar_18;
  tmpvar_18.xyz = (rgba_1.xyz + ((
    (UNIFORM_LIGHT_COLOR * tmpvar_16)
   + tmpvar_17) * sum_brightness_5.xyz));
  tmpvar_18.w = (rgba_1.w + sum_brightness_5.w);
  _glesFragData[0] = tmpvar_18;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"POST_EFFECT_ALPHA_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "BRIGHT_TEXTURE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CENTER",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SAMPLES",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STEP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RATIO",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_1 * _glesVertex);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D BRIGHT_TEXTURE;
uniform highp vec3 UNIFORM_LIGHT_COLOR;
uniform highp vec2 CENTER;
uniform highp float SAMPLES;
uniform highp float STEP;
uniform highp float RATIO;
in highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec3 rgb_1;
  highp int i_1_2;
  highp float cur_dis_3;
  highp float delta_step_4;
  highp vec3 sum_brightness_5;
  highp vec2 dTuv_6;
  highp vec2 uv_7;
  highp int samples_8;
  highp int tmpvar_9;
  tmpvar_9 = int(SAMPLES);
  samples_8 = tmpvar_9;
  uv_7 = xlv_TEXCOORD0;
  highp vec2 tmpvar_10;
  tmpvar_10.x = CENTER.x;
  tmpvar_10.y = -(CENTER.y);
  highp vec2 tmpvar_11;
  tmpvar_11 = (xlv_TEXCOORD0 - tmpvar_10);
  highp float tmpvar_12;
  tmpvar_12 = sqrt(dot (tmpvar_11, tmpvar_11));
  highp vec2 tmpvar_13;
  if ((tmpvar_12 > (float(tmpvar_9) * STEP))) {
    tmpvar_13 = (normalize(tmpvar_11) * STEP);
  } else {
    tmpvar_13 = (tmpvar_11 / float(tmpvar_9));
  };
  dTuv_6 = tmpvar_13;
  sum_brightness_5 = vec3(0.0, 0.0, 0.0);
  delta_step_4 = (1.0/(float(tmpvar_9)));
  cur_dis_3 = 1.0;
  i_1_2 = 0;
  for (; i_1_2 < samples_8; i_1_2++, uv_7 = (uv_7 - dTuv_6), cur_dis_3 = (cur_dis_3 - delta_step_4)) {
    lowp vec4 tmpvar_14;
    tmpvar_14 = texture (BRIGHT_TEXTURE, uv_7);
    sum_brightness_5 = (sum_brightness_5 + ((tmpvar_14 * 0.05) * (cur_dis_3 * cur_dis_3)).xyz);
  };
  lowp vec3 tmpvar_15;
  tmpvar_15 = texture (BRIGHT_TEXTURE, xlv_TEXCOORD0).xyz;
  rgb_1 = tmpvar_15;
  highp float tmpvar_16;
  tmpvar_16 = clamp (RATIO, 0.0, 1.0);
  highp vec3 tmpvar_17;
  tmpvar_17.x = (1.0 - tmpvar_16);
  tmpvar_17.y = (1.0 - tmpvar_16);
  tmpvar_17.z = (1.0 - tmpvar_16);
  highp vec4 tmpvar_18;
  tmpvar_18.w = 1.0;
  tmpvar_18.xyz = (rgb_1 + ((
    (UNIFORM_LIGHT_COLOR * tmpvar_16)
   + tmpvar_17) * sum_brightness_5));
  _glesFragData[0] = tmpvar_18;
}

]===],
	},
}

end
