

#DEFPARAMS
_MainTex = {"main Color", TEXTURE2D, "white" },
_Brightness = {"Brightness", FLOAT, "1.0"},
_Contrast = {"Contrast", FLOAT, "1.0"},
_Saturation = {"Saturation", FLOAT, "1.0"},
#END

#DEFTAG
ShaderName = "GreyDisp"
RenderQueue = "POSTEFFECT"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv     : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D _MainTex;
float _Brightness;
float _Contrast;
float _Saturation;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;
	return o;
}

float4 frag(v2f i) : SV_Target
{
	fixed4 renderTex = tex2D(_MainTex, i.uv);		
	fixed3 finalColor = renderTex * _Brightness;
	fixed gray = 0.2125 * renderTex.r + 0.7154 * renderTex.g + 0.0721 * renderTex.b;
	fixed3 grayColor = fixed3(gray, gray, gray);
	finalColor = lerp(grayColor, finalColor, _Saturation);
	fixed3 avgColor = fixed3(0.5, 0.5, 0.5);
	finalColor = lerp(avgColor, finalColor, _Contrast);
	float grey = dot(finalColor.rgb, fixed3(0.22, 0.707, 0.071));
	finalColor.rgb = fixed3(grey, grey, grey);

	return fixed4(finalColor.rgb, renderTex.a);
}
ENDCG
#END
