

function DefineParams()
	Properties = 
	{
		
_MainTex = {"main Color", TEXTURE2D, "white" },
_Brightness = {"Brightness", FLOAT, "1.0"},
_Contrast = {"Contrast", FLOAT, "1.0"},
_Saturation = {"Saturation", FLOAT, "1.0"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "GreyDisp"
RenderQueue = "POSTEFFECT"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Brightness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Contrast",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Saturation",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_1 * _glesVertex);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D _MainTex;
uniform highp float _Brightness;
uniform highp float _Contrast;
uniform highp float _Saturation;
in highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  highp float grey_2;
  lowp vec3 finalColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_MainTex, xlv_TEXCOORD0);
  highp vec3 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * _Brightness).xyz;
  finalColor_3 = tmpvar_5;
  lowp float tmpvar_6;
  tmpvar_6 = (((0.2125 * tmpvar_4.x) + (0.7154 * tmpvar_4.y)) + (0.0721 * tmpvar_4.z));
  highp vec3 tmpvar_7;
  tmpvar_7 = mix (vec3(tmpvar_6), finalColor_3, vec3(_Saturation));
  finalColor_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = mix (vec3(0.5, 0.5, 0.5), finalColor_3, vec3(_Contrast));
  finalColor_3 = tmpvar_8;
  lowp float tmpvar_9;
  tmpvar_9 = dot (finalColor_3, vec3(0.22, 0.707, 0.071));
  grey_2 = tmpvar_9;
  highp vec3 tmpvar_10;
  tmpvar_10.x = grey_2;
  tmpvar_10.y = grey_2;
  tmpvar_10.z = grey_2;
  finalColor_3 = tmpvar_10;
  lowp vec4 tmpvar_11;
  tmpvar_11.xyz = finalColor_3;
  tmpvar_11.w = tmpvar_4.w;
  tmpvar_1 = tmpvar_11;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
}

end
