function DefineParams()
	Properties = 
	{
		
MV_FORCE_SCALE = {"MV_FORCE_SCALE", FLOAT, "1.0"},
MOTION_VECTOR  = {"MOTION_VECTOR", TEXTURE2D, "MOTION_VECTOR"},
FORCE_TARGET   = {"FORCE_TARGET", TEXTURE2D, "FORCE_TARGET"},
FLOAT_MIN      = {"FLOAT_MIN", FLOAT, "-100.0"},
FLOAT_MAX      = {"FLOAT_MAX", FLOAT, "100.0"},
WIND_FIELD     = {"WIND_FIELD", VEC2, "0.0, 0.0"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName  = "ExtForceStep"
RenderQueue = "PostEffect"
end

function Always()

COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE   = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "MV_FORCE_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MOTION_VECTOR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FORCE_TARGET",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FLOAT_MIN",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FLOAT_MAX",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WIND_FIELD",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_1 * _glesVertex);
}

]===],
		psShader = [===[uniform highp float MV_FORCE_SCALE;
uniform sampler2D MOTION_VECTOR;
uniform sampler2D FORCE_TARGET;
uniform highp float FLOAT_MIN;
uniform highp float FLOAT_MAX;
uniform highp vec2 WIND_FIELD;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 result_1;
  highp vec2 motion_vector_2;
  lowp vec2 tmpvar_3;
  tmpvar_3 = (2.0 * (texture2D (MOTION_VECTOR, xlv_TEXCOORD0).xy - vec2(0.5, 0.5)));
  motion_vector_2 = tmpvar_3;
  lowp vec4 tmpvar_4;
  tmpvar_4.zw = vec2(0.0, 1.0);
  tmpvar_4.xy = texture2D (FORCE_TARGET, xlv_TEXCOORD0).xy;
  result_1 = tmpvar_4;
  result_1.xy = (result_1.xy + ((
    (MV_FORCE_SCALE * motion_vector_2)
   + WIND_FIELD) / (FLOAT_MAX - FLOAT_MIN)));
  gl_FragData[0] = result_1;
}

]===],
	},
}

end