function DefineParams()
	Properties = 
	{
		
MOTION_VECTOR   = {"MOTION_VECTOR", TEXTURE2D, "MOTION_VECTOR"},
CUR_FRAME       = {"CUR_FRAME", TEXTURE2D, "CUR_FRAME"},
CUR_COLOR       = {"CUR_COLOR", TEXTURE2D, "CUR_COLOR"},
COLOR_MODE      = {"COLOR_MODE", FLOAT, "0.0"},
FLUID_COLOR     = {"FLUID_COLOR", VEC3, "1.0, 0.0, 0.0"},
DYE_DIFFICULTY  = {"DYE_DIFFICULTY", FLOAT, "0.0"},
DYE_MASK        = {"DYE_MASK", TEXTURE2D, "DYE_MASK"},
MASK_VALID      = {"MASK_VALID", FLOAT, "0.0"},
INVERT_MASK     = {"INVERT_MASK", FLOAT, "0.0"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName  = "DyeColorStep"
RenderQueue = "PostEffect"
end

function Always()

COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE   = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "MOTION_VECTOR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CUR_FRAME",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CUR_COLOR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_MODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FLUID_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DYE_DIFFICULTY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DYE_MASK",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "INVERT_MASK",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_1 * _glesVertex);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D MOTION_VECTOR;
uniform sampler2D CUR_FRAME;
uniform sampler2D CUR_COLOR;
uniform highp float COLOR_MODE;
uniform highp vec3 FLUID_COLOR;
uniform highp float DYE_DIFFICULTY;
uniform sampler2D DYE_MASK;
uniform highp float MASK_VALID;
uniform highp float INVERT_MASK;
in highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 cur_color_2;
  highp float dye_flag_3;
  highp vec2 motion_vector_4;
  lowp vec2 tmpvar_5;
  tmpvar_5 = (2.0 * (texture (MOTION_VECTOR, xlv_TEXCOORD0).xy - vec2(0.5, 0.5)));
  motion_vector_4 = tmpvar_5;
  highp float tmpvar_6;
  tmpvar_6 = sqrt(dot (motion_vector_4, motion_vector_4));
  highp float tmpvar_7;
  if ((tmpvar_6 > 0.15)) {
    tmpvar_7 = 1.0;
  } else {
    tmpvar_7 = 0.0;
  };
  dye_flag_3 = tmpvar_7;
  highp float tmpvar_8;
  tmpvar_8 = (1.0 - clamp (DYE_DIFFICULTY, 0.0, 1.0));
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture (CUR_COLOR, xlv_TEXCOORD0);
  cur_color_2 = tmpvar_9;
  highp float tmpvar_10;
  if ((cur_color_2.w > tmpvar_8)) {
    tmpvar_10 = 0.0;
  } else {
    tmpvar_10 = tmpvar_7;
  };
  dye_flag_3 = tmpvar_10;
  if ((MASK_VALID > 0.0)) {
    highp float mask_alpha_11;
    lowp float tmpvar_12;
    if ((INVERT_MASK > 0.0)) {
      tmpvar_12 = (1.0 - texture (DYE_MASK, xlv_TEXCOORD0).w);
    } else {
      tmpvar_12 = texture (DYE_MASK, xlv_TEXCOORD0).w;
    };
    mask_alpha_11 = tmpvar_12;
    highp float tmpvar_13;
    if ((mask_alpha_11 > 0.0)) {
      tmpvar_13 = tmpvar_10;
    } else {
      tmpvar_13 = 0.0;
    };
    dye_flag_3 = tmpvar_13;
  };
  highp int tmpvar_14;
  tmpvar_14 = int((COLOR_MODE + 0.5));
  if ((tmpvar_14 == 0)) {
    highp vec4 tmpvar_15;
    if ((dye_flag_3 > 0.0)) {
      highp vec4 tmpvar_16;
      tmpvar_16.w = 1.0;
      tmpvar_16.xyz = FLUID_COLOR;
      tmpvar_15 = tmpvar_16;
    } else {
      tmpvar_15 = cur_color_2;
    };
    tmpvar_1 = tmpvar_15;
  } else {
    highp vec4 frame_color_17;
    lowp vec4 tmpvar_18;
    tmpvar_18 = texture (CUR_FRAME, xlv_TEXCOORD0);
    frame_color_17 = tmpvar_18;
    highp vec4 tmpvar_19;
    if ((dye_flag_3 > 0.0)) {
      tmpvar_19 = frame_color_17;
    } else {
      tmpvar_19 = cur_color_2;
    };
    tmpvar_1 = tmpvar_19;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
}

end