function DefineParams()
	Properties = 
	{
		
ADVECT_SOURCE   = {"ADVECT_SOURCE", TEXTURE2D, "ADVECT_SOURCE"},
VELOCITY        = {"VELOCITY", TEXTURE2D, "VELOCITY"},
TEXEL_SIZE      = {"TEXEL_SIZE", VEC2, "64.0, 64.0"},
DISSIPATION     = {"DISSIPATION", FLOAT, "0.0"},
TIME_STEP       = {"TIME_STEP", FLOAT, "0.01"},
VEL_FLOAT_MIN   = {"VEL_FLOAT_MIN", FLOAT, "-100.0"},
VEL_FLOAT_MAX   = {"VEL_FLOAT_MAX", FLOAT, "100.0"},
SRC_FLOAT_MIN   = {"SRC_FLOAT_MIN", FLOAT, "-100.0"},
SRC_FLOAT_MAX   = {"SRC_FLOAT_MAX", FLOAT, "100.0"},
SRC_MULTI_PHASE = {"SRC_MULTI_PHASE", FLOAT, "0.0"},
SRC_PHASE_1     = {"SRC_PHASE_1", VEC3, "1.0, 0.0, 0.0"},
SRC_PHASE_2     = {"SRC_PHASE_2", VEC3, "1.0, 0.0, 0.0"},
SRC_PHASE_3     = {"SRC_PHASE_3", VEC3, "1.0, 0.0, 0.0"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName  = "AdvectionStep"
RenderQueue = "PostEffect"
end

function Always()

COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE   = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "ADVECT_SOURCE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "VELOCITY",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXEL_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DISSIPATION",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TIME_STEP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "VEL_FLOAT_MIN",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "VEL_FLOAT_MAX",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SRC_FLOAT_MIN",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SRC_FLOAT_MAX",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SRC_MULTI_PHASE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SRC_PHASE_1",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SRC_PHASE_2",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SRC_PHASE_3",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_1 * _glesVertex);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D ADVECT_SOURCE;
uniform sampler2D VELOCITY;
uniform highp vec2 TEXEL_SIZE;
uniform highp float DISSIPATION;
uniform highp float TIME_STEP;
uniform highp float VEL_FLOAT_MIN;
uniform highp float VEL_FLOAT_MAX;
uniform highp float SRC_FLOAT_MIN;
uniform highp float SRC_FLOAT_MAX;
uniform highp float SRC_MULTI_PHASE;
uniform highp vec3 SRC_PHASE_1;
uniform highp vec3 SRC_PHASE_2;
uniform highp vec3 SRC_PHASE_3;
in highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec3 result_1;
  highp vec4 normalized_result_2;
  highp float tmpvar_3;
  tmpvar_3 = (SRC_FLOAT_MAX - SRC_FLOAT_MIN);
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (VELOCITY, xlv_TEXCOORD0);
  highp vec2 tmpvar_5;
  tmpvar_5 = (xlv_TEXCOORD0 - ((TIME_STEP * 
    (((VEL_FLOAT_MAX - VEL_FLOAT_MIN) * tmpvar_4.xy) + vec2(VEL_FLOAT_MIN))
  ) * TEXEL_SIZE));
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture (ADVECT_SOURCE, tmpvar_5);
  normalized_result_2 = tmpvar_6;
  result_1 = ((tmpvar_3 * normalized_result_2.xyz) + vec3(SRC_FLOAT_MIN));
  highp float tmpvar_7;
  tmpvar_7 = (1.0 + (DISSIPATION * TIME_STEP));
  normalized_result_2.w = (normalized_result_2.w / tmpvar_7);
  highp int tmpvar_8;
  tmpvar_8 = int((SRC_MULTI_PHASE + 0.5));
  if ((tmpvar_8 != 0)) {
    highp float tmpvar_9;
    tmpvar_9 = (1.0 - normalized_result_2.w);
    highp float tmpvar_10;
    if ((tmpvar_9 > 0.5)) {
      tmpvar_10 = 0.0;
    } else {
      tmpvar_10 = ((0.5 - tmpvar_9) * 2.0);
    };
    highp float tmpvar_11;
    if ((tmpvar_9 > 0.5)) {
      tmpvar_11 = ((tmpvar_9 - 0.5) * 2.0);
    } else {
      tmpvar_11 = 0.0;
    };
    result_1 = (((tmpvar_10 * SRC_PHASE_1) + (
      (1.0 - max (tmpvar_10, tmpvar_11))
     * SRC_PHASE_2)) + SRC_PHASE_3);
  } else {
    result_1 = (result_1 / tmpvar_7);
  };
  normalized_result_2.xyz = ((result_1 - vec3(SRC_FLOAT_MIN)) / tmpvar_3);
  _glesFragData[0] = normalized_result_2;
}

]===],
	},
}

end