

#DEFPARAMS
_MainTex = { "Main Color", TEXTURE2D, "white" },
_MetallicGlossMap = {"Metallic Gloss", TEXTURE2D, "white"},
_BumpMap = {"Normal Map", TEXTURE2D, "bump"},
_GlossEnvMap = {"Specular IBL Map", TEXTURECUBE, "black"},
_IrradianceMap = {"Diffuse IBL Map",TEXTURECUBE,"black"},
_Smoothness = {"Smoothness", FLOAT, "0.5" },
_Metallic = { "Metallic", FLOAT, "0.5" },
_EmissionColor = {"Emission Color", COLOR, "0.0,0.0,0.0,1.0"},
_EmissionMap = {"Emission Map",TEXTURE2D,"white"},
_Rotation = { "Rotation", FLOATRANGE, "0, 360, 0" },
_Opacity = { "Opacity", FLOAT, "1.0" },
_RimColor = {"Rim Color", COLOR, "1.0, 1.0, 1.0, 1.0"},
_RimPow = { "RimPow", FLOATRANGE, "2.0, 10.0, 0.0" },
_RimIdentity = { "RimIdentity", FLOATRANGE, "3.0, 10.0, 0.0" },
_SimpleReflectionTex = {"Simple Reflection",TEXTURE2D,"white"},
_ReflectionIntensity = {"ReflectionIntensity",FLOAT,"0.0"},
_CutOff = { "CutOff", FLOAT, "0.0" },
[Enum(RenderQueue)]
_RenderQueue = {"Render Queue", FLOAT, "1000"},
[Enum(BlendOnOff)]
_BlendState = {"Blend State", FLOAT, "0.0"},
[Enum(BlendFactor)]
_BlendSrc = {"Blend Src", FLOAT, "4.0"},
[Enum(BlendFactor)]
_BlendDst = {"Blend Dst", FLOAT, "5.0"},
[Enum(DepthMode)]
_DepthMask = {"Depth Mask", FLOAT, "1.0"},
[Enum(DepthFunc)]
_DepthFc = {"Depth Test", FLOAT, "1.0"},
[Enum(CullMode)]
_CullMode = {"Cull Mode", FLOAT, "0.0"},
[Keywords(RIM_REFLECTION_ON, RIM_REFLECTION_OFF)]
_RimAndReflectionlState = {"RimAndReflection State", FLOAT, "1.0"},
[Keywords(ALPHAPREMULTIPLY_ON, ALPHAPREMULTIPLY_OFF)]
_AlphaPreMultiply = {"Alpha Pre Multiply", FLOAT, "1.0"},
[Keywords(ALPHATEST_ON, ALPHATEST_OFF)]
_ALPHATEST_ON = {"Alpha Test On", FLOAT, "1.0"},
#END

#DEFTAG
ShaderName = "StandardPbr"
RenderQueue = "%_RenderQueue"
#END

#DEFPASS ForwardBase
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { "%_BlendState", "%_BlendSrc", "%_BlendDst", ONE, ONE }
DRAW_MODE = { "%_CullMode", "%_DepthMask", DEPTH_TEST_ON, "%_DepthFc" }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fwdbase
#pragma multi_compile RIM_REFLECTION_ON RIM_REFLECTION_OFF
#pragma multi_compile ALPHAPREMULTIPLY_ON ALPHAPREMULTIPLY_OFF
#pragma multi_compile ALPHATEST_ON ALPHATEST_OFF
#include "lightpbr.inc"

struct appdata
{
	float4 vertex : POSITION;
	float3 normal : NORMAL;
	float3 binoraml : BINORMAL;
	float3 tangent : TANGENT;
	float2 uv : TEXCOORD0;
	ANI_ATTRIBUTE
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 worldnormal : TEXCOORD1;
	float4 worldtangent : TEXCOORD2;
	float4 worldbinormal : TEXCOORD3;
	float4 vertex : SV_POSITION;
	SHADOW_COORDS(4)
};

sampler2D _MainTex;
sampler2D _MetallicGlossMap;
sampler2D _BumpMap;
sampler2D _EmissionMap;
samplerCUBE _GlossEnvMap;
samplerCUBE _IrradianceMap;
float _Smoothness;
float _Metallic;
float4 _EmissionColor;
float _Rotation;
float _CutOff;
float _Opacity;
float4 _RimColor;
float _RimPow;
float _RimIdentity;
sampler2D _SimpleReflectionTex;
float _ReflectionIntensity;

v2f vert(appdata v)
{
	COMPUTE_BONE_MATERIX(v);

	v2f o;
	float4 pos = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(pos);
	o.uv = v.uv.xy;
	float3 worldpos = ObjectToWorldPos(v.vertex).xyz;
	o.worldnormal.xyz = ObjectToWorldNormal(v.normal).xyz;
	o.worldtangent.xyz = ObjectToWorldDir(v.tangent).xyz;
	o.worldbinormal.xyz = ObjectToWorldDir(v.binoraml).xyz;

	o.worldnormal.w = worldpos.x;
	o.worldtangent.w = worldpos.y;
	o.worldbinormal.w = worldpos.z;

	TRANSFER_SHADOW(o, v.vertex);
	return o;
}

float4 frag(v2f i) : SV_Target
{
	// sample the texture
	float4 col = tex2D(_MainTex, i.uv);
	float2 mg = tex2D(_MetallicGlossMap, i.uv).ra;
	//float emissionMask = tex2D(_MetallicGlossMap, i.uv).g;
	float3 emissionMapColor = tex2D(_EmissionMap,i.uv).rgb;
	float3 normalTangent = tex2D(_BumpMap, i.uv).rgb;
	normalTangent.xyz = normalTangent.xyz * 2.0 - 1.0;
	float3 normalWorld = normalTangent.x * i.worldtangent.xyz + normalTangent.y * i.worldbinormal.xyz
		+ normalTangent.z * i.worldnormal.xyz;
	normalWorld.xyz = normalize(normalWorld.xyz);

	float roughness = 1.0 - mg.g * _Smoothness;
	float3 worldPos = float3(i.worldnormal.w, i.worldtangent.w, i.worldbinormal.w);
	float3 dir = RotateAroundYInDegrees(normalWorld, _Rotation);
	float3 iblColor = SpecularIBLColor(_GlossEnvMap, worldPos, normalWorld, roughness, _Rotation);
	float3 iblDiffuseColor = DiffuseIBLColor(_IrradianceMap, worldPos, dir);
	float3 reflectionColor = float3(0.0, 0.0, 0.0);
	float3 rim = float3(0.0, 0.0, 0.0);
	#ifdef RIM_REFLECTION_ON
	    float modulation = tex2D(_MetallicGlossMap, i.uv).g;
		reflectionColor = SampleReflection(_SimpleReflectionTex, modulation, _ReflectionIntensity, worldPos, normalWorld);
		rim = RimHeightLight(_RimColor.xyz, _RimIdentity, _RimPow, worldPos, normalWorld);
	#endif

	SurfaceStandardInput input;
	input.albedo = col.rgb;
	input.metallic = mg.r * _Metallic;
	input.smoothness = mg.g * _Smoothness;
	input.worldNormal = normalWorld; // normalWorld;
	input.worldPos = worldPos;
	input.emission = AmbientColor() + _EmissionColor.rgb * emissionMapColor + reflectionColor + rim;// * emissionMask;
	input.specularIbl = iblColor.rgb;
	input.diffuseIbl = iblDiffuseColor.rgb;
	input.alpha = col.a;
	input.atten = SHADOW_ATTEN(i);

	float4 outColor;
	outColor.xyz = PBR_LightCalc(input);
	#ifdef ALPHATEST_ON
		outColor.w = 1.0;
		if (col.a - _CutOff <= 0) {discard; }
	#else
		#ifdef ALPHAPREMULTIPLY_ON
			outColor.w = input.alpha *  _Opacity;
		#else
			outColor.w = 1.0;
		#endif
	#endif
	
	return outColor;
}
ENDCG

#END

#DEFPASS ForwardAdd
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, ONE, ONE, ONE, ONE }
DRAW_MODE = { "%_CullMode", "%_DepthMask", DEPTH_TEST_ON, "%_DepthFc" }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDADD }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fwdadd
#pragma multi_compile ALPHATEST_ON ALPHATEST_OFF
#pragma multi_compile ALPHAPREMULTIPLY_ON ALPHAPREMULTIPLY_OFF
#include "lightpbr.inc"

struct appdata
{
	float4 vertex : POSITION;
	float3 normal : NORMAL;
	float3 binoraml : BINORMAL;
	float3 tangent : TANGENT;
	float2 uv : TEXCOORD0;
	ANI_ATTRIBUTE
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 worldnormal : TEXCOORD1;
	float4 worldtangent : TEXCOORD2;
	float4 worldbinormal : TEXCOORD3;
	float4 vertex : SV_POSITION;
	SHADOW_COORDS(4)
};

sampler2D _MainTex;
sampler2D _MetallicGlossMap;
sampler2D _BumpMap;
float _Smoothness;
float _Metallic;
float4 _EmissionColor;
float _CutOff;
float _Opacity;

v2f vert(appdata v)
{
	COMPUTE_BONE_MATERIX(v);

	v2f o;
	float4 pos = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(pos);
	o.uv = v.uv.xy;
	float3 worldpos = ObjectToWorldPos(v.vertex).xyz;
	o.worldnormal.xyz = ObjectToWorldNormal(v.normal).xyz;
	o.worldtangent.xyz = ObjectToWorldDir(v.tangent).xyz;
	o.worldbinormal.xyz = ObjectToWorldDir(v.binoraml).xyz;

	o.worldnormal.w = worldpos.x;
	o.worldtangent.w = worldpos.y;
	o.worldbinormal.w = worldpos.z;

	TRANSFER_SHADOW(o, v.vertex);
	return o;
}

float4 frag(v2f i) : SV_Target
{
	// sample the texture
	float4 col = tex2D(_MainTex, i.uv);
	float2 mg = tex2D(_MetallicGlossMap, i.uv).ra;
	float3 normalTangent = tex2D(_BumpMap, i.uv).rgb;
	normalTangent.xyz = normalTangent.xyz * 2.0 - 1.0;
	float3 normalWorld = normalTangent.x * i.worldtangent.xyz + normalTangent.y * i.worldbinormal.xyz
		+ normalTangent.z * i.worldnormal.xyz;
	normalWorld.xyz = normalize(normalWorld.xyz);

	SurfaceStandardInput input;
	input.albedo = col.rgb;
	input.metallic = mg.r * _Metallic;
	input.smoothness = mg.g * _Smoothness;
	input.worldNormal = normalWorld; // normalWorld;
	input.worldPos = float3(i.worldnormal.w, i.worldtangent.w, i.worldbinormal.w);
	input.emission = float3(0.0, 0.0, 0.0);
	input.atten = SHADOW_ATTEN(i);
	input.alpha = col.a;
	input.specularIbl = float3(0.0, 0.0, 0.0);
	input.diffuseIbl = float3(0.0, 0.0, 0.0);

	float4 outColor;
	outColor.xyz = PBR_LightCalc(input);
	outColor.w = 1.0;
	#ifdef ALPHATEST_ON
		outColor.w = 1.0;
		if (col.a - _CutOff <= 0) {discard; }
	#else
		#ifdef ALPHAPREMULTIPLY_ON
			outColor.w = input.alpha *  _Opacity;
		#else
			outColor.w = 1.0;
		#endif
	#endif
	
	return outColor;
}
ENDCG

#END

#DEFPASS Depth
	COLOR_MASK = COLOR_RGBA
	ALPAH_MODE = { ALPAH_OFF }
	DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
	STENCIL_MODE = { STENCIL_OFF }
	LIGHT_MODE = { DEPTHPASS }

	CGPROGRAM
	#pragma vertex vert
	#pragma fragment frag
	#include "lightpbr.inc"
	#pragma multi_compile_skin

	struct appdata
	{
		float4 vertex : POSITION;
		float3 normal : NORMAL;
		ANI_ATTRIBUTE
	};

	struct v2f
	{
		float4 vertex : SV_POSITION;
	};

	v2f vert(appdata v)
	{
		COMPUTE_BONE_MATERIX(v);

		float4 clipPos = ObjectToClipPos(v.vertex);
		clipPos = ApplyShadowBias(clipPos);

		v2f o;
		o.vertex = UniformNDC(clipPos);
		return o;
	}

	float4 frag(v2f i) : SV_Target
	{
		return float4(0.0, 0.0, 0.0, 1.0);
	}
	ENDCG
#END
