#DEFPARAMS
_TexMask = {"TexMask", TEXTURE2D, "white" },
_TexR = {"TexR", TEXTURE2D, "white" },
_TexG = {"TexG", TEXTURE2D, "white" },


_MaskR = {"MaskR", FLOAT, "1.0"},
_MaskG = {"MaskG", FLOAT, "1.0"},
#END

#DEFTAG
ShaderName = "MixBySegment"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "light.inc"
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv     : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D _TexMask;
sampler2D  _TexR;
sampler2D  _TexG;


float _MaskR;
float _MaskG;





v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;
	return o;
}

float4 frag(v2f i) : SV_Target
{	
	float2 maskuv =  i.uv;

    fixed maskcolor  = tex2D(_TexMask, maskuv).a;

	fixed4 colorr  = tex2D(_TexR, i.uv).rgba;
	fixed4 colorg  = tex2D(_TexG, i.uv).rgba;


	fixed4 frameColor = colorr*maskcolor*_MaskR
					  + colorg*(1-maskcolor)*_MaskG;


    return frameColor;
}
ENDCG
#END
