

function DefineParams()
	Properties = 
	{
		
_MainTex = { "main Color", TEXTURE2D, "white" },
_BumpMap = { "Normal Map", TEXTURE2D, "bump" },
_EnvMap = { "Env Map", TEXTURECUBE, "cube"},
_FresnelPower = { "Fresnel Power", FLOAT, "10"},
_FresnelBase = {"Fresnel Base", FLOAT, "0.9"},
_Cutoff = {"Cut Off", FLOAT, "1.0"},
_Opacity = {"Opacity", FLOAT, "0.3"},
_ReflectCol = {"Reflect Color", COLOR, "0.8,0.8,1.0,1.0"},
_ReflectStrength = { "Reflect Strength", FLOAT, "7.5" },
_MainUVScale = {"Main UV Scale", VEC2, "0.1,0.1"},
_BumpUVScale = {"Bump UV Scale", VEC2, "0.001,0.001"}

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "Ice"
RenderQueue = "Transparent+1"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FresnelPower",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FresnelBase",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Cutoff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ReflectCol",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ReflectStrength",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainUVScale",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpUVScale",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_9[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_9[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform lowp samplerCube _EnvMap;
uniform highp float _FresnelPower;
uniform highp float _FresnelBase;
uniform highp float _Cutoff;
uniform highp float _Opacity;
uniform highp vec4 _ReflectCol;
uniform highp float _ReflectStrength;
uniform highp vec2 _MainUVScale;
uniform highp vec2 _BumpUVScale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 outColor_1;
  mediump float fresnel_2;
  mediump float dotNV_3;
  mediump vec4 reflectCol_4;
  highp vec3 normalWorld_5;
  highp vec3 normalTangent_6;
  highp vec4 mainColor_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = (xlv_TEXCOORD0 * _MainUVScale);
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, tmpvar_8);
  mainColor_7 = tmpvar_9;
  highp vec2 tmpvar_10;
  tmpvar_10 = (xlv_TEXCOORD0 * _BumpUVScale);
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_BumpMap, tmpvar_10).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  normalWorld_5 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD2.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  highp vec3 I_14;
  I_14 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_12)));
  tmpvar_13 = (I_14 - (2.0 * (
    dot (normalWorld_5, I_14)
   * normalWorld_5)));
  lowp vec4 tmpvar_15;
  tmpvar_15 = textureCube (_EnvMap, tmpvar_13);
  highp vec4 tmpvar_16;
  tmpvar_16 = (tmpvar_15 * mainColor_7.w);
  reflectCol_4 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = dot (normalWorld_5, normalize((CAMERA_WORLDPOSITION - tmpvar_12)));
  dotNV_3 = tmpvar_17;
  mediump float tmpvar_18;
  tmpvar_18 = clamp ((1.0 - dotNV_3), 0.0, 1.0);
  highp float tmpvar_19;
  tmpvar_19 = pow (tmpvar_18, _FresnelPower);
  fresnel_2 = tmpvar_19;
  fresnel_2 = (_FresnelBase + ((1.0 - _FresnelBase) * fresnel_2));
  mediump vec3 tmpvar_20;
  tmpvar_20 = (reflectCol_4 * fresnel_2).xyz;
  outColor_1.xyz = tmpvar_20;
  outColor_1.xyz = ((outColor_1.xyz * _ReflectCol.xyz) * _ReflectStrength);
  highp float tmpvar_21;
  if ((_Cutoff > mainColor_7.w)) {
    tmpvar_21 = (mainColor_7.w + _Opacity);
  } else {
    tmpvar_21 = 0.0;
  };
  outColor_1.w = tmpvar_21;
  gl_FragData[0] = outColor_1;
}

]===],
	},
}

end
