

function DefineParams()
	Properties = 
	{
		
_MainTex = { "Main Tex", TEXTURE2D, "white" },
_MaskTex = { "Mask Tex", TEXTURE2D, "white" },
_LutTex = { "Lut Tex", TEXTURE2D, "white"},
_Alpha = { "Alpha", FLOAT, "1.0"},
_BlendFirst = {"Blend First", FLOAT, "1.0"},
_ShaderStyle = {"Shader Style", FLOAT, "1.0"},
_MaskPos = {"Mask Pos", VEC2, "300.0,708.0"},
_MaskScale = {"Mask Scale", FLOAT, "1.01"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "ShadingOfLipStick"
RenderQueue = "Transparent+1"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskPos",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_LutTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ShaderStyle",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendFirst",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _MaskPos;
uniform highp float _MaskScale;
out highp vec2 xlv_TEXCOORD0;
out highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_2;
  tmpvar_2.x = (1.0/((167.0 * _MaskScale)));
  tmpvar_2.y = (1.0/((122.0 * _MaskScale)));
  tmpvar_2.z = (_MaskPos.x / (-167.0 * _MaskScale));
  tmpvar_2.w = (_MaskPos.y / (-122.0 * _MaskScale));
  highp vec2 tmpvar_3;
  tmpvar_3.x = (1.0 + _glesVertex.x);
  tmpvar_3.y = (1.0 - _glesVertex.y);
  xlv_TEXCOORD0 = ((_glesMultiTexCoord0.xy * tmpvar_2.xy) + tmpvar_2.zw);
  xlv_TEXCOORD1 = (tmpvar_3 / 2.0);
  gl_Position = (tmpvar_1 * _glesVertex);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _LutTex;
uniform highp float _Alpha;
uniform highp float _ShaderStyle;
uniform highp float _BlendFirst;
in highp vec2 xlv_TEXCOORD0;
in highp vec2 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 newcolor_1;
  lowp vec4 basecolor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (_MainTex, xlv_TEXCOORD1);
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_MaskTex, xlv_TEXCOORD0);
  lowp vec3 tmpvar_5;
  tmpvar_5 = clamp (tmpvar_3.xyz, vec3(0.0, 0.0, 0.0), vec3(0.9, 0.9, 0.9));
  lowp vec4 tmpvar_6;
  tmpvar_6.xyz = tmpvar_5;
  tmpvar_6.w = tmpvar_3.w;
  lowp vec4 newColor_7;
  mediump vec2 texPos2_8;
  mediump vec2 texPos1_9;
  mediump vec2 quad2_10;
  mediump vec2 quad1_11;
  mediump float blueColor_12;
  lowp float tmpvar_13;
  tmpvar_13 = (tmpvar_5.z * 15.0);
  blueColor_12 = tmpvar_13;
  quad1_11.y = floor((floor(blueColor_12) / 4.0));
  quad1_11.x = (floor(blueColor_12) - (quad1_11.y * 4.0));
  quad2_10.y = floor((ceil(blueColor_12) / 4.0));
  quad2_10.x = (ceil(blueColor_12) - (quad2_10.y * 4.0));
  texPos1_9 = (((quad1_11 * vec2(0.25, 0.25)) + vec2(0.0078125, 0.0078125)) + (vec2(0.234375, 0.234375) * tmpvar_5.xy));
  texPos2_8 = (((quad2_10 * vec2(0.25, 0.25)) + vec2(0.0078125, 0.0078125)) + (vec2(0.234375, 0.234375) * tmpvar_5.xy));
  mediump vec2 tmpvar_14;
  tmpvar_14.x = texPos1_9.x;
  tmpvar_14.y = (1.0 - texPos1_9.y);
  lowp vec4 tmpvar_15;
  tmpvar_15 = texture (_LutTex, tmpvar_14);
  mediump vec2 tmpvar_16;
  tmpvar_16.x = texPos2_8.x;
  tmpvar_16.y = (1.0 - texPos2_8.y);
  lowp vec4 tmpvar_17;
  tmpvar_17 = texture (_LutTex, tmpvar_16);
  mediump vec4 tmpvar_18;
  tmpvar_18 = ((tmpvar_15 * (1.0 - 
    fract(blueColor_12)
  )) + (tmpvar_17 * fract(blueColor_12)));
  newColor_7 = tmpvar_18;
  highp vec4 tmpvar_19;
  bool tmpvar_20;
  tmpvar_20 = (_ShaderStyle >= 1.5);
  bool tmpvar_21;
  tmpvar_21 = (1.5 >= _ShaderStyle);
  tmpvar_19 = ((float(tmpvar_20) * tmpvar_4) + (float(tmpvar_21) * newColor_7));
  newcolor_1 = tmpvar_19;
  highp float tmpvar_22;
  tmpvar_22 = float(tmpvar_20);
  highp float tmpvar_23;
  tmpvar_23 = float(tmpvar_21);
  basecolor_2 = ((tmpvar_22 * tmpvar_3) + (tmpvar_23 * tmpvar_6));
  lowp vec3 blend_24;
  blend_24 = newcolor_1.xyz;
  mediump float mode_25;
  mode_25 = _BlendFirst;
  lowp vec3 dst_26;
  mediump float tmpvar_27;
  tmpvar_27 = float((1.5 >= mode_25));
  mediump float tmpvar_28;
  tmpvar_28 = float((mode_25 >= 1.5));
  mediump float tmpvar_29;
  tmpvar_29 = float((2.5 >= mode_25));
  mediump float tmpvar_30;
  tmpvar_30 = float((mode_25 >= 2.5));
  highp float tmpvar_31;
  lowp float blend_32;
  blend_32 = blend_24.x;
  lowp float tmpvar_33;
  if ((newcolor_1.x == 0.0)) {
    tmpvar_33 = blend_32;
  } else {
    tmpvar_33 = max ((1.0 - (
      (1.0 - basecolor_2.x)
     / newcolor_1.x)), 0.0);
  };
  tmpvar_31 = tmpvar_33;
  highp float tmpvar_34;
  lowp float blend_35;
  blend_35 = blend_24.y;
  lowp float tmpvar_36;
  if ((newcolor_1.y == 0.0)) {
    tmpvar_36 = blend_35;
  } else {
    tmpvar_36 = max ((1.0 - (
      (1.0 - basecolor_2.y)
     / newcolor_1.y)), 0.0);
  };
  tmpvar_34 = tmpvar_36;
  highp float tmpvar_37;
  lowp float blend_38;
  blend_38 = blend_24.z;
  lowp float tmpvar_39;
  if ((newcolor_1.z == 0.0)) {
    tmpvar_39 = blend_38;
  } else {
    tmpvar_39 = max ((1.0 - (
      (1.0 - basecolor_2.z)
     / newcolor_1.z)), 0.0);
  };
  tmpvar_37 = tmpvar_39;
  highp vec3 tmpvar_40;
  tmpvar_40.x = tmpvar_31;
  tmpvar_40.y = tmpvar_34;
  tmpvar_40.z = tmpvar_37;
  highp vec3 tmpvar_41;
  tmpvar_41 = ((tmpvar_27 * newcolor_1.xyz) + (tmpvar_28 * (
    ((tmpvar_29 * basecolor_2.xyz) * newcolor_1.xyz)
   + 
    (tmpvar_30 * tmpvar_40)
  )));
  dst_26 = tmpvar_41;
  newcolor_1.xyz = dst_26;
  basecolor_2.xyz = (((dst_26 * tmpvar_4.w) * _Alpha) + ((1.0 - 
    (_Alpha * tmpvar_4.w)
  ) * tmpvar_3.xyz));
  lowp vec4 tmpvar_42;
  tmpvar_42.w = 1.0;
  tmpvar_42.xyz = basecolor_2.xyz;
  _glesFragData[0] = tmpvar_42;
}

]===],
	},
}

end
