

#DEFPARAMS
_MainTex = { "Main Tex", TEXTURE2D, "white" },
_MaskTex = { "Mask Tex", TEXTURE2D, "white" },
_Alpha = { "Alpha", FLOAT, "1.0"},
_Brightscale = {"BrightScale", FLOAT, "1.0"},
_MaskPos = {"Mask Pos", VEC2, "300.0,708.0"},
_MaskScale = {"Mask Scale", FLOAT, "1.01"},
#END

#DEFTAG
ShaderName = "ComputeHLOfLipStick"
RenderQueue = "Transparent+1"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "lipstick_3layer.inc"
#include "common.inc"

struct appdata   
{
	float4 vertex : POSITION;
	float2 uv0 : TEXCOORD0;
	float2 uv1 : TEXCOORD1;
};

struct v2f
{
	float2 uv0 : TEXCOORD0; 
	float2 uv1 : TEXCOORD1;   
	float4 vertex : SV_POSITION;
};

sampler2D _MainTex;
sampler2D _HighTex;
sampler2D _MaskTex;
float _Alpha;
float2 _MaskPos;
float _MaskScale;
float _Brightscale;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
    float4 facetexpara = float4(1.0/(167.0*_MaskScale),1.0/(122.0*_MaskScale),_MaskPos.x/(-167.0*_MaskScale),_MaskPos.y/(-122.0*_MaskScale));
    o.uv0 = v.uv0*facetexpara.xy+facetexpara.zw;
	o.uv1 = float2(1.0+v.vertex.x,1.0-v.vertex.y)/2.0;
	return o;
}

fixed4 frag(v2f i) : SV_Target
{
	// sample the texture
	fixed4 basecolor = tex2D(_MainTex, i.uv1);
	fixed4 blendcolor = tex2D(_MaskTex, i.uv0);
  fixed3 hightlightcolor = tex2D(_HighTex, i.uv1).rgb;//匹配fbo传入的坐标
  fixed3 newcolor2 = blendOverlaylipsticks(basecolor.rgb, hightlightcolor);//第三次混合
  newcolor2 = newcolor2*blendcolor.a+basecolor.rgb*(1.0-blendcolor.a); //mask过滤
  fixed atten = 1.0 - _Brightscale*hightlightcolor.b;
  newcolor2 = (float3(1.0,1.0,1.0) - (float3(1.0,1.0,1.0) - newcolor2) * fixed3(atten,atten,atten));
  newcolor2 = newcolor2*_Alpha + basecolor.rgb*(1.0-_Alpha); //滑动条
  return fixed4(newcolor2,1.0);
}
ENDCG
#END
