


function DefineParams()
	Properties = 
	{
		
TEXTURE_ALDEBO = {"TEXTURE_ALDEBO", TEXTURE2D, "white" },
TEXTURE_METALLIC = {"TEXTURE_METALLIC", TEXTURE2D, "white" },
TEXTURE_ROUGHNESS = {"TEXTURE_ROUGHNESS", TEXTURE2D, "white" },
TEXTURE_AMR = {"TEXTURE_AMR", TEXTURE2D, "white" },
TEXTURE_NORMAL = {"TEXTURE_NORMAL", TEXTURE2D, "white" },

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"ForwardBase","ForwardAdd"
	}

ShaderName = "pbr"
RenderQueue = "Opaque"
end

function ForwardBase()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","NoLight"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  out_Position_1 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * _glesVertex));
  highp vec4 tmpvar_3;
  tmpvar_3.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_3.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_3 * out_Position_1);
  highp vec3 tmpvar_4;
  tmpvar_4 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_6;
  tmpvar_6 = ((tmpvar_5.yzx * tmpvar_4.zxy) - (tmpvar_5.zxy * tmpvar_4.yzx));
  highp vec3 tmpvar_7;
  tmpvar_7.x = tmpvar_5.x;
  tmpvar_7.y = tmpvar_6.x;
  tmpvar_7.z = tmpvar_4.x;
  highp vec3 tmpvar_8;
  tmpvar_8.x = tmpvar_5.y;
  tmpvar_8.y = tmpvar_6.y;
  tmpvar_8.z = tmpvar_4.y;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_5.z;
  tmpvar_9.y = tmpvar_6.z;
  tmpvar_9.z = tmpvar_4.z;
  highp vec3 tmpvar_10;
  highp vec3 tmpvar_11;
  highp vec3 tmpvar_12;
  tmpvar_10.x = tmpvar_7.x;
  tmpvar_10.y = tmpvar_8.x;
  tmpvar_10.z = tmpvar_9.x;
  tmpvar_11.x = tmpvar_7.y;
  tmpvar_11.y = tmpvar_8.y;
  tmpvar_11.z = tmpvar_9.y;
  tmpvar_12.x = tmpvar_7.z;
  tmpvar_12.y = tmpvar_8.z;
  tmpvar_12.z = tmpvar_9.z;
  highp vec3 v_13;
  v_13.x = tmpvar_10.x;
  v_13.y = tmpvar_11.x;
  v_13.z = tmpvar_12.x;
  highp vec3 v_14;
  v_14.x = tmpvar_10.y;
  v_14.y = tmpvar_11.y;
  v_14.z = tmpvar_12.y;
  highp vec3 v_15;
  v_15.x = tmpvar_10.z;
  v_15.y = tmpvar_11.z;
  v_15.z = tmpvar_12.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = vec3(0.0, 0.0, 1.0);
  xlv_TEXCOORD2 = vec3(0.0, 0.0, 1.0);
  xlv_TEXCOORD3 = v_13;
  xlv_TEXCOORD4 = v_14;
  xlv_TEXCOORD5 = v_15;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize(normalize(tangentNormal_tmp_3));
  highp vec3 tmpvar_10;
  tmpvar_10 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_11;
  tmpvar_11 = max (dot (tmpvar_9, tmpvar_10), 0.0);
  highp vec3 tmpvar_12;
  tmpvar_12.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_12.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_12.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_13;
  tmpvar_13.w = 8.0;
  tmpvar_13.xyz = (T2W_TBN_1 * tmpvar_9);
  lowp vec4 tmpvar_14;
  tmpvar_14 = textureLod (SKY_BOX, tmpvar_13.xyz, 8.0);
  highp vec4 tmpvar_15;
  tmpvar_15 = tmpvar_14;
  highp vec3 I_16;
  I_16 = -(tmpvar_10);
  highp vec4 tmpvar_17;
  tmpvar_17.xyz = (T2W_TBN_1 * (I_16 - (2.0 * 
    (dot (tmpvar_9, I_16) * tmpvar_9)
  )));
  tmpvar_17.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_18;
  tmpvar_18 = textureLod (SKY_BOX, tmpvar_17.xyz, tmpvar_17.w);
  highp vec3 tmpvar_19;
  tmpvar_19 = tmpvar_18.xyz;
  highp float tmpvar_20;
  tmpvar_20 = (1.0 - tmpvar_11);
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = pow (((
    (((1.0 - (tmpvar_8 + 
      ((max (tmpvar_12, tmpvar_8) - tmpvar_8) * pow ((1.0 - tmpvar_11), 5.0))
    )) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2)
   * tmpvar_15.xyz) + (
    ((1.0 - ((0.28 * ao_roughness_metallic_4.y) * (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y))) * tmpvar_19)
   * 
    mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp (((1.0 - ao_roughness_metallic_4.y) + (1.0 - 
      (0.96 - (ao_roughness_metallic_4.z * 0.04))
    )), 0.0, 1.0)), vec3(((tmpvar_20 * tmpvar_20) * ((tmpvar_20 * tmpvar_20) * tmpvar_20))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_21;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * LIGHT_GIVEN_DIRECTION);
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 F_10;
  highp vec3 tmpvar_11;
  tmpvar_11 = normalize(tmpvar_8);
  highp vec3 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(-(xlv_TEXCOORD2));
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize((tmpvar_12 + tmpvar_13));
  highp float tmpvar_15;
  tmpvar_15 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_15 * tmpvar_15);
  highp float tmpvar_17;
  tmpvar_17 = max (dot (tmpvar_11, tmpvar_14), 0.0);
  highp float tmpvar_18;
  tmpvar_18 = (((tmpvar_17 * tmpvar_17) * (tmpvar_16 - 1.0)) + 1.0);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_11, tmpvar_12), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  F_10 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_14, tmpvar_12), 0.0))
  , 5.0)));
  highp float tmpvar_21;
  tmpvar_21 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  highp vec3 tmpvar_22;
  tmpvar_22 = normalize(tmpvar_8);
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_24;
  tmpvar_24 = max (dot (tmpvar_22, tmpvar_23), 0.0);
  highp vec3 tmpvar_25;
  tmpvar_25.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_26;
  tmpvar_26.w = 8.0;
  tmpvar_26.xyz = (T2W_TBN_1 * tmpvar_22);
  lowp vec4 tmpvar_27;
  tmpvar_27 = textureLod (SKY_BOX, tmpvar_26.xyz, 8.0);
  highp vec4 tmpvar_28;
  tmpvar_28 = tmpvar_27;
  highp vec3 I_29;
  I_29 = -(tmpvar_23);
  highp vec4 tmpvar_30;
  tmpvar_30.xyz = (T2W_TBN_1 * (I_29 - (2.0 * 
    (dot (tmpvar_22, I_29) * tmpvar_22)
  )));
  tmpvar_30.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_31;
  tmpvar_31 = textureLod (SKY_BOX, tmpvar_30.xyz, tmpvar_30.w);
  highp vec3 tmpvar_32;
  tmpvar_32 = tmpvar_31.xyz;
  highp float tmpvar_33;
  tmpvar_33 = (1.0 - tmpvar_24);
  highp vec4 tmpvar_34;
  tmpvar_34.w = 1.0;
  tmpvar_34.xyz = pow (((
    ((((
      ((tmpvar_16 / ((3.141593 * tmpvar_18) * tmpvar_18)) * (0.5 / ((
        (tmpvar_20 * ((tmpvar_19 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_19 * ((tmpvar_20 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_10) * 3.14) * tmpvar_21) * LIGHT_COLOR)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_10) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_21) * LIGHT_COLOR)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_25, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_24), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_28.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_32) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_33 * tmpvar_33) * (
      (tmpvar_33 * tmpvar_33)
     * tmpvar_33)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_34;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * LIGHT_GIVEN_DIRECTION);
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 F_10;
  highp vec3 tmpvar_11;
  tmpvar_11 = normalize(tmpvar_8);
  highp vec3 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(-(xlv_TEXCOORD2));
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize((tmpvar_12 + tmpvar_13));
  highp float tmpvar_15;
  tmpvar_15 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_15 * tmpvar_15);
  highp float tmpvar_17;
  tmpvar_17 = max (dot (tmpvar_11, tmpvar_14), 0.0);
  highp float tmpvar_18;
  tmpvar_18 = (((tmpvar_17 * tmpvar_17) * (tmpvar_16 - 1.0)) + 1.0);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_11, tmpvar_12), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  F_10 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_14, tmpvar_12), 0.0))
  , 5.0)));
  highp float tmpvar_21;
  tmpvar_21 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  highp vec3 tmpvar_22;
  tmpvar_22 = normalize(tmpvar_8);
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_24;
  tmpvar_24 = max (dot (tmpvar_22, tmpvar_23), 0.0);
  highp vec3 tmpvar_25;
  tmpvar_25.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_26;
  tmpvar_26.w = 8.0;
  tmpvar_26.xyz = (T2W_TBN_1 * tmpvar_22);
  lowp vec4 tmpvar_27;
  tmpvar_27 = textureLod (SKY_BOX, tmpvar_26.xyz, 8.0);
  highp vec4 tmpvar_28;
  tmpvar_28 = tmpvar_27;
  highp vec3 I_29;
  I_29 = -(tmpvar_23);
  highp vec4 tmpvar_30;
  tmpvar_30.xyz = (T2W_TBN_1 * (I_29 - (2.0 * 
    (dot (tmpvar_22, I_29) * tmpvar_22)
  )));
  tmpvar_30.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_31;
  tmpvar_31 = textureLod (SKY_BOX, tmpvar_30.xyz, tmpvar_30.w);
  highp vec3 tmpvar_32;
  tmpvar_32 = tmpvar_31.xyz;
  highp float tmpvar_33;
  tmpvar_33 = (1.0 - tmpvar_24);
  highp vec4 tmpvar_34;
  tmpvar_34.w = 1.0;
  tmpvar_34.xyz = pow (((
    ((((
      ((tmpvar_16 / ((3.141593 * tmpvar_18) * tmpvar_18)) * (0.5 / ((
        (tmpvar_20 * ((tmpvar_19 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_19 * ((tmpvar_20 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_10) * 3.14) * tmpvar_21) * LIGHT_COLOR)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_10) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_21) * LIGHT_COLOR)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_25, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_24), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_28.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_32) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_33 * tmpvar_33) * (
      (tmpvar_33 * tmpvar_33)
     * tmpvar_33)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_34;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * LIGHT_GIVEN_DIRECTION);
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 F_10;
  highp vec3 tmpvar_11;
  tmpvar_11 = normalize(tmpvar_8);
  highp vec3 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(-(xlv_TEXCOORD2));
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize((tmpvar_12 + tmpvar_13));
  highp float tmpvar_15;
  tmpvar_15 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_15 * tmpvar_15);
  highp float tmpvar_17;
  tmpvar_17 = max (dot (tmpvar_11, tmpvar_14), 0.0);
  highp float tmpvar_18;
  tmpvar_18 = (((tmpvar_17 * tmpvar_17) * (tmpvar_16 - 1.0)) + 1.0);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_11, tmpvar_12), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  F_10 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_14, tmpvar_12), 0.0))
  , 5.0)));
  highp float tmpvar_21;
  tmpvar_21 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  highp vec3 tmpvar_22;
  tmpvar_22 = normalize(tmpvar_8);
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_24;
  tmpvar_24 = max (dot (tmpvar_22, tmpvar_23), 0.0);
  highp vec3 tmpvar_25;
  tmpvar_25.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_26;
  tmpvar_26.w = 8.0;
  tmpvar_26.xyz = (T2W_TBN_1 * tmpvar_22);
  lowp vec4 tmpvar_27;
  tmpvar_27 = textureLod (SKY_BOX, tmpvar_26.xyz, 8.0);
  highp vec4 tmpvar_28;
  tmpvar_28 = tmpvar_27;
  highp vec3 I_29;
  I_29 = -(tmpvar_23);
  highp vec4 tmpvar_30;
  tmpvar_30.xyz = (T2W_TBN_1 * (I_29 - (2.0 * 
    (dot (tmpvar_22, I_29) * tmpvar_22)
  )));
  tmpvar_30.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_31;
  tmpvar_31 = textureLod (SKY_BOX, tmpvar_30.xyz, tmpvar_30.w);
  highp vec3 tmpvar_32;
  tmpvar_32 = tmpvar_31.xyz;
  highp float tmpvar_33;
  tmpvar_33 = (1.0 - tmpvar_24);
  highp vec4 tmpvar_34;
  tmpvar_34.w = 1.0;
  tmpvar_34.xyz = pow (((
    ((((
      ((tmpvar_16 / ((3.141593 * tmpvar_18) * tmpvar_18)) * (0.5 / ((
        (tmpvar_20 * ((tmpvar_19 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_19 * ((tmpvar_20 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_10) * 3.14) * tmpvar_21) * LIGHT_COLOR)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_10) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_21) * LIGHT_COLOR)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_25, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_24), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_28.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_32) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_33 * tmpvar_33) * (
      (tmpvar_33 * tmpvar_33)
     * tmpvar_33)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_34;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * LIGHT_GIVEN_DIRECTION);
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 F_10;
  highp vec3 tmpvar_11;
  tmpvar_11 = normalize(tmpvar_8);
  highp vec3 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(-(xlv_TEXCOORD2));
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize((tmpvar_12 + tmpvar_13));
  highp float tmpvar_15;
  tmpvar_15 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_15 * tmpvar_15);
  highp float tmpvar_17;
  tmpvar_17 = max (dot (tmpvar_11, tmpvar_14), 0.0);
  highp float tmpvar_18;
  tmpvar_18 = (((tmpvar_17 * tmpvar_17) * (tmpvar_16 - 1.0)) + 1.0);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_11, tmpvar_12), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  F_10 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_14, tmpvar_12), 0.0))
  , 5.0)));
  highp float tmpvar_21;
  tmpvar_21 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  highp vec3 tmpvar_22;
  tmpvar_22 = normalize(tmpvar_8);
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_24;
  tmpvar_24 = max (dot (tmpvar_22, tmpvar_23), 0.0);
  highp vec3 tmpvar_25;
  tmpvar_25.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_26;
  tmpvar_26.w = 8.0;
  tmpvar_26.xyz = (T2W_TBN_1 * tmpvar_22);
  lowp vec4 tmpvar_27;
  tmpvar_27 = textureLod (SKY_BOX, tmpvar_26.xyz, 8.0);
  highp vec4 tmpvar_28;
  tmpvar_28 = tmpvar_27;
  highp vec3 I_29;
  I_29 = -(tmpvar_23);
  highp vec4 tmpvar_30;
  tmpvar_30.xyz = (T2W_TBN_1 * (I_29 - (2.0 * 
    (dot (tmpvar_22, I_29) * tmpvar_22)
  )));
  tmpvar_30.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_31;
  tmpvar_31 = textureLod (SKY_BOX, tmpvar_30.xyz, tmpvar_30.w);
  highp vec3 tmpvar_32;
  tmpvar_32 = tmpvar_31.xyz;
  highp float tmpvar_33;
  tmpvar_33 = (1.0 - tmpvar_24);
  highp vec4 tmpvar_34;
  tmpvar_34.w = 1.0;
  tmpvar_34.xyz = pow (((
    ((((
      ((tmpvar_16 / ((3.141593 * tmpvar_18) * tmpvar_18)) * (0.5 / ((
        (tmpvar_20 * ((tmpvar_19 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_19 * ((tmpvar_20 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_10) * 3.14) * tmpvar_21) * LIGHT_COLOR)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_10) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_21) * LIGHT_COLOR)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_25, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_24), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_28.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_32) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_33 * tmpvar_33) * (
      (tmpvar_33 * tmpvar_33)
     * tmpvar_33)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_34;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * LIGHT_GIVEN_DIRECTION);
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 F_10;
  highp vec3 tmpvar_11;
  tmpvar_11 = normalize(tmpvar_8);
  highp vec3 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(-(xlv_TEXCOORD2));
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize((tmpvar_12 + tmpvar_13));
  highp float tmpvar_15;
  tmpvar_15 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_15 * tmpvar_15);
  highp float tmpvar_17;
  tmpvar_17 = max (dot (tmpvar_11, tmpvar_14), 0.0);
  highp float tmpvar_18;
  tmpvar_18 = (((tmpvar_17 * tmpvar_17) * (tmpvar_16 - 1.0)) + 1.0);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_11, tmpvar_12), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  F_10 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_14, tmpvar_12), 0.0))
  , 5.0)));
  highp float tmpvar_21;
  tmpvar_21 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  highp vec3 tmpvar_22;
  tmpvar_22 = normalize(tmpvar_8);
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_24;
  tmpvar_24 = max (dot (tmpvar_22, tmpvar_23), 0.0);
  highp vec3 tmpvar_25;
  tmpvar_25.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_26;
  tmpvar_26.w = 8.0;
  tmpvar_26.xyz = (T2W_TBN_1 * tmpvar_22);
  lowp vec4 tmpvar_27;
  tmpvar_27 = textureLod (SKY_BOX, tmpvar_26.xyz, 8.0);
  highp vec4 tmpvar_28;
  tmpvar_28 = tmpvar_27;
  highp vec3 I_29;
  I_29 = -(tmpvar_23);
  highp vec4 tmpvar_30;
  tmpvar_30.xyz = (T2W_TBN_1 * (I_29 - (2.0 * 
    (dot (tmpvar_22, I_29) * tmpvar_22)
  )));
  tmpvar_30.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_31;
  tmpvar_31 = textureLod (SKY_BOX, tmpvar_30.xyz, tmpvar_30.w);
  highp vec3 tmpvar_32;
  tmpvar_32 = tmpvar_31.xyz;
  highp float tmpvar_33;
  tmpvar_33 = (1.0 - tmpvar_24);
  highp vec4 tmpvar_34;
  tmpvar_34.w = 1.0;
  tmpvar_34.xyz = pow (((
    ((((
      ((tmpvar_16 / ((3.141593 * tmpvar_18) * tmpvar_18)) * (0.5 / ((
        (tmpvar_20 * ((tmpvar_19 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_19 * ((tmpvar_20 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_10) * 3.14) * tmpvar_21) * LIGHT_COLOR)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_10) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_21) * LIGHT_COLOR)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_25, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_24), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_28.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_32) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_33 * tmpvar_33) * (
      (tmpvar_33 * tmpvar_33)
     * tmpvar_33)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_34;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"NoLight"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  out_Position_1 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * _glesVertex));
  highp vec4 tmpvar_3;
  tmpvar_3.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_3.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_3 * out_Position_1);
  highp vec3 tmpvar_4;
  tmpvar_4 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_6;
  tmpvar_6 = ((tmpvar_5.yzx * tmpvar_4.zxy) - (tmpvar_5.zxy * tmpvar_4.yzx));
  highp vec3 tmpvar_7;
  tmpvar_7.x = tmpvar_5.x;
  tmpvar_7.y = tmpvar_6.x;
  tmpvar_7.z = tmpvar_4.x;
  highp vec3 tmpvar_8;
  tmpvar_8.x = tmpvar_5.y;
  tmpvar_8.y = tmpvar_6.y;
  tmpvar_8.z = tmpvar_4.y;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_5.z;
  tmpvar_9.y = tmpvar_6.z;
  tmpvar_9.z = tmpvar_4.z;
  highp vec3 tmpvar_10;
  highp vec3 tmpvar_11;
  highp vec3 tmpvar_12;
  tmpvar_10.x = tmpvar_7.x;
  tmpvar_10.y = tmpvar_8.x;
  tmpvar_10.z = tmpvar_9.x;
  tmpvar_11.x = tmpvar_7.y;
  tmpvar_11.y = tmpvar_8.y;
  tmpvar_11.z = tmpvar_9.y;
  tmpvar_12.x = tmpvar_7.z;
  tmpvar_12.y = tmpvar_8.z;
  tmpvar_12.z = tmpvar_9.z;
  highp vec3 v_13;
  v_13.x = tmpvar_10.x;
  v_13.y = tmpvar_11.x;
  v_13.z = tmpvar_12.x;
  highp vec3 v_14;
  v_14.x = tmpvar_10.y;
  v_14.y = tmpvar_11.y;
  v_14.z = tmpvar_12.y;
  highp vec3 v_15;
  v_15.x = tmpvar_10.z;
  v_15.y = tmpvar_11.z;
  v_15.z = tmpvar_12.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = vec3(0.0, 0.0, 1.0);
  xlv_TEXCOORD2 = vec3(0.0, 0.0, 1.0);
  xlv_TEXCOORD3 = v_13;
  xlv_TEXCOORD4 = v_14;
  xlv_TEXCOORD5 = v_15;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize(normalize(tangentNormal_tmp_3));
  highp vec3 tmpvar_10;
  tmpvar_10 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_11;
  tmpvar_11 = max (dot (tmpvar_9, tmpvar_10), 0.0);
  highp vec3 tmpvar_12;
  tmpvar_12.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_12.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_12.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_13;
  tmpvar_13.w = 8.0;
  tmpvar_13.xyz = (T2W_TBN_1 * tmpvar_9);
  lowp vec4 tmpvar_14;
  tmpvar_14 = textureLod (SKY_BOX, tmpvar_13.xyz, 8.0);
  highp vec4 tmpvar_15;
  tmpvar_15 = tmpvar_14;
  highp vec3 I_16;
  I_16 = -(tmpvar_10);
  highp vec4 tmpvar_17;
  tmpvar_17.xyz = (T2W_TBN_1 * (I_16 - (2.0 * 
    (dot (tmpvar_9, I_16) * tmpvar_9)
  )));
  tmpvar_17.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_18;
  tmpvar_18 = textureLod (SKY_BOX, tmpvar_17.xyz, tmpvar_17.w);
  highp vec3 tmpvar_19;
  tmpvar_19 = tmpvar_18.xyz;
  highp float tmpvar_20;
  tmpvar_20 = (1.0 - tmpvar_11);
  highp vec4 tmpvar_21;
  tmpvar_21.w = 1.0;
  tmpvar_21.xyz = pow (((
    (((1.0 - (tmpvar_8 + 
      ((max (tmpvar_12, tmpvar_8) - tmpvar_8) * pow ((1.0 - tmpvar_11), 5.0))
    )) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2)
   * tmpvar_15.xyz) + (
    ((1.0 - ((0.28 * ao_roughness_metallic_4.y) * (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y))) * tmpvar_19)
   * 
    mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp (((1.0 - ao_roughness_metallic_4.y) + (1.0 - 
      (0.96 - (ao_roughness_metallic_4.z * 0.04))
    )), 0.0, 1.0)), vec3(((tmpvar_20 * tmpvar_20) * ((tmpvar_20 * tmpvar_20) * tmpvar_20))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_21;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * LIGHT_GIVEN_DIRECTION);
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 F_10;
  highp vec3 tmpvar_11;
  tmpvar_11 = normalize(tmpvar_8);
  highp vec3 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(-(xlv_TEXCOORD2));
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize((tmpvar_12 + tmpvar_13));
  highp float tmpvar_15;
  tmpvar_15 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_15 * tmpvar_15);
  highp float tmpvar_17;
  tmpvar_17 = max (dot (tmpvar_11, tmpvar_14), 0.0);
  highp float tmpvar_18;
  tmpvar_18 = (((tmpvar_17 * tmpvar_17) * (tmpvar_16 - 1.0)) + 1.0);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_11, tmpvar_12), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  F_10 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_14, tmpvar_12), 0.0))
  , 5.0)));
  highp float tmpvar_21;
  tmpvar_21 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  highp vec3 tmpvar_22;
  tmpvar_22 = normalize(tmpvar_8);
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_24;
  tmpvar_24 = max (dot (tmpvar_22, tmpvar_23), 0.0);
  highp vec3 tmpvar_25;
  tmpvar_25.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_26;
  tmpvar_26.w = 8.0;
  tmpvar_26.xyz = (T2W_TBN_1 * tmpvar_22);
  lowp vec4 tmpvar_27;
  tmpvar_27 = textureLod (SKY_BOX, tmpvar_26.xyz, 8.0);
  highp vec4 tmpvar_28;
  tmpvar_28 = tmpvar_27;
  highp vec3 I_29;
  I_29 = -(tmpvar_23);
  highp vec4 tmpvar_30;
  tmpvar_30.xyz = (T2W_TBN_1 * (I_29 - (2.0 * 
    (dot (tmpvar_22, I_29) * tmpvar_22)
  )));
  tmpvar_30.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_31;
  tmpvar_31 = textureLod (SKY_BOX, tmpvar_30.xyz, tmpvar_30.w);
  highp vec3 tmpvar_32;
  tmpvar_32 = tmpvar_31.xyz;
  highp float tmpvar_33;
  tmpvar_33 = (1.0 - tmpvar_24);
  highp vec4 tmpvar_34;
  tmpvar_34.w = 1.0;
  tmpvar_34.xyz = pow (((
    ((((
      ((tmpvar_16 / ((3.141593 * tmpvar_18) * tmpvar_18)) * (0.5 / ((
        (tmpvar_20 * ((tmpvar_19 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_19 * ((tmpvar_20 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_10) * 3.14) * tmpvar_21) * LIGHT_COLOR)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_10) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_21) * LIGHT_COLOR)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_25, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_24), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_28.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_32) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_33 * tmpvar_33) * (
      (tmpvar_33 * tmpvar_33)
     * tmpvar_33)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_34;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * LIGHT_GIVEN_DIRECTION);
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 F_10;
  highp vec3 tmpvar_11;
  tmpvar_11 = normalize(tmpvar_8);
  highp vec3 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(-(xlv_TEXCOORD2));
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize((tmpvar_12 + tmpvar_13));
  highp float tmpvar_15;
  tmpvar_15 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_15 * tmpvar_15);
  highp float tmpvar_17;
  tmpvar_17 = max (dot (tmpvar_11, tmpvar_14), 0.0);
  highp float tmpvar_18;
  tmpvar_18 = (((tmpvar_17 * tmpvar_17) * (tmpvar_16 - 1.0)) + 1.0);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_11, tmpvar_12), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  F_10 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_14, tmpvar_12), 0.0))
  , 5.0)));
  highp float tmpvar_21;
  tmpvar_21 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  highp vec3 tmpvar_22;
  tmpvar_22 = normalize(tmpvar_8);
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_24;
  tmpvar_24 = max (dot (tmpvar_22, tmpvar_23), 0.0);
  highp vec3 tmpvar_25;
  tmpvar_25.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_26;
  tmpvar_26.w = 8.0;
  tmpvar_26.xyz = (T2W_TBN_1 * tmpvar_22);
  lowp vec4 tmpvar_27;
  tmpvar_27 = textureLod (SKY_BOX, tmpvar_26.xyz, 8.0);
  highp vec4 tmpvar_28;
  tmpvar_28 = tmpvar_27;
  highp vec3 I_29;
  I_29 = -(tmpvar_23);
  highp vec4 tmpvar_30;
  tmpvar_30.xyz = (T2W_TBN_1 * (I_29 - (2.0 * 
    (dot (tmpvar_22, I_29) * tmpvar_22)
  )));
  tmpvar_30.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_31;
  tmpvar_31 = textureLod (SKY_BOX, tmpvar_30.xyz, tmpvar_30.w);
  highp vec3 tmpvar_32;
  tmpvar_32 = tmpvar_31.xyz;
  highp float tmpvar_33;
  tmpvar_33 = (1.0 - tmpvar_24);
  highp vec4 tmpvar_34;
  tmpvar_34.w = 1.0;
  tmpvar_34.xyz = pow (((
    ((((
      ((tmpvar_16 / ((3.141593 * tmpvar_18) * tmpvar_18)) * (0.5 / ((
        (tmpvar_20 * ((tmpvar_19 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_19 * ((tmpvar_20 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_10) * 3.14) * tmpvar_21) * LIGHT_COLOR)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_10) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_21) * LIGHT_COLOR)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_25, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_24), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_28.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_32) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_33 * tmpvar_33) * (
      (tmpvar_33 * tmpvar_33)
     * tmpvar_33)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_34;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * LIGHT_GIVEN_DIRECTION);
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 F_10;
  highp vec3 tmpvar_11;
  tmpvar_11 = normalize(tmpvar_8);
  highp vec3 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(-(xlv_TEXCOORD2));
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize((tmpvar_12 + tmpvar_13));
  highp float tmpvar_15;
  tmpvar_15 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_15 * tmpvar_15);
  highp float tmpvar_17;
  tmpvar_17 = max (dot (tmpvar_11, tmpvar_14), 0.0);
  highp float tmpvar_18;
  tmpvar_18 = (((tmpvar_17 * tmpvar_17) * (tmpvar_16 - 1.0)) + 1.0);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_11, tmpvar_12), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  F_10 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_14, tmpvar_12), 0.0))
  , 5.0)));
  highp float tmpvar_21;
  tmpvar_21 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  highp vec3 tmpvar_22;
  tmpvar_22 = normalize(tmpvar_8);
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_24;
  tmpvar_24 = max (dot (tmpvar_22, tmpvar_23), 0.0);
  highp vec3 tmpvar_25;
  tmpvar_25.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_26;
  tmpvar_26.w = 8.0;
  tmpvar_26.xyz = (T2W_TBN_1 * tmpvar_22);
  lowp vec4 tmpvar_27;
  tmpvar_27 = textureLod (SKY_BOX, tmpvar_26.xyz, 8.0);
  highp vec4 tmpvar_28;
  tmpvar_28 = tmpvar_27;
  highp vec3 I_29;
  I_29 = -(tmpvar_23);
  highp vec4 tmpvar_30;
  tmpvar_30.xyz = (T2W_TBN_1 * (I_29 - (2.0 * 
    (dot (tmpvar_22, I_29) * tmpvar_22)
  )));
  tmpvar_30.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_31;
  tmpvar_31 = textureLod (SKY_BOX, tmpvar_30.xyz, tmpvar_30.w);
  highp vec3 tmpvar_32;
  tmpvar_32 = tmpvar_31.xyz;
  highp float tmpvar_33;
  tmpvar_33 = (1.0 - tmpvar_24);
  highp vec4 tmpvar_34;
  tmpvar_34.w = 1.0;
  tmpvar_34.xyz = pow (((
    ((((
      ((tmpvar_16 / ((3.141593 * tmpvar_18) * tmpvar_18)) * (0.5 / ((
        (tmpvar_20 * ((tmpvar_19 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_19 * ((tmpvar_20 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_10) * 3.14) * tmpvar_21) * LIGHT_COLOR)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_10) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_21) * LIGHT_COLOR)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_25, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_24), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_28.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_32) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_33 * tmpvar_33) * (
      (tmpvar_33 * tmpvar_33)
     * tmpvar_33)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_34;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * LIGHT_GIVEN_DIRECTION);
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 F_10;
  highp vec3 tmpvar_11;
  tmpvar_11 = normalize(tmpvar_8);
  highp vec3 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(-(xlv_TEXCOORD2));
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize((tmpvar_12 + tmpvar_13));
  highp float tmpvar_15;
  tmpvar_15 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_15 * tmpvar_15);
  highp float tmpvar_17;
  tmpvar_17 = max (dot (tmpvar_11, tmpvar_14), 0.0);
  highp float tmpvar_18;
  tmpvar_18 = (((tmpvar_17 * tmpvar_17) * (tmpvar_16 - 1.0)) + 1.0);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_11, tmpvar_12), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  F_10 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_14, tmpvar_12), 0.0))
  , 5.0)));
  highp float tmpvar_21;
  tmpvar_21 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  highp vec3 tmpvar_22;
  tmpvar_22 = normalize(tmpvar_8);
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_24;
  tmpvar_24 = max (dot (tmpvar_22, tmpvar_23), 0.0);
  highp vec3 tmpvar_25;
  tmpvar_25.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_26;
  tmpvar_26.w = 8.0;
  tmpvar_26.xyz = (T2W_TBN_1 * tmpvar_22);
  lowp vec4 tmpvar_27;
  tmpvar_27 = textureLod (SKY_BOX, tmpvar_26.xyz, 8.0);
  highp vec4 tmpvar_28;
  tmpvar_28 = tmpvar_27;
  highp vec3 I_29;
  I_29 = -(tmpvar_23);
  highp vec4 tmpvar_30;
  tmpvar_30.xyz = (T2W_TBN_1 * (I_29 - (2.0 * 
    (dot (tmpvar_22, I_29) * tmpvar_22)
  )));
  tmpvar_30.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_31;
  tmpvar_31 = textureLod (SKY_BOX, tmpvar_30.xyz, tmpvar_30.w);
  highp vec3 tmpvar_32;
  tmpvar_32 = tmpvar_31.xyz;
  highp float tmpvar_33;
  tmpvar_33 = (1.0 - tmpvar_24);
  highp vec4 tmpvar_34;
  tmpvar_34.w = 1.0;
  tmpvar_34.xyz = pow (((
    ((((
      ((tmpvar_16 / ((3.141593 * tmpvar_18) * tmpvar_18)) * (0.5 / ((
        (tmpvar_20 * ((tmpvar_19 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_19 * ((tmpvar_20 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_10) * 3.14) * tmpvar_21) * LIGHT_COLOR)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_10) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_21) * LIGHT_COLOR)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_25, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_24), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_28.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_32) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_33 * tmpvar_33) * (
      (tmpvar_33 * tmpvar_33)
     * tmpvar_33)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_34;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * LIGHT_GIVEN_DIRECTION);
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 F_10;
  highp vec3 tmpvar_11;
  tmpvar_11 = normalize(tmpvar_8);
  highp vec3 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(-(xlv_TEXCOORD2));
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize((tmpvar_12 + tmpvar_13));
  highp float tmpvar_15;
  tmpvar_15 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_15 * tmpvar_15);
  highp float tmpvar_17;
  tmpvar_17 = max (dot (tmpvar_11, tmpvar_14), 0.0);
  highp float tmpvar_18;
  tmpvar_18 = (((tmpvar_17 * tmpvar_17) * (tmpvar_16 - 1.0)) + 1.0);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_11, tmpvar_12), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  F_10 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_14, tmpvar_12), 0.0))
  , 5.0)));
  highp float tmpvar_21;
  tmpvar_21 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  highp vec3 tmpvar_22;
  tmpvar_22 = normalize(tmpvar_8);
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_24;
  tmpvar_24 = max (dot (tmpvar_22, tmpvar_23), 0.0);
  highp vec3 tmpvar_25;
  tmpvar_25.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_26;
  tmpvar_26.w = 8.0;
  tmpvar_26.xyz = (T2W_TBN_1 * tmpvar_22);
  lowp vec4 tmpvar_27;
  tmpvar_27 = textureLod (SKY_BOX, tmpvar_26.xyz, 8.0);
  highp vec4 tmpvar_28;
  tmpvar_28 = tmpvar_27;
  highp vec3 I_29;
  I_29 = -(tmpvar_23);
  highp vec4 tmpvar_30;
  tmpvar_30.xyz = (T2W_TBN_1 * (I_29 - (2.0 * 
    (dot (tmpvar_22, I_29) * tmpvar_22)
  )));
  tmpvar_30.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_31;
  tmpvar_31 = textureLod (SKY_BOX, tmpvar_30.xyz, tmpvar_30.w);
  highp vec3 tmpvar_32;
  tmpvar_32 = tmpvar_31.xyz;
  highp float tmpvar_33;
  tmpvar_33 = (1.0 - tmpvar_24);
  highp vec4 tmpvar_34;
  tmpvar_34.w = 1.0;
  tmpvar_34.xyz = pow (((
    ((((
      ((tmpvar_16 / ((3.141593 * tmpvar_18) * tmpvar_18)) * (0.5 / ((
        (tmpvar_20 * ((tmpvar_19 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_19 * ((tmpvar_20 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_10) * 3.14) * tmpvar_21) * LIGHT_COLOR)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_10) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_21) * LIGHT_COLOR)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_25, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_24), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_28.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_32) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_33 * tmpvar_33) * (
      (tmpvar_33 * tmpvar_33)
     * tmpvar_33)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_34;
}

]===],
	},
}

end

function ForwardAdd()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, ONE, ONE, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LEQUAL }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDADD }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * LIGHT_GIVEN_DIRECTION);
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 F_10;
  highp vec3 tmpvar_11;
  tmpvar_11 = normalize(tmpvar_8);
  highp vec3 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(-(xlv_TEXCOORD2));
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize((tmpvar_12 + tmpvar_13));
  highp float tmpvar_15;
  tmpvar_15 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_15 * tmpvar_15);
  highp float tmpvar_17;
  tmpvar_17 = max (dot (tmpvar_11, tmpvar_14), 0.0);
  highp float tmpvar_18;
  tmpvar_18 = (((tmpvar_17 * tmpvar_17) * (tmpvar_16 - 1.0)) + 1.0);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_11, tmpvar_12), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  F_10 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_14, tmpvar_12), 0.0))
  , 5.0)));
  highp float tmpvar_21;
  tmpvar_21 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  highp vec3 tmpvar_22;
  tmpvar_22 = normalize(tmpvar_8);
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_24;
  tmpvar_24 = max (dot (tmpvar_22, tmpvar_23), 0.0);
  highp vec3 tmpvar_25;
  tmpvar_25.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_26;
  tmpvar_26.w = 8.0;
  tmpvar_26.xyz = (T2W_TBN_1 * tmpvar_22);
  lowp vec4 tmpvar_27;
  tmpvar_27 = textureLod (SKY_BOX, tmpvar_26.xyz, 8.0);
  highp vec4 tmpvar_28;
  tmpvar_28 = tmpvar_27;
  highp vec3 I_29;
  I_29 = -(tmpvar_23);
  highp vec4 tmpvar_30;
  tmpvar_30.xyz = (T2W_TBN_1 * (I_29 - (2.0 * 
    (dot (tmpvar_22, I_29) * tmpvar_22)
  )));
  tmpvar_30.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_31;
  tmpvar_31 = textureLod (SKY_BOX, tmpvar_30.xyz, tmpvar_30.w);
  highp vec3 tmpvar_32;
  tmpvar_32 = tmpvar_31.xyz;
  highp float tmpvar_33;
  tmpvar_33 = (1.0 - tmpvar_24);
  highp vec4 tmpvar_34;
  tmpvar_34.w = 1.0;
  tmpvar_34.xyz = pow (((
    ((((
      ((tmpvar_16 / ((3.141593 * tmpvar_18) * tmpvar_18)) * (0.5 / ((
        (tmpvar_20 * ((tmpvar_19 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_19 * ((tmpvar_20 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_10) * 3.14) * tmpvar_21) * LIGHT_COLOR)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_10) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_21) * LIGHT_COLOR)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_25, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_24), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_28.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_32) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_33 * tmpvar_33) * (
      (tmpvar_33 * tmpvar_33)
     * tmpvar_33)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_34;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * LIGHT_GIVEN_DIRECTION);
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 F_10;
  highp vec3 tmpvar_11;
  tmpvar_11 = normalize(tmpvar_8);
  highp vec3 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(-(xlv_TEXCOORD2));
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize((tmpvar_12 + tmpvar_13));
  highp float tmpvar_15;
  tmpvar_15 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_15 * tmpvar_15);
  highp float tmpvar_17;
  tmpvar_17 = max (dot (tmpvar_11, tmpvar_14), 0.0);
  highp float tmpvar_18;
  tmpvar_18 = (((tmpvar_17 * tmpvar_17) * (tmpvar_16 - 1.0)) + 1.0);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_11, tmpvar_12), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  F_10 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_14, tmpvar_12), 0.0))
  , 5.0)));
  highp float tmpvar_21;
  tmpvar_21 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  highp vec3 tmpvar_22;
  tmpvar_22 = normalize(tmpvar_8);
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_24;
  tmpvar_24 = max (dot (tmpvar_22, tmpvar_23), 0.0);
  highp vec3 tmpvar_25;
  tmpvar_25.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_26;
  tmpvar_26.w = 8.0;
  tmpvar_26.xyz = (T2W_TBN_1 * tmpvar_22);
  lowp vec4 tmpvar_27;
  tmpvar_27 = textureLod (SKY_BOX, tmpvar_26.xyz, 8.0);
  highp vec4 tmpvar_28;
  tmpvar_28 = tmpvar_27;
  highp vec3 I_29;
  I_29 = -(tmpvar_23);
  highp vec4 tmpvar_30;
  tmpvar_30.xyz = (T2W_TBN_1 * (I_29 - (2.0 * 
    (dot (tmpvar_22, I_29) * tmpvar_22)
  )));
  tmpvar_30.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_31;
  tmpvar_31 = textureLod (SKY_BOX, tmpvar_30.xyz, tmpvar_30.w);
  highp vec3 tmpvar_32;
  tmpvar_32 = tmpvar_31.xyz;
  highp float tmpvar_33;
  tmpvar_33 = (1.0 - tmpvar_24);
  highp vec4 tmpvar_34;
  tmpvar_34.w = 1.0;
  tmpvar_34.xyz = pow (((
    ((((
      ((tmpvar_16 / ((3.141593 * tmpvar_18) * tmpvar_18)) * (0.5 / ((
        (tmpvar_20 * ((tmpvar_19 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_19 * ((tmpvar_20 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_10) * 3.14) * tmpvar_21) * LIGHT_COLOR)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_10) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_21) * LIGHT_COLOR)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_25, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_24), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_28.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_32) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_33 * tmpvar_33) * (
      (tmpvar_33 * tmpvar_33)
     * tmpvar_33)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_34;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * LIGHT_GIVEN_DIRECTION);
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 F_10;
  highp vec3 tmpvar_11;
  tmpvar_11 = normalize(tmpvar_8);
  highp vec3 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(-(xlv_TEXCOORD2));
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize((tmpvar_12 + tmpvar_13));
  highp float tmpvar_15;
  tmpvar_15 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_15 * tmpvar_15);
  highp float tmpvar_17;
  tmpvar_17 = max (dot (tmpvar_11, tmpvar_14), 0.0);
  highp float tmpvar_18;
  tmpvar_18 = (((tmpvar_17 * tmpvar_17) * (tmpvar_16 - 1.0)) + 1.0);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_11, tmpvar_12), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  F_10 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_14, tmpvar_12), 0.0))
  , 5.0)));
  highp float tmpvar_21;
  tmpvar_21 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  highp vec3 tmpvar_22;
  tmpvar_22 = normalize(tmpvar_8);
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_24;
  tmpvar_24 = max (dot (tmpvar_22, tmpvar_23), 0.0);
  highp vec3 tmpvar_25;
  tmpvar_25.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_26;
  tmpvar_26.w = 8.0;
  tmpvar_26.xyz = (T2W_TBN_1 * tmpvar_22);
  lowp vec4 tmpvar_27;
  tmpvar_27 = textureLod (SKY_BOX, tmpvar_26.xyz, 8.0);
  highp vec4 tmpvar_28;
  tmpvar_28 = tmpvar_27;
  highp vec3 I_29;
  I_29 = -(tmpvar_23);
  highp vec4 tmpvar_30;
  tmpvar_30.xyz = (T2W_TBN_1 * (I_29 - (2.0 * 
    (dot (tmpvar_22, I_29) * tmpvar_22)
  )));
  tmpvar_30.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_31;
  tmpvar_31 = textureLod (SKY_BOX, tmpvar_30.xyz, tmpvar_30.w);
  highp vec3 tmpvar_32;
  tmpvar_32 = tmpvar_31.xyz;
  highp float tmpvar_33;
  tmpvar_33 = (1.0 - tmpvar_24);
  highp vec4 tmpvar_34;
  tmpvar_34.w = 1.0;
  tmpvar_34.xyz = pow (((
    ((((
      ((tmpvar_16 / ((3.141593 * tmpvar_18) * tmpvar_18)) * (0.5 / ((
        (tmpvar_20 * ((tmpvar_19 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_19 * ((tmpvar_20 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_10) * 3.14) * tmpvar_21) * LIGHT_COLOR)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_10) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_21) * LIGHT_COLOR)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_25, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_24), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_28.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_32) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_33 * tmpvar_33) * (
      (tmpvar_33 * tmpvar_33)
     * tmpvar_33)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_34;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * LIGHT_GIVEN_DIRECTION);
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 F_10;
  highp vec3 tmpvar_11;
  tmpvar_11 = normalize(tmpvar_8);
  highp vec3 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(-(xlv_TEXCOORD2));
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize((tmpvar_12 + tmpvar_13));
  highp float tmpvar_15;
  tmpvar_15 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_15 * tmpvar_15);
  highp float tmpvar_17;
  tmpvar_17 = max (dot (tmpvar_11, tmpvar_14), 0.0);
  highp float tmpvar_18;
  tmpvar_18 = (((tmpvar_17 * tmpvar_17) * (tmpvar_16 - 1.0)) + 1.0);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_11, tmpvar_12), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  F_10 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_14, tmpvar_12), 0.0))
  , 5.0)));
  highp float tmpvar_21;
  tmpvar_21 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  highp vec3 tmpvar_22;
  tmpvar_22 = normalize(tmpvar_8);
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_24;
  tmpvar_24 = max (dot (tmpvar_22, tmpvar_23), 0.0);
  highp vec3 tmpvar_25;
  tmpvar_25.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_26;
  tmpvar_26.w = 8.0;
  tmpvar_26.xyz = (T2W_TBN_1 * tmpvar_22);
  lowp vec4 tmpvar_27;
  tmpvar_27 = textureLod (SKY_BOX, tmpvar_26.xyz, 8.0);
  highp vec4 tmpvar_28;
  tmpvar_28 = tmpvar_27;
  highp vec3 I_29;
  I_29 = -(tmpvar_23);
  highp vec4 tmpvar_30;
  tmpvar_30.xyz = (T2W_TBN_1 * (I_29 - (2.0 * 
    (dot (tmpvar_22, I_29) * tmpvar_22)
  )));
  tmpvar_30.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_31;
  tmpvar_31 = textureLod (SKY_BOX, tmpvar_30.xyz, tmpvar_30.w);
  highp vec3 tmpvar_32;
  tmpvar_32 = tmpvar_31.xyz;
  highp float tmpvar_33;
  tmpvar_33 = (1.0 - tmpvar_24);
  highp vec4 tmpvar_34;
  tmpvar_34.w = 1.0;
  tmpvar_34.xyz = pow (((
    ((((
      ((tmpvar_16 / ((3.141593 * tmpvar_18) * tmpvar_18)) * (0.5 / ((
        (tmpvar_20 * ((tmpvar_19 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_19 * ((tmpvar_20 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_10) * 3.14) * tmpvar_21) * LIGHT_COLOR)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_10) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_21) * LIGHT_COLOR)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_25, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_24), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_28.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_32) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_33 * tmpvar_33) * (
      (tmpvar_33 * tmpvar_33)
     * tmpvar_33)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_34;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * LIGHT_GIVEN_DIRECTION);
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 F_10;
  highp vec3 tmpvar_11;
  tmpvar_11 = normalize(tmpvar_8);
  highp vec3 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(-(xlv_TEXCOORD2));
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize((tmpvar_12 + tmpvar_13));
  highp float tmpvar_15;
  tmpvar_15 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_15 * tmpvar_15);
  highp float tmpvar_17;
  tmpvar_17 = max (dot (tmpvar_11, tmpvar_14), 0.0);
  highp float tmpvar_18;
  tmpvar_18 = (((tmpvar_17 * tmpvar_17) * (tmpvar_16 - 1.0)) + 1.0);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_11, tmpvar_12), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  F_10 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_14, tmpvar_12), 0.0))
  , 5.0)));
  highp float tmpvar_21;
  tmpvar_21 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  highp vec3 tmpvar_22;
  tmpvar_22 = normalize(tmpvar_8);
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_24;
  tmpvar_24 = max (dot (tmpvar_22, tmpvar_23), 0.0);
  highp vec3 tmpvar_25;
  tmpvar_25.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_26;
  tmpvar_26.w = 8.0;
  tmpvar_26.xyz = (T2W_TBN_1 * tmpvar_22);
  lowp vec4 tmpvar_27;
  tmpvar_27 = textureLod (SKY_BOX, tmpvar_26.xyz, 8.0);
  highp vec4 tmpvar_28;
  tmpvar_28 = tmpvar_27;
  highp vec3 I_29;
  I_29 = -(tmpvar_23);
  highp vec4 tmpvar_30;
  tmpvar_30.xyz = (T2W_TBN_1 * (I_29 - (2.0 * 
    (dot (tmpvar_22, I_29) * tmpvar_22)
  )));
  tmpvar_30.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_31;
  tmpvar_31 = textureLod (SKY_BOX, tmpvar_30.xyz, tmpvar_30.w);
  highp vec3 tmpvar_32;
  tmpvar_32 = tmpvar_31.xyz;
  highp float tmpvar_33;
  tmpvar_33 = (1.0 - tmpvar_24);
  highp vec4 tmpvar_34;
  tmpvar_34.w = 1.0;
  tmpvar_34.xyz = pow (((
    ((((
      ((tmpvar_16 / ((3.141593 * tmpvar_18) * tmpvar_18)) * (0.5 / ((
        (tmpvar_20 * ((tmpvar_19 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_19 * ((tmpvar_20 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_10) * 3.14) * tmpvar_21) * LIGHT_COLOR)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_10) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_21) * LIGHT_COLOR)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_25, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_24), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_28.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_32) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_33 * tmpvar_33) * (
      (tmpvar_33 * tmpvar_33)
     * tmpvar_33)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_34;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * (tmpvar_3.xyz - LIGHT_POSITION));
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 out_LightColor_10;
  highp float tmpvar_11;
  tmpvar_11 = clamp ((sqrt(
    dot (xlv_TEXCOORD2, xlv_TEXCOORD2)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  highp vec3 tmpvar_12;
  tmpvar_12 = -(xlv_TEXCOORD2);
  out_LightColor_10 = (LIGHT_COLOR * ((
    (1.0 - tmpvar_11)
   / 
    ((LIGHT_ATTENUATION.x + (tmpvar_11 * LIGHT_ATTENUATION.y)) + ((tmpvar_11 * tmpvar_11) * LIGHT_ATTENUATION.z))
  ) * clamp (
    (1.0 - ((LIGHT_INNER_DIFF_INV.x - dot (
      normalize(tmpvar_12)
    , 
      -(LIGHT_GIVEN_DIRECTION)
    )) * LIGHT_INNER_DIFF_INV.y))
  , 0.0, 1.0)));
  highp vec3 F_13;
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(tmpvar_8);
  highp vec3 tmpvar_15;
  tmpvar_15 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(tmpvar_12);
  highp vec3 tmpvar_17;
  tmpvar_17 = normalize((tmpvar_15 + tmpvar_16));
  highp float tmpvar_18;
  tmpvar_18 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_19;
  tmpvar_19 = (tmpvar_18 * tmpvar_18);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_14, tmpvar_17), 0.0);
  highp float tmpvar_21;
  tmpvar_21 = (((tmpvar_20 * tmpvar_20) * (tmpvar_19 - 1.0)) + 1.0);
  highp float tmpvar_22;
  tmpvar_22 = max (dot (tmpvar_14, tmpvar_15), 0.0);
  highp float tmpvar_23;
  tmpvar_23 = max (dot (tmpvar_14, tmpvar_16), 0.0);
  F_13 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_17, tmpvar_15), 0.0))
  , 5.0)));
  highp float tmpvar_24;
  tmpvar_24 = max (dot (tmpvar_14, tmpvar_16), 0.0);
  highp vec3 tmpvar_25;
  tmpvar_25 = normalize(tmpvar_8);
  highp vec3 tmpvar_26;
  tmpvar_26 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_27;
  tmpvar_27 = max (dot (tmpvar_25, tmpvar_26), 0.0);
  highp vec3 tmpvar_28;
  tmpvar_28.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_28.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_28.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_29;
  tmpvar_29.w = 8.0;
  tmpvar_29.xyz = (T2W_TBN_1 * tmpvar_25);
  lowp vec4 tmpvar_30;
  tmpvar_30 = textureLod (SKY_BOX, tmpvar_29.xyz, 8.0);
  highp vec4 tmpvar_31;
  tmpvar_31 = tmpvar_30;
  highp vec3 I_32;
  I_32 = -(tmpvar_26);
  highp vec4 tmpvar_33;
  tmpvar_33.xyz = (T2W_TBN_1 * (I_32 - (2.0 * 
    (dot (tmpvar_25, I_32) * tmpvar_25)
  )));
  tmpvar_33.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_34;
  tmpvar_34 = textureLod (SKY_BOX, tmpvar_33.xyz, tmpvar_33.w);
  highp vec3 tmpvar_35;
  tmpvar_35 = tmpvar_34.xyz;
  highp float tmpvar_36;
  tmpvar_36 = (1.0 - tmpvar_27);
  highp vec4 tmpvar_37;
  tmpvar_37.w = 1.0;
  tmpvar_37.xyz = pow (((
    ((((
      ((tmpvar_19 / ((3.141593 * tmpvar_21) * tmpvar_21)) * (0.5 / ((
        (tmpvar_23 * ((tmpvar_22 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_22 * ((tmpvar_23 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_13) * 3.14) * tmpvar_24) * out_LightColor_10)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_13) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_24) * out_LightColor_10)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_28, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_27), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_31.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_35) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_36 * tmpvar_36) * (
      (tmpvar_36 * tmpvar_36)
     * tmpvar_36)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_37;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * (tmpvar_3.xyz - LIGHT_POSITION));
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 out_LightColor_10;
  highp float tmpvar_11;
  tmpvar_11 = clamp ((sqrt(
    dot (xlv_TEXCOORD2, xlv_TEXCOORD2)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  highp vec3 tmpvar_12;
  tmpvar_12 = -(xlv_TEXCOORD2);
  out_LightColor_10 = (LIGHT_COLOR * ((
    (1.0 - tmpvar_11)
   / 
    ((LIGHT_ATTENUATION.x + (tmpvar_11 * LIGHT_ATTENUATION.y)) + ((tmpvar_11 * tmpvar_11) * LIGHT_ATTENUATION.z))
  ) * clamp (
    (1.0 - ((LIGHT_INNER_DIFF_INV.x - dot (
      normalize(tmpvar_12)
    , 
      -(LIGHT_GIVEN_DIRECTION)
    )) * LIGHT_INNER_DIFF_INV.y))
  , 0.0, 1.0)));
  highp vec3 F_13;
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(tmpvar_8);
  highp vec3 tmpvar_15;
  tmpvar_15 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(tmpvar_12);
  highp vec3 tmpvar_17;
  tmpvar_17 = normalize((tmpvar_15 + tmpvar_16));
  highp float tmpvar_18;
  tmpvar_18 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_19;
  tmpvar_19 = (tmpvar_18 * tmpvar_18);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_14, tmpvar_17), 0.0);
  highp float tmpvar_21;
  tmpvar_21 = (((tmpvar_20 * tmpvar_20) * (tmpvar_19 - 1.0)) + 1.0);
  highp float tmpvar_22;
  tmpvar_22 = max (dot (tmpvar_14, tmpvar_15), 0.0);
  highp float tmpvar_23;
  tmpvar_23 = max (dot (tmpvar_14, tmpvar_16), 0.0);
  F_13 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_17, tmpvar_15), 0.0))
  , 5.0)));
  highp float tmpvar_24;
  tmpvar_24 = max (dot (tmpvar_14, tmpvar_16), 0.0);
  highp vec3 tmpvar_25;
  tmpvar_25 = normalize(tmpvar_8);
  highp vec3 tmpvar_26;
  tmpvar_26 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_27;
  tmpvar_27 = max (dot (tmpvar_25, tmpvar_26), 0.0);
  highp vec3 tmpvar_28;
  tmpvar_28.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_28.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_28.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_29;
  tmpvar_29.w = 8.0;
  tmpvar_29.xyz = (T2W_TBN_1 * tmpvar_25);
  lowp vec4 tmpvar_30;
  tmpvar_30 = textureLod (SKY_BOX, tmpvar_29.xyz, 8.0);
  highp vec4 tmpvar_31;
  tmpvar_31 = tmpvar_30;
  highp vec3 I_32;
  I_32 = -(tmpvar_26);
  highp vec4 tmpvar_33;
  tmpvar_33.xyz = (T2W_TBN_1 * (I_32 - (2.0 * 
    (dot (tmpvar_25, I_32) * tmpvar_25)
  )));
  tmpvar_33.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_34;
  tmpvar_34 = textureLod (SKY_BOX, tmpvar_33.xyz, tmpvar_33.w);
  highp vec3 tmpvar_35;
  tmpvar_35 = tmpvar_34.xyz;
  highp float tmpvar_36;
  tmpvar_36 = (1.0 - tmpvar_27);
  highp vec4 tmpvar_37;
  tmpvar_37.w = 1.0;
  tmpvar_37.xyz = pow (((
    ((((
      ((tmpvar_19 / ((3.141593 * tmpvar_21) * tmpvar_21)) * (0.5 / ((
        (tmpvar_23 * ((tmpvar_22 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_22 * ((tmpvar_23 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_13) * 3.14) * tmpvar_24) * out_LightColor_10)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_13) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_24) * out_LightColor_10)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_28, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_27), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_31.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_35) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_36 * tmpvar_36) * (
      (tmpvar_36 * tmpvar_36)
     * tmpvar_36)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_37;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * (tmpvar_3.xyz - LIGHT_POSITION));
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 out_LightColor_10;
  highp float tmpvar_11;
  tmpvar_11 = clamp ((sqrt(
    dot (xlv_TEXCOORD2, xlv_TEXCOORD2)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  highp vec3 tmpvar_12;
  tmpvar_12 = -(xlv_TEXCOORD2);
  out_LightColor_10 = (LIGHT_COLOR * ((
    (1.0 - tmpvar_11)
   / 
    ((LIGHT_ATTENUATION.x + (tmpvar_11 * LIGHT_ATTENUATION.y)) + ((tmpvar_11 * tmpvar_11) * LIGHT_ATTENUATION.z))
  ) * clamp (
    (1.0 - ((LIGHT_INNER_DIFF_INV.x - dot (
      normalize(tmpvar_12)
    , 
      -(LIGHT_GIVEN_DIRECTION)
    )) * LIGHT_INNER_DIFF_INV.y))
  , 0.0, 1.0)));
  highp vec3 F_13;
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(tmpvar_8);
  highp vec3 tmpvar_15;
  tmpvar_15 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(tmpvar_12);
  highp vec3 tmpvar_17;
  tmpvar_17 = normalize((tmpvar_15 + tmpvar_16));
  highp float tmpvar_18;
  tmpvar_18 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_19;
  tmpvar_19 = (tmpvar_18 * tmpvar_18);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_14, tmpvar_17), 0.0);
  highp float tmpvar_21;
  tmpvar_21 = (((tmpvar_20 * tmpvar_20) * (tmpvar_19 - 1.0)) + 1.0);
  highp float tmpvar_22;
  tmpvar_22 = max (dot (tmpvar_14, tmpvar_15), 0.0);
  highp float tmpvar_23;
  tmpvar_23 = max (dot (tmpvar_14, tmpvar_16), 0.0);
  F_13 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_17, tmpvar_15), 0.0))
  , 5.0)));
  highp float tmpvar_24;
  tmpvar_24 = max (dot (tmpvar_14, tmpvar_16), 0.0);
  highp vec3 tmpvar_25;
  tmpvar_25 = normalize(tmpvar_8);
  highp vec3 tmpvar_26;
  tmpvar_26 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_27;
  tmpvar_27 = max (dot (tmpvar_25, tmpvar_26), 0.0);
  highp vec3 tmpvar_28;
  tmpvar_28.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_28.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_28.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_29;
  tmpvar_29.w = 8.0;
  tmpvar_29.xyz = (T2W_TBN_1 * tmpvar_25);
  lowp vec4 tmpvar_30;
  tmpvar_30 = textureLod (SKY_BOX, tmpvar_29.xyz, 8.0);
  highp vec4 tmpvar_31;
  tmpvar_31 = tmpvar_30;
  highp vec3 I_32;
  I_32 = -(tmpvar_26);
  highp vec4 tmpvar_33;
  tmpvar_33.xyz = (T2W_TBN_1 * (I_32 - (2.0 * 
    (dot (tmpvar_25, I_32) * tmpvar_25)
  )));
  tmpvar_33.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_34;
  tmpvar_34 = textureLod (SKY_BOX, tmpvar_33.xyz, tmpvar_33.w);
  highp vec3 tmpvar_35;
  tmpvar_35 = tmpvar_34.xyz;
  highp float tmpvar_36;
  tmpvar_36 = (1.0 - tmpvar_27);
  highp vec4 tmpvar_37;
  tmpvar_37.w = 1.0;
  tmpvar_37.xyz = pow (((
    ((((
      ((tmpvar_19 / ((3.141593 * tmpvar_21) * tmpvar_21)) * (0.5 / ((
        (tmpvar_23 * ((tmpvar_22 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_22 * ((tmpvar_23 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_13) * 3.14) * tmpvar_24) * out_LightColor_10)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_13) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_24) * out_LightColor_10)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_28, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_27), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_31.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_35) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_36 * tmpvar_36) * (
      (tmpvar_36 * tmpvar_36)
     * tmpvar_36)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_37;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * (tmpvar_3.xyz - LIGHT_POSITION));
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 out_LightColor_10;
  highp float tmpvar_11;
  tmpvar_11 = clamp ((sqrt(
    dot (xlv_TEXCOORD2, xlv_TEXCOORD2)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  highp vec3 tmpvar_12;
  tmpvar_12 = -(xlv_TEXCOORD2);
  out_LightColor_10 = (LIGHT_COLOR * ((
    (1.0 - tmpvar_11)
   / 
    ((LIGHT_ATTENUATION.x + (tmpvar_11 * LIGHT_ATTENUATION.y)) + ((tmpvar_11 * tmpvar_11) * LIGHT_ATTENUATION.z))
  ) * clamp (
    (1.0 - ((LIGHT_INNER_DIFF_INV.x - dot (
      normalize(tmpvar_12)
    , 
      -(LIGHT_GIVEN_DIRECTION)
    )) * LIGHT_INNER_DIFF_INV.y))
  , 0.0, 1.0)));
  highp vec3 F_13;
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(tmpvar_8);
  highp vec3 tmpvar_15;
  tmpvar_15 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(tmpvar_12);
  highp vec3 tmpvar_17;
  tmpvar_17 = normalize((tmpvar_15 + tmpvar_16));
  highp float tmpvar_18;
  tmpvar_18 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_19;
  tmpvar_19 = (tmpvar_18 * tmpvar_18);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_14, tmpvar_17), 0.0);
  highp float tmpvar_21;
  tmpvar_21 = (((tmpvar_20 * tmpvar_20) * (tmpvar_19 - 1.0)) + 1.0);
  highp float tmpvar_22;
  tmpvar_22 = max (dot (tmpvar_14, tmpvar_15), 0.0);
  highp float tmpvar_23;
  tmpvar_23 = max (dot (tmpvar_14, tmpvar_16), 0.0);
  F_13 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_17, tmpvar_15), 0.0))
  , 5.0)));
  highp float tmpvar_24;
  tmpvar_24 = max (dot (tmpvar_14, tmpvar_16), 0.0);
  highp vec3 tmpvar_25;
  tmpvar_25 = normalize(tmpvar_8);
  highp vec3 tmpvar_26;
  tmpvar_26 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_27;
  tmpvar_27 = max (dot (tmpvar_25, tmpvar_26), 0.0);
  highp vec3 tmpvar_28;
  tmpvar_28.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_28.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_28.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_29;
  tmpvar_29.w = 8.0;
  tmpvar_29.xyz = (T2W_TBN_1 * tmpvar_25);
  lowp vec4 tmpvar_30;
  tmpvar_30 = textureLod (SKY_BOX, tmpvar_29.xyz, 8.0);
  highp vec4 tmpvar_31;
  tmpvar_31 = tmpvar_30;
  highp vec3 I_32;
  I_32 = -(tmpvar_26);
  highp vec4 tmpvar_33;
  tmpvar_33.xyz = (T2W_TBN_1 * (I_32 - (2.0 * 
    (dot (tmpvar_25, I_32) * tmpvar_25)
  )));
  tmpvar_33.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_34;
  tmpvar_34 = textureLod (SKY_BOX, tmpvar_33.xyz, tmpvar_33.w);
  highp vec3 tmpvar_35;
  tmpvar_35 = tmpvar_34.xyz;
  highp float tmpvar_36;
  tmpvar_36 = (1.0 - tmpvar_27);
  highp vec4 tmpvar_37;
  tmpvar_37.w = 1.0;
  tmpvar_37.xyz = pow (((
    ((((
      ((tmpvar_19 / ((3.141593 * tmpvar_21) * tmpvar_21)) * (0.5 / ((
        (tmpvar_23 * ((tmpvar_22 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_22 * ((tmpvar_23 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_13) * 3.14) * tmpvar_24) * out_LightColor_10)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_13) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_24) * out_LightColor_10)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_28, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_27), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_31.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_35) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_36 * tmpvar_36) * (
      (tmpvar_36 * tmpvar_36)
     * tmpvar_36)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_37;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * (tmpvar_3.xyz - LIGHT_POSITION));
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 out_LightColor_10;
  highp float tmpvar_11;
  tmpvar_11 = clamp ((sqrt(
    dot (xlv_TEXCOORD2, xlv_TEXCOORD2)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  highp vec3 tmpvar_12;
  tmpvar_12 = -(xlv_TEXCOORD2);
  out_LightColor_10 = (LIGHT_COLOR * ((
    (1.0 - tmpvar_11)
   / 
    ((LIGHT_ATTENUATION.x + (tmpvar_11 * LIGHT_ATTENUATION.y)) + ((tmpvar_11 * tmpvar_11) * LIGHT_ATTENUATION.z))
  ) * clamp (
    (1.0 - ((LIGHT_INNER_DIFF_INV.x - dot (
      normalize(tmpvar_12)
    , 
      -(LIGHT_GIVEN_DIRECTION)
    )) * LIGHT_INNER_DIFF_INV.y))
  , 0.0, 1.0)));
  highp vec3 F_13;
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(tmpvar_8);
  highp vec3 tmpvar_15;
  tmpvar_15 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(tmpvar_12);
  highp vec3 tmpvar_17;
  tmpvar_17 = normalize((tmpvar_15 + tmpvar_16));
  highp float tmpvar_18;
  tmpvar_18 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_19;
  tmpvar_19 = (tmpvar_18 * tmpvar_18);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_14, tmpvar_17), 0.0);
  highp float tmpvar_21;
  tmpvar_21 = (((tmpvar_20 * tmpvar_20) * (tmpvar_19 - 1.0)) + 1.0);
  highp float tmpvar_22;
  tmpvar_22 = max (dot (tmpvar_14, tmpvar_15), 0.0);
  highp float tmpvar_23;
  tmpvar_23 = max (dot (tmpvar_14, tmpvar_16), 0.0);
  F_13 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_17, tmpvar_15), 0.0))
  , 5.0)));
  highp float tmpvar_24;
  tmpvar_24 = max (dot (tmpvar_14, tmpvar_16), 0.0);
  highp vec3 tmpvar_25;
  tmpvar_25 = normalize(tmpvar_8);
  highp vec3 tmpvar_26;
  tmpvar_26 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_27;
  tmpvar_27 = max (dot (tmpvar_25, tmpvar_26), 0.0);
  highp vec3 tmpvar_28;
  tmpvar_28.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_28.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_28.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_29;
  tmpvar_29.w = 8.0;
  tmpvar_29.xyz = (T2W_TBN_1 * tmpvar_25);
  lowp vec4 tmpvar_30;
  tmpvar_30 = textureLod (SKY_BOX, tmpvar_29.xyz, 8.0);
  highp vec4 tmpvar_31;
  tmpvar_31 = tmpvar_30;
  highp vec3 I_32;
  I_32 = -(tmpvar_26);
  highp vec4 tmpvar_33;
  tmpvar_33.xyz = (T2W_TBN_1 * (I_32 - (2.0 * 
    (dot (tmpvar_25, I_32) * tmpvar_25)
  )));
  tmpvar_33.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_34;
  tmpvar_34 = textureLod (SKY_BOX, tmpvar_33.xyz, tmpvar_33.w);
  highp vec3 tmpvar_35;
  tmpvar_35 = tmpvar_34.xyz;
  highp float tmpvar_36;
  tmpvar_36 = (1.0 - tmpvar_27);
  highp vec4 tmpvar_37;
  tmpvar_37.w = 1.0;
  tmpvar_37.xyz = pow (((
    ((((
      ((tmpvar_19 / ((3.141593 * tmpvar_21) * tmpvar_21)) * (0.5 / ((
        (tmpvar_23 * ((tmpvar_22 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_22 * ((tmpvar_23 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_13) * 3.14) * tmpvar_24) * out_LightColor_10)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_13) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_24) * out_LightColor_10)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_28, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_27), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_31.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_35) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_36 * tmpvar_36) * (
      (tmpvar_36 * tmpvar_36)
     * tmpvar_36)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_37;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","PointLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * (tmpvar_3.xyz - LIGHT_POSITION));
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 out_LightColor_10;
  highp float tmpvar_11;
  tmpvar_11 = clamp ((sqrt(
    dot (xlv_TEXCOORD2, xlv_TEXCOORD2)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  out_LightColor_10 = (LIGHT_COLOR * ((1.0 - tmpvar_11) / (
    (LIGHT_ATTENUATION.x + (tmpvar_11 * LIGHT_ATTENUATION.y))
   + 
    ((tmpvar_11 * tmpvar_11) * LIGHT_ATTENUATION.z)
  )));
  highp vec3 F_12;
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(tmpvar_8);
  highp vec3 tmpvar_14;
  tmpvar_14 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(-(xlv_TEXCOORD2));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize((tmpvar_14 + tmpvar_15));
  highp float tmpvar_17;
  tmpvar_17 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_18;
  tmpvar_18 = (tmpvar_17 * tmpvar_17);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_13, tmpvar_16), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = (((tmpvar_19 * tmpvar_19) * (tmpvar_18 - 1.0)) + 1.0);
  highp float tmpvar_21;
  tmpvar_21 = max (dot (tmpvar_13, tmpvar_14), 0.0);
  highp float tmpvar_22;
  tmpvar_22 = max (dot (tmpvar_13, tmpvar_15), 0.0);
  F_12 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_16, tmpvar_14), 0.0))
  , 5.0)));
  highp float tmpvar_23;
  tmpvar_23 = max (dot (tmpvar_13, tmpvar_15), 0.0);
  highp vec3 tmpvar_24;
  tmpvar_24 = normalize(tmpvar_8);
  highp vec3 tmpvar_25;
  tmpvar_25 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_26;
  tmpvar_26 = max (dot (tmpvar_24, tmpvar_25), 0.0);
  highp vec3 tmpvar_27;
  tmpvar_27.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_27.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_27.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_28;
  tmpvar_28.w = 8.0;
  tmpvar_28.xyz = (T2W_TBN_1 * tmpvar_24);
  lowp vec4 tmpvar_29;
  tmpvar_29 = textureLod (SKY_BOX, tmpvar_28.xyz, 8.0);
  highp vec4 tmpvar_30;
  tmpvar_30 = tmpvar_29;
  highp vec3 I_31;
  I_31 = -(tmpvar_25);
  highp vec4 tmpvar_32;
  tmpvar_32.xyz = (T2W_TBN_1 * (I_31 - (2.0 * 
    (dot (tmpvar_24, I_31) * tmpvar_24)
  )));
  tmpvar_32.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_33;
  tmpvar_33 = textureLod (SKY_BOX, tmpvar_32.xyz, tmpvar_32.w);
  highp vec3 tmpvar_34;
  tmpvar_34 = tmpvar_33.xyz;
  highp float tmpvar_35;
  tmpvar_35 = (1.0 - tmpvar_26);
  highp vec4 tmpvar_36;
  tmpvar_36.w = 1.0;
  tmpvar_36.xyz = pow (((
    ((((
      ((tmpvar_18 / ((3.141593 * tmpvar_20) * tmpvar_20)) * (0.5 / ((
        (tmpvar_22 * ((tmpvar_21 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_21 * ((tmpvar_22 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_12) * 3.14) * tmpvar_23) * out_LightColor_10)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_12) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_23) * out_LightColor_10)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_27, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_26), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_30.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_34) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_35 * tmpvar_35) * (
      (tmpvar_35 * tmpvar_35)
     * tmpvar_35)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_36;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","PointLight","ShadowOn"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * (tmpvar_3.xyz - LIGHT_POSITION));
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 out_LightColor_10;
  highp float tmpvar_11;
  tmpvar_11 = clamp ((sqrt(
    dot (xlv_TEXCOORD2, xlv_TEXCOORD2)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  out_LightColor_10 = (LIGHT_COLOR * ((1.0 - tmpvar_11) / (
    (LIGHT_ATTENUATION.x + (tmpvar_11 * LIGHT_ATTENUATION.y))
   + 
    ((tmpvar_11 * tmpvar_11) * LIGHT_ATTENUATION.z)
  )));
  highp vec3 F_12;
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(tmpvar_8);
  highp vec3 tmpvar_14;
  tmpvar_14 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(-(xlv_TEXCOORD2));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize((tmpvar_14 + tmpvar_15));
  highp float tmpvar_17;
  tmpvar_17 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_18;
  tmpvar_18 = (tmpvar_17 * tmpvar_17);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_13, tmpvar_16), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = (((tmpvar_19 * tmpvar_19) * (tmpvar_18 - 1.0)) + 1.0);
  highp float tmpvar_21;
  tmpvar_21 = max (dot (tmpvar_13, tmpvar_14), 0.0);
  highp float tmpvar_22;
  tmpvar_22 = max (dot (tmpvar_13, tmpvar_15), 0.0);
  F_12 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_16, tmpvar_14), 0.0))
  , 5.0)));
  highp float tmpvar_23;
  tmpvar_23 = max (dot (tmpvar_13, tmpvar_15), 0.0);
  highp vec3 tmpvar_24;
  tmpvar_24 = normalize(tmpvar_8);
  highp vec3 tmpvar_25;
  tmpvar_25 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_26;
  tmpvar_26 = max (dot (tmpvar_24, tmpvar_25), 0.0);
  highp vec3 tmpvar_27;
  tmpvar_27.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_27.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_27.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_28;
  tmpvar_28.w = 8.0;
  tmpvar_28.xyz = (T2W_TBN_1 * tmpvar_24);
  lowp vec4 tmpvar_29;
  tmpvar_29 = textureLod (SKY_BOX, tmpvar_28.xyz, 8.0);
  highp vec4 tmpvar_30;
  tmpvar_30 = tmpvar_29;
  highp vec3 I_31;
  I_31 = -(tmpvar_25);
  highp vec4 tmpvar_32;
  tmpvar_32.xyz = (T2W_TBN_1 * (I_31 - (2.0 * 
    (dot (tmpvar_24, I_31) * tmpvar_24)
  )));
  tmpvar_32.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_33;
  tmpvar_33 = textureLod (SKY_BOX, tmpvar_32.xyz, tmpvar_32.w);
  highp vec3 tmpvar_34;
  tmpvar_34 = tmpvar_33.xyz;
  highp float tmpvar_35;
  tmpvar_35 = (1.0 - tmpvar_26);
  highp vec4 tmpvar_36;
  tmpvar_36.w = 1.0;
  tmpvar_36.xyz = pow (((
    ((((
      ((tmpvar_18 / ((3.141593 * tmpvar_20) * tmpvar_20)) * (0.5 / ((
        (tmpvar_22 * ((tmpvar_21 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_21 * ((tmpvar_22 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_12) * 3.14) * tmpvar_23) * out_LightColor_10)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_12) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_23) * out_LightColor_10)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_27, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_26), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_30.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_34) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_35 * tmpvar_35) * (
      (tmpvar_35 * tmpvar_35)
     * tmpvar_35)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_36;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * LIGHT_GIVEN_DIRECTION);
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 F_10;
  highp vec3 tmpvar_11;
  tmpvar_11 = normalize(tmpvar_8);
  highp vec3 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(-(xlv_TEXCOORD2));
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize((tmpvar_12 + tmpvar_13));
  highp float tmpvar_15;
  tmpvar_15 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_15 * tmpvar_15);
  highp float tmpvar_17;
  tmpvar_17 = max (dot (tmpvar_11, tmpvar_14), 0.0);
  highp float tmpvar_18;
  tmpvar_18 = (((tmpvar_17 * tmpvar_17) * (tmpvar_16 - 1.0)) + 1.0);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_11, tmpvar_12), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  F_10 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_14, tmpvar_12), 0.0))
  , 5.0)));
  highp float tmpvar_21;
  tmpvar_21 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  highp vec3 tmpvar_22;
  tmpvar_22 = normalize(tmpvar_8);
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_24;
  tmpvar_24 = max (dot (tmpvar_22, tmpvar_23), 0.0);
  highp vec3 tmpvar_25;
  tmpvar_25.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_26;
  tmpvar_26.w = 8.0;
  tmpvar_26.xyz = (T2W_TBN_1 * tmpvar_22);
  lowp vec4 tmpvar_27;
  tmpvar_27 = textureLod (SKY_BOX, tmpvar_26.xyz, 8.0);
  highp vec4 tmpvar_28;
  tmpvar_28 = tmpvar_27;
  highp vec3 I_29;
  I_29 = -(tmpvar_23);
  highp vec4 tmpvar_30;
  tmpvar_30.xyz = (T2W_TBN_1 * (I_29 - (2.0 * 
    (dot (tmpvar_22, I_29) * tmpvar_22)
  )));
  tmpvar_30.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_31;
  tmpvar_31 = textureLod (SKY_BOX, tmpvar_30.xyz, tmpvar_30.w);
  highp vec3 tmpvar_32;
  tmpvar_32 = tmpvar_31.xyz;
  highp float tmpvar_33;
  tmpvar_33 = (1.0 - tmpvar_24);
  highp vec4 tmpvar_34;
  tmpvar_34.w = 1.0;
  tmpvar_34.xyz = pow (((
    ((((
      ((tmpvar_16 / ((3.141593 * tmpvar_18) * tmpvar_18)) * (0.5 / ((
        (tmpvar_20 * ((tmpvar_19 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_19 * ((tmpvar_20 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_10) * 3.14) * tmpvar_21) * LIGHT_COLOR)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_10) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_21) * LIGHT_COLOR)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_25, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_24), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_28.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_32) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_33 * tmpvar_33) * (
      (tmpvar_33 * tmpvar_33)
     * tmpvar_33)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_34;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * LIGHT_GIVEN_DIRECTION);
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 F_10;
  highp vec3 tmpvar_11;
  tmpvar_11 = normalize(tmpvar_8);
  highp vec3 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(-(xlv_TEXCOORD2));
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize((tmpvar_12 + tmpvar_13));
  highp float tmpvar_15;
  tmpvar_15 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_15 * tmpvar_15);
  highp float tmpvar_17;
  tmpvar_17 = max (dot (tmpvar_11, tmpvar_14), 0.0);
  highp float tmpvar_18;
  tmpvar_18 = (((tmpvar_17 * tmpvar_17) * (tmpvar_16 - 1.0)) + 1.0);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_11, tmpvar_12), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  F_10 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_14, tmpvar_12), 0.0))
  , 5.0)));
  highp float tmpvar_21;
  tmpvar_21 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  highp vec3 tmpvar_22;
  tmpvar_22 = normalize(tmpvar_8);
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_24;
  tmpvar_24 = max (dot (tmpvar_22, tmpvar_23), 0.0);
  highp vec3 tmpvar_25;
  tmpvar_25.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_26;
  tmpvar_26.w = 8.0;
  tmpvar_26.xyz = (T2W_TBN_1 * tmpvar_22);
  lowp vec4 tmpvar_27;
  tmpvar_27 = textureLod (SKY_BOX, tmpvar_26.xyz, 8.0);
  highp vec4 tmpvar_28;
  tmpvar_28 = tmpvar_27;
  highp vec3 I_29;
  I_29 = -(tmpvar_23);
  highp vec4 tmpvar_30;
  tmpvar_30.xyz = (T2W_TBN_1 * (I_29 - (2.0 * 
    (dot (tmpvar_22, I_29) * tmpvar_22)
  )));
  tmpvar_30.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_31;
  tmpvar_31 = textureLod (SKY_BOX, tmpvar_30.xyz, tmpvar_30.w);
  highp vec3 tmpvar_32;
  tmpvar_32 = tmpvar_31.xyz;
  highp float tmpvar_33;
  tmpvar_33 = (1.0 - tmpvar_24);
  highp vec4 tmpvar_34;
  tmpvar_34.w = 1.0;
  tmpvar_34.xyz = pow (((
    ((((
      ((tmpvar_16 / ((3.141593 * tmpvar_18) * tmpvar_18)) * (0.5 / ((
        (tmpvar_20 * ((tmpvar_19 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_19 * ((tmpvar_20 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_10) * 3.14) * tmpvar_21) * LIGHT_COLOR)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_10) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_21) * LIGHT_COLOR)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_25, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_24), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_28.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_32) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_33 * tmpvar_33) * (
      (tmpvar_33 * tmpvar_33)
     * tmpvar_33)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_34;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * LIGHT_GIVEN_DIRECTION);
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 F_10;
  highp vec3 tmpvar_11;
  tmpvar_11 = normalize(tmpvar_8);
  highp vec3 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(-(xlv_TEXCOORD2));
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize((tmpvar_12 + tmpvar_13));
  highp float tmpvar_15;
  tmpvar_15 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_15 * tmpvar_15);
  highp float tmpvar_17;
  tmpvar_17 = max (dot (tmpvar_11, tmpvar_14), 0.0);
  highp float tmpvar_18;
  tmpvar_18 = (((tmpvar_17 * tmpvar_17) * (tmpvar_16 - 1.0)) + 1.0);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_11, tmpvar_12), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  F_10 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_14, tmpvar_12), 0.0))
  , 5.0)));
  highp float tmpvar_21;
  tmpvar_21 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  highp vec3 tmpvar_22;
  tmpvar_22 = normalize(tmpvar_8);
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_24;
  tmpvar_24 = max (dot (tmpvar_22, tmpvar_23), 0.0);
  highp vec3 tmpvar_25;
  tmpvar_25.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_26;
  tmpvar_26.w = 8.0;
  tmpvar_26.xyz = (T2W_TBN_1 * tmpvar_22);
  lowp vec4 tmpvar_27;
  tmpvar_27 = textureLod (SKY_BOX, tmpvar_26.xyz, 8.0);
  highp vec4 tmpvar_28;
  tmpvar_28 = tmpvar_27;
  highp vec3 I_29;
  I_29 = -(tmpvar_23);
  highp vec4 tmpvar_30;
  tmpvar_30.xyz = (T2W_TBN_1 * (I_29 - (2.0 * 
    (dot (tmpvar_22, I_29) * tmpvar_22)
  )));
  tmpvar_30.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_31;
  tmpvar_31 = textureLod (SKY_BOX, tmpvar_30.xyz, tmpvar_30.w);
  highp vec3 tmpvar_32;
  tmpvar_32 = tmpvar_31.xyz;
  highp float tmpvar_33;
  tmpvar_33 = (1.0 - tmpvar_24);
  highp vec4 tmpvar_34;
  tmpvar_34.w = 1.0;
  tmpvar_34.xyz = pow (((
    ((((
      ((tmpvar_16 / ((3.141593 * tmpvar_18) * tmpvar_18)) * (0.5 / ((
        (tmpvar_20 * ((tmpvar_19 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_19 * ((tmpvar_20 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_10) * 3.14) * tmpvar_21) * LIGHT_COLOR)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_10) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_21) * LIGHT_COLOR)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_25, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_24), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_28.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_32) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_33 * tmpvar_33) * (
      (tmpvar_33 * tmpvar_33)
     * tmpvar_33)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_34;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * LIGHT_GIVEN_DIRECTION);
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 F_10;
  highp vec3 tmpvar_11;
  tmpvar_11 = normalize(tmpvar_8);
  highp vec3 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(-(xlv_TEXCOORD2));
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize((tmpvar_12 + tmpvar_13));
  highp float tmpvar_15;
  tmpvar_15 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_15 * tmpvar_15);
  highp float tmpvar_17;
  tmpvar_17 = max (dot (tmpvar_11, tmpvar_14), 0.0);
  highp float tmpvar_18;
  tmpvar_18 = (((tmpvar_17 * tmpvar_17) * (tmpvar_16 - 1.0)) + 1.0);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_11, tmpvar_12), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  F_10 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_14, tmpvar_12), 0.0))
  , 5.0)));
  highp float tmpvar_21;
  tmpvar_21 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  highp vec3 tmpvar_22;
  tmpvar_22 = normalize(tmpvar_8);
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_24;
  tmpvar_24 = max (dot (tmpvar_22, tmpvar_23), 0.0);
  highp vec3 tmpvar_25;
  tmpvar_25.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_26;
  tmpvar_26.w = 8.0;
  tmpvar_26.xyz = (T2W_TBN_1 * tmpvar_22);
  lowp vec4 tmpvar_27;
  tmpvar_27 = textureLod (SKY_BOX, tmpvar_26.xyz, 8.0);
  highp vec4 tmpvar_28;
  tmpvar_28 = tmpvar_27;
  highp vec3 I_29;
  I_29 = -(tmpvar_23);
  highp vec4 tmpvar_30;
  tmpvar_30.xyz = (T2W_TBN_1 * (I_29 - (2.0 * 
    (dot (tmpvar_22, I_29) * tmpvar_22)
  )));
  tmpvar_30.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_31;
  tmpvar_31 = textureLod (SKY_BOX, tmpvar_30.xyz, tmpvar_30.w);
  highp vec3 tmpvar_32;
  tmpvar_32 = tmpvar_31.xyz;
  highp float tmpvar_33;
  tmpvar_33 = (1.0 - tmpvar_24);
  highp vec4 tmpvar_34;
  tmpvar_34.w = 1.0;
  tmpvar_34.xyz = pow (((
    ((((
      ((tmpvar_16 / ((3.141593 * tmpvar_18) * tmpvar_18)) * (0.5 / ((
        (tmpvar_20 * ((tmpvar_19 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_19 * ((tmpvar_20 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_10) * 3.14) * tmpvar_21) * LIGHT_COLOR)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_10) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_21) * LIGHT_COLOR)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_25, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_24), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_28.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_32) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_33 * tmpvar_33) * (
      (tmpvar_33 * tmpvar_33)
     * tmpvar_33)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_34;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * LIGHT_GIVEN_DIRECTION);
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 F_10;
  highp vec3 tmpvar_11;
  tmpvar_11 = normalize(tmpvar_8);
  highp vec3 tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(-(xlv_TEXCOORD2));
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize((tmpvar_12 + tmpvar_13));
  highp float tmpvar_15;
  tmpvar_15 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_15 * tmpvar_15);
  highp float tmpvar_17;
  tmpvar_17 = max (dot (tmpvar_11, tmpvar_14), 0.0);
  highp float tmpvar_18;
  tmpvar_18 = (((tmpvar_17 * tmpvar_17) * (tmpvar_16 - 1.0)) + 1.0);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_11, tmpvar_12), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  F_10 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_14, tmpvar_12), 0.0))
  , 5.0)));
  highp float tmpvar_21;
  tmpvar_21 = max (dot (tmpvar_11, tmpvar_13), 0.0);
  highp vec3 tmpvar_22;
  tmpvar_22 = normalize(tmpvar_8);
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_24;
  tmpvar_24 = max (dot (tmpvar_22, tmpvar_23), 0.0);
  highp vec3 tmpvar_25;
  tmpvar_25.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_25.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_26;
  tmpvar_26.w = 8.0;
  tmpvar_26.xyz = (T2W_TBN_1 * tmpvar_22);
  lowp vec4 tmpvar_27;
  tmpvar_27 = textureLod (SKY_BOX, tmpvar_26.xyz, 8.0);
  highp vec4 tmpvar_28;
  tmpvar_28 = tmpvar_27;
  highp vec3 I_29;
  I_29 = -(tmpvar_23);
  highp vec4 tmpvar_30;
  tmpvar_30.xyz = (T2W_TBN_1 * (I_29 - (2.0 * 
    (dot (tmpvar_22, I_29) * tmpvar_22)
  )));
  tmpvar_30.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_31;
  tmpvar_31 = textureLod (SKY_BOX, tmpvar_30.xyz, tmpvar_30.w);
  highp vec3 tmpvar_32;
  tmpvar_32 = tmpvar_31.xyz;
  highp float tmpvar_33;
  tmpvar_33 = (1.0 - tmpvar_24);
  highp vec4 tmpvar_34;
  tmpvar_34.w = 1.0;
  tmpvar_34.xyz = pow (((
    ((((
      ((tmpvar_16 / ((3.141593 * tmpvar_18) * tmpvar_18)) * (0.5 / ((
        (tmpvar_20 * ((tmpvar_19 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_19 * ((tmpvar_20 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_10) * 3.14) * tmpvar_21) * LIGHT_COLOR)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_10) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_21) * LIGHT_COLOR)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_25, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_24), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_28.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_32) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_33 * tmpvar_33) * (
      (tmpvar_33 * tmpvar_33)
     * tmpvar_33)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_34;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"SpotLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * (tmpvar_3.xyz - LIGHT_POSITION));
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 out_LightColor_10;
  highp float tmpvar_11;
  tmpvar_11 = clamp ((sqrt(
    dot (xlv_TEXCOORD2, xlv_TEXCOORD2)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  highp vec3 tmpvar_12;
  tmpvar_12 = -(xlv_TEXCOORD2);
  out_LightColor_10 = (LIGHT_COLOR * ((
    (1.0 - tmpvar_11)
   / 
    ((LIGHT_ATTENUATION.x + (tmpvar_11 * LIGHT_ATTENUATION.y)) + ((tmpvar_11 * tmpvar_11) * LIGHT_ATTENUATION.z))
  ) * clamp (
    (1.0 - ((LIGHT_INNER_DIFF_INV.x - dot (
      normalize(tmpvar_12)
    , 
      -(LIGHT_GIVEN_DIRECTION)
    )) * LIGHT_INNER_DIFF_INV.y))
  , 0.0, 1.0)));
  highp vec3 F_13;
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(tmpvar_8);
  highp vec3 tmpvar_15;
  tmpvar_15 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(tmpvar_12);
  highp vec3 tmpvar_17;
  tmpvar_17 = normalize((tmpvar_15 + tmpvar_16));
  highp float tmpvar_18;
  tmpvar_18 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_19;
  tmpvar_19 = (tmpvar_18 * tmpvar_18);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_14, tmpvar_17), 0.0);
  highp float tmpvar_21;
  tmpvar_21 = (((tmpvar_20 * tmpvar_20) * (tmpvar_19 - 1.0)) + 1.0);
  highp float tmpvar_22;
  tmpvar_22 = max (dot (tmpvar_14, tmpvar_15), 0.0);
  highp float tmpvar_23;
  tmpvar_23 = max (dot (tmpvar_14, tmpvar_16), 0.0);
  F_13 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_17, tmpvar_15), 0.0))
  , 5.0)));
  highp float tmpvar_24;
  tmpvar_24 = max (dot (tmpvar_14, tmpvar_16), 0.0);
  highp vec3 tmpvar_25;
  tmpvar_25 = normalize(tmpvar_8);
  highp vec3 tmpvar_26;
  tmpvar_26 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_27;
  tmpvar_27 = max (dot (tmpvar_25, tmpvar_26), 0.0);
  highp vec3 tmpvar_28;
  tmpvar_28.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_28.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_28.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_29;
  tmpvar_29.w = 8.0;
  tmpvar_29.xyz = (T2W_TBN_1 * tmpvar_25);
  lowp vec4 tmpvar_30;
  tmpvar_30 = textureLod (SKY_BOX, tmpvar_29.xyz, 8.0);
  highp vec4 tmpvar_31;
  tmpvar_31 = tmpvar_30;
  highp vec3 I_32;
  I_32 = -(tmpvar_26);
  highp vec4 tmpvar_33;
  tmpvar_33.xyz = (T2W_TBN_1 * (I_32 - (2.0 * 
    (dot (tmpvar_25, I_32) * tmpvar_25)
  )));
  tmpvar_33.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_34;
  tmpvar_34 = textureLod (SKY_BOX, tmpvar_33.xyz, tmpvar_33.w);
  highp vec3 tmpvar_35;
  tmpvar_35 = tmpvar_34.xyz;
  highp float tmpvar_36;
  tmpvar_36 = (1.0 - tmpvar_27);
  highp vec4 tmpvar_37;
  tmpvar_37.w = 1.0;
  tmpvar_37.xyz = pow (((
    ((((
      ((tmpvar_19 / ((3.141593 * tmpvar_21) * tmpvar_21)) * (0.5 / ((
        (tmpvar_23 * ((tmpvar_22 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_22 * ((tmpvar_23 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_13) * 3.14) * tmpvar_24) * out_LightColor_10)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_13) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_24) * out_LightColor_10)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_28, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_27), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_31.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_35) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_36 * tmpvar_36) * (
      (tmpvar_36 * tmpvar_36)
     * tmpvar_36)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_37;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * (tmpvar_3.xyz - LIGHT_POSITION));
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 out_LightColor_10;
  highp float tmpvar_11;
  tmpvar_11 = clamp ((sqrt(
    dot (xlv_TEXCOORD2, xlv_TEXCOORD2)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  highp vec3 tmpvar_12;
  tmpvar_12 = -(xlv_TEXCOORD2);
  out_LightColor_10 = (LIGHT_COLOR * ((
    (1.0 - tmpvar_11)
   / 
    ((LIGHT_ATTENUATION.x + (tmpvar_11 * LIGHT_ATTENUATION.y)) + ((tmpvar_11 * tmpvar_11) * LIGHT_ATTENUATION.z))
  ) * clamp (
    (1.0 - ((LIGHT_INNER_DIFF_INV.x - dot (
      normalize(tmpvar_12)
    , 
      -(LIGHT_GIVEN_DIRECTION)
    )) * LIGHT_INNER_DIFF_INV.y))
  , 0.0, 1.0)));
  highp vec3 F_13;
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(tmpvar_8);
  highp vec3 tmpvar_15;
  tmpvar_15 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(tmpvar_12);
  highp vec3 tmpvar_17;
  tmpvar_17 = normalize((tmpvar_15 + tmpvar_16));
  highp float tmpvar_18;
  tmpvar_18 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_19;
  tmpvar_19 = (tmpvar_18 * tmpvar_18);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_14, tmpvar_17), 0.0);
  highp float tmpvar_21;
  tmpvar_21 = (((tmpvar_20 * tmpvar_20) * (tmpvar_19 - 1.0)) + 1.0);
  highp float tmpvar_22;
  tmpvar_22 = max (dot (tmpvar_14, tmpvar_15), 0.0);
  highp float tmpvar_23;
  tmpvar_23 = max (dot (tmpvar_14, tmpvar_16), 0.0);
  F_13 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_17, tmpvar_15), 0.0))
  , 5.0)));
  highp float tmpvar_24;
  tmpvar_24 = max (dot (tmpvar_14, tmpvar_16), 0.0);
  highp vec3 tmpvar_25;
  tmpvar_25 = normalize(tmpvar_8);
  highp vec3 tmpvar_26;
  tmpvar_26 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_27;
  tmpvar_27 = max (dot (tmpvar_25, tmpvar_26), 0.0);
  highp vec3 tmpvar_28;
  tmpvar_28.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_28.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_28.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_29;
  tmpvar_29.w = 8.0;
  tmpvar_29.xyz = (T2W_TBN_1 * tmpvar_25);
  lowp vec4 tmpvar_30;
  tmpvar_30 = textureLod (SKY_BOX, tmpvar_29.xyz, 8.0);
  highp vec4 tmpvar_31;
  tmpvar_31 = tmpvar_30;
  highp vec3 I_32;
  I_32 = -(tmpvar_26);
  highp vec4 tmpvar_33;
  tmpvar_33.xyz = (T2W_TBN_1 * (I_32 - (2.0 * 
    (dot (tmpvar_25, I_32) * tmpvar_25)
  )));
  tmpvar_33.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_34;
  tmpvar_34 = textureLod (SKY_BOX, tmpvar_33.xyz, tmpvar_33.w);
  highp vec3 tmpvar_35;
  tmpvar_35 = tmpvar_34.xyz;
  highp float tmpvar_36;
  tmpvar_36 = (1.0 - tmpvar_27);
  highp vec4 tmpvar_37;
  tmpvar_37.w = 1.0;
  tmpvar_37.xyz = pow (((
    ((((
      ((tmpvar_19 / ((3.141593 * tmpvar_21) * tmpvar_21)) * (0.5 / ((
        (tmpvar_23 * ((tmpvar_22 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_22 * ((tmpvar_23 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_13) * 3.14) * tmpvar_24) * out_LightColor_10)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_13) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_24) * out_LightColor_10)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_28, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_27), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_31.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_35) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_36 * tmpvar_36) * (
      (tmpvar_36 * tmpvar_36)
     * tmpvar_36)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_37;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * (tmpvar_3.xyz - LIGHT_POSITION));
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 out_LightColor_10;
  highp float tmpvar_11;
  tmpvar_11 = clamp ((sqrt(
    dot (xlv_TEXCOORD2, xlv_TEXCOORD2)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  highp vec3 tmpvar_12;
  tmpvar_12 = -(xlv_TEXCOORD2);
  out_LightColor_10 = (LIGHT_COLOR * ((
    (1.0 - tmpvar_11)
   / 
    ((LIGHT_ATTENUATION.x + (tmpvar_11 * LIGHT_ATTENUATION.y)) + ((tmpvar_11 * tmpvar_11) * LIGHT_ATTENUATION.z))
  ) * clamp (
    (1.0 - ((LIGHT_INNER_DIFF_INV.x - dot (
      normalize(tmpvar_12)
    , 
      -(LIGHT_GIVEN_DIRECTION)
    )) * LIGHT_INNER_DIFF_INV.y))
  , 0.0, 1.0)));
  highp vec3 F_13;
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(tmpvar_8);
  highp vec3 tmpvar_15;
  tmpvar_15 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(tmpvar_12);
  highp vec3 tmpvar_17;
  tmpvar_17 = normalize((tmpvar_15 + tmpvar_16));
  highp float tmpvar_18;
  tmpvar_18 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_19;
  tmpvar_19 = (tmpvar_18 * tmpvar_18);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_14, tmpvar_17), 0.0);
  highp float tmpvar_21;
  tmpvar_21 = (((tmpvar_20 * tmpvar_20) * (tmpvar_19 - 1.0)) + 1.0);
  highp float tmpvar_22;
  tmpvar_22 = max (dot (tmpvar_14, tmpvar_15), 0.0);
  highp float tmpvar_23;
  tmpvar_23 = max (dot (tmpvar_14, tmpvar_16), 0.0);
  F_13 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_17, tmpvar_15), 0.0))
  , 5.0)));
  highp float tmpvar_24;
  tmpvar_24 = max (dot (tmpvar_14, tmpvar_16), 0.0);
  highp vec3 tmpvar_25;
  tmpvar_25 = normalize(tmpvar_8);
  highp vec3 tmpvar_26;
  tmpvar_26 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_27;
  tmpvar_27 = max (dot (tmpvar_25, tmpvar_26), 0.0);
  highp vec3 tmpvar_28;
  tmpvar_28.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_28.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_28.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_29;
  tmpvar_29.w = 8.0;
  tmpvar_29.xyz = (T2W_TBN_1 * tmpvar_25);
  lowp vec4 tmpvar_30;
  tmpvar_30 = textureLod (SKY_BOX, tmpvar_29.xyz, 8.0);
  highp vec4 tmpvar_31;
  tmpvar_31 = tmpvar_30;
  highp vec3 I_32;
  I_32 = -(tmpvar_26);
  highp vec4 tmpvar_33;
  tmpvar_33.xyz = (T2W_TBN_1 * (I_32 - (2.0 * 
    (dot (tmpvar_25, I_32) * tmpvar_25)
  )));
  tmpvar_33.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_34;
  tmpvar_34 = textureLod (SKY_BOX, tmpvar_33.xyz, tmpvar_33.w);
  highp vec3 tmpvar_35;
  tmpvar_35 = tmpvar_34.xyz;
  highp float tmpvar_36;
  tmpvar_36 = (1.0 - tmpvar_27);
  highp vec4 tmpvar_37;
  tmpvar_37.w = 1.0;
  tmpvar_37.xyz = pow (((
    ((((
      ((tmpvar_19 / ((3.141593 * tmpvar_21) * tmpvar_21)) * (0.5 / ((
        (tmpvar_23 * ((tmpvar_22 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_22 * ((tmpvar_23 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_13) * 3.14) * tmpvar_24) * out_LightColor_10)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_13) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_24) * out_LightColor_10)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_28, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_27), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_31.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_35) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_36 * tmpvar_36) * (
      (tmpvar_36 * tmpvar_36)
     * tmpvar_36)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_37;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * (tmpvar_3.xyz - LIGHT_POSITION));
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 out_LightColor_10;
  highp float tmpvar_11;
  tmpvar_11 = clamp ((sqrt(
    dot (xlv_TEXCOORD2, xlv_TEXCOORD2)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  highp vec3 tmpvar_12;
  tmpvar_12 = -(xlv_TEXCOORD2);
  out_LightColor_10 = (LIGHT_COLOR * ((
    (1.0 - tmpvar_11)
   / 
    ((LIGHT_ATTENUATION.x + (tmpvar_11 * LIGHT_ATTENUATION.y)) + ((tmpvar_11 * tmpvar_11) * LIGHT_ATTENUATION.z))
  ) * clamp (
    (1.0 - ((LIGHT_INNER_DIFF_INV.x - dot (
      normalize(tmpvar_12)
    , 
      -(LIGHT_GIVEN_DIRECTION)
    )) * LIGHT_INNER_DIFF_INV.y))
  , 0.0, 1.0)));
  highp vec3 F_13;
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(tmpvar_8);
  highp vec3 tmpvar_15;
  tmpvar_15 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(tmpvar_12);
  highp vec3 tmpvar_17;
  tmpvar_17 = normalize((tmpvar_15 + tmpvar_16));
  highp float tmpvar_18;
  tmpvar_18 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_19;
  tmpvar_19 = (tmpvar_18 * tmpvar_18);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_14, tmpvar_17), 0.0);
  highp float tmpvar_21;
  tmpvar_21 = (((tmpvar_20 * tmpvar_20) * (tmpvar_19 - 1.0)) + 1.0);
  highp float tmpvar_22;
  tmpvar_22 = max (dot (tmpvar_14, tmpvar_15), 0.0);
  highp float tmpvar_23;
  tmpvar_23 = max (dot (tmpvar_14, tmpvar_16), 0.0);
  F_13 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_17, tmpvar_15), 0.0))
  , 5.0)));
  highp float tmpvar_24;
  tmpvar_24 = max (dot (tmpvar_14, tmpvar_16), 0.0);
  highp vec3 tmpvar_25;
  tmpvar_25 = normalize(tmpvar_8);
  highp vec3 tmpvar_26;
  tmpvar_26 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_27;
  tmpvar_27 = max (dot (tmpvar_25, tmpvar_26), 0.0);
  highp vec3 tmpvar_28;
  tmpvar_28.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_28.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_28.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_29;
  tmpvar_29.w = 8.0;
  tmpvar_29.xyz = (T2W_TBN_1 * tmpvar_25);
  lowp vec4 tmpvar_30;
  tmpvar_30 = textureLod (SKY_BOX, tmpvar_29.xyz, 8.0);
  highp vec4 tmpvar_31;
  tmpvar_31 = tmpvar_30;
  highp vec3 I_32;
  I_32 = -(tmpvar_26);
  highp vec4 tmpvar_33;
  tmpvar_33.xyz = (T2W_TBN_1 * (I_32 - (2.0 * 
    (dot (tmpvar_25, I_32) * tmpvar_25)
  )));
  tmpvar_33.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_34;
  tmpvar_34 = textureLod (SKY_BOX, tmpvar_33.xyz, tmpvar_33.w);
  highp vec3 tmpvar_35;
  tmpvar_35 = tmpvar_34.xyz;
  highp float tmpvar_36;
  tmpvar_36 = (1.0 - tmpvar_27);
  highp vec4 tmpvar_37;
  tmpvar_37.w = 1.0;
  tmpvar_37.xyz = pow (((
    ((((
      ((tmpvar_19 / ((3.141593 * tmpvar_21) * tmpvar_21)) * (0.5 / ((
        (tmpvar_23 * ((tmpvar_22 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_22 * ((tmpvar_23 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_13) * 3.14) * tmpvar_24) * out_LightColor_10)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_13) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_24) * out_LightColor_10)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_28, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_27), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_31.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_35) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_36 * tmpvar_36) * (
      (tmpvar_36 * tmpvar_36)
     * tmpvar_36)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_37;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * (tmpvar_3.xyz - LIGHT_POSITION));
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 out_LightColor_10;
  highp float tmpvar_11;
  tmpvar_11 = clamp ((sqrt(
    dot (xlv_TEXCOORD2, xlv_TEXCOORD2)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  highp vec3 tmpvar_12;
  tmpvar_12 = -(xlv_TEXCOORD2);
  out_LightColor_10 = (LIGHT_COLOR * ((
    (1.0 - tmpvar_11)
   / 
    ((LIGHT_ATTENUATION.x + (tmpvar_11 * LIGHT_ATTENUATION.y)) + ((tmpvar_11 * tmpvar_11) * LIGHT_ATTENUATION.z))
  ) * clamp (
    (1.0 - ((LIGHT_INNER_DIFF_INV.x - dot (
      normalize(tmpvar_12)
    , 
      -(LIGHT_GIVEN_DIRECTION)
    )) * LIGHT_INNER_DIFF_INV.y))
  , 0.0, 1.0)));
  highp vec3 F_13;
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(tmpvar_8);
  highp vec3 tmpvar_15;
  tmpvar_15 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(tmpvar_12);
  highp vec3 tmpvar_17;
  tmpvar_17 = normalize((tmpvar_15 + tmpvar_16));
  highp float tmpvar_18;
  tmpvar_18 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_19;
  tmpvar_19 = (tmpvar_18 * tmpvar_18);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_14, tmpvar_17), 0.0);
  highp float tmpvar_21;
  tmpvar_21 = (((tmpvar_20 * tmpvar_20) * (tmpvar_19 - 1.0)) + 1.0);
  highp float tmpvar_22;
  tmpvar_22 = max (dot (tmpvar_14, tmpvar_15), 0.0);
  highp float tmpvar_23;
  tmpvar_23 = max (dot (tmpvar_14, tmpvar_16), 0.0);
  F_13 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_17, tmpvar_15), 0.0))
  , 5.0)));
  highp float tmpvar_24;
  tmpvar_24 = max (dot (tmpvar_14, tmpvar_16), 0.0);
  highp vec3 tmpvar_25;
  tmpvar_25 = normalize(tmpvar_8);
  highp vec3 tmpvar_26;
  tmpvar_26 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_27;
  tmpvar_27 = max (dot (tmpvar_25, tmpvar_26), 0.0);
  highp vec3 tmpvar_28;
  tmpvar_28.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_28.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_28.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_29;
  tmpvar_29.w = 8.0;
  tmpvar_29.xyz = (T2W_TBN_1 * tmpvar_25);
  lowp vec4 tmpvar_30;
  tmpvar_30 = textureLod (SKY_BOX, tmpvar_29.xyz, 8.0);
  highp vec4 tmpvar_31;
  tmpvar_31 = tmpvar_30;
  highp vec3 I_32;
  I_32 = -(tmpvar_26);
  highp vec4 tmpvar_33;
  tmpvar_33.xyz = (T2W_TBN_1 * (I_32 - (2.0 * 
    (dot (tmpvar_25, I_32) * tmpvar_25)
  )));
  tmpvar_33.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_34;
  tmpvar_34 = textureLod (SKY_BOX, tmpvar_33.xyz, tmpvar_33.w);
  highp vec3 tmpvar_35;
  tmpvar_35 = tmpvar_34.xyz;
  highp float tmpvar_36;
  tmpvar_36 = (1.0 - tmpvar_27);
  highp vec4 tmpvar_37;
  tmpvar_37.w = 1.0;
  tmpvar_37.xyz = pow (((
    ((((
      ((tmpvar_19 / ((3.141593 * tmpvar_21) * tmpvar_21)) * (0.5 / ((
        (tmpvar_23 * ((tmpvar_22 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_22 * ((tmpvar_23 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_13) * 3.14) * tmpvar_24) * out_LightColor_10)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_13) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_24) * out_LightColor_10)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_28, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_27), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_31.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_35) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_36 * tmpvar_36) * (
      (tmpvar_36 * tmpvar_36)
     * tmpvar_36)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_37;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"PointLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * (tmpvar_3.xyz - LIGHT_POSITION));
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 out_LightColor_10;
  highp float tmpvar_11;
  tmpvar_11 = clamp ((sqrt(
    dot (xlv_TEXCOORD2, xlv_TEXCOORD2)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  out_LightColor_10 = (LIGHT_COLOR * ((1.0 - tmpvar_11) / (
    (LIGHT_ATTENUATION.x + (tmpvar_11 * LIGHT_ATTENUATION.y))
   + 
    ((tmpvar_11 * tmpvar_11) * LIGHT_ATTENUATION.z)
  )));
  highp vec3 F_12;
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(tmpvar_8);
  highp vec3 tmpvar_14;
  tmpvar_14 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(-(xlv_TEXCOORD2));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize((tmpvar_14 + tmpvar_15));
  highp float tmpvar_17;
  tmpvar_17 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_18;
  tmpvar_18 = (tmpvar_17 * tmpvar_17);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_13, tmpvar_16), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = (((tmpvar_19 * tmpvar_19) * (tmpvar_18 - 1.0)) + 1.0);
  highp float tmpvar_21;
  tmpvar_21 = max (dot (tmpvar_13, tmpvar_14), 0.0);
  highp float tmpvar_22;
  tmpvar_22 = max (dot (tmpvar_13, tmpvar_15), 0.0);
  F_12 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_16, tmpvar_14), 0.0))
  , 5.0)));
  highp float tmpvar_23;
  tmpvar_23 = max (dot (tmpvar_13, tmpvar_15), 0.0);
  highp vec3 tmpvar_24;
  tmpvar_24 = normalize(tmpvar_8);
  highp vec3 tmpvar_25;
  tmpvar_25 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_26;
  tmpvar_26 = max (dot (tmpvar_24, tmpvar_25), 0.0);
  highp vec3 tmpvar_27;
  tmpvar_27.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_27.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_27.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_28;
  tmpvar_28.w = 8.0;
  tmpvar_28.xyz = (T2W_TBN_1 * tmpvar_24);
  lowp vec4 tmpvar_29;
  tmpvar_29 = textureLod (SKY_BOX, tmpvar_28.xyz, 8.0);
  highp vec4 tmpvar_30;
  tmpvar_30 = tmpvar_29;
  highp vec3 I_31;
  I_31 = -(tmpvar_25);
  highp vec4 tmpvar_32;
  tmpvar_32.xyz = (T2W_TBN_1 * (I_31 - (2.0 * 
    (dot (tmpvar_24, I_31) * tmpvar_24)
  )));
  tmpvar_32.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_33;
  tmpvar_33 = textureLod (SKY_BOX, tmpvar_32.xyz, tmpvar_32.w);
  highp vec3 tmpvar_34;
  tmpvar_34 = tmpvar_33.xyz;
  highp float tmpvar_35;
  tmpvar_35 = (1.0 - tmpvar_26);
  highp vec4 tmpvar_36;
  tmpvar_36.w = 1.0;
  tmpvar_36.xyz = pow (((
    ((((
      ((tmpvar_18 / ((3.141593 * tmpvar_20) * tmpvar_20)) * (0.5 / ((
        (tmpvar_22 * ((tmpvar_21 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_21 * ((tmpvar_22 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_12) * 3.14) * tmpvar_23) * out_LightColor_10)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_12) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_23) * out_LightColor_10)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_27, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_26), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_30.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_34) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_35 * tmpvar_35) * (
      (tmpvar_35 * tmpvar_35)
     * tmpvar_35)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_36;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"PointLight","ShadowOn"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_ALDEBO",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_AMR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_NORMAL",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SKY_BOX",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec3 xlv_TEXCOORD1;
out highp vec3 xlv_TEXCOORD2;
out highp vec3 xlv_TEXCOORD3;
out highp vec3 xlv_TEXCOORD4;
out highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 out_Position_1;
  highp mat3 tmpvar_2;
  tmpvar_2[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_2[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_2[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_3;
  tmpvar_3 = (LOCALWORLD_TRANSFORM * _glesVertex);
  out_Position_1 = (CAMERA_VIEWPROJ * tmpvar_3);
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  out_Position_1 = (tmpvar_4 * out_Position_1);
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize((tmpvar_2 * _glesNormal));
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize((tmpvar_2 * _glesTangent));
  highp vec3 tmpvar_7;
  tmpvar_7 = ((tmpvar_6.yzx * tmpvar_5.zxy) - (tmpvar_6.zxy * tmpvar_5.yzx));
  highp mat3 tmpvar_8;
  tmpvar_8[uint(0)].x = tmpvar_6.x;
  tmpvar_8[uint(0)].y = tmpvar_7.x;
  tmpvar_8[uint(0)].z = tmpvar_5.x;
  tmpvar_8[1u].x = tmpvar_6.y;
  tmpvar_8[1u].y = tmpvar_7.y;
  tmpvar_8[1u].z = tmpvar_5.y;
  tmpvar_8[2u].x = tmpvar_6.z;
  tmpvar_8[2u].y = tmpvar_7.z;
  tmpvar_8[2u].z = tmpvar_5.z;
  highp vec3 tmpvar_9;
  tmpvar_9.x = tmpvar_6.x;
  tmpvar_9.y = tmpvar_7.x;
  tmpvar_9.z = tmpvar_5.x;
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_6.y;
  tmpvar_10.y = tmpvar_7.y;
  tmpvar_10.z = tmpvar_5.y;
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_6.z;
  tmpvar_11.y = tmpvar_7.z;
  tmpvar_11.z = tmpvar_5.z;
  highp vec3 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_12.x = tmpvar_9.x;
  tmpvar_12.y = tmpvar_10.x;
  tmpvar_12.z = tmpvar_11.x;
  tmpvar_13.x = tmpvar_9.y;
  tmpvar_13.y = tmpvar_10.y;
  tmpvar_13.z = tmpvar_11.y;
  tmpvar_14.x = tmpvar_9.z;
  tmpvar_14.y = tmpvar_10.z;
  tmpvar_14.z = tmpvar_11.z;
  highp vec3 v_15;
  v_15.x = tmpvar_12.x;
  v_15.y = tmpvar_13.x;
  v_15.z = tmpvar_14.x;
  highp vec3 v_16;
  v_16.x = tmpvar_12.y;
  v_16.y = tmpvar_13.y;
  v_16.z = tmpvar_14.y;
  highp vec3 v_17;
  v_17.x = tmpvar_12.z;
  v_17.y = tmpvar_13.z;
  v_17.z = tmpvar_14.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (tmpvar_8 * (CAMERA_WORLDPOSITION - tmpvar_3.xyz));
  xlv_TEXCOORD2 = (tmpvar_8 * (tmpvar_3.xyz - LIGHT_POSITION));
  xlv_TEXCOORD3 = v_15;
  xlv_TEXCOORD4 = v_16;
  xlv_TEXCOORD5 = v_17;
  gl_Position = out_Position_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform lowp samplerCube SKY_BOX;
in highp vec2 xlv_TEXCOORD0;
in highp vec3 xlv_TEXCOORD1;
in highp vec3 xlv_TEXCOORD2;
void main ()
{
  highp mat3 T2W_TBN_1;
  highp vec3 albedo_2;
  highp vec3 tangentNormal_tmp_3;
  highp vec3 ao_roughness_metallic_4;
  lowp vec3 tmpvar_5;
  tmpvar_5 = pow (texture (TEXTURE_ALDEBO, xlv_TEXCOORD0).xyz, vec3(2.2, 2.2, 2.2));
  albedo_2 = tmpvar_5;
  lowp vec3 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_AMR, xlv_TEXCOORD0).xyz;
  ao_roughness_metallic_4 = tmpvar_6;
  albedo_2 = (albedo_2 * ao_roughness_metallic_4.x);
  lowp vec3 tmpvar_7;
  tmpvar_7 = ((texture (TEXTURE_NORMAL, xlv_TEXCOORD0).xyz * 2.0) - 1.0);
  tangentNormal_tmp_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(tangentNormal_tmp_3);
  highp vec3 tmpvar_9;
  tmpvar_9 = mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz);
  highp vec3 out_LightColor_10;
  highp float tmpvar_11;
  tmpvar_11 = clamp ((sqrt(
    dot (xlv_TEXCOORD2, xlv_TEXCOORD2)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  out_LightColor_10 = (LIGHT_COLOR * ((1.0 - tmpvar_11) / (
    (LIGHT_ATTENUATION.x + (tmpvar_11 * LIGHT_ATTENUATION.y))
   + 
    ((tmpvar_11 * tmpvar_11) * LIGHT_ATTENUATION.z)
  )));
  highp vec3 F_12;
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(tmpvar_8);
  highp vec3 tmpvar_14;
  tmpvar_14 = (xlv_TEXCOORD1 * inversesqrt(dot (xlv_TEXCOORD1, xlv_TEXCOORD1)));
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(-(xlv_TEXCOORD2));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize((tmpvar_14 + tmpvar_15));
  highp float tmpvar_17;
  tmpvar_17 = (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y);
  highp float tmpvar_18;
  tmpvar_18 = (tmpvar_17 * tmpvar_17);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_13, tmpvar_16), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = (((tmpvar_19 * tmpvar_19) * (tmpvar_18 - 1.0)) + 1.0);
  highp float tmpvar_21;
  tmpvar_21 = max (dot (tmpvar_13, tmpvar_14), 0.0);
  highp float tmpvar_22;
  tmpvar_22 = max (dot (tmpvar_13, tmpvar_15), 0.0);
  F_12 = (tmpvar_9 + ((1.0 - tmpvar_9) * pow (
    (1.0 - max (dot (tmpvar_16, tmpvar_14), 0.0))
  , 5.0)));
  highp float tmpvar_23;
  tmpvar_23 = max (dot (tmpvar_13, tmpvar_15), 0.0);
  highp vec3 tmpvar_24;
  tmpvar_24 = normalize(tmpvar_8);
  highp vec3 tmpvar_25;
  tmpvar_25 = normalize(xlv_TEXCOORD1);
  highp float tmpvar_26;
  tmpvar_26 = max (dot (tmpvar_24, tmpvar_25), 0.0);
  highp vec3 tmpvar_27;
  tmpvar_27.x = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_27.y = (1.0 - ao_roughness_metallic_4.y);
  tmpvar_27.z = (1.0 - ao_roughness_metallic_4.y);
  highp vec4 tmpvar_28;
  tmpvar_28.w = 8.0;
  tmpvar_28.xyz = (T2W_TBN_1 * tmpvar_24);
  lowp vec4 tmpvar_29;
  tmpvar_29 = textureLod (SKY_BOX, tmpvar_28.xyz, 8.0);
  highp vec4 tmpvar_30;
  tmpvar_30 = tmpvar_29;
  highp vec3 I_31;
  I_31 = -(tmpvar_25);
  highp vec4 tmpvar_32;
  tmpvar_32.xyz = (T2W_TBN_1 * (I_31 - (2.0 * 
    (dot (tmpvar_24, I_31) * tmpvar_24)
  )));
  tmpvar_32.w = (8.0 * ao_roughness_metallic_4.y);
  lowp vec4 tmpvar_33;
  tmpvar_33 = textureLod (SKY_BOX, tmpvar_32.xyz, tmpvar_32.w);
  highp vec3 tmpvar_34;
  tmpvar_34 = tmpvar_33.xyz;
  highp float tmpvar_35;
  tmpvar_35 = (1.0 - tmpvar_26);
  highp vec4 tmpvar_36;
  tmpvar_36.w = 1.0;
  tmpvar_36.xyz = pow (((
    ((((
      ((tmpvar_18 / ((3.141593 * tmpvar_20) * tmpvar_20)) * (0.5 / ((
        (tmpvar_22 * ((tmpvar_21 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
       + 
        (tmpvar_21 * ((tmpvar_22 * (1.0 - ao_roughness_metallic_4.y)) + ao_roughness_metallic_4.y))
      ) + 1e-5)))
     * F_12) * 3.14) * tmpvar_23) * out_LightColor_10)
   + 
    ((((
      ((vec3(1.0, 1.0, 1.0) - F_12) * (1.0 - ao_roughness_metallic_4.z))
     * albedo_2) / 3.141593) * tmpvar_23) * out_LightColor_10)
  ) + (
    ((((1.0 - 
      (tmpvar_9 + ((max (tmpvar_27, tmpvar_9) - tmpvar_9) * pow ((1.0 - tmpvar_26), 5.0)))
    ) * (1.0 - ao_roughness_metallic_4.z)) * albedo_2) * tmpvar_30.xyz)
   + 
    (((1.0 - (
      (0.28 * ao_roughness_metallic_4.y)
     * 
      (ao_roughness_metallic_4.y * ao_roughness_metallic_4.y)
    )) * tmpvar_34) * mix (mix (vec3(0.04, 0.04, 0.04), albedo_2, ao_roughness_metallic_4.zzz), vec3(clamp ((
      (1.0 - ao_roughness_metallic_4.y)
     + 
      (1.0 - (0.96 - (ao_roughness_metallic_4.z * 0.04)))
    ), 0.0, 1.0)), vec3(((tmpvar_35 * tmpvar_35) * (
      (tmpvar_35 * tmpvar_35)
     * tmpvar_35)))))
  )), vec3(0.4545454, 0.4545454, 0.4545454));
  _glesFragData[0] = tmpvar_36;
}

]===],
	},
}

end




