
#DEFPARAMS
_MainTex = { "Main Color", TEXTURE2D, "maintex" },
_Ratio = {"Aspect", FLOAT, "1.0"},
_Size = {"Ortho Size", FLOAT, "1.0"},
#END

#DEFTAG
ShaderName = "StandardBg"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "commonvar.inc"
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D _MainTex;
float     _Ratio;
float 	  _Size;

v2f vert(appdata v)
{
	v2f o;
	v.vertex.x = v.vertex.x * _Ratio;//需要把正交相机的size传进来~
	v.vertex.xy = v.vertex.xy * _Size;
	float4 pos = ObjectToClipPos(v.vertex);//lens貌似没有做归一化 底图宽高都不为一 高为size  
	o.vertex = UniformNDC(pos);
	o.uv = v.uv.xy; 

 
	return o;
}

float4 frag(v2f i) : SV_Target
{

  float4 mainColor = tex2D(_MainTex,i.uv);
  return mainColor;
}
ENDCG
#END
