

#DEFPARAMS
#END

#DEFTAG
ShaderName = "SkinDetect"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
    float4 Color = tex2D(TEXTURE_DIFFUSE, i.uv);
    if(Color.r>0.3725&&Color.g>0.156&&Color.b>0.0039){
      if(Color.r>Color.g&&Color.r>Color.b&&(Color.r-Color.b)>0.058&&(Color.r-min(Color.b,Color.g))>0.058){
        return float4(1.0,1.0,1.0,1.0);
      }
      else{
        return float4(0.0,0.0,0.0,0.0);
      }
    }
    else{
      return float4(0.0,0.0,0.0,0.0);
    }
}
ENDCG
#END
