

#DEFPARAMS
_MaskTex = { "", TEXTURE2D, "black" },
_FgTex = { "", TEXTURE2D, "white" },
_BgTex = { "", TEXTURE2D, "black" },
_BgSize = { "", VEC2, "4,4" },
_MaskMatR1 = { "", VEC3, "1,0,0" },
_MaskMatR2 = { "", VEC3, "0,1,0" },
_MaskMatR3 = { "", VEC3, "0,0,1" },
_RefRect1 = { "", VEC4, "0,0,1,1" },
_RefRect2 = { "", VEC4, "0,0,1,1" },
_RefRect3 = { "", VEC4, "0,0,1,1" },
_RefRect4 = { "", VEC4, "0,0,1,1" },
#END

#DEFTAG
ShaderName = "SkinStuff"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
    float2 vertex : POSITION;
    float2 uv : TEXCOORD0;
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 vertex : SV_POSITION;
};

sampler2D _MaskTex;
sampler2D _FgTex;
sampler2D _BgTex;
float2 _BgSize;
float3 _MaskMatR1;
float3 _MaskMatR2;
float3 _MaskMatR3;
float4 _RefRect1;
float4 _RefRect2;
float4 _RefRect3;
float4 _RefRect4;

v2f vert(appdata v)
{
    v2f o;

    o.vertex = UniformNDC(float4(v.vertex.xy, 0.0, 1.0));
    o.uv = v.uv;
    return o;
}

bool checkRectPoint(float2 p, float4 r, float pr)
{
    return length(p - r.xy) <= pr || length(p - r.zy) <= pr || length(p - r.xw) <= pr || length(p - r.zw) <= pr;
}

float4 frag(v2f i) : SV_Target
{
    float3x3 mat = float3x3(_MaskMatR1, _MaskMatR2, _MaskMatR3);
    float2 maskUV = i.uv;
    maskUV.y = 1.0 - maskUV.y;
    maskUV = mul(float3(maskUV, 1.0), mat).xy;

    float2 fgUV1 = _RefRect1.xy + _RefRect1.zw * maskUV;
    float2 fgUV2 = _RefRect2.xy + _RefRect2.zw * maskUV;
    float2 fgUV3 = _RefRect3.xy + _RefRect3.zw * maskUV;
    float2 fgUV4 = _RefRect4.xy + _RefRect4.zw * maskUV;

    float3 fgColor1 = tex2D(_FgTex, fgUV1).rgb;
    float3 fgColor2 = tex2D(_FgTex, fgUV2).rgb;
    float3 fgColor3 = tex2D(_FgTex, fgUV3).rgb;
    float3 fgColor4 = tex2D(_FgTex, fgUV4).rgb;

    float maskAlpha = 0.0;
    if (maskUV.x >= 0.0 && maskUV.x <= 1.0 && maskUV.y >= 0.0 && maskUV.y <= 1.0)
    {
        maskAlpha = tex2D(_MaskTex, maskUV).a;
        maskAlpha = 1.0 - pow(1.0 - maskAlpha, 3.0);
    }
    float3 bgColor = tex2D(_BgTex, i.uv).rgb;
    float3 fgColor = (fgColor1 + fgColor2 + fgColor3 + fgColor4) * 0.25;
    float3 color = bgColor * (1.0 - maskAlpha) + fgColor * maskAlpha;

    //ref point
    /*
    const float pr = 2.0;
    float2 xy = i.uv;
    xy *= _BgSize;
    float4 rs = float4(_BgSize.x, _BgSize.y, _BgSize.x, _BgSize.y);
    float4 r1 = _RefRect1 * rs;
    float4 r2 = _RefRect2 * rs;
    float4 r3 = _RefRect3 * rs;
    float4 r4 = _RefRect4 * rs;
    r1.zw += r1.xy;
    r2.zw += r2.xy;
    r3.zw += r3.xy;
    r4.zw += r4.xy;
    if (checkRectPoint(xy, r1, pr) || 
        checkRectPoint(xy, r2, pr) || 
        checkRectPoint(xy, r3, pr) || 
        checkRectPoint(xy, r4, pr))
    {
        color = float3(0.0, 1.0, 0.0);
    }
    */

    return float4(color, 1.0);
}

ENDCG
#END
