

function DefineParams()
	Properties = 
	{
		
TEXTURE_DIFFUSE = { "main Color", TEXTURE2D, "white" },
TEXTURE_SHADOW_DEPTH = { "main Color", TEXTURE2D, "white" },

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"ForwardBase","ForwardAdd","Depth"
	}

ShaderName = "simple"
RenderQueue = "Opaque"
end

function ForwardBase()

	COLOR_MASK = COLOR_RGBA
	ALPAH_MODE = { ALPAH_OFF }
	DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
	STENCIL_MODE = { STENCIL_OFF }
	LIGHT_MODE = { FORWARDBASE }

	
Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","NoLight"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec3 tmpvar_2;
  highp float tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[0].x = row0_6.x;
  tmpvar_11[0].y = row0_6.y;
  tmpvar_11[0].z = row0_6.z;
  tmpvar_11[0].w = row0_6.w;
  tmpvar_11[1].x = row1_5.x;
  tmpvar_11[1].y = row1_5.y;
  tmpvar_11[1].z = row1_5.z;
  tmpvar_11[1].w = row1_5.w;
  tmpvar_11[2].x = row2_4.x;
  tmpvar_11[2].y = row2_4.y;
  tmpvar_11[2].z = row2_4.z;
  tmpvar_11[2].w = row2_4.w;
  tmpvar_11[3].x = 0.0;
  tmpvar_11[3].y = 0.0;
  tmpvar_11[3].z = 0.0;
  tmpvar_11[3].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_13;
  tmpvar_13[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_13[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_13[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[0] = tmpvar_11[0].xyz;
  tmpvar_14[1] = tmpvar_11[1].xyz;
  tmpvar_14[2] = tmpvar_11[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_13 * (_glesNormal * tmpvar_14)));
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
  xlv_TEXCOORD5 = tmpvar_1;
  xlv_TEXCOORD1 = vec3(0.0, 0.0, 1.0);
  xlv_TEXCOORD2 = vec3(0.0, 0.0, 1.0);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = tmpvar_3;
}

]===],
		psShader = [===[uniform highp vec3 LIGHT_COLOR;
uniform sampler2D TEXTURE_DIFFUSE;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 col_1;
  lowp vec4 tmpvar_2;
  tmpvar_2 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  col_1 = tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.xyz = (LIGHT_COLOR * col_1.xyz);
  tmpvar_3.w = col_1.w;
  gl_FragData[0] = tmpvar_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec3 tmpvar_2;
  highp vec3 tmpvar_3;
  highp float tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = tmpvar_12[0].xyz;
  tmpvar_15[1] = tmpvar_12[1].xyz;
  tmpvar_15[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD5 = tmpvar_1;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz);
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D TEXTURE_DIFFUSE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
void main ()
{
  mediump vec3 vLight_1;
  mediump vec3 vNormal_2;
  highp vec4 col_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  col_3 = tmpvar_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD5).xyz;
  vNormal_2 = tmpvar_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(-(LIGHT_GIVEN_DIRECTION));
  vLight_1 = tmpvar_6;
  mediump float tmpvar_7;
  tmpvar_7 = clamp (dot (vLight_1, vNormal_2), 0.0, 1.0);
  highp vec4 tmpvar_8;
  tmpvar_8.xyz = ((AMBIENT_COLOR + (tmpvar_7 * LIGHT_COLOR)) * col_3.xyz);
  tmpvar_8.w = col_3.w;
  gl_FragData[0] = tmpvar_8;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALSCREEN_TRANSVIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "CAMERA_RESOLUTION",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_HALF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec3 tmpvar_2;
  highp vec4 row2_3;
  highp vec4 row1_4;
  highp vec4 row0_5;
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.w) * 3);
  row0_5 = (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.x);
  row1_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.x);
  row2_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.x);
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.y));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.y));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.y));
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.z));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.z));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.z));
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.w));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.w));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = row0_5.x;
  tmpvar_10[0].y = row0_5.y;
  tmpvar_10[0].z = row0_5.z;
  tmpvar_10[0].w = row0_5.w;
  tmpvar_10[1].x = row1_4.x;
  tmpvar_10[1].y = row1_4.y;
  tmpvar_10[1].z = row1_4.z;
  tmpvar_10[1].w = row1_4.w;
  tmpvar_10[2].x = row2_3.x;
  tmpvar_10[2].y = row2_3.y;
  tmpvar_10[2].z = row2_3.z;
  tmpvar_10[2].w = row2_3.w;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_11.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_13;
  tmpvar_13[0] = tmpvar_10[0].xyz;
  tmpvar_13[1] = tmpvar_10[1].xyz;
  tmpvar_13[2] = tmpvar_10[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_12 * (_glesNormal * tmpvar_13)));
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_10)).xyz;
  highp mat4 tmpvar_15;
  tmpvar_15[0].x = 0.5;
  tmpvar_15[0].y = 0.0;
  tmpvar_15[0].z = 0.0;
  tmpvar_15[0].w = 0.5;
  tmpvar_15[1].x = 0.0;
  tmpvar_15[1].y = 0.5;
  tmpvar_15[1].z = 0.0;
  tmpvar_15[1].w = 0.5;
  tmpvar_15[2].x = 0.0;
  tmpvar_15[2].y = 0.0;
  tmpvar_15[2].z = 0.5;
  tmpvar_15[2].w = 0.5;
  tmpvar_15[3].x = 0.0;
  tmpvar_15[3].y = 0.0;
  tmpvar_15[3].z = 0.0;
  tmpvar_15[3].w = 1.0;
  highp vec4 tmpvar_16;
  tmpvar_16.w = 0.0;
  tmpvar_16.xyz = tmpvar_14;
  highp vec4 tmpvar_17;
  tmpvar_17.w = 0.0;
  tmpvar_17.xyz = (0.005 * tmpvar_1.xyz);
  highp vec4 tmpvar_18;
  tmpvar_18 = (tmpvar_16 - tmpvar_17);
  highp vec4 tmpvar_19;
  tmpvar_19 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * tmpvar_18));
  highp vec4 tmpvar_20;
  tmpvar_20 = (LIGHT_CAMERA_VIEW * tmpvar_18);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_11 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_10)
  )));
  xlv_TEXCOORD5 = tmpvar_1;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - tmpvar_14);
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = (tmpvar_15 * (tmpvar_19 / tmpvar_19.w)).xyz;
  xlv_TEXCOORD4 = (((
    -(tmpvar_20.z)
   / tmpvar_20.w) - LIGHT_CAMERA_LINEARPARAM.x) * LIGHT_CAMERA_LINEARPARAM.y);
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : require

#line 20
struct LightInput {
    highp vec3 lightColor;
    highp vec3 viewDir;
    highp vec3 lightDir;
    highp vec3 normalDir;
    highp float atten;
    highp vec3 emission;
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
};
#line 9
struct SurfaceInput {
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
    highp vec3 emission;
    highp vec3 worldNormal;
    highp vec3 worldPos;
    highp float atten;
};
#line 32
struct v2f {
    highp vec2 uv;
    highp vec4 vertex;
    highp vec4 worldnormal;
    highp vec3 viewDirection;
    highp vec3 lightDirection;
    highp vec3 LightCoord;
    highp float OrigDepth;
};
#line 24
struct appdata {
    highp vec4 vertex;
    highp vec2 uv;
    highp vec3 normal;
    highp vec4 boneIndices;
    highp vec4 boneWeight;
};
#line 5
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
#line 9
uniform highp mat4 CAMERA_PROJECTION;
uniform highp mat4 LOCALSCREEN_TRANSVIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
#line 13
uniform highp vec3 LIGHT_POSITION;
uniform highp vec3 WORLD_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
#line 17
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
#line 21
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp vec2 CAMERA_RESOLUTION;
#line 25
uniform highp vec2 CAMERA_RESOLUTION_INV;
uniform highp vec2 CAMERA_RESOLUTION_HALF_INV;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform sampler2D TEXTURE_GRAP;
#line 32
uniform highp float DEVICE_COORDINATE_Y_FLIP;
#line 124
#line 129
#line 144
#line 8
#line 18
#line 27
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
#line 35
#line 40
#line 58
#line 79
#line 95
#line 118
#line 154
#line 196
#line 245
#line 289
#line 33
#line 70
#line 44
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
#line 87
highp vec4 frag( in v2f i ) {
    #line 90
    highp vec4 col = texture2D( TEXTURE_DIFFUSE, i.uv);
    highp vec3 diffuse = vec3( 1.0, 1.0, 1.0);
    #line 94
    highp vec4 depthColor = shadow2D( TEXTURE_SHADOW_DEPTH, vec3( i.uv, 0.0));
    const highp vec4 bitShifts = vec4( 1.0, 0.00390625, 1.525879e-5, 5.960464e-8);
    #line 99
    highp float TexDepth = dot( depthColor, bitShifts);
    const mediump float constant = 60.0;
    #line 103
    mediump vec3 vNormal = vec3( normalize(i.worldnormal));
    mediump vec3 vLight = normalize((-LIGHT_GIVEN_DIRECTION));
    mediump vec3 vView = normalize(i.viewDirection);
    mediump vec3 vHalf = normalize((vLight + vView));
    #line 107
    mediump float dotLightNormal = dot( vLight, vNormal);
    mediump float fDiffuse = clamp( dotLightNormal, 0.0, 1.0);
    #line 111
    highp float expFactor = exp((60.0 * (TexDepth - i.OrigDepth)));
    if ((expFactor > 1.0)){
        expFactor = 1.0;
    }
    #line 117
    diffuse = (AMBIENT_COLOR + ((fDiffuse * LIGHT_COLOR) * expFactor));
    #line 191
    return vec4( (diffuse * col.xyz), col.w);
}
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main() {
    highp vec4 xl_retval;
    v2f xlt_i;
    xlt_i.uv = vec2(xlv_TEXCOORD0);
    xlt_i.vertex = vec4(0.0);
    xlt_i.worldnormal = vec4(xlv_TEXCOORD5);
    xlt_i.viewDirection = vec3(xlv_TEXCOORD1);
    xlt_i.lightDirection = vec3(xlv_TEXCOORD2);
    xlt_i.LightCoord = vec3(xlv_TEXCOORD3);
    xlt_i.OrigDepth = float(xlv_TEXCOORD4);
    xl_retval = frag( xlt_i);
    gl_FragData[0] = vec4(xl_retval);
}
/* NOTE: GLSL optimization failed
(95,26): error: no matching function for call to `shadow2D(sampler2DShadow, vec3)'; candidates are:
*/
]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALSCREEN_TRANSVIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "CAMERA_RESOLUTION",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_HALF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec3 tmpvar_2;
  highp vec4 row2_3;
  highp vec4 row1_4;
  highp vec4 row0_5;
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.w) * 3);
  row0_5 = (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.x);
  row1_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.x);
  row2_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.x);
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.y));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.y));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.y));
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.z));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.z));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.z));
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.w));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.w));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = row0_5.x;
  tmpvar_10[0].y = row0_5.y;
  tmpvar_10[0].z = row0_5.z;
  tmpvar_10[0].w = row0_5.w;
  tmpvar_10[1].x = row1_4.x;
  tmpvar_10[1].y = row1_4.y;
  tmpvar_10[1].z = row1_4.z;
  tmpvar_10[1].w = row1_4.w;
  tmpvar_10[2].x = row2_3.x;
  tmpvar_10[2].y = row2_3.y;
  tmpvar_10[2].z = row2_3.z;
  tmpvar_10[2].w = row2_3.w;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_11.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_13;
  tmpvar_13[0] = tmpvar_10[0].xyz;
  tmpvar_13[1] = tmpvar_10[1].xyz;
  tmpvar_13[2] = tmpvar_10[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_12 * (_glesNormal * tmpvar_13)));
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_10)).xyz;
  highp mat4 tmpvar_15;
  tmpvar_15[0].x = 0.5;
  tmpvar_15[0].y = 0.0;
  tmpvar_15[0].z = 0.0;
  tmpvar_15[0].w = 0.5;
  tmpvar_15[1].x = 0.0;
  tmpvar_15[1].y = 0.5;
  tmpvar_15[1].z = 0.0;
  tmpvar_15[1].w = 0.5;
  tmpvar_15[2].x = 0.0;
  tmpvar_15[2].y = 0.0;
  tmpvar_15[2].z = 0.5;
  tmpvar_15[2].w = 0.5;
  tmpvar_15[3].x = 0.0;
  tmpvar_15[3].y = 0.0;
  tmpvar_15[3].z = 0.0;
  tmpvar_15[3].w = 1.0;
  highp vec4 tmpvar_16;
  tmpvar_16.w = 0.0;
  tmpvar_16.xyz = tmpvar_14;
  highp vec4 tmpvar_17;
  tmpvar_17.w = 0.0;
  tmpvar_17.xyz = (0.005 * tmpvar_1.xyz);
  highp vec4 tmpvar_18;
  tmpvar_18 = (tmpvar_16 - tmpvar_17);
  highp vec4 tmpvar_19;
  tmpvar_19 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * tmpvar_18));
  highp vec4 tmpvar_20;
  tmpvar_20 = (LIGHT_CAMERA_VIEW * tmpvar_18);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_11 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_10)
  )));
  xlv_TEXCOORD5 = tmpvar_1;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - tmpvar_14);
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = (tmpvar_15 * (tmpvar_19 / tmpvar_19.w)).xyz;
  xlv_TEXCOORD4 = (((
    -(tmpvar_20.z)
   / tmpvar_20.w) - LIGHT_CAMERA_LINEARPARAM.x) * LIGHT_CAMERA_LINEARPARAM.y);
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : require

#line 20
struct LightInput {
    highp vec3 lightColor;
    highp vec3 viewDir;
    highp vec3 lightDir;
    highp vec3 normalDir;
    highp float atten;
    highp vec3 emission;
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
};
#line 9
struct SurfaceInput {
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
    highp vec3 emission;
    highp vec3 worldNormal;
    highp vec3 worldPos;
    highp float atten;
};
#line 32
struct v2f {
    highp vec2 uv;
    highp vec4 vertex;
    highp vec4 worldnormal;
    highp vec3 viewDirection;
    highp vec3 lightDirection;
    highp vec3 LightCoord;
    highp float OrigDepth;
};
#line 24
struct appdata {
    highp vec4 vertex;
    highp vec2 uv;
    highp vec3 normal;
    highp vec4 boneIndices;
    highp vec4 boneWeight;
};
#line 5
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
#line 9
uniform highp mat4 CAMERA_PROJECTION;
uniform highp mat4 LOCALSCREEN_TRANSVIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
#line 13
uniform highp vec3 LIGHT_POSITION;
uniform highp vec3 WORLD_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
#line 17
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
#line 21
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp vec2 CAMERA_RESOLUTION;
#line 25
uniform highp vec2 CAMERA_RESOLUTION_INV;
uniform highp vec2 CAMERA_RESOLUTION_HALF_INV;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform sampler2D TEXTURE_GRAP;
#line 32
uniform highp float DEVICE_COORDINATE_Y_FLIP;
#line 124
#line 129
#line 144
#line 8
#line 18
#line 27
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
#line 35
#line 40
#line 58
#line 79
#line 95
#line 118
#line 154
#line 196
#line 245
#line 289
#line 33
#line 70
#line 44
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
#line 87
highp vec4 frag( in v2f i ) {
    #line 90
    highp vec4 col = texture2D( TEXTURE_DIFFUSE, i.uv);
    highp vec3 diffuse = vec3( 1.0, 1.0, 1.0);
    #line 94
    highp vec4 depthColor = shadow2D( TEXTURE_SHADOW_DEPTH, vec3( i.uv, 0.0));
    const highp vec4 bitShifts = vec4( 1.0, 0.00390625, 1.525879e-5, 5.960464e-8);
    #line 99
    highp float TexDepth = dot( depthColor, bitShifts);
    const mediump float constant = 60.0;
    #line 103
    mediump vec3 vNormal = vec3( normalize(i.worldnormal));
    mediump vec3 vLight = normalize((-LIGHT_GIVEN_DIRECTION));
    mediump vec3 vView = normalize(i.viewDirection);
    mediump vec3 vHalf = normalize((vLight + vView));
    #line 107
    mediump float dotLightNormal = dot( vLight, vNormal);
    mediump float fDiffuse = clamp( dotLightNormal, 0.0, 1.0);
    #line 111
    highp float expFactor = exp((60.0 * (TexDepth - i.OrigDepth)));
    if ((expFactor > 1.0)){
        expFactor = 1.0;
    }
    #line 117
    diffuse = (AMBIENT_COLOR + ((fDiffuse * LIGHT_COLOR) * expFactor));
    #line 191
    return vec4( (diffuse * col.xyz), col.w);
}
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main() {
    highp vec4 xl_retval;
    v2f xlt_i;
    xlt_i.uv = vec2(xlv_TEXCOORD0);
    xlt_i.vertex = vec4(0.0);
    xlt_i.worldnormal = vec4(xlv_TEXCOORD5);
    xlt_i.viewDirection = vec3(xlv_TEXCOORD1);
    xlt_i.lightDirection = vec3(xlv_TEXCOORD2);
    xlt_i.LightCoord = vec3(xlv_TEXCOORD3);
    xlt_i.OrigDepth = float(xlv_TEXCOORD4);
    xl_retval = frag( xlt_i);
    gl_FragData[0] = vec4(xl_retval);
}
/* NOTE: GLSL optimization failed
(95,26): error: no matching function for call to `shadow2D(sampler2DShadow, vec3)'; candidates are:
*/
]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALSCREEN_TRANSVIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "CAMERA_RESOLUTION",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_HALF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec3 tmpvar_2;
  highp vec4 row2_3;
  highp vec4 row1_4;
  highp vec4 row0_5;
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.w) * 3);
  row0_5 = (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.x);
  row1_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.x);
  row2_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.x);
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.y));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.y));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.y));
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.z));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.z));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.z));
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.w));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.w));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = row0_5.x;
  tmpvar_10[0].y = row0_5.y;
  tmpvar_10[0].z = row0_5.z;
  tmpvar_10[0].w = row0_5.w;
  tmpvar_10[1].x = row1_4.x;
  tmpvar_10[1].y = row1_4.y;
  tmpvar_10[1].z = row1_4.z;
  tmpvar_10[1].w = row1_4.w;
  tmpvar_10[2].x = row2_3.x;
  tmpvar_10[2].y = row2_3.y;
  tmpvar_10[2].z = row2_3.z;
  tmpvar_10[2].w = row2_3.w;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_11.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_13;
  tmpvar_13[0] = tmpvar_10[0].xyz;
  tmpvar_13[1] = tmpvar_10[1].xyz;
  tmpvar_13[2] = tmpvar_10[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_12 * (_glesNormal * tmpvar_13)));
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_10)).xyz;
  highp mat4 tmpvar_15;
  tmpvar_15[0].x = 0.5;
  tmpvar_15[0].y = 0.0;
  tmpvar_15[0].z = 0.0;
  tmpvar_15[0].w = 0.5;
  tmpvar_15[1].x = 0.0;
  tmpvar_15[1].y = 0.5;
  tmpvar_15[1].z = 0.0;
  tmpvar_15[1].w = 0.5;
  tmpvar_15[2].x = 0.0;
  tmpvar_15[2].y = 0.0;
  tmpvar_15[2].z = 0.5;
  tmpvar_15[2].w = 0.5;
  tmpvar_15[3].x = 0.0;
  tmpvar_15[3].y = 0.0;
  tmpvar_15[3].z = 0.0;
  tmpvar_15[3].w = 1.0;
  highp vec4 tmpvar_16;
  tmpvar_16.w = 0.0;
  tmpvar_16.xyz = tmpvar_14;
  highp vec4 tmpvar_17;
  tmpvar_17.w = 0.0;
  tmpvar_17.xyz = (0.005 * tmpvar_1.xyz);
  highp vec4 tmpvar_18;
  tmpvar_18 = (tmpvar_16 - tmpvar_17);
  highp vec4 tmpvar_19;
  tmpvar_19 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * tmpvar_18));
  highp vec4 tmpvar_20;
  tmpvar_20 = (LIGHT_CAMERA_VIEW * tmpvar_18);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_11 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_10)
  )));
  xlv_TEXCOORD5 = tmpvar_1;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - tmpvar_14);
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = (tmpvar_15 * (tmpvar_19 / tmpvar_19.w)).xyz;
  xlv_TEXCOORD4 = (((
    -(tmpvar_20.z)
   / tmpvar_20.w) - LIGHT_CAMERA_LINEARPARAM.x) * LIGHT_CAMERA_LINEARPARAM.y);
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : require

#line 20
struct LightInput {
    highp vec3 lightColor;
    highp vec3 viewDir;
    highp vec3 lightDir;
    highp vec3 normalDir;
    highp float atten;
    highp vec3 emission;
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
};
#line 9
struct SurfaceInput {
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
    highp vec3 emission;
    highp vec3 worldNormal;
    highp vec3 worldPos;
    highp float atten;
};
#line 32
struct v2f {
    highp vec2 uv;
    highp vec4 vertex;
    highp vec4 worldnormal;
    highp vec3 viewDirection;
    highp vec3 lightDirection;
    highp vec3 LightCoord;
    highp float OrigDepth;
};
#line 24
struct appdata {
    highp vec4 vertex;
    highp vec2 uv;
    highp vec3 normal;
    highp vec4 boneIndices;
    highp vec4 boneWeight;
};
#line 5
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
#line 9
uniform highp mat4 CAMERA_PROJECTION;
uniform highp mat4 LOCALSCREEN_TRANSVIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
#line 13
uniform highp vec3 LIGHT_POSITION;
uniform highp vec3 WORLD_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
#line 17
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
#line 21
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp vec2 CAMERA_RESOLUTION;
#line 25
uniform highp vec2 CAMERA_RESOLUTION_INV;
uniform highp vec2 CAMERA_RESOLUTION_HALF_INV;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform sampler2D TEXTURE_GRAP;
#line 32
uniform highp float DEVICE_COORDINATE_Y_FLIP;
#line 124
#line 129
#line 144
#line 8
#line 18
#line 27
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
#line 35
#line 40
#line 58
#line 79
#line 95
#line 118
#line 154
#line 196
#line 245
#line 289
#line 33
#line 70
#line 44
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
#line 87
highp vec4 frag( in v2f i ) {
    #line 90
    highp vec4 col = texture2D( TEXTURE_DIFFUSE, i.uv);
    highp vec3 diffuse = vec3( 1.0, 1.0, 1.0);
    #line 94
    highp vec4 depthColor = shadow2D( TEXTURE_SHADOW_DEPTH, vec3( i.uv, 0.0));
    const highp vec4 bitShifts = vec4( 1.0, 0.00390625, 1.525879e-5, 5.960464e-8);
    #line 99
    highp float TexDepth = dot( depthColor, bitShifts);
    const mediump float constant = 60.0;
    #line 103
    mediump vec3 vNormal = vec3( normalize(i.worldnormal));
    mediump vec3 vLight = normalize((-LIGHT_GIVEN_DIRECTION));
    mediump vec3 vView = normalize(i.viewDirection);
    mediump vec3 vHalf = normalize((vLight + vView));
    #line 107
    mediump float dotLightNormal = dot( vLight, vNormal);
    mediump float fDiffuse = clamp( dotLightNormal, 0.0, 1.0);
    #line 111
    highp float expFactor = exp((60.0 * (TexDepth - i.OrigDepth)));
    if ((expFactor > 1.0)){
        expFactor = 1.0;
    }
    #line 117
    diffuse = (AMBIENT_COLOR + ((fDiffuse * LIGHT_COLOR) * expFactor));
    #line 191
    return vec4( (diffuse * col.xyz), col.w);
}
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main() {
    highp vec4 xl_retval;
    v2f xlt_i;
    xlt_i.uv = vec2(xlv_TEXCOORD0);
    xlt_i.vertex = vec4(0.0);
    xlt_i.worldnormal = vec4(xlv_TEXCOORD5);
    xlt_i.viewDirection = vec3(xlv_TEXCOORD1);
    xlt_i.lightDirection = vec3(xlv_TEXCOORD2);
    xlt_i.LightCoord = vec3(xlv_TEXCOORD3);
    xlt_i.OrigDepth = float(xlv_TEXCOORD4);
    xl_retval = frag( xlt_i);
    gl_FragData[0] = vec4(xl_retval);
}
/* NOTE: GLSL optimization failed
(95,26): error: no matching function for call to `shadow2D(sampler2DShadow, vec3)'; candidates are:
*/
]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec3 tmpvar_2;
  highp vec4 row2_3;
  highp vec4 row1_4;
  highp vec4 row0_5;
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.w) * 3);
  row0_5 = (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.x);
  row1_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.x);
  row2_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.x);
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.y));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.y));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.y));
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.z));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.z));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.z));
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.w));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.w));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = row0_5.x;
  tmpvar_10[0].y = row0_5.y;
  tmpvar_10[0].z = row0_5.z;
  tmpvar_10[0].w = row0_5.w;
  tmpvar_10[1].x = row1_4.x;
  tmpvar_10[1].y = row1_4.y;
  tmpvar_10[1].z = row1_4.z;
  tmpvar_10[1].w = row1_4.w;
  tmpvar_10[2].x = row2_3.x;
  tmpvar_10[2].y = row2_3.y;
  tmpvar_10[2].z = row2_3.z;
  tmpvar_10[2].w = row2_3.w;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_11.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_13;
  tmpvar_13[0] = tmpvar_10[0].xyz;
  tmpvar_13[1] = tmpvar_10[1].xyz;
  tmpvar_13[2] = tmpvar_10[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_12 * (_glesNormal * tmpvar_13)));
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_10)).xyz;
  highp mat4 tmpvar_15;
  tmpvar_15[0].x = 0.5;
  tmpvar_15[0].y = 0.0;
  tmpvar_15[0].z = 0.0;
  tmpvar_15[0].w = 0.5;
  tmpvar_15[1].x = 0.0;
  tmpvar_15[1].y = 0.5;
  tmpvar_15[1].z = 0.0;
  tmpvar_15[1].w = 0.5;
  tmpvar_15[2].x = 0.0;
  tmpvar_15[2].y = 0.0;
  tmpvar_15[2].z = 0.5;
  tmpvar_15[2].w = 0.5;
  tmpvar_15[3].x = 0.0;
  tmpvar_15[3].y = 0.0;
  tmpvar_15[3].z = 0.0;
  tmpvar_15[3].w = 1.0;
  highp vec4 tmpvar_16;
  tmpvar_16.w = 0.0;
  tmpvar_16.xyz = tmpvar_14;
  highp vec4 tmpvar_17;
  tmpvar_17.w = 0.0;
  tmpvar_17.xyz = (0.005 * tmpvar_1.xyz);
  highp vec4 tmpvar_18;
  tmpvar_18 = (tmpvar_16 - tmpvar_17);
  highp vec4 tmpvar_19;
  tmpvar_19 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * tmpvar_18));
  highp vec4 tmpvar_20;
  tmpvar_20 = (LIGHT_CAMERA_VIEW * tmpvar_18);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_11 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_10)
  )));
  xlv_TEXCOORD5 = tmpvar_1;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - tmpvar_14);
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = (tmpvar_15 * (tmpvar_19 / tmpvar_19.w)).xyz;
  xlv_TEXCOORD4 = (((
    -(tmpvar_20.z)
   / tmpvar_20.w) - LIGHT_CAMERA_LINEARPARAM.x) * LIGHT_CAMERA_LINEARPARAM.y);
}

]===],
		psShader = [===[uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D TEXTURE_DIFFUSE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp float expFactor_1;
  mediump vec3 vLight_2;
  mediump vec3 vNormal_3;
  highp vec3 diffuse_4;
  highp vec4 col_5;
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  col_5 = tmpvar_6;
  diffuse_4 = vec3(1.0, 1.0, 1.0);
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD5).xyz;
  vNormal_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(-(LIGHT_GIVEN_DIRECTION));
  vLight_2 = tmpvar_8;
  mediump float tmpvar_9;
  tmpvar_9 = clamp (dot (vLight_2, vNormal_3), 0.0, 1.0);
  highp float tmpvar_10;
  tmpvar_10 = exp((60.0 * (
    dot (texture2D (TEXTURE_SHADOW_DEPTH, xlv_TEXCOORD0), vec4(1.0, 0.00390625, 1.525879e-5, 5.960464e-8))
   - xlv_TEXCOORD4)));
  expFactor_1 = tmpvar_10;
  if ((tmpvar_10 > 1.0)) {
    expFactor_1 = 1.0;
  };
  diffuse_4 = (AMBIENT_COLOR + ((tmpvar_9 * LIGHT_COLOR) * expFactor_1));
  highp vec4 tmpvar_11;
  tmpvar_11.xyz = (diffuse_4 * col_5.xyz);
  tmpvar_11.w = col_5.w;
  gl_FragData[0] = tmpvar_11;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"NoLight"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec3 tmpvar_2;
  highp float tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = _glesVertex.xyz;
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_6;
  tmpvar_6[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_6[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_6[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_6 * _glesNormal));
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_5 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4)));
  xlv_TEXCOORD5 = tmpvar_1;
  xlv_TEXCOORD1 = vec3(0.0, 0.0, 1.0);
  xlv_TEXCOORD2 = vec3(0.0, 0.0, 1.0);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = tmpvar_3;
}

]===],
		psShader = [===[uniform highp vec3 LIGHT_COLOR;
uniform sampler2D TEXTURE_DIFFUSE;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 col_1;
  lowp vec4 tmpvar_2;
  tmpvar_2 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  col_1 = tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.xyz = (LIGHT_COLOR * col_1.xyz);
  tmpvar_3.w = col_1.w;
  gl_FragData[0] = tmpvar_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec3 tmpvar_3;
  highp vec3 tmpvar_4;
  highp float tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_8;
  tmpvar_8[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_8[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_8[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_8 * _glesNormal));
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = tmpvar_1.xyz;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD5 = tmpvar_2;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - (LOCALWORLD_TRANSFORM * tmpvar_9).xyz);
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D TEXTURE_DIFFUSE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
void main ()
{
  mediump vec3 vLight_1;
  mediump vec3 vNormal_2;
  highp vec4 col_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  col_3 = tmpvar_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD5).xyz;
  vNormal_2 = tmpvar_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(-(LIGHT_GIVEN_DIRECTION));
  vLight_1 = tmpvar_6;
  mediump float tmpvar_7;
  tmpvar_7 = clamp (dot (vLight_1, vNormal_2), 0.0, 1.0);
  highp vec4 tmpvar_8;
  tmpvar_8.xyz = ((AMBIENT_COLOR + (tmpvar_7 * LIGHT_COLOR)) * col_3.xyz);
  tmpvar_8.w = col_3.w;
  gl_FragData[0] = tmpvar_8;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALSCREEN_TRANSVIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "CAMERA_RESOLUTION",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_HALF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec3 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_6;
  tmpvar_6[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_6[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_6[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_6 * _glesNormal));
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  tmpvar_7 = (LOCALWORLD_TRANSFORM * tmpvar_8);
  highp mat4 tmpvar_9;
  tmpvar_9[0].x = 0.5;
  tmpvar_9[0].y = 0.0;
  tmpvar_9[0].z = 0.0;
  tmpvar_9[0].w = 0.5;
  tmpvar_9[1].x = 0.0;
  tmpvar_9[1].y = 0.5;
  tmpvar_9[1].z = 0.0;
  tmpvar_9[1].w = 0.5;
  tmpvar_9[2].x = 0.0;
  tmpvar_9[2].y = 0.0;
  tmpvar_9[2].z = 0.5;
  tmpvar_9[2].w = 0.5;
  tmpvar_9[3].x = 0.0;
  tmpvar_9[3].y = 0.0;
  tmpvar_9[3].z = 0.0;
  tmpvar_9[3].w = 1.0;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 0.0;
  tmpvar_10.xyz = tmpvar_7.xyz;
  highp vec4 tmpvar_11;
  tmpvar_11.w = 0.0;
  tmpvar_11.xyz = (0.005 * tmpvar_2.xyz);
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_10 - tmpvar_11);
  highp vec4 tmpvar_13;
  tmpvar_13 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * tmpvar_12));
  highp vec4 tmpvar_14;
  tmpvar_14 = (LIGHT_CAMERA_VIEW * tmpvar_12);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_5 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4)));
  xlv_TEXCOORD5 = tmpvar_2;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - tmpvar_7.xyz);
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = (tmpvar_9 * (tmpvar_13 / tmpvar_13.w)).xyz;
  xlv_TEXCOORD4 = (((
    -(tmpvar_14.z)
   / tmpvar_14.w) - LIGHT_CAMERA_LINEARPARAM.x) * LIGHT_CAMERA_LINEARPARAM.y);
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : require

#line 20
struct LightInput {
    highp vec3 lightColor;
    highp vec3 viewDir;
    highp vec3 lightDir;
    highp vec3 normalDir;
    highp float atten;
    highp vec3 emission;
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
};
#line 9
struct SurfaceInput {
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
    highp vec3 emission;
    highp vec3 worldNormal;
    highp vec3 worldPos;
    highp float atten;
};
#line 29
struct v2f {
    highp vec2 uv;
    highp vec4 vertex;
    highp vec4 worldnormal;
    highp vec3 viewDirection;
    highp vec3 lightDirection;
    highp vec3 LightCoord;
    highp float OrigDepth;
};
#line 21
struct appdata {
    highp vec4 vertex;
    highp vec2 uv;
    highp vec3 normal;
};
#line 5
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
#line 9
uniform highp mat4 CAMERA_PROJECTION;
uniform highp mat4 LOCALSCREEN_TRANSVIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
#line 13
uniform highp vec3 LIGHT_POSITION;
uniform highp vec3 WORLD_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
#line 17
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
#line 21
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp vec2 CAMERA_RESOLUTION;
#line 25
uniform highp vec2 CAMERA_RESOLUTION_INV;
uniform highp vec2 CAMERA_RESOLUTION_HALF_INV;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform sampler2D TEXTURE_GRAP;
#line 32
uniform highp float DEVICE_COORDINATE_Y_FLIP;
#line 86
#line 92
#line 97
#line 102
#line 107
#line 112
#line 117
#line 124
#line 129
#line 144
#line 8
#line 18
#line 27
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
#line 35
#line 40
#line 58
#line 79
#line 95
#line 118
#line 154
#line 196
#line 245
#line 289
#line 33
#line 70
#line 41
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
#line 84
highp vec4 frag( in v2f i ) {
    #line 87
    highp vec4 col = texture2D( TEXTURE_DIFFUSE, i.uv);
    highp vec3 diffuse = vec3( 1.0, 1.0, 1.0);
    #line 91
    highp vec4 depthColor = shadow2D( TEXTURE_SHADOW_DEPTH, vec3( i.uv, 0.0));
    const highp vec4 bitShifts = vec4( 1.0, 0.00390625, 1.525879e-5, 5.960464e-8);
    #line 96
    highp float TexDepth = dot( depthColor, bitShifts);
    const mediump float constant = 60.0;
    #line 100
    mediump vec3 vNormal = vec3( normalize(i.worldnormal));
    mediump vec3 vLight = normalize((-LIGHT_GIVEN_DIRECTION));
    mediump vec3 vView = normalize(i.viewDirection);
    mediump vec3 vHalf = normalize((vLight + vView));
    #line 104
    mediump float dotLightNormal = dot( vLight, vNormal);
    mediump float fDiffuse = clamp( dotLightNormal, 0.0, 1.0);
    #line 108
    highp float expFactor = exp((60.0 * (TexDepth - i.OrigDepth)));
    if ((expFactor > 1.0)){
        expFactor = 1.0;
    }
    #line 114
    diffuse = (AMBIENT_COLOR + ((fDiffuse * LIGHT_COLOR) * expFactor));
    #line 188
    return vec4( (diffuse * col.xyz), col.w);
}
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main() {
    highp vec4 xl_retval;
    v2f xlt_i;
    xlt_i.uv = vec2(xlv_TEXCOORD0);
    xlt_i.vertex = vec4(0.0);
    xlt_i.worldnormal = vec4(xlv_TEXCOORD5);
    xlt_i.viewDirection = vec3(xlv_TEXCOORD1);
    xlt_i.lightDirection = vec3(xlv_TEXCOORD2);
    xlt_i.LightCoord = vec3(xlv_TEXCOORD3);
    xlt_i.OrigDepth = float(xlv_TEXCOORD4);
    xl_retval = frag( xlt_i);
    gl_FragData[0] = vec4(xl_retval);
}
/* NOTE: GLSL optimization failed
(92,26): error: no matching function for call to `shadow2D(sampler2DShadow, vec3)'; candidates are:
*/
]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALSCREEN_TRANSVIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "CAMERA_RESOLUTION",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_HALF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec3 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_6;
  tmpvar_6[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_6[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_6[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_6 * _glesNormal));
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  tmpvar_7 = (LOCALWORLD_TRANSFORM * tmpvar_8);
  highp mat4 tmpvar_9;
  tmpvar_9[0].x = 0.5;
  tmpvar_9[0].y = 0.0;
  tmpvar_9[0].z = 0.0;
  tmpvar_9[0].w = 0.5;
  tmpvar_9[1].x = 0.0;
  tmpvar_9[1].y = 0.5;
  tmpvar_9[1].z = 0.0;
  tmpvar_9[1].w = 0.5;
  tmpvar_9[2].x = 0.0;
  tmpvar_9[2].y = 0.0;
  tmpvar_9[2].z = 0.5;
  tmpvar_9[2].w = 0.5;
  tmpvar_9[3].x = 0.0;
  tmpvar_9[3].y = 0.0;
  tmpvar_9[3].z = 0.0;
  tmpvar_9[3].w = 1.0;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 0.0;
  tmpvar_10.xyz = tmpvar_7.xyz;
  highp vec4 tmpvar_11;
  tmpvar_11.w = 0.0;
  tmpvar_11.xyz = (0.005 * tmpvar_2.xyz);
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_10 - tmpvar_11);
  highp vec4 tmpvar_13;
  tmpvar_13 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * tmpvar_12));
  highp vec4 tmpvar_14;
  tmpvar_14 = (LIGHT_CAMERA_VIEW * tmpvar_12);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_5 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4)));
  xlv_TEXCOORD5 = tmpvar_2;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - tmpvar_7.xyz);
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = (tmpvar_9 * (tmpvar_13 / tmpvar_13.w)).xyz;
  xlv_TEXCOORD4 = (((
    -(tmpvar_14.z)
   / tmpvar_14.w) - LIGHT_CAMERA_LINEARPARAM.x) * LIGHT_CAMERA_LINEARPARAM.y);
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : require

#line 20
struct LightInput {
    highp vec3 lightColor;
    highp vec3 viewDir;
    highp vec3 lightDir;
    highp vec3 normalDir;
    highp float atten;
    highp vec3 emission;
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
};
#line 9
struct SurfaceInput {
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
    highp vec3 emission;
    highp vec3 worldNormal;
    highp vec3 worldPos;
    highp float atten;
};
#line 29
struct v2f {
    highp vec2 uv;
    highp vec4 vertex;
    highp vec4 worldnormal;
    highp vec3 viewDirection;
    highp vec3 lightDirection;
    highp vec3 LightCoord;
    highp float OrigDepth;
};
#line 21
struct appdata {
    highp vec4 vertex;
    highp vec2 uv;
    highp vec3 normal;
};
#line 5
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
#line 9
uniform highp mat4 CAMERA_PROJECTION;
uniform highp mat4 LOCALSCREEN_TRANSVIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
#line 13
uniform highp vec3 LIGHT_POSITION;
uniform highp vec3 WORLD_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
#line 17
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
#line 21
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp vec2 CAMERA_RESOLUTION;
#line 25
uniform highp vec2 CAMERA_RESOLUTION_INV;
uniform highp vec2 CAMERA_RESOLUTION_HALF_INV;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform sampler2D TEXTURE_GRAP;
#line 32
uniform highp float DEVICE_COORDINATE_Y_FLIP;
#line 86
#line 92
#line 97
#line 102
#line 107
#line 112
#line 117
#line 124
#line 129
#line 144
#line 8
#line 18
#line 27
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
#line 35
#line 40
#line 58
#line 79
#line 95
#line 118
#line 154
#line 196
#line 245
#line 289
#line 33
#line 70
#line 41
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
#line 84
highp vec4 frag( in v2f i ) {
    #line 87
    highp vec4 col = texture2D( TEXTURE_DIFFUSE, i.uv);
    highp vec3 diffuse = vec3( 1.0, 1.0, 1.0);
    #line 91
    highp vec4 depthColor = shadow2D( TEXTURE_SHADOW_DEPTH, vec3( i.uv, 0.0));
    const highp vec4 bitShifts = vec4( 1.0, 0.00390625, 1.525879e-5, 5.960464e-8);
    #line 96
    highp float TexDepth = dot( depthColor, bitShifts);
    const mediump float constant = 60.0;
    #line 100
    mediump vec3 vNormal = vec3( normalize(i.worldnormal));
    mediump vec3 vLight = normalize((-LIGHT_GIVEN_DIRECTION));
    mediump vec3 vView = normalize(i.viewDirection);
    mediump vec3 vHalf = normalize((vLight + vView));
    #line 104
    mediump float dotLightNormal = dot( vLight, vNormal);
    mediump float fDiffuse = clamp( dotLightNormal, 0.0, 1.0);
    #line 108
    highp float expFactor = exp((60.0 * (TexDepth - i.OrigDepth)));
    if ((expFactor > 1.0)){
        expFactor = 1.0;
    }
    #line 114
    diffuse = (AMBIENT_COLOR + ((fDiffuse * LIGHT_COLOR) * expFactor));
    #line 188
    return vec4( (diffuse * col.xyz), col.w);
}
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main() {
    highp vec4 xl_retval;
    v2f xlt_i;
    xlt_i.uv = vec2(xlv_TEXCOORD0);
    xlt_i.vertex = vec4(0.0);
    xlt_i.worldnormal = vec4(xlv_TEXCOORD5);
    xlt_i.viewDirection = vec3(xlv_TEXCOORD1);
    xlt_i.lightDirection = vec3(xlv_TEXCOORD2);
    xlt_i.LightCoord = vec3(xlv_TEXCOORD3);
    xlt_i.OrigDepth = float(xlv_TEXCOORD4);
    xl_retval = frag( xlt_i);
    gl_FragData[0] = vec4(xl_retval);
}
/* NOTE: GLSL optimization failed
(92,26): error: no matching function for call to `shadow2D(sampler2DShadow, vec3)'; candidates are:
*/
]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALSCREEN_TRANSVIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "CAMERA_RESOLUTION",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_HALF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec3 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_6;
  tmpvar_6[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_6[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_6[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_6 * _glesNormal));
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  tmpvar_7 = (LOCALWORLD_TRANSFORM * tmpvar_8);
  highp mat4 tmpvar_9;
  tmpvar_9[0].x = 0.5;
  tmpvar_9[0].y = 0.0;
  tmpvar_9[0].z = 0.0;
  tmpvar_9[0].w = 0.5;
  tmpvar_9[1].x = 0.0;
  tmpvar_9[1].y = 0.5;
  tmpvar_9[1].z = 0.0;
  tmpvar_9[1].w = 0.5;
  tmpvar_9[2].x = 0.0;
  tmpvar_9[2].y = 0.0;
  tmpvar_9[2].z = 0.5;
  tmpvar_9[2].w = 0.5;
  tmpvar_9[3].x = 0.0;
  tmpvar_9[3].y = 0.0;
  tmpvar_9[3].z = 0.0;
  tmpvar_9[3].w = 1.0;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 0.0;
  tmpvar_10.xyz = tmpvar_7.xyz;
  highp vec4 tmpvar_11;
  tmpvar_11.w = 0.0;
  tmpvar_11.xyz = (0.005 * tmpvar_2.xyz);
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_10 - tmpvar_11);
  highp vec4 tmpvar_13;
  tmpvar_13 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * tmpvar_12));
  highp vec4 tmpvar_14;
  tmpvar_14 = (LIGHT_CAMERA_VIEW * tmpvar_12);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_5 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4)));
  xlv_TEXCOORD5 = tmpvar_2;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - tmpvar_7.xyz);
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = (tmpvar_9 * (tmpvar_13 / tmpvar_13.w)).xyz;
  xlv_TEXCOORD4 = (((
    -(tmpvar_14.z)
   / tmpvar_14.w) - LIGHT_CAMERA_LINEARPARAM.x) * LIGHT_CAMERA_LINEARPARAM.y);
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : require

#line 20
struct LightInput {
    highp vec3 lightColor;
    highp vec3 viewDir;
    highp vec3 lightDir;
    highp vec3 normalDir;
    highp float atten;
    highp vec3 emission;
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
};
#line 9
struct SurfaceInput {
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
    highp vec3 emission;
    highp vec3 worldNormal;
    highp vec3 worldPos;
    highp float atten;
};
#line 29
struct v2f {
    highp vec2 uv;
    highp vec4 vertex;
    highp vec4 worldnormal;
    highp vec3 viewDirection;
    highp vec3 lightDirection;
    highp vec3 LightCoord;
    highp float OrigDepth;
};
#line 21
struct appdata {
    highp vec4 vertex;
    highp vec2 uv;
    highp vec3 normal;
};
#line 5
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
#line 9
uniform highp mat4 CAMERA_PROJECTION;
uniform highp mat4 LOCALSCREEN_TRANSVIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
#line 13
uniform highp vec3 LIGHT_POSITION;
uniform highp vec3 WORLD_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
#line 17
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
#line 21
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp vec2 CAMERA_RESOLUTION;
#line 25
uniform highp vec2 CAMERA_RESOLUTION_INV;
uniform highp vec2 CAMERA_RESOLUTION_HALF_INV;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform sampler2D TEXTURE_GRAP;
#line 32
uniform highp float DEVICE_COORDINATE_Y_FLIP;
#line 86
#line 92
#line 97
#line 102
#line 107
#line 112
#line 117
#line 124
#line 129
#line 144
#line 8
#line 18
#line 27
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
#line 35
#line 40
#line 58
#line 79
#line 95
#line 118
#line 154
#line 196
#line 245
#line 289
#line 33
#line 70
#line 41
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
#line 84
highp vec4 frag( in v2f i ) {
    #line 87
    highp vec4 col = texture2D( TEXTURE_DIFFUSE, i.uv);
    highp vec3 diffuse = vec3( 1.0, 1.0, 1.0);
    #line 91
    highp vec4 depthColor = shadow2D( TEXTURE_SHADOW_DEPTH, vec3( i.uv, 0.0));
    const highp vec4 bitShifts = vec4( 1.0, 0.00390625, 1.525879e-5, 5.960464e-8);
    #line 96
    highp float TexDepth = dot( depthColor, bitShifts);
    const mediump float constant = 60.0;
    #line 100
    mediump vec3 vNormal = vec3( normalize(i.worldnormal));
    mediump vec3 vLight = normalize((-LIGHT_GIVEN_DIRECTION));
    mediump vec3 vView = normalize(i.viewDirection);
    mediump vec3 vHalf = normalize((vLight + vView));
    #line 104
    mediump float dotLightNormal = dot( vLight, vNormal);
    mediump float fDiffuse = clamp( dotLightNormal, 0.0, 1.0);
    #line 108
    highp float expFactor = exp((60.0 * (TexDepth - i.OrigDepth)));
    if ((expFactor > 1.0)){
        expFactor = 1.0;
    }
    #line 114
    diffuse = (AMBIENT_COLOR + ((fDiffuse * LIGHT_COLOR) * expFactor));
    #line 188
    return vec4( (diffuse * col.xyz), col.w);
}
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main() {
    highp vec4 xl_retval;
    v2f xlt_i;
    xlt_i.uv = vec2(xlv_TEXCOORD0);
    xlt_i.vertex = vec4(0.0);
    xlt_i.worldnormal = vec4(xlv_TEXCOORD5);
    xlt_i.viewDirection = vec3(xlv_TEXCOORD1);
    xlt_i.lightDirection = vec3(xlv_TEXCOORD2);
    xlt_i.LightCoord = vec3(xlv_TEXCOORD3);
    xlt_i.OrigDepth = float(xlv_TEXCOORD4);
    xl_retval = frag( xlt_i);
    gl_FragData[0] = vec4(xl_retval);
}
/* NOTE: GLSL optimization failed
(92,26): error: no matching function for call to `shadow2D(sampler2DShadow, vec3)'; candidates are:
*/
]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec3 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_6;
  tmpvar_6[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_6[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_6[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_6 * _glesNormal));
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  tmpvar_7 = (LOCALWORLD_TRANSFORM * tmpvar_8);
  highp mat4 tmpvar_9;
  tmpvar_9[0].x = 0.5;
  tmpvar_9[0].y = 0.0;
  tmpvar_9[0].z = 0.0;
  tmpvar_9[0].w = 0.5;
  tmpvar_9[1].x = 0.0;
  tmpvar_9[1].y = 0.5;
  tmpvar_9[1].z = 0.0;
  tmpvar_9[1].w = 0.5;
  tmpvar_9[2].x = 0.0;
  tmpvar_9[2].y = 0.0;
  tmpvar_9[2].z = 0.5;
  tmpvar_9[2].w = 0.5;
  tmpvar_9[3].x = 0.0;
  tmpvar_9[3].y = 0.0;
  tmpvar_9[3].z = 0.0;
  tmpvar_9[3].w = 1.0;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 0.0;
  tmpvar_10.xyz = tmpvar_7.xyz;
  highp vec4 tmpvar_11;
  tmpvar_11.w = 0.0;
  tmpvar_11.xyz = (0.005 * tmpvar_2.xyz);
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_10 - tmpvar_11);
  highp vec4 tmpvar_13;
  tmpvar_13 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * tmpvar_12));
  highp vec4 tmpvar_14;
  tmpvar_14 = (LIGHT_CAMERA_VIEW * tmpvar_12);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_5 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4)));
  xlv_TEXCOORD5 = tmpvar_2;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - tmpvar_7.xyz);
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = (tmpvar_9 * (tmpvar_13 / tmpvar_13.w)).xyz;
  xlv_TEXCOORD4 = (((
    -(tmpvar_14.z)
   / tmpvar_14.w) - LIGHT_CAMERA_LINEARPARAM.x) * LIGHT_CAMERA_LINEARPARAM.y);
}

]===],
		psShader = [===[uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D TEXTURE_DIFFUSE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp float expFactor_1;
  mediump vec3 vLight_2;
  mediump vec3 vNormal_3;
  highp vec3 diffuse_4;
  highp vec4 col_5;
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  col_5 = tmpvar_6;
  diffuse_4 = vec3(1.0, 1.0, 1.0);
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD5).xyz;
  vNormal_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(-(LIGHT_GIVEN_DIRECTION));
  vLight_2 = tmpvar_8;
  mediump float tmpvar_9;
  tmpvar_9 = clamp (dot (vLight_2, vNormal_3), 0.0, 1.0);
  highp float tmpvar_10;
  tmpvar_10 = exp((60.0 * (
    dot (texture2D (TEXTURE_SHADOW_DEPTH, xlv_TEXCOORD0), vec4(1.0, 0.00390625, 1.525879e-5, 5.960464e-8))
   - xlv_TEXCOORD4)));
  expFactor_1 = tmpvar_10;
  if ((tmpvar_10 > 1.0)) {
    expFactor_1 = 1.0;
  };
  diffuse_4 = (AMBIENT_COLOR + ((tmpvar_9 * LIGHT_COLOR) * expFactor_1));
  highp vec4 tmpvar_11;
  tmpvar_11.xyz = (diffuse_4 * col_5.xyz);
  tmpvar_11.w = col_5.w;
  gl_FragData[0] = tmpvar_11;
}

]===],
	},
}

end

function ForwardAdd()

	COLOR_MASK = COLOR_RGBA
	ALPAH_MODE = { ALPAH_BLEND, ONE, ONE, ONE, ONE }
	DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LEQUAL }
	STENCIL_MODE = { STENCIL_OFF }
	LIGHT_MODE = { FORWARDADD }

	
Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec3 tmpvar_2;
  highp vec3 tmpvar_3;
  highp float tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = tmpvar_12[0].xyz;
  tmpvar_15[1] = tmpvar_12[1].xyz;
  tmpvar_15[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD5 = tmpvar_1;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz);
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D TEXTURE_DIFFUSE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
void main ()
{
  mediump vec3 vLight_1;
  mediump vec3 vNormal_2;
  highp vec4 col_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  col_3 = tmpvar_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD5).xyz;
  vNormal_2 = tmpvar_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(-(LIGHT_GIVEN_DIRECTION));
  vLight_1 = tmpvar_6;
  mediump float tmpvar_7;
  tmpvar_7 = clamp (dot (vLight_1, vNormal_2), 0.0, 1.0);
  highp vec4 tmpvar_8;
  tmpvar_8.xyz = ((AMBIENT_COLOR + (tmpvar_7 * LIGHT_COLOR)) * col_3.xyz);
  tmpvar_8.w = col_3.w;
  gl_FragData[0] = tmpvar_8;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALSCREEN_TRANSVIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "CAMERA_RESOLUTION",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_HALF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec3 tmpvar_2;
  highp vec4 row2_3;
  highp vec4 row1_4;
  highp vec4 row0_5;
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.w) * 3);
  row0_5 = (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.x);
  row1_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.x);
  row2_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.x);
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.y));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.y));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.y));
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.z));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.z));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.z));
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.w));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.w));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = row0_5.x;
  tmpvar_10[0].y = row0_5.y;
  tmpvar_10[0].z = row0_5.z;
  tmpvar_10[0].w = row0_5.w;
  tmpvar_10[1].x = row1_4.x;
  tmpvar_10[1].y = row1_4.y;
  tmpvar_10[1].z = row1_4.z;
  tmpvar_10[1].w = row1_4.w;
  tmpvar_10[2].x = row2_3.x;
  tmpvar_10[2].y = row2_3.y;
  tmpvar_10[2].z = row2_3.z;
  tmpvar_10[2].w = row2_3.w;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_11.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_13;
  tmpvar_13[0] = tmpvar_10[0].xyz;
  tmpvar_13[1] = tmpvar_10[1].xyz;
  tmpvar_13[2] = tmpvar_10[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_12 * (_glesNormal * tmpvar_13)));
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_10)).xyz;
  highp mat4 tmpvar_15;
  tmpvar_15[0].x = 0.5;
  tmpvar_15[0].y = 0.0;
  tmpvar_15[0].z = 0.0;
  tmpvar_15[0].w = 0.5;
  tmpvar_15[1].x = 0.0;
  tmpvar_15[1].y = 0.5;
  tmpvar_15[1].z = 0.0;
  tmpvar_15[1].w = 0.5;
  tmpvar_15[2].x = 0.0;
  tmpvar_15[2].y = 0.0;
  tmpvar_15[2].z = 0.5;
  tmpvar_15[2].w = 0.5;
  tmpvar_15[3].x = 0.0;
  tmpvar_15[3].y = 0.0;
  tmpvar_15[3].z = 0.0;
  tmpvar_15[3].w = 1.0;
  highp vec4 tmpvar_16;
  tmpvar_16.w = 0.0;
  tmpvar_16.xyz = tmpvar_14;
  highp vec4 tmpvar_17;
  tmpvar_17.w = 0.0;
  tmpvar_17.xyz = (0.005 * tmpvar_1.xyz);
  highp vec4 tmpvar_18;
  tmpvar_18 = (tmpvar_16 - tmpvar_17);
  highp vec4 tmpvar_19;
  tmpvar_19 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * tmpvar_18));
  highp vec4 tmpvar_20;
  tmpvar_20 = (LIGHT_CAMERA_VIEW * tmpvar_18);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_11 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_10)
  )));
  xlv_TEXCOORD5 = tmpvar_1;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - tmpvar_14);
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = (tmpvar_15 * (tmpvar_19 / tmpvar_19.w)).xyz;
  xlv_TEXCOORD4 = (((
    -(tmpvar_20.z)
   / tmpvar_20.w) - LIGHT_CAMERA_LINEARPARAM.x) * LIGHT_CAMERA_LINEARPARAM.y);
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : require

#line 20
struct LightInput {
    highp vec3 lightColor;
    highp vec3 viewDir;
    highp vec3 lightDir;
    highp vec3 normalDir;
    highp float atten;
    highp vec3 emission;
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
};
#line 9
struct SurfaceInput {
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
    highp vec3 emission;
    highp vec3 worldNormal;
    highp vec3 worldPos;
    highp float atten;
};
#line 32
struct v2f {
    highp vec2 uv;
    highp vec4 vertex;
    highp vec4 worldnormal;
    highp vec3 viewDirection;
    highp vec3 lightDirection;
    highp vec3 LightCoord;
    highp float OrigDepth;
};
#line 24
struct appdata {
    highp vec4 vertex;
    highp vec2 uv;
    highp vec3 normal;
    highp vec4 boneIndices;
    highp vec4 boneWeight;
};
#line 5
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
#line 9
uniform highp mat4 CAMERA_PROJECTION;
uniform highp mat4 LOCALSCREEN_TRANSVIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
#line 13
uniform highp vec3 LIGHT_POSITION;
uniform highp vec3 WORLD_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
#line 17
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
#line 21
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp vec2 CAMERA_RESOLUTION;
#line 25
uniform highp vec2 CAMERA_RESOLUTION_INV;
uniform highp vec2 CAMERA_RESOLUTION_HALF_INV;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform sampler2D TEXTURE_GRAP;
#line 32
uniform highp float DEVICE_COORDINATE_Y_FLIP;
#line 124
#line 129
#line 144
#line 8
#line 18
#line 27
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
#line 35
#line 40
#line 58
#line 79
#line 95
#line 118
#line 154
#line 196
#line 245
#line 289
#line 33
#line 70
#line 44
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
#line 87
highp vec4 frag( in v2f i ) {
    #line 90
    highp vec4 col = texture2D( TEXTURE_DIFFUSE, i.uv);
    highp vec3 diffuse = vec3( 1.0, 1.0, 1.0);
    #line 94
    highp vec4 depthColor = shadow2D( TEXTURE_SHADOW_DEPTH, vec3( i.uv, 0.0));
    const highp vec4 bitShifts = vec4( 1.0, 0.00390625, 1.525879e-5, 5.960464e-8);
    #line 99
    highp float TexDepth = dot( depthColor, bitShifts);
    const mediump float constant = 60.0;
    #line 103
    mediump vec3 vNormal = vec3( normalize(i.worldnormal));
    mediump vec3 vLight = normalize((-LIGHT_GIVEN_DIRECTION));
    mediump vec3 vView = normalize(i.viewDirection);
    mediump vec3 vHalf = normalize((vLight + vView));
    #line 107
    mediump float dotLightNormal = dot( vLight, vNormal);
    mediump float fDiffuse = clamp( dotLightNormal, 0.0, 1.0);
    #line 111
    highp float expFactor = exp((60.0 * (TexDepth - i.OrigDepth)));
    if ((expFactor > 1.0)){
        expFactor = 1.0;
    }
    #line 117
    diffuse = (AMBIENT_COLOR + ((fDiffuse * LIGHT_COLOR) * expFactor));
    #line 191
    return vec4( (diffuse * col.xyz), col.w);
}
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main() {
    highp vec4 xl_retval;
    v2f xlt_i;
    xlt_i.uv = vec2(xlv_TEXCOORD0);
    xlt_i.vertex = vec4(0.0);
    xlt_i.worldnormal = vec4(xlv_TEXCOORD5);
    xlt_i.viewDirection = vec3(xlv_TEXCOORD1);
    xlt_i.lightDirection = vec3(xlv_TEXCOORD2);
    xlt_i.LightCoord = vec3(xlv_TEXCOORD3);
    xlt_i.OrigDepth = float(xlv_TEXCOORD4);
    xl_retval = frag( xlt_i);
    gl_FragData[0] = vec4(xl_retval);
}
/* NOTE: GLSL optimization failed
(95,26): error: no matching function for call to `shadow2D(sampler2DShadow, vec3)'; candidates are:
*/
]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALSCREEN_TRANSVIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "CAMERA_RESOLUTION",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_HALF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec3 tmpvar_2;
  highp vec4 row2_3;
  highp vec4 row1_4;
  highp vec4 row0_5;
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.w) * 3);
  row0_5 = (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.x);
  row1_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.x);
  row2_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.x);
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.y));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.y));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.y));
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.z));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.z));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.z));
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.w));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.w));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = row0_5.x;
  tmpvar_10[0].y = row0_5.y;
  tmpvar_10[0].z = row0_5.z;
  tmpvar_10[0].w = row0_5.w;
  tmpvar_10[1].x = row1_4.x;
  tmpvar_10[1].y = row1_4.y;
  tmpvar_10[1].z = row1_4.z;
  tmpvar_10[1].w = row1_4.w;
  tmpvar_10[2].x = row2_3.x;
  tmpvar_10[2].y = row2_3.y;
  tmpvar_10[2].z = row2_3.z;
  tmpvar_10[2].w = row2_3.w;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_11.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_13;
  tmpvar_13[0] = tmpvar_10[0].xyz;
  tmpvar_13[1] = tmpvar_10[1].xyz;
  tmpvar_13[2] = tmpvar_10[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_12 * (_glesNormal * tmpvar_13)));
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_10)).xyz;
  highp mat4 tmpvar_15;
  tmpvar_15[0].x = 0.5;
  tmpvar_15[0].y = 0.0;
  tmpvar_15[0].z = 0.0;
  tmpvar_15[0].w = 0.5;
  tmpvar_15[1].x = 0.0;
  tmpvar_15[1].y = 0.5;
  tmpvar_15[1].z = 0.0;
  tmpvar_15[1].w = 0.5;
  tmpvar_15[2].x = 0.0;
  tmpvar_15[2].y = 0.0;
  tmpvar_15[2].z = 0.5;
  tmpvar_15[2].w = 0.5;
  tmpvar_15[3].x = 0.0;
  tmpvar_15[3].y = 0.0;
  tmpvar_15[3].z = 0.0;
  tmpvar_15[3].w = 1.0;
  highp vec4 tmpvar_16;
  tmpvar_16.w = 0.0;
  tmpvar_16.xyz = tmpvar_14;
  highp vec4 tmpvar_17;
  tmpvar_17.w = 0.0;
  tmpvar_17.xyz = (0.005 * tmpvar_1.xyz);
  highp vec4 tmpvar_18;
  tmpvar_18 = (tmpvar_16 - tmpvar_17);
  highp vec4 tmpvar_19;
  tmpvar_19 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * tmpvar_18));
  highp vec4 tmpvar_20;
  tmpvar_20 = (LIGHT_CAMERA_VIEW * tmpvar_18);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_11 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_10)
  )));
  xlv_TEXCOORD5 = tmpvar_1;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - tmpvar_14);
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = (tmpvar_15 * (tmpvar_19 / tmpvar_19.w)).xyz;
  xlv_TEXCOORD4 = (((
    -(tmpvar_20.z)
   / tmpvar_20.w) - LIGHT_CAMERA_LINEARPARAM.x) * LIGHT_CAMERA_LINEARPARAM.y);
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : require

#line 20
struct LightInput {
    highp vec3 lightColor;
    highp vec3 viewDir;
    highp vec3 lightDir;
    highp vec3 normalDir;
    highp float atten;
    highp vec3 emission;
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
};
#line 9
struct SurfaceInput {
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
    highp vec3 emission;
    highp vec3 worldNormal;
    highp vec3 worldPos;
    highp float atten;
};
#line 32
struct v2f {
    highp vec2 uv;
    highp vec4 vertex;
    highp vec4 worldnormal;
    highp vec3 viewDirection;
    highp vec3 lightDirection;
    highp vec3 LightCoord;
    highp float OrigDepth;
};
#line 24
struct appdata {
    highp vec4 vertex;
    highp vec2 uv;
    highp vec3 normal;
    highp vec4 boneIndices;
    highp vec4 boneWeight;
};
#line 5
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
#line 9
uniform highp mat4 CAMERA_PROJECTION;
uniform highp mat4 LOCALSCREEN_TRANSVIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
#line 13
uniform highp vec3 LIGHT_POSITION;
uniform highp vec3 WORLD_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
#line 17
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
#line 21
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp vec2 CAMERA_RESOLUTION;
#line 25
uniform highp vec2 CAMERA_RESOLUTION_INV;
uniform highp vec2 CAMERA_RESOLUTION_HALF_INV;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform sampler2D TEXTURE_GRAP;
#line 32
uniform highp float DEVICE_COORDINATE_Y_FLIP;
#line 124
#line 129
#line 144
#line 8
#line 18
#line 27
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
#line 35
#line 40
#line 58
#line 79
#line 95
#line 118
#line 154
#line 196
#line 245
#line 289
#line 33
#line 70
#line 44
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
#line 87
highp vec4 frag( in v2f i ) {
    #line 90
    highp vec4 col = texture2D( TEXTURE_DIFFUSE, i.uv);
    highp vec3 diffuse = vec3( 1.0, 1.0, 1.0);
    #line 94
    highp vec4 depthColor = shadow2D( TEXTURE_SHADOW_DEPTH, vec3( i.uv, 0.0));
    const highp vec4 bitShifts = vec4( 1.0, 0.00390625, 1.525879e-5, 5.960464e-8);
    #line 99
    highp float TexDepth = dot( depthColor, bitShifts);
    const mediump float constant = 60.0;
    #line 103
    mediump vec3 vNormal = vec3( normalize(i.worldnormal));
    mediump vec3 vLight = normalize((-LIGHT_GIVEN_DIRECTION));
    mediump vec3 vView = normalize(i.viewDirection);
    mediump vec3 vHalf = normalize((vLight + vView));
    #line 107
    mediump float dotLightNormal = dot( vLight, vNormal);
    mediump float fDiffuse = clamp( dotLightNormal, 0.0, 1.0);
    #line 111
    highp float expFactor = exp((60.0 * (TexDepth - i.OrigDepth)));
    if ((expFactor > 1.0)){
        expFactor = 1.0;
    }
    #line 117
    diffuse = (AMBIENT_COLOR + ((fDiffuse * LIGHT_COLOR) * expFactor));
    #line 191
    return vec4( (diffuse * col.xyz), col.w);
}
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main() {
    highp vec4 xl_retval;
    v2f xlt_i;
    xlt_i.uv = vec2(xlv_TEXCOORD0);
    xlt_i.vertex = vec4(0.0);
    xlt_i.worldnormal = vec4(xlv_TEXCOORD5);
    xlt_i.viewDirection = vec3(xlv_TEXCOORD1);
    xlt_i.lightDirection = vec3(xlv_TEXCOORD2);
    xlt_i.LightCoord = vec3(xlv_TEXCOORD3);
    xlt_i.OrigDepth = float(xlv_TEXCOORD4);
    xl_retval = frag( xlt_i);
    gl_FragData[0] = vec4(xl_retval);
}
/* NOTE: GLSL optimization failed
(95,26): error: no matching function for call to `shadow2D(sampler2DShadow, vec3)'; candidates are:
*/
]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALSCREEN_TRANSVIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "CAMERA_RESOLUTION",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_HALF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec3 tmpvar_2;
  highp vec4 row2_3;
  highp vec4 row1_4;
  highp vec4 row0_5;
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.w) * 3);
  row0_5 = (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.x);
  row1_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.x);
  row2_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.x);
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.y));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.y));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.y));
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.z));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.z));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.z));
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.w));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.w));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = row0_5.x;
  tmpvar_10[0].y = row0_5.y;
  tmpvar_10[0].z = row0_5.z;
  tmpvar_10[0].w = row0_5.w;
  tmpvar_10[1].x = row1_4.x;
  tmpvar_10[1].y = row1_4.y;
  tmpvar_10[1].z = row1_4.z;
  tmpvar_10[1].w = row1_4.w;
  tmpvar_10[2].x = row2_3.x;
  tmpvar_10[2].y = row2_3.y;
  tmpvar_10[2].z = row2_3.z;
  tmpvar_10[2].w = row2_3.w;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_11.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_13;
  tmpvar_13[0] = tmpvar_10[0].xyz;
  tmpvar_13[1] = tmpvar_10[1].xyz;
  tmpvar_13[2] = tmpvar_10[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_12 * (_glesNormal * tmpvar_13)));
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_10)).xyz;
  highp mat4 tmpvar_15;
  tmpvar_15[0].x = 0.5;
  tmpvar_15[0].y = 0.0;
  tmpvar_15[0].z = 0.0;
  tmpvar_15[0].w = 0.5;
  tmpvar_15[1].x = 0.0;
  tmpvar_15[1].y = 0.5;
  tmpvar_15[1].z = 0.0;
  tmpvar_15[1].w = 0.5;
  tmpvar_15[2].x = 0.0;
  tmpvar_15[2].y = 0.0;
  tmpvar_15[2].z = 0.5;
  tmpvar_15[2].w = 0.5;
  tmpvar_15[3].x = 0.0;
  tmpvar_15[3].y = 0.0;
  tmpvar_15[3].z = 0.0;
  tmpvar_15[3].w = 1.0;
  highp vec4 tmpvar_16;
  tmpvar_16.w = 0.0;
  tmpvar_16.xyz = tmpvar_14;
  highp vec4 tmpvar_17;
  tmpvar_17.w = 0.0;
  tmpvar_17.xyz = (0.005 * tmpvar_1.xyz);
  highp vec4 tmpvar_18;
  tmpvar_18 = (tmpvar_16 - tmpvar_17);
  highp vec4 tmpvar_19;
  tmpvar_19 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * tmpvar_18));
  highp vec4 tmpvar_20;
  tmpvar_20 = (LIGHT_CAMERA_VIEW * tmpvar_18);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_11 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_10)
  )));
  xlv_TEXCOORD5 = tmpvar_1;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - tmpvar_14);
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = (tmpvar_15 * (tmpvar_19 / tmpvar_19.w)).xyz;
  xlv_TEXCOORD4 = (((
    -(tmpvar_20.z)
   / tmpvar_20.w) - LIGHT_CAMERA_LINEARPARAM.x) * LIGHT_CAMERA_LINEARPARAM.y);
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : require

#line 20
struct LightInput {
    highp vec3 lightColor;
    highp vec3 viewDir;
    highp vec3 lightDir;
    highp vec3 normalDir;
    highp float atten;
    highp vec3 emission;
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
};
#line 9
struct SurfaceInput {
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
    highp vec3 emission;
    highp vec3 worldNormal;
    highp vec3 worldPos;
    highp float atten;
};
#line 32
struct v2f {
    highp vec2 uv;
    highp vec4 vertex;
    highp vec4 worldnormal;
    highp vec3 viewDirection;
    highp vec3 lightDirection;
    highp vec3 LightCoord;
    highp float OrigDepth;
};
#line 24
struct appdata {
    highp vec4 vertex;
    highp vec2 uv;
    highp vec3 normal;
    highp vec4 boneIndices;
    highp vec4 boneWeight;
};
#line 5
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
#line 9
uniform highp mat4 CAMERA_PROJECTION;
uniform highp mat4 LOCALSCREEN_TRANSVIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
#line 13
uniform highp vec3 LIGHT_POSITION;
uniform highp vec3 WORLD_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
#line 17
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
#line 21
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp vec2 CAMERA_RESOLUTION;
#line 25
uniform highp vec2 CAMERA_RESOLUTION_INV;
uniform highp vec2 CAMERA_RESOLUTION_HALF_INV;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform sampler2D TEXTURE_GRAP;
#line 32
uniform highp float DEVICE_COORDINATE_Y_FLIP;
#line 124
#line 129
#line 144
#line 8
#line 18
#line 27
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
#line 35
#line 40
#line 58
#line 79
#line 95
#line 118
#line 154
#line 196
#line 245
#line 289
#line 33
#line 70
#line 44
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
#line 87
highp vec4 frag( in v2f i ) {
    #line 90
    highp vec4 col = texture2D( TEXTURE_DIFFUSE, i.uv);
    highp vec3 diffuse = vec3( 1.0, 1.0, 1.0);
    #line 94
    highp vec4 depthColor = shadow2D( TEXTURE_SHADOW_DEPTH, vec3( i.uv, 0.0));
    const highp vec4 bitShifts = vec4( 1.0, 0.00390625, 1.525879e-5, 5.960464e-8);
    #line 99
    highp float TexDepth = dot( depthColor, bitShifts);
    const mediump float constant = 60.0;
    #line 103
    mediump vec3 vNormal = vec3( normalize(i.worldnormal));
    mediump vec3 vLight = normalize((-LIGHT_GIVEN_DIRECTION));
    mediump vec3 vView = normalize(i.viewDirection);
    mediump vec3 vHalf = normalize((vLight + vView));
    #line 107
    mediump float dotLightNormal = dot( vLight, vNormal);
    mediump float fDiffuse = clamp( dotLightNormal, 0.0, 1.0);
    #line 111
    highp float expFactor = exp((60.0 * (TexDepth - i.OrigDepth)));
    if ((expFactor > 1.0)){
        expFactor = 1.0;
    }
    #line 117
    diffuse = (AMBIENT_COLOR + ((fDiffuse * LIGHT_COLOR) * expFactor));
    #line 191
    return vec4( (diffuse * col.xyz), col.w);
}
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main() {
    highp vec4 xl_retval;
    v2f xlt_i;
    xlt_i.uv = vec2(xlv_TEXCOORD0);
    xlt_i.vertex = vec4(0.0);
    xlt_i.worldnormal = vec4(xlv_TEXCOORD5);
    xlt_i.viewDirection = vec3(xlv_TEXCOORD1);
    xlt_i.lightDirection = vec3(xlv_TEXCOORD2);
    xlt_i.LightCoord = vec3(xlv_TEXCOORD3);
    xlt_i.OrigDepth = float(xlv_TEXCOORD4);
    xl_retval = frag( xlt_i);
    gl_FragData[0] = vec4(xl_retval);
}
/* NOTE: GLSL optimization failed
(95,26): error: no matching function for call to `shadow2D(sampler2DShadow, vec3)'; candidates are:
*/
]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec3 tmpvar_2;
  highp vec4 row2_3;
  highp vec4 row1_4;
  highp vec4 row0_5;
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.w) * 3);
  row0_5 = (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.x);
  row1_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.x);
  row2_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.x);
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.y));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.y));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.y));
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.z));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.z));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.z));
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.w));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.w));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = row0_5.x;
  tmpvar_10[0].y = row0_5.y;
  tmpvar_10[0].z = row0_5.z;
  tmpvar_10[0].w = row0_5.w;
  tmpvar_10[1].x = row1_4.x;
  tmpvar_10[1].y = row1_4.y;
  tmpvar_10[1].z = row1_4.z;
  tmpvar_10[1].w = row1_4.w;
  tmpvar_10[2].x = row2_3.x;
  tmpvar_10[2].y = row2_3.y;
  tmpvar_10[2].z = row2_3.z;
  tmpvar_10[2].w = row2_3.w;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_11.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_13;
  tmpvar_13[0] = tmpvar_10[0].xyz;
  tmpvar_13[1] = tmpvar_10[1].xyz;
  tmpvar_13[2] = tmpvar_10[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_12 * (_glesNormal * tmpvar_13)));
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_10)).xyz;
  highp mat4 tmpvar_15;
  tmpvar_15[0].x = 0.5;
  tmpvar_15[0].y = 0.0;
  tmpvar_15[0].z = 0.0;
  tmpvar_15[0].w = 0.5;
  tmpvar_15[1].x = 0.0;
  tmpvar_15[1].y = 0.5;
  tmpvar_15[1].z = 0.0;
  tmpvar_15[1].w = 0.5;
  tmpvar_15[2].x = 0.0;
  tmpvar_15[2].y = 0.0;
  tmpvar_15[2].z = 0.5;
  tmpvar_15[2].w = 0.5;
  tmpvar_15[3].x = 0.0;
  tmpvar_15[3].y = 0.0;
  tmpvar_15[3].z = 0.0;
  tmpvar_15[3].w = 1.0;
  highp vec4 tmpvar_16;
  tmpvar_16.w = 0.0;
  tmpvar_16.xyz = tmpvar_14;
  highp vec4 tmpvar_17;
  tmpvar_17.w = 0.0;
  tmpvar_17.xyz = (0.005 * tmpvar_1.xyz);
  highp vec4 tmpvar_18;
  tmpvar_18 = (tmpvar_16 - tmpvar_17);
  highp vec4 tmpvar_19;
  tmpvar_19 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * tmpvar_18));
  highp vec4 tmpvar_20;
  tmpvar_20 = (LIGHT_CAMERA_VIEW * tmpvar_18);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_11 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_10)
  )));
  xlv_TEXCOORD5 = tmpvar_1;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - tmpvar_14);
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = (tmpvar_15 * (tmpvar_19 / tmpvar_19.w)).xyz;
  xlv_TEXCOORD4 = (((
    -(tmpvar_20.z)
   / tmpvar_20.w) - LIGHT_CAMERA_LINEARPARAM.x) * LIGHT_CAMERA_LINEARPARAM.y);
}

]===],
		psShader = [===[uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D TEXTURE_DIFFUSE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp float expFactor_1;
  mediump vec3 vLight_2;
  mediump vec3 vNormal_3;
  highp vec3 diffuse_4;
  highp vec4 col_5;
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  col_5 = tmpvar_6;
  diffuse_4 = vec3(1.0, 1.0, 1.0);
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD5).xyz;
  vNormal_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(-(LIGHT_GIVEN_DIRECTION));
  vLight_2 = tmpvar_8;
  mediump float tmpvar_9;
  tmpvar_9 = clamp (dot (vLight_2, vNormal_3), 0.0, 1.0);
  highp float tmpvar_10;
  tmpvar_10 = exp((60.0 * (
    dot (texture2D (TEXTURE_SHADOW_DEPTH, xlv_TEXCOORD0), vec4(1.0, 0.00390625, 1.525879e-5, 5.960464e-8))
   - xlv_TEXCOORD4)));
  expFactor_1 = tmpvar_10;
  if ((tmpvar_10 > 1.0)) {
    expFactor_1 = 1.0;
  };
  diffuse_4 = (AMBIENT_COLOR + ((tmpvar_9 * LIGHT_COLOR) * expFactor_1));
  highp vec4 tmpvar_11;
  tmpvar_11.xyz = (diffuse_4 * col_5.xyz);
  tmpvar_11.w = col_5.w;
  gl_FragData[0] = tmpvar_11;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec3 tmpvar_2;
  highp float tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[0].x = row0_6.x;
  tmpvar_11[0].y = row0_6.y;
  tmpvar_11[0].z = row0_6.z;
  tmpvar_11[0].w = row0_6.w;
  tmpvar_11[1].x = row1_5.x;
  tmpvar_11[1].y = row1_5.y;
  tmpvar_11[1].z = row1_5.z;
  tmpvar_11[1].w = row1_5.w;
  tmpvar_11[2].x = row2_4.x;
  tmpvar_11[2].y = row2_4.y;
  tmpvar_11[2].z = row2_4.z;
  tmpvar_11[2].w = row2_4.w;
  tmpvar_11[3].x = 0.0;
  tmpvar_11[3].y = 0.0;
  tmpvar_11[3].z = 0.0;
  tmpvar_11[3].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_13;
  tmpvar_13[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_13[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_13[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[0] = tmpvar_11[0].xyz;
  tmpvar_14[1] = tmpvar_11[1].xyz;
  tmpvar_14[2] = tmpvar_11[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_13 * (_glesNormal * tmpvar_14)));
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
  xlv_TEXCOORD5 = tmpvar_1;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - tmpvar_15);
  xlv_TEXCOORD2 = (LIGHT_POSITION - tmpvar_15);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = tmpvar_3;
}

]===],
		psShader = [===[uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform sampler2D TEXTURE_DIFFUSE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD2;
void main ()
{
  lowp float attenAngle_1;
  mediump vec3 vLight_2;
  mediump vec3 vNormal_3;
  lowp float g_fAttenuation_4;
  mediump float disRange_5;
  mediump float dis_6;
  highp vec4 col_7;
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  col_7 = tmpvar_8;
  highp float tmpvar_9;
  tmpvar_9 = sqrt(dot (xlv_TEXCOORD2, xlv_TEXCOORD2));
  dis_6 = tmpvar_9;
  highp float tmpvar_10;
  tmpvar_10 = clamp ((dis_6 * LIGHT_RANGE_INV), 0.0, 1.0);
  disRange_5 = tmpvar_10;
  highp float tmpvar_11;
  tmpvar_11 = ((1.0 - disRange_5) / ((LIGHT_ATTENUATION.x + 
    (disRange_5 * LIGHT_ATTENUATION.y)
  ) + (
    (disRange_5 * disRange_5)
   * LIGHT_ATTENUATION.z)));
  g_fAttenuation_4 = tmpvar_11;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(xlv_TEXCOORD5).xyz;
  vNormal_3 = tmpvar_12;
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(xlv_TEXCOORD2);
  vLight_2 = tmpvar_13;
  mediump float tmpvar_14;
  tmpvar_14 = clamp (dot (vLight_2, vNormal_3), 0.0, 1.0);
  highp float tmpvar_15;
  tmpvar_15 = clamp ((1.0 - (
    (LIGHT_INNER_DIFF_INV.x - dot (vLight_2, -(LIGHT_GIVEN_DIRECTION)))
   * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0);
  attenAngle_1 = tmpvar_15;
  g_fAttenuation_4 = (g_fAttenuation_4 * attenAngle_1);
  highp vec4 tmpvar_16;
  tmpvar_16.xyz = ((AMBIENT_COLOR + (
    (tmpvar_14 * g_fAttenuation_4)
   * LIGHT_COLOR)) * col_7.xyz);
  tmpvar_16.w = col_7.w;
  gl_FragData[0] = tmpvar_16;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALSCREEN_TRANSVIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "CAMERA_RESOLUTION",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_HALF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 row2_2;
  highp vec4 row1_3;
  highp vec4 row0_4;
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.w) * 3);
  row0_4 = (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.x);
  row1_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.x);
  row2_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.x);
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.y));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.y));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.y));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.z));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.z));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.z));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.w));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.w));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_9;
  tmpvar_9[0].x = row0_4.x;
  tmpvar_9[0].y = row0_4.y;
  tmpvar_9[0].z = row0_4.z;
  tmpvar_9[0].w = row0_4.w;
  tmpvar_9[1].x = row1_3.x;
  tmpvar_9[1].y = row1_3.y;
  tmpvar_9[1].z = row1_3.z;
  tmpvar_9[1].w = row1_3.w;
  tmpvar_9[2].x = row2_2.x;
  tmpvar_9[2].y = row2_2.y;
  tmpvar_9[2].z = row2_2.z;
  tmpvar_9[2].w = row2_2.w;
  tmpvar_9[3].x = 0.0;
  tmpvar_9[3].y = 0.0;
  tmpvar_9[3].z = 0.0;
  tmpvar_9[3].w = 1.0;
  highp vec4 tmpvar_10;
  tmpvar_10.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_10.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_12;
  tmpvar_12[0] = tmpvar_9[0].xyz;
  tmpvar_12[1] = tmpvar_9[1].xyz;
  tmpvar_12[2] = tmpvar_9[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_11 * (_glesNormal * tmpvar_12)));
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)).xyz;
  highp mat4 tmpvar_14;
  tmpvar_14[0].x = 0.5;
  tmpvar_14[0].y = 0.0;
  tmpvar_14[0].z = 0.0;
  tmpvar_14[0].w = 0.5;
  tmpvar_14[1].x = 0.0;
  tmpvar_14[1].y = 0.5;
  tmpvar_14[1].z = 0.0;
  tmpvar_14[1].w = 0.5;
  tmpvar_14[2].x = 0.0;
  tmpvar_14[2].y = 0.0;
  tmpvar_14[2].z = 0.5;
  tmpvar_14[2].w = 0.5;
  tmpvar_14[3].x = 0.0;
  tmpvar_14[3].y = 0.0;
  tmpvar_14[3].z = 0.0;
  tmpvar_14[3].w = 1.0;
  highp vec4 tmpvar_15;
  tmpvar_15.w = 0.0;
  tmpvar_15.xyz = tmpvar_13;
  highp vec4 tmpvar_16;
  tmpvar_16.w = 0.0;
  tmpvar_16.xyz = (0.005 * tmpvar_1.xyz);
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_15 - tmpvar_16);
  highp vec4 tmpvar_18;
  tmpvar_18 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * tmpvar_17));
  highp vec4 tmpvar_19;
  tmpvar_19 = (LIGHT_CAMERA_VIEW * tmpvar_17);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_10 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_9)
  )));
  xlv_TEXCOORD5 = tmpvar_1;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - tmpvar_13);
  xlv_TEXCOORD2 = (LIGHT_POSITION - tmpvar_13);
  xlv_TEXCOORD3 = (tmpvar_14 * (tmpvar_18 / tmpvar_18.w)).xyz;
  xlv_TEXCOORD4 = (((
    -(tmpvar_19.z)
   / tmpvar_19.w) - LIGHT_CAMERA_LINEARPARAM.x) * LIGHT_CAMERA_LINEARPARAM.y);
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : require

#line 20
struct LightInput {
    highp vec3 lightColor;
    highp vec3 viewDir;
    highp vec3 lightDir;
    highp vec3 normalDir;
    highp float atten;
    highp vec3 emission;
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
};
#line 9
struct SurfaceInput {
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
    highp vec3 emission;
    highp vec3 worldNormal;
    highp vec3 worldPos;
    highp float atten;
};
#line 32
struct v2f {
    highp vec2 uv;
    highp vec4 vertex;
    highp vec4 worldnormal;
    highp vec3 viewDirection;
    highp vec3 lightDirection;
    highp vec3 LightCoord;
    highp float OrigDepth;
};
#line 24
struct appdata {
    highp vec4 vertex;
    highp vec2 uv;
    highp vec3 normal;
    highp vec4 boneIndices;
    highp vec4 boneWeight;
};
#line 5
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
#line 9
uniform highp mat4 CAMERA_PROJECTION;
uniform highp mat4 LOCALSCREEN_TRANSVIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
#line 13
uniform highp vec3 LIGHT_POSITION;
uniform highp vec3 WORLD_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
#line 17
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
#line 21
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp vec2 CAMERA_RESOLUTION;
#line 25
uniform highp vec2 CAMERA_RESOLUTION_INV;
uniform highp vec2 CAMERA_RESOLUTION_HALF_INV;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform sampler2D TEXTURE_GRAP;
#line 32
uniform highp float DEVICE_COORDINATE_Y_FLIP;
#line 124
#line 129
#line 144
#line 8
#line 18
#line 27
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
#line 35
#line 40
#line 58
#line 79
#line 95
#line 118
#line 154
#line 196
#line 245
#line 318
#line 33
#line 91
#line 44
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
#line 87
highp vec4 frag( in v2f i ) {
    #line 90
    highp vec4 col = texture2D( TEXTURE_DIFFUSE, i.uv);
    highp vec3 diffuse = vec3( 1.0, 1.0, 1.0);
    #line 94
    highp vec4 depthColor = shadow2D( TEXTURE_SHADOW_DEPTH, vec3( i.uv, 0.0));
    const highp vec4 bitShifts = vec4( 1.0, 0.00390625, 1.525879e-5, 5.960464e-8);
    #line 99
    highp float TexDepth = dot( depthColor, bitShifts);
    #line 191
    return vec4( (diffuse * col.xyz), col.w);
}
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main() {
    highp vec4 xl_retval;
    v2f xlt_i;
    xlt_i.uv = vec2(xlv_TEXCOORD0);
    xlt_i.vertex = vec4(0.0);
    xlt_i.worldnormal = vec4(xlv_TEXCOORD5);
    xlt_i.viewDirection = vec3(xlv_TEXCOORD1);
    xlt_i.lightDirection = vec3(xlv_TEXCOORD2);
    xlt_i.LightCoord = vec3(xlv_TEXCOORD3);
    xlt_i.OrigDepth = float(xlv_TEXCOORD4);
    xl_retval = frag( xlt_i);
    gl_FragData[0] = vec4(xl_retval);
}
/* NOTE: GLSL optimization failed
(95,26): error: no matching function for call to `shadow2D(sampler2DShadow, vec3)'; candidates are:
*/
]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALSCREEN_TRANSVIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "CAMERA_RESOLUTION",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_HALF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 row2_2;
  highp vec4 row1_3;
  highp vec4 row0_4;
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.w) * 3);
  row0_4 = (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.x);
  row1_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.x);
  row2_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.x);
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.y));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.y));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.y));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.z));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.z));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.z));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.w));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.w));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_9;
  tmpvar_9[0].x = row0_4.x;
  tmpvar_9[0].y = row0_4.y;
  tmpvar_9[0].z = row0_4.z;
  tmpvar_9[0].w = row0_4.w;
  tmpvar_9[1].x = row1_3.x;
  tmpvar_9[1].y = row1_3.y;
  tmpvar_9[1].z = row1_3.z;
  tmpvar_9[1].w = row1_3.w;
  tmpvar_9[2].x = row2_2.x;
  tmpvar_9[2].y = row2_2.y;
  tmpvar_9[2].z = row2_2.z;
  tmpvar_9[2].w = row2_2.w;
  tmpvar_9[3].x = 0.0;
  tmpvar_9[3].y = 0.0;
  tmpvar_9[3].z = 0.0;
  tmpvar_9[3].w = 1.0;
  highp vec4 tmpvar_10;
  tmpvar_10.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_10.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_12;
  tmpvar_12[0] = tmpvar_9[0].xyz;
  tmpvar_12[1] = tmpvar_9[1].xyz;
  tmpvar_12[2] = tmpvar_9[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_11 * (_glesNormal * tmpvar_12)));
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)).xyz;
  highp mat4 tmpvar_14;
  tmpvar_14[0].x = 0.5;
  tmpvar_14[0].y = 0.0;
  tmpvar_14[0].z = 0.0;
  tmpvar_14[0].w = 0.5;
  tmpvar_14[1].x = 0.0;
  tmpvar_14[1].y = 0.5;
  tmpvar_14[1].z = 0.0;
  tmpvar_14[1].w = 0.5;
  tmpvar_14[2].x = 0.0;
  tmpvar_14[2].y = 0.0;
  tmpvar_14[2].z = 0.5;
  tmpvar_14[2].w = 0.5;
  tmpvar_14[3].x = 0.0;
  tmpvar_14[3].y = 0.0;
  tmpvar_14[3].z = 0.0;
  tmpvar_14[3].w = 1.0;
  highp vec4 tmpvar_15;
  tmpvar_15.w = 0.0;
  tmpvar_15.xyz = tmpvar_13;
  highp vec4 tmpvar_16;
  tmpvar_16.w = 0.0;
  tmpvar_16.xyz = (0.005 * tmpvar_1.xyz);
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_15 - tmpvar_16);
  highp vec4 tmpvar_18;
  tmpvar_18 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * tmpvar_17));
  highp vec4 tmpvar_19;
  tmpvar_19 = (LIGHT_CAMERA_VIEW * tmpvar_17);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_10 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_9)
  )));
  xlv_TEXCOORD5 = tmpvar_1;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - tmpvar_13);
  xlv_TEXCOORD2 = (LIGHT_POSITION - tmpvar_13);
  xlv_TEXCOORD3 = (tmpvar_14 * (tmpvar_18 / tmpvar_18.w)).xyz;
  xlv_TEXCOORD4 = (((
    -(tmpvar_19.z)
   / tmpvar_19.w) - LIGHT_CAMERA_LINEARPARAM.x) * LIGHT_CAMERA_LINEARPARAM.y);
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : require

#line 20
struct LightInput {
    highp vec3 lightColor;
    highp vec3 viewDir;
    highp vec3 lightDir;
    highp vec3 normalDir;
    highp float atten;
    highp vec3 emission;
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
};
#line 9
struct SurfaceInput {
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
    highp vec3 emission;
    highp vec3 worldNormal;
    highp vec3 worldPos;
    highp float atten;
};
#line 32
struct v2f {
    highp vec2 uv;
    highp vec4 vertex;
    highp vec4 worldnormal;
    highp vec3 viewDirection;
    highp vec3 lightDirection;
    highp vec3 LightCoord;
    highp float OrigDepth;
};
#line 24
struct appdata {
    highp vec4 vertex;
    highp vec2 uv;
    highp vec3 normal;
    highp vec4 boneIndices;
    highp vec4 boneWeight;
};
#line 5
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
#line 9
uniform highp mat4 CAMERA_PROJECTION;
uniform highp mat4 LOCALSCREEN_TRANSVIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
#line 13
uniform highp vec3 LIGHT_POSITION;
uniform highp vec3 WORLD_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
#line 17
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
#line 21
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp vec2 CAMERA_RESOLUTION;
#line 25
uniform highp vec2 CAMERA_RESOLUTION_INV;
uniform highp vec2 CAMERA_RESOLUTION_HALF_INV;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform sampler2D TEXTURE_GRAP;
#line 32
uniform highp float DEVICE_COORDINATE_Y_FLIP;
#line 124
#line 129
#line 144
#line 8
#line 18
#line 27
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
#line 35
#line 40
#line 58
#line 79
#line 95
#line 118
#line 154
#line 196
#line 245
#line 318
#line 33
#line 91
#line 44
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
#line 87
highp vec4 frag( in v2f i ) {
    #line 90
    highp vec4 col = texture2D( TEXTURE_DIFFUSE, i.uv);
    highp vec3 diffuse = vec3( 1.0, 1.0, 1.0);
    #line 94
    highp vec4 depthColor = shadow2D( TEXTURE_SHADOW_DEPTH, vec3( i.uv, 0.0));
    const highp vec4 bitShifts = vec4( 1.0, 0.00390625, 1.525879e-5, 5.960464e-8);
    #line 99
    highp float TexDepth = dot( depthColor, bitShifts);
    #line 191
    return vec4( (diffuse * col.xyz), col.w);
}
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main() {
    highp vec4 xl_retval;
    v2f xlt_i;
    xlt_i.uv = vec2(xlv_TEXCOORD0);
    xlt_i.vertex = vec4(0.0);
    xlt_i.worldnormal = vec4(xlv_TEXCOORD5);
    xlt_i.viewDirection = vec3(xlv_TEXCOORD1);
    xlt_i.lightDirection = vec3(xlv_TEXCOORD2);
    xlt_i.LightCoord = vec3(xlv_TEXCOORD3);
    xlt_i.OrigDepth = float(xlv_TEXCOORD4);
    xl_retval = frag( xlt_i);
    gl_FragData[0] = vec4(xl_retval);
}
/* NOTE: GLSL optimization failed
(95,26): error: no matching function for call to `shadow2D(sampler2DShadow, vec3)'; candidates are:
*/
]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALSCREEN_TRANSVIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "CAMERA_RESOLUTION",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_HALF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 row2_2;
  highp vec4 row1_3;
  highp vec4 row0_4;
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.w) * 3);
  row0_4 = (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.x);
  row1_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.x);
  row2_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.x);
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.y));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.y));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.y));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.z));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.z));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.z));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.w));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.w));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_9;
  tmpvar_9[0].x = row0_4.x;
  tmpvar_9[0].y = row0_4.y;
  tmpvar_9[0].z = row0_4.z;
  tmpvar_9[0].w = row0_4.w;
  tmpvar_9[1].x = row1_3.x;
  tmpvar_9[1].y = row1_3.y;
  tmpvar_9[1].z = row1_3.z;
  tmpvar_9[1].w = row1_3.w;
  tmpvar_9[2].x = row2_2.x;
  tmpvar_9[2].y = row2_2.y;
  tmpvar_9[2].z = row2_2.z;
  tmpvar_9[2].w = row2_2.w;
  tmpvar_9[3].x = 0.0;
  tmpvar_9[3].y = 0.0;
  tmpvar_9[3].z = 0.0;
  tmpvar_9[3].w = 1.0;
  highp vec4 tmpvar_10;
  tmpvar_10.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_10.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_12;
  tmpvar_12[0] = tmpvar_9[0].xyz;
  tmpvar_12[1] = tmpvar_9[1].xyz;
  tmpvar_12[2] = tmpvar_9[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_11 * (_glesNormal * tmpvar_12)));
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)).xyz;
  highp mat4 tmpvar_14;
  tmpvar_14[0].x = 0.5;
  tmpvar_14[0].y = 0.0;
  tmpvar_14[0].z = 0.0;
  tmpvar_14[0].w = 0.5;
  tmpvar_14[1].x = 0.0;
  tmpvar_14[1].y = 0.5;
  tmpvar_14[1].z = 0.0;
  tmpvar_14[1].w = 0.5;
  tmpvar_14[2].x = 0.0;
  tmpvar_14[2].y = 0.0;
  tmpvar_14[2].z = 0.5;
  tmpvar_14[2].w = 0.5;
  tmpvar_14[3].x = 0.0;
  tmpvar_14[3].y = 0.0;
  tmpvar_14[3].z = 0.0;
  tmpvar_14[3].w = 1.0;
  highp vec4 tmpvar_15;
  tmpvar_15.w = 0.0;
  tmpvar_15.xyz = tmpvar_13;
  highp vec4 tmpvar_16;
  tmpvar_16.w = 0.0;
  tmpvar_16.xyz = (0.005 * tmpvar_1.xyz);
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_15 - tmpvar_16);
  highp vec4 tmpvar_18;
  tmpvar_18 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * tmpvar_17));
  highp vec4 tmpvar_19;
  tmpvar_19 = (LIGHT_CAMERA_VIEW * tmpvar_17);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_10 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_9)
  )));
  xlv_TEXCOORD5 = tmpvar_1;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - tmpvar_13);
  xlv_TEXCOORD2 = (LIGHT_POSITION - tmpvar_13);
  xlv_TEXCOORD3 = (tmpvar_14 * (tmpvar_18 / tmpvar_18.w)).xyz;
  xlv_TEXCOORD4 = (((
    -(tmpvar_19.z)
   / tmpvar_19.w) - LIGHT_CAMERA_LINEARPARAM.x) * LIGHT_CAMERA_LINEARPARAM.y);
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : require

#line 20
struct LightInput {
    highp vec3 lightColor;
    highp vec3 viewDir;
    highp vec3 lightDir;
    highp vec3 normalDir;
    highp float atten;
    highp vec3 emission;
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
};
#line 9
struct SurfaceInput {
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
    highp vec3 emission;
    highp vec3 worldNormal;
    highp vec3 worldPos;
    highp float atten;
};
#line 32
struct v2f {
    highp vec2 uv;
    highp vec4 vertex;
    highp vec4 worldnormal;
    highp vec3 viewDirection;
    highp vec3 lightDirection;
    highp vec3 LightCoord;
    highp float OrigDepth;
};
#line 24
struct appdata {
    highp vec4 vertex;
    highp vec2 uv;
    highp vec3 normal;
    highp vec4 boneIndices;
    highp vec4 boneWeight;
};
#line 5
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
#line 9
uniform highp mat4 CAMERA_PROJECTION;
uniform highp mat4 LOCALSCREEN_TRANSVIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
#line 13
uniform highp vec3 LIGHT_POSITION;
uniform highp vec3 WORLD_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
#line 17
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
#line 21
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp vec2 CAMERA_RESOLUTION;
#line 25
uniform highp vec2 CAMERA_RESOLUTION_INV;
uniform highp vec2 CAMERA_RESOLUTION_HALF_INV;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform sampler2D TEXTURE_GRAP;
#line 32
uniform highp float DEVICE_COORDINATE_Y_FLIP;
#line 124
#line 129
#line 144
#line 8
#line 18
#line 27
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
#line 35
#line 40
#line 58
#line 79
#line 95
#line 118
#line 154
#line 196
#line 245
#line 318
#line 33
#line 91
#line 44
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
#line 87
highp vec4 frag( in v2f i ) {
    #line 90
    highp vec4 col = texture2D( TEXTURE_DIFFUSE, i.uv);
    highp vec3 diffuse = vec3( 1.0, 1.0, 1.0);
    #line 94
    highp vec4 depthColor = shadow2D( TEXTURE_SHADOW_DEPTH, vec3( i.uv, 0.0));
    const highp vec4 bitShifts = vec4( 1.0, 0.00390625, 1.525879e-5, 5.960464e-8);
    #line 99
    highp float TexDepth = dot( depthColor, bitShifts);
    #line 191
    return vec4( (diffuse * col.xyz), col.w);
}
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main() {
    highp vec4 xl_retval;
    v2f xlt_i;
    xlt_i.uv = vec2(xlv_TEXCOORD0);
    xlt_i.vertex = vec4(0.0);
    xlt_i.worldnormal = vec4(xlv_TEXCOORD5);
    xlt_i.viewDirection = vec3(xlv_TEXCOORD1);
    xlt_i.lightDirection = vec3(xlv_TEXCOORD2);
    xlt_i.LightCoord = vec3(xlv_TEXCOORD3);
    xlt_i.OrigDepth = float(xlv_TEXCOORD4);
    xl_retval = frag( xlt_i);
    gl_FragData[0] = vec4(xl_retval);
}
/* NOTE: GLSL optimization failed
(95,26): error: no matching function for call to `shadow2D(sampler2DShadow, vec3)'; candidates are:
*/
]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 row2_2;
  highp vec4 row1_3;
  highp vec4 row0_4;
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.w) * 3);
  row0_4 = (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.x);
  row1_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.x);
  row2_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.x);
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.y));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.y));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.y));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.z));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.z));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.z));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.w));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.w));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_9;
  tmpvar_9[0].x = row0_4.x;
  tmpvar_9[0].y = row0_4.y;
  tmpvar_9[0].z = row0_4.z;
  tmpvar_9[0].w = row0_4.w;
  tmpvar_9[1].x = row1_3.x;
  tmpvar_9[1].y = row1_3.y;
  tmpvar_9[1].z = row1_3.z;
  tmpvar_9[1].w = row1_3.w;
  tmpvar_9[2].x = row2_2.x;
  tmpvar_9[2].y = row2_2.y;
  tmpvar_9[2].z = row2_2.z;
  tmpvar_9[2].w = row2_2.w;
  tmpvar_9[3].x = 0.0;
  tmpvar_9[3].y = 0.0;
  tmpvar_9[3].z = 0.0;
  tmpvar_9[3].w = 1.0;
  highp vec4 tmpvar_10;
  tmpvar_10.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_10.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_12;
  tmpvar_12[0] = tmpvar_9[0].xyz;
  tmpvar_12[1] = tmpvar_9[1].xyz;
  tmpvar_12[2] = tmpvar_9[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_11 * (_glesNormal * tmpvar_12)));
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)).xyz;
  highp mat4 tmpvar_14;
  tmpvar_14[0].x = 0.5;
  tmpvar_14[0].y = 0.0;
  tmpvar_14[0].z = 0.0;
  tmpvar_14[0].w = 0.5;
  tmpvar_14[1].x = 0.0;
  tmpvar_14[1].y = 0.5;
  tmpvar_14[1].z = 0.0;
  tmpvar_14[1].w = 0.5;
  tmpvar_14[2].x = 0.0;
  tmpvar_14[2].y = 0.0;
  tmpvar_14[2].z = 0.5;
  tmpvar_14[2].w = 0.5;
  tmpvar_14[3].x = 0.0;
  tmpvar_14[3].y = 0.0;
  tmpvar_14[3].z = 0.0;
  tmpvar_14[3].w = 1.0;
  highp vec4 tmpvar_15;
  tmpvar_15.w = 0.0;
  tmpvar_15.xyz = tmpvar_13;
  highp vec4 tmpvar_16;
  tmpvar_16.w = 0.0;
  tmpvar_16.xyz = (0.005 * tmpvar_1.xyz);
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_15 - tmpvar_16);
  highp vec4 tmpvar_18;
  tmpvar_18 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * tmpvar_17));
  highp vec4 tmpvar_19;
  tmpvar_19 = (LIGHT_CAMERA_VIEW * tmpvar_17);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_10 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_9)
  )));
  xlv_TEXCOORD5 = tmpvar_1;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - tmpvar_13);
  xlv_TEXCOORD2 = (LIGHT_POSITION - tmpvar_13);
  xlv_TEXCOORD3 = (tmpvar_14 * (tmpvar_18 / tmpvar_18.w)).xyz;
  xlv_TEXCOORD4 = (((
    -(tmpvar_19.z)
   / tmpvar_19.w) - LIGHT_CAMERA_LINEARPARAM.x) * LIGHT_CAMERA_LINEARPARAM.y);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_DIFFUSE;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 col_1;
  lowp vec4 tmpvar_2;
  tmpvar_2 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  col_1 = tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.xyz = col_1.xyz;
  tmpvar_3.w = col_1.w;
  gl_FragData[0] = tmpvar_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","PointLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec3 tmpvar_2;
  highp float tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[0].x = row0_6.x;
  tmpvar_11[0].y = row0_6.y;
  tmpvar_11[0].z = row0_6.z;
  tmpvar_11[0].w = row0_6.w;
  tmpvar_11[1].x = row1_5.x;
  tmpvar_11[1].y = row1_5.y;
  tmpvar_11[1].z = row1_5.z;
  tmpvar_11[1].w = row1_5.w;
  tmpvar_11[2].x = row2_4.x;
  tmpvar_11[2].y = row2_4.y;
  tmpvar_11[2].z = row2_4.z;
  tmpvar_11[2].w = row2_4.w;
  tmpvar_11[3].x = 0.0;
  tmpvar_11[3].y = 0.0;
  tmpvar_11[3].z = 0.0;
  tmpvar_11[3].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_13;
  tmpvar_13[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_13[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_13[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[0] = tmpvar_11[0].xyz;
  tmpvar_14[1] = tmpvar_11[1].xyz;
  tmpvar_14[2] = tmpvar_11[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_13 * (_glesNormal * tmpvar_14)));
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
  xlv_TEXCOORD5 = tmpvar_1;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - tmpvar_15);
  xlv_TEXCOORD2 = (LIGHT_POSITION - tmpvar_15);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = tmpvar_3;
}

]===],
		psShader = [===[uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D TEXTURE_DIFFUSE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD2;
void main ()
{
  mediump vec3 vLight_1;
  mediump vec3 vNormal_2;
  lowp float g_fAttenuation_3;
  mediump float disRange_4;
  mediump float dis_5;
  highp vec4 col_6;
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  col_6 = tmpvar_7;
  highp float tmpvar_8;
  tmpvar_8 = sqrt(dot (xlv_TEXCOORD2, xlv_TEXCOORD2));
  dis_5 = tmpvar_8;
  highp float tmpvar_9;
  tmpvar_9 = clamp ((dis_5 * LIGHT_RANGE_INV), 0.0, 1.0);
  disRange_4 = tmpvar_9;
  highp float tmpvar_10;
  tmpvar_10 = ((1.0 - disRange_4) / ((LIGHT_ATTENUATION.x + 
    (disRange_4 * LIGHT_ATTENUATION.y)
  ) + (
    (disRange_4 * disRange_4)
   * LIGHT_ATTENUATION.z)));
  g_fAttenuation_3 = tmpvar_10;
  highp vec3 tmpvar_11;
  tmpvar_11 = normalize(xlv_TEXCOORD5).xyz;
  vNormal_2 = tmpvar_11;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(xlv_TEXCOORD2);
  vLight_1 = tmpvar_12;
  mediump float tmpvar_13;
  tmpvar_13 = clamp (dot (vLight_1, vNormal_2), 0.0, 1.0);
  highp vec4 tmpvar_14;
  tmpvar_14.xyz = ((AMBIENT_COLOR + (
    (tmpvar_13 * g_fAttenuation_3)
   * LIGHT_COLOR)) * col_6.xyz);
  tmpvar_14.w = col_6.w;
  gl_FragData[0] = tmpvar_14;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","PointLight","ShadowOn"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 row2_2;
  highp vec4 row1_3;
  highp vec4 row0_4;
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.w) * 3);
  row0_4 = (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.x);
  row1_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.x);
  row2_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.x);
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.y));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.y));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.y));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.z));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.z));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.z));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.w));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.w));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_9;
  tmpvar_9[0].x = row0_4.x;
  tmpvar_9[0].y = row0_4.y;
  tmpvar_9[0].z = row0_4.z;
  tmpvar_9[0].w = row0_4.w;
  tmpvar_9[1].x = row1_3.x;
  tmpvar_9[1].y = row1_3.y;
  tmpvar_9[1].z = row1_3.z;
  tmpvar_9[1].w = row1_3.w;
  tmpvar_9[2].x = row2_2.x;
  tmpvar_9[2].y = row2_2.y;
  tmpvar_9[2].z = row2_2.z;
  tmpvar_9[2].w = row2_2.w;
  tmpvar_9[3].x = 0.0;
  tmpvar_9[3].y = 0.0;
  tmpvar_9[3].z = 0.0;
  tmpvar_9[3].w = 1.0;
  highp vec4 tmpvar_10;
  tmpvar_10.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_10.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_12;
  tmpvar_12[0] = tmpvar_9[0].xyz;
  tmpvar_12[1] = tmpvar_9[1].xyz;
  tmpvar_12[2] = tmpvar_9[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_11 * (_glesNormal * tmpvar_12)));
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)).xyz;
  highp mat4 tmpvar_14;
  tmpvar_14[0].x = 0.5;
  tmpvar_14[0].y = 0.0;
  tmpvar_14[0].z = 0.0;
  tmpvar_14[0].w = 0.5;
  tmpvar_14[1].x = 0.0;
  tmpvar_14[1].y = 0.5;
  tmpvar_14[1].z = 0.0;
  tmpvar_14[1].w = 0.5;
  tmpvar_14[2].x = 0.0;
  tmpvar_14[2].y = 0.0;
  tmpvar_14[2].z = 0.5;
  tmpvar_14[2].w = 0.5;
  tmpvar_14[3].x = 0.0;
  tmpvar_14[3].y = 0.0;
  tmpvar_14[3].z = 0.0;
  tmpvar_14[3].w = 1.0;
  highp vec4 tmpvar_15;
  tmpvar_15.w = 0.0;
  tmpvar_15.xyz = tmpvar_13;
  highp vec4 tmpvar_16;
  tmpvar_16.w = 0.0;
  tmpvar_16.xyz = (0.005 * tmpvar_1.xyz);
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_15 - tmpvar_16);
  highp vec4 tmpvar_18;
  tmpvar_18 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * tmpvar_17));
  highp vec4 tmpvar_19;
  tmpvar_19 = (LIGHT_CAMERA_VIEW * tmpvar_17);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_10 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_9)
  )));
  xlv_TEXCOORD5 = tmpvar_1;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - tmpvar_13);
  xlv_TEXCOORD2 = (LIGHT_POSITION - tmpvar_13);
  xlv_TEXCOORD3 = (tmpvar_14 * (tmpvar_18 / tmpvar_18.w)).xyz;
  xlv_TEXCOORD4 = (((
    -(tmpvar_19.z)
   / tmpvar_19.w) - LIGHT_CAMERA_LINEARPARAM.x) * LIGHT_CAMERA_LINEARPARAM.y);
}

]===],
		psShader = [===[uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D TEXTURE_DIFFUSE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp float expFactor_1;
  lowp float attenAngle_2;
  mediump vec3 vLight_3;
  mediump vec3 vNormal_4;
  lowp float g_fAttenuation_5;
  mediump float disRange_6;
  mediump float dis_7;
  highp vec3 diffuse_8;
  highp vec4 col_9;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  col_9 = tmpvar_10;
  diffuse_8 = vec3(1.0, 1.0, 1.0);
  highp float tmpvar_11;
  tmpvar_11 = sqrt(dot (xlv_TEXCOORD2, xlv_TEXCOORD2));
  dis_7 = tmpvar_11;
  highp float tmpvar_12;
  tmpvar_12 = clamp ((dis_7 * LIGHT_RANGE_INV), 0.0, 1.0);
  disRange_6 = tmpvar_12;
  highp float tmpvar_13;
  tmpvar_13 = ((1.0 - disRange_6) / ((LIGHT_ATTENUATION.x + 
    (disRange_6 * LIGHT_ATTENUATION.y)
  ) + (
    (disRange_6 * disRange_6)
   * LIGHT_ATTENUATION.z)));
  g_fAttenuation_5 = tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(xlv_TEXCOORD5).xyz;
  vNormal_4 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(xlv_TEXCOORD2);
  vLight_3 = tmpvar_15;
  mediump float tmpvar_16;
  tmpvar_16 = clamp (dot (vLight_3, vNormal_4), 0.0, 1.0);
  highp float tmpvar_17;
  tmpvar_17 = clamp ((1.0 - (
    (LIGHT_INNER_DIFF_INV.x - dot (vLight_3, -(LIGHT_GIVEN_DIRECTION)))
   * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0);
  attenAngle_2 = tmpvar_17;
  g_fAttenuation_5 = (g_fAttenuation_5 * attenAngle_2);
  highp float tmpvar_18;
  tmpvar_18 = exp((60.0 * (
    dot (texture2D (TEXTURE_SHADOW_DEPTH, xlv_TEXCOORD0), vec4(1.0, 0.00390625, 1.525879e-5, 5.960464e-8))
   - xlv_TEXCOORD4)));
  expFactor_1 = tmpvar_18;
  if ((tmpvar_18 > 1.0)) {
    expFactor_1 = 1.0;
  };
  diffuse_8 = (AMBIENT_COLOR + ((
    (tmpvar_16 * g_fAttenuation_5)
   * LIGHT_COLOR) * expFactor_1));
  highp vec4 tmpvar_19;
  tmpvar_19.xyz = (diffuse_8 * col_9.xyz);
  tmpvar_19.w = col_9.w;
  gl_FragData[0] = tmpvar_19;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec3 tmpvar_3;
  highp vec3 tmpvar_4;
  highp float tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_8;
  tmpvar_8[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_8[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_8[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_8 * _glesNormal));
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = tmpvar_1.xyz;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD5 = tmpvar_2;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - (LOCALWORLD_TRANSFORM * tmpvar_9).xyz);
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D TEXTURE_DIFFUSE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
void main ()
{
  mediump vec3 vLight_1;
  mediump vec3 vNormal_2;
  highp vec4 col_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  col_3 = tmpvar_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD5).xyz;
  vNormal_2 = tmpvar_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(-(LIGHT_GIVEN_DIRECTION));
  vLight_1 = tmpvar_6;
  mediump float tmpvar_7;
  tmpvar_7 = clamp (dot (vLight_1, vNormal_2), 0.0, 1.0);
  highp vec4 tmpvar_8;
  tmpvar_8.xyz = ((AMBIENT_COLOR + (tmpvar_7 * LIGHT_COLOR)) * col_3.xyz);
  tmpvar_8.w = col_3.w;
  gl_FragData[0] = tmpvar_8;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALSCREEN_TRANSVIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "CAMERA_RESOLUTION",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_HALF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec3 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_6;
  tmpvar_6[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_6[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_6[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_6 * _glesNormal));
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  tmpvar_7 = (LOCALWORLD_TRANSFORM * tmpvar_8);
  highp mat4 tmpvar_9;
  tmpvar_9[0].x = 0.5;
  tmpvar_9[0].y = 0.0;
  tmpvar_9[0].z = 0.0;
  tmpvar_9[0].w = 0.5;
  tmpvar_9[1].x = 0.0;
  tmpvar_9[1].y = 0.5;
  tmpvar_9[1].z = 0.0;
  tmpvar_9[1].w = 0.5;
  tmpvar_9[2].x = 0.0;
  tmpvar_9[2].y = 0.0;
  tmpvar_9[2].z = 0.5;
  tmpvar_9[2].w = 0.5;
  tmpvar_9[3].x = 0.0;
  tmpvar_9[3].y = 0.0;
  tmpvar_9[3].z = 0.0;
  tmpvar_9[3].w = 1.0;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 0.0;
  tmpvar_10.xyz = tmpvar_7.xyz;
  highp vec4 tmpvar_11;
  tmpvar_11.w = 0.0;
  tmpvar_11.xyz = (0.005 * tmpvar_2.xyz);
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_10 - tmpvar_11);
  highp vec4 tmpvar_13;
  tmpvar_13 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * tmpvar_12));
  highp vec4 tmpvar_14;
  tmpvar_14 = (LIGHT_CAMERA_VIEW * tmpvar_12);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_5 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4)));
  xlv_TEXCOORD5 = tmpvar_2;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - tmpvar_7.xyz);
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = (tmpvar_9 * (tmpvar_13 / tmpvar_13.w)).xyz;
  xlv_TEXCOORD4 = (((
    -(tmpvar_14.z)
   / tmpvar_14.w) - LIGHT_CAMERA_LINEARPARAM.x) * LIGHT_CAMERA_LINEARPARAM.y);
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : require

#line 20
struct LightInput {
    highp vec3 lightColor;
    highp vec3 viewDir;
    highp vec3 lightDir;
    highp vec3 normalDir;
    highp float atten;
    highp vec3 emission;
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
};
#line 9
struct SurfaceInput {
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
    highp vec3 emission;
    highp vec3 worldNormal;
    highp vec3 worldPos;
    highp float atten;
};
#line 29
struct v2f {
    highp vec2 uv;
    highp vec4 vertex;
    highp vec4 worldnormal;
    highp vec3 viewDirection;
    highp vec3 lightDirection;
    highp vec3 LightCoord;
    highp float OrigDepth;
};
#line 21
struct appdata {
    highp vec4 vertex;
    highp vec2 uv;
    highp vec3 normal;
};
#line 5
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
#line 9
uniform highp mat4 CAMERA_PROJECTION;
uniform highp mat4 LOCALSCREEN_TRANSVIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
#line 13
uniform highp vec3 LIGHT_POSITION;
uniform highp vec3 WORLD_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
#line 17
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
#line 21
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp vec2 CAMERA_RESOLUTION;
#line 25
uniform highp vec2 CAMERA_RESOLUTION_INV;
uniform highp vec2 CAMERA_RESOLUTION_HALF_INV;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform sampler2D TEXTURE_GRAP;
#line 32
uniform highp float DEVICE_COORDINATE_Y_FLIP;
#line 86
#line 92
#line 97
#line 102
#line 107
#line 112
#line 117
#line 124
#line 129
#line 144
#line 8
#line 18
#line 27
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
#line 35
#line 40
#line 58
#line 79
#line 95
#line 118
#line 154
#line 196
#line 245
#line 289
#line 33
#line 70
#line 41
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
#line 84
highp vec4 frag( in v2f i ) {
    #line 87
    highp vec4 col = texture2D( TEXTURE_DIFFUSE, i.uv);
    highp vec3 diffuse = vec3( 1.0, 1.0, 1.0);
    #line 91
    highp vec4 depthColor = shadow2D( TEXTURE_SHADOW_DEPTH, vec3( i.uv, 0.0));
    const highp vec4 bitShifts = vec4( 1.0, 0.00390625, 1.525879e-5, 5.960464e-8);
    #line 96
    highp float TexDepth = dot( depthColor, bitShifts);
    const mediump float constant = 60.0;
    #line 100
    mediump vec3 vNormal = vec3( normalize(i.worldnormal));
    mediump vec3 vLight = normalize((-LIGHT_GIVEN_DIRECTION));
    mediump vec3 vView = normalize(i.viewDirection);
    mediump vec3 vHalf = normalize((vLight + vView));
    #line 104
    mediump float dotLightNormal = dot( vLight, vNormal);
    mediump float fDiffuse = clamp( dotLightNormal, 0.0, 1.0);
    #line 108
    highp float expFactor = exp((60.0 * (TexDepth - i.OrigDepth)));
    if ((expFactor > 1.0)){
        expFactor = 1.0;
    }
    #line 114
    diffuse = (AMBIENT_COLOR + ((fDiffuse * LIGHT_COLOR) * expFactor));
    #line 188
    return vec4( (diffuse * col.xyz), col.w);
}
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main() {
    highp vec4 xl_retval;
    v2f xlt_i;
    xlt_i.uv = vec2(xlv_TEXCOORD0);
    xlt_i.vertex = vec4(0.0);
    xlt_i.worldnormal = vec4(xlv_TEXCOORD5);
    xlt_i.viewDirection = vec3(xlv_TEXCOORD1);
    xlt_i.lightDirection = vec3(xlv_TEXCOORD2);
    xlt_i.LightCoord = vec3(xlv_TEXCOORD3);
    xlt_i.OrigDepth = float(xlv_TEXCOORD4);
    xl_retval = frag( xlt_i);
    gl_FragData[0] = vec4(xl_retval);
}
/* NOTE: GLSL optimization failed
(92,26): error: no matching function for call to `shadow2D(sampler2DShadow, vec3)'; candidates are:
*/
]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALSCREEN_TRANSVIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "CAMERA_RESOLUTION",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_HALF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec3 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_6;
  tmpvar_6[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_6[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_6[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_6 * _glesNormal));
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  tmpvar_7 = (LOCALWORLD_TRANSFORM * tmpvar_8);
  highp mat4 tmpvar_9;
  tmpvar_9[0].x = 0.5;
  tmpvar_9[0].y = 0.0;
  tmpvar_9[0].z = 0.0;
  tmpvar_9[0].w = 0.5;
  tmpvar_9[1].x = 0.0;
  tmpvar_9[1].y = 0.5;
  tmpvar_9[1].z = 0.0;
  tmpvar_9[1].w = 0.5;
  tmpvar_9[2].x = 0.0;
  tmpvar_9[2].y = 0.0;
  tmpvar_9[2].z = 0.5;
  tmpvar_9[2].w = 0.5;
  tmpvar_9[3].x = 0.0;
  tmpvar_9[3].y = 0.0;
  tmpvar_9[3].z = 0.0;
  tmpvar_9[3].w = 1.0;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 0.0;
  tmpvar_10.xyz = tmpvar_7.xyz;
  highp vec4 tmpvar_11;
  tmpvar_11.w = 0.0;
  tmpvar_11.xyz = (0.005 * tmpvar_2.xyz);
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_10 - tmpvar_11);
  highp vec4 tmpvar_13;
  tmpvar_13 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * tmpvar_12));
  highp vec4 tmpvar_14;
  tmpvar_14 = (LIGHT_CAMERA_VIEW * tmpvar_12);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_5 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4)));
  xlv_TEXCOORD5 = tmpvar_2;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - tmpvar_7.xyz);
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = (tmpvar_9 * (tmpvar_13 / tmpvar_13.w)).xyz;
  xlv_TEXCOORD4 = (((
    -(tmpvar_14.z)
   / tmpvar_14.w) - LIGHT_CAMERA_LINEARPARAM.x) * LIGHT_CAMERA_LINEARPARAM.y);
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : require

#line 20
struct LightInput {
    highp vec3 lightColor;
    highp vec3 viewDir;
    highp vec3 lightDir;
    highp vec3 normalDir;
    highp float atten;
    highp vec3 emission;
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
};
#line 9
struct SurfaceInput {
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
    highp vec3 emission;
    highp vec3 worldNormal;
    highp vec3 worldPos;
    highp float atten;
};
#line 29
struct v2f {
    highp vec2 uv;
    highp vec4 vertex;
    highp vec4 worldnormal;
    highp vec3 viewDirection;
    highp vec3 lightDirection;
    highp vec3 LightCoord;
    highp float OrigDepth;
};
#line 21
struct appdata {
    highp vec4 vertex;
    highp vec2 uv;
    highp vec3 normal;
};
#line 5
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
#line 9
uniform highp mat4 CAMERA_PROJECTION;
uniform highp mat4 LOCALSCREEN_TRANSVIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
#line 13
uniform highp vec3 LIGHT_POSITION;
uniform highp vec3 WORLD_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
#line 17
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
#line 21
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp vec2 CAMERA_RESOLUTION;
#line 25
uniform highp vec2 CAMERA_RESOLUTION_INV;
uniform highp vec2 CAMERA_RESOLUTION_HALF_INV;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform sampler2D TEXTURE_GRAP;
#line 32
uniform highp float DEVICE_COORDINATE_Y_FLIP;
#line 86
#line 92
#line 97
#line 102
#line 107
#line 112
#line 117
#line 124
#line 129
#line 144
#line 8
#line 18
#line 27
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
#line 35
#line 40
#line 58
#line 79
#line 95
#line 118
#line 154
#line 196
#line 245
#line 289
#line 33
#line 70
#line 41
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
#line 84
highp vec4 frag( in v2f i ) {
    #line 87
    highp vec4 col = texture2D( TEXTURE_DIFFUSE, i.uv);
    highp vec3 diffuse = vec3( 1.0, 1.0, 1.0);
    #line 91
    highp vec4 depthColor = shadow2D( TEXTURE_SHADOW_DEPTH, vec3( i.uv, 0.0));
    const highp vec4 bitShifts = vec4( 1.0, 0.00390625, 1.525879e-5, 5.960464e-8);
    #line 96
    highp float TexDepth = dot( depthColor, bitShifts);
    const mediump float constant = 60.0;
    #line 100
    mediump vec3 vNormal = vec3( normalize(i.worldnormal));
    mediump vec3 vLight = normalize((-LIGHT_GIVEN_DIRECTION));
    mediump vec3 vView = normalize(i.viewDirection);
    mediump vec3 vHalf = normalize((vLight + vView));
    #line 104
    mediump float dotLightNormal = dot( vLight, vNormal);
    mediump float fDiffuse = clamp( dotLightNormal, 0.0, 1.0);
    #line 108
    highp float expFactor = exp((60.0 * (TexDepth - i.OrigDepth)));
    if ((expFactor > 1.0)){
        expFactor = 1.0;
    }
    #line 114
    diffuse = (AMBIENT_COLOR + ((fDiffuse * LIGHT_COLOR) * expFactor));
    #line 188
    return vec4( (diffuse * col.xyz), col.w);
}
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main() {
    highp vec4 xl_retval;
    v2f xlt_i;
    xlt_i.uv = vec2(xlv_TEXCOORD0);
    xlt_i.vertex = vec4(0.0);
    xlt_i.worldnormal = vec4(xlv_TEXCOORD5);
    xlt_i.viewDirection = vec3(xlv_TEXCOORD1);
    xlt_i.lightDirection = vec3(xlv_TEXCOORD2);
    xlt_i.LightCoord = vec3(xlv_TEXCOORD3);
    xlt_i.OrigDepth = float(xlv_TEXCOORD4);
    xl_retval = frag( xlt_i);
    gl_FragData[0] = vec4(xl_retval);
}
/* NOTE: GLSL optimization failed
(92,26): error: no matching function for call to `shadow2D(sampler2DShadow, vec3)'; candidates are:
*/
]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALSCREEN_TRANSVIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "CAMERA_RESOLUTION",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_HALF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec3 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_6;
  tmpvar_6[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_6[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_6[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_6 * _glesNormal));
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  tmpvar_7 = (LOCALWORLD_TRANSFORM * tmpvar_8);
  highp mat4 tmpvar_9;
  tmpvar_9[0].x = 0.5;
  tmpvar_9[0].y = 0.0;
  tmpvar_9[0].z = 0.0;
  tmpvar_9[0].w = 0.5;
  tmpvar_9[1].x = 0.0;
  tmpvar_9[1].y = 0.5;
  tmpvar_9[1].z = 0.0;
  tmpvar_9[1].w = 0.5;
  tmpvar_9[2].x = 0.0;
  tmpvar_9[2].y = 0.0;
  tmpvar_9[2].z = 0.5;
  tmpvar_9[2].w = 0.5;
  tmpvar_9[3].x = 0.0;
  tmpvar_9[3].y = 0.0;
  tmpvar_9[3].z = 0.0;
  tmpvar_9[3].w = 1.0;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 0.0;
  tmpvar_10.xyz = tmpvar_7.xyz;
  highp vec4 tmpvar_11;
  tmpvar_11.w = 0.0;
  tmpvar_11.xyz = (0.005 * tmpvar_2.xyz);
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_10 - tmpvar_11);
  highp vec4 tmpvar_13;
  tmpvar_13 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * tmpvar_12));
  highp vec4 tmpvar_14;
  tmpvar_14 = (LIGHT_CAMERA_VIEW * tmpvar_12);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_5 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4)));
  xlv_TEXCOORD5 = tmpvar_2;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - tmpvar_7.xyz);
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = (tmpvar_9 * (tmpvar_13 / tmpvar_13.w)).xyz;
  xlv_TEXCOORD4 = (((
    -(tmpvar_14.z)
   / tmpvar_14.w) - LIGHT_CAMERA_LINEARPARAM.x) * LIGHT_CAMERA_LINEARPARAM.y);
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : require

#line 20
struct LightInput {
    highp vec3 lightColor;
    highp vec3 viewDir;
    highp vec3 lightDir;
    highp vec3 normalDir;
    highp float atten;
    highp vec3 emission;
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
};
#line 9
struct SurfaceInput {
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
    highp vec3 emission;
    highp vec3 worldNormal;
    highp vec3 worldPos;
    highp float atten;
};
#line 29
struct v2f {
    highp vec2 uv;
    highp vec4 vertex;
    highp vec4 worldnormal;
    highp vec3 viewDirection;
    highp vec3 lightDirection;
    highp vec3 LightCoord;
    highp float OrigDepth;
};
#line 21
struct appdata {
    highp vec4 vertex;
    highp vec2 uv;
    highp vec3 normal;
};
#line 5
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
#line 9
uniform highp mat4 CAMERA_PROJECTION;
uniform highp mat4 LOCALSCREEN_TRANSVIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
#line 13
uniform highp vec3 LIGHT_POSITION;
uniform highp vec3 WORLD_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
#line 17
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
#line 21
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp vec2 CAMERA_RESOLUTION;
#line 25
uniform highp vec2 CAMERA_RESOLUTION_INV;
uniform highp vec2 CAMERA_RESOLUTION_HALF_INV;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform sampler2D TEXTURE_GRAP;
#line 32
uniform highp float DEVICE_COORDINATE_Y_FLIP;
#line 86
#line 92
#line 97
#line 102
#line 107
#line 112
#line 117
#line 124
#line 129
#line 144
#line 8
#line 18
#line 27
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
#line 35
#line 40
#line 58
#line 79
#line 95
#line 118
#line 154
#line 196
#line 245
#line 289
#line 33
#line 70
#line 41
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
#line 84
highp vec4 frag( in v2f i ) {
    #line 87
    highp vec4 col = texture2D( TEXTURE_DIFFUSE, i.uv);
    highp vec3 diffuse = vec3( 1.0, 1.0, 1.0);
    #line 91
    highp vec4 depthColor = shadow2D( TEXTURE_SHADOW_DEPTH, vec3( i.uv, 0.0));
    const highp vec4 bitShifts = vec4( 1.0, 0.00390625, 1.525879e-5, 5.960464e-8);
    #line 96
    highp float TexDepth = dot( depthColor, bitShifts);
    const mediump float constant = 60.0;
    #line 100
    mediump vec3 vNormal = vec3( normalize(i.worldnormal));
    mediump vec3 vLight = normalize((-LIGHT_GIVEN_DIRECTION));
    mediump vec3 vView = normalize(i.viewDirection);
    mediump vec3 vHalf = normalize((vLight + vView));
    #line 104
    mediump float dotLightNormal = dot( vLight, vNormal);
    mediump float fDiffuse = clamp( dotLightNormal, 0.0, 1.0);
    #line 108
    highp float expFactor = exp((60.0 * (TexDepth - i.OrigDepth)));
    if ((expFactor > 1.0)){
        expFactor = 1.0;
    }
    #line 114
    diffuse = (AMBIENT_COLOR + ((fDiffuse * LIGHT_COLOR) * expFactor));
    #line 188
    return vec4( (diffuse * col.xyz), col.w);
}
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main() {
    highp vec4 xl_retval;
    v2f xlt_i;
    xlt_i.uv = vec2(xlv_TEXCOORD0);
    xlt_i.vertex = vec4(0.0);
    xlt_i.worldnormal = vec4(xlv_TEXCOORD5);
    xlt_i.viewDirection = vec3(xlv_TEXCOORD1);
    xlt_i.lightDirection = vec3(xlv_TEXCOORD2);
    xlt_i.LightCoord = vec3(xlv_TEXCOORD3);
    xlt_i.OrigDepth = float(xlv_TEXCOORD4);
    xl_retval = frag( xlt_i);
    gl_FragData[0] = vec4(xl_retval);
}
/* NOTE: GLSL optimization failed
(92,26): error: no matching function for call to `shadow2D(sampler2DShadow, vec3)'; candidates are:
*/
]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec3 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_6;
  tmpvar_6[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_6[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_6[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_6 * _glesNormal));
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  tmpvar_7 = (LOCALWORLD_TRANSFORM * tmpvar_8);
  highp mat4 tmpvar_9;
  tmpvar_9[0].x = 0.5;
  tmpvar_9[0].y = 0.0;
  tmpvar_9[0].z = 0.0;
  tmpvar_9[0].w = 0.5;
  tmpvar_9[1].x = 0.0;
  tmpvar_9[1].y = 0.5;
  tmpvar_9[1].z = 0.0;
  tmpvar_9[1].w = 0.5;
  tmpvar_9[2].x = 0.0;
  tmpvar_9[2].y = 0.0;
  tmpvar_9[2].z = 0.5;
  tmpvar_9[2].w = 0.5;
  tmpvar_9[3].x = 0.0;
  tmpvar_9[3].y = 0.0;
  tmpvar_9[3].z = 0.0;
  tmpvar_9[3].w = 1.0;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 0.0;
  tmpvar_10.xyz = tmpvar_7.xyz;
  highp vec4 tmpvar_11;
  tmpvar_11.w = 0.0;
  tmpvar_11.xyz = (0.005 * tmpvar_2.xyz);
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_10 - tmpvar_11);
  highp vec4 tmpvar_13;
  tmpvar_13 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * tmpvar_12));
  highp vec4 tmpvar_14;
  tmpvar_14 = (LIGHT_CAMERA_VIEW * tmpvar_12);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_5 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4)));
  xlv_TEXCOORD5 = tmpvar_2;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - tmpvar_7.xyz);
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = (tmpvar_9 * (tmpvar_13 / tmpvar_13.w)).xyz;
  xlv_TEXCOORD4 = (((
    -(tmpvar_14.z)
   / tmpvar_14.w) - LIGHT_CAMERA_LINEARPARAM.x) * LIGHT_CAMERA_LINEARPARAM.y);
}

]===],
		psShader = [===[uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D TEXTURE_DIFFUSE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp float expFactor_1;
  mediump vec3 vLight_2;
  mediump vec3 vNormal_3;
  highp vec3 diffuse_4;
  highp vec4 col_5;
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  col_5 = tmpvar_6;
  diffuse_4 = vec3(1.0, 1.0, 1.0);
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD5).xyz;
  vNormal_3 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(-(LIGHT_GIVEN_DIRECTION));
  vLight_2 = tmpvar_8;
  mediump float tmpvar_9;
  tmpvar_9 = clamp (dot (vLight_2, vNormal_3), 0.0, 1.0);
  highp float tmpvar_10;
  tmpvar_10 = exp((60.0 * (
    dot (texture2D (TEXTURE_SHADOW_DEPTH, xlv_TEXCOORD0), vec4(1.0, 0.00390625, 1.525879e-5, 5.960464e-8))
   - xlv_TEXCOORD4)));
  expFactor_1 = tmpvar_10;
  if ((tmpvar_10 > 1.0)) {
    expFactor_1 = 1.0;
  };
  diffuse_4 = (AMBIENT_COLOR + ((tmpvar_9 * LIGHT_COLOR) * expFactor_1));
  highp vec4 tmpvar_11;
  tmpvar_11.xyz = (diffuse_4 * col_5.xyz);
  tmpvar_11.w = col_5.w;
  gl_FragData[0] = tmpvar_11;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"SpotLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec3 tmpvar_3;
  highp float tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_7;
  tmpvar_7[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_7[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_7[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_7 * _glesNormal));
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = tmpvar_1.xyz;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
  xlv_TEXCOORD5 = tmpvar_2;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - tmpvar_8.xyz);
  xlv_TEXCOORD2 = (LIGHT_POSITION - tmpvar_8.xyz);
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform sampler2D TEXTURE_DIFFUSE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD2;
void main ()
{
  lowp float attenAngle_1;
  mediump vec3 vLight_2;
  mediump vec3 vNormal_3;
  lowp float g_fAttenuation_4;
  mediump float disRange_5;
  mediump float dis_6;
  highp vec4 col_7;
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  col_7 = tmpvar_8;
  highp float tmpvar_9;
  tmpvar_9 = sqrt(dot (xlv_TEXCOORD2, xlv_TEXCOORD2));
  dis_6 = tmpvar_9;
  highp float tmpvar_10;
  tmpvar_10 = clamp ((dis_6 * LIGHT_RANGE_INV), 0.0, 1.0);
  disRange_5 = tmpvar_10;
  highp float tmpvar_11;
  tmpvar_11 = ((1.0 - disRange_5) / ((LIGHT_ATTENUATION.x + 
    (disRange_5 * LIGHT_ATTENUATION.y)
  ) + (
    (disRange_5 * disRange_5)
   * LIGHT_ATTENUATION.z)));
  g_fAttenuation_4 = tmpvar_11;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(xlv_TEXCOORD5).xyz;
  vNormal_3 = tmpvar_12;
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize(xlv_TEXCOORD2);
  vLight_2 = tmpvar_13;
  mediump float tmpvar_14;
  tmpvar_14 = clamp (dot (vLight_2, vNormal_3), 0.0, 1.0);
  highp float tmpvar_15;
  tmpvar_15 = clamp ((1.0 - (
    (LIGHT_INNER_DIFF_INV.x - dot (vLight_2, -(LIGHT_GIVEN_DIRECTION)))
   * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0);
  attenAngle_1 = tmpvar_15;
  g_fAttenuation_4 = (g_fAttenuation_4 * attenAngle_1);
  highp vec4 tmpvar_16;
  tmpvar_16.xyz = ((AMBIENT_COLOR + (
    (tmpvar_14 * g_fAttenuation_4)
   * LIGHT_COLOR)) * col_7.xyz);
  tmpvar_16.w = col_7.w;
  gl_FragData[0] = tmpvar_16;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALSCREEN_TRANSVIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "CAMERA_RESOLUTION",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_HALF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_5;
  tmpvar_5[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_5[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_5[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_5 * _glesNormal));
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_6 = (LOCALWORLD_TRANSFORM * tmpvar_7);
  highp mat4 tmpvar_8;
  tmpvar_8[0].x = 0.5;
  tmpvar_8[0].y = 0.0;
  tmpvar_8[0].z = 0.0;
  tmpvar_8[0].w = 0.5;
  tmpvar_8[1].x = 0.0;
  tmpvar_8[1].y = 0.5;
  tmpvar_8[1].z = 0.0;
  tmpvar_8[1].w = 0.5;
  tmpvar_8[2].x = 0.0;
  tmpvar_8[2].y = 0.0;
  tmpvar_8[2].z = 0.5;
  tmpvar_8[2].w = 0.5;
  tmpvar_8[3].x = 0.0;
  tmpvar_8[3].y = 0.0;
  tmpvar_8[3].z = 0.0;
  tmpvar_8[3].w = 1.0;
  highp vec4 tmpvar_9;
  tmpvar_9.w = 0.0;
  tmpvar_9.xyz = tmpvar_6.xyz;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 0.0;
  tmpvar_10.xyz = (0.005 * tmpvar_2.xyz);
  highp vec4 tmpvar_11;
  tmpvar_11 = (tmpvar_9 - tmpvar_10);
  highp vec4 tmpvar_12;
  tmpvar_12 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * tmpvar_11));
  highp vec4 tmpvar_13;
  tmpvar_13 = (LIGHT_CAMERA_VIEW * tmpvar_11);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_4 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3)));
  xlv_TEXCOORD5 = tmpvar_2;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - tmpvar_6.xyz);
  xlv_TEXCOORD2 = (LIGHT_POSITION - tmpvar_6.xyz);
  xlv_TEXCOORD3 = (tmpvar_8 * (tmpvar_12 / tmpvar_12.w)).xyz;
  xlv_TEXCOORD4 = (((
    -(tmpvar_13.z)
   / tmpvar_13.w) - LIGHT_CAMERA_LINEARPARAM.x) * LIGHT_CAMERA_LINEARPARAM.y);
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : require

#line 20
struct LightInput {
    highp vec3 lightColor;
    highp vec3 viewDir;
    highp vec3 lightDir;
    highp vec3 normalDir;
    highp float atten;
    highp vec3 emission;
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
};
#line 9
struct SurfaceInput {
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
    highp vec3 emission;
    highp vec3 worldNormal;
    highp vec3 worldPos;
    highp float atten;
};
#line 29
struct v2f {
    highp vec2 uv;
    highp vec4 vertex;
    highp vec4 worldnormal;
    highp vec3 viewDirection;
    highp vec3 lightDirection;
    highp vec3 LightCoord;
    highp float OrigDepth;
};
#line 21
struct appdata {
    highp vec4 vertex;
    highp vec2 uv;
    highp vec3 normal;
};
#line 5
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
#line 9
uniform highp mat4 CAMERA_PROJECTION;
uniform highp mat4 LOCALSCREEN_TRANSVIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
#line 13
uniform highp vec3 LIGHT_POSITION;
uniform highp vec3 WORLD_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
#line 17
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
#line 21
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp vec2 CAMERA_RESOLUTION;
#line 25
uniform highp vec2 CAMERA_RESOLUTION_INV;
uniform highp vec2 CAMERA_RESOLUTION_HALF_INV;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform sampler2D TEXTURE_GRAP;
#line 32
uniform highp float DEVICE_COORDINATE_Y_FLIP;
#line 86
#line 92
#line 97
#line 102
#line 107
#line 112
#line 117
#line 124
#line 129
#line 144
#line 8
#line 18
#line 27
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
#line 35
#line 40
#line 58
#line 79
#line 95
#line 118
#line 154
#line 196
#line 245
#line 318
#line 33
#line 91
#line 41
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
#line 84
highp vec4 frag( in v2f i ) {
    #line 87
    highp vec4 col = texture2D( TEXTURE_DIFFUSE, i.uv);
    highp vec3 diffuse = vec3( 1.0, 1.0, 1.0);
    #line 91
    highp vec4 depthColor = shadow2D( TEXTURE_SHADOW_DEPTH, vec3( i.uv, 0.0));
    const highp vec4 bitShifts = vec4( 1.0, 0.00390625, 1.525879e-5, 5.960464e-8);
    #line 96
    highp float TexDepth = dot( depthColor, bitShifts);
    #line 188
    return vec4( (diffuse * col.xyz), col.w);
}
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main() {
    highp vec4 xl_retval;
    v2f xlt_i;
    xlt_i.uv = vec2(xlv_TEXCOORD0);
    xlt_i.vertex = vec4(0.0);
    xlt_i.worldnormal = vec4(xlv_TEXCOORD5);
    xlt_i.viewDirection = vec3(xlv_TEXCOORD1);
    xlt_i.lightDirection = vec3(xlv_TEXCOORD2);
    xlt_i.LightCoord = vec3(xlv_TEXCOORD3);
    xlt_i.OrigDepth = float(xlv_TEXCOORD4);
    xl_retval = frag( xlt_i);
    gl_FragData[0] = vec4(xl_retval);
}
/* NOTE: GLSL optimization failed
(92,26): error: no matching function for call to `shadow2D(sampler2DShadow, vec3)'; candidates are:
*/
]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALSCREEN_TRANSVIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "CAMERA_RESOLUTION",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_HALF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_5;
  tmpvar_5[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_5[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_5[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_5 * _glesNormal));
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_6 = (LOCALWORLD_TRANSFORM * tmpvar_7);
  highp mat4 tmpvar_8;
  tmpvar_8[0].x = 0.5;
  tmpvar_8[0].y = 0.0;
  tmpvar_8[0].z = 0.0;
  tmpvar_8[0].w = 0.5;
  tmpvar_8[1].x = 0.0;
  tmpvar_8[1].y = 0.5;
  tmpvar_8[1].z = 0.0;
  tmpvar_8[1].w = 0.5;
  tmpvar_8[2].x = 0.0;
  tmpvar_8[2].y = 0.0;
  tmpvar_8[2].z = 0.5;
  tmpvar_8[2].w = 0.5;
  tmpvar_8[3].x = 0.0;
  tmpvar_8[3].y = 0.0;
  tmpvar_8[3].z = 0.0;
  tmpvar_8[3].w = 1.0;
  highp vec4 tmpvar_9;
  tmpvar_9.w = 0.0;
  tmpvar_9.xyz = tmpvar_6.xyz;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 0.0;
  tmpvar_10.xyz = (0.005 * tmpvar_2.xyz);
  highp vec4 tmpvar_11;
  tmpvar_11 = (tmpvar_9 - tmpvar_10);
  highp vec4 tmpvar_12;
  tmpvar_12 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * tmpvar_11));
  highp vec4 tmpvar_13;
  tmpvar_13 = (LIGHT_CAMERA_VIEW * tmpvar_11);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_4 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3)));
  xlv_TEXCOORD5 = tmpvar_2;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - tmpvar_6.xyz);
  xlv_TEXCOORD2 = (LIGHT_POSITION - tmpvar_6.xyz);
  xlv_TEXCOORD3 = (tmpvar_8 * (tmpvar_12 / tmpvar_12.w)).xyz;
  xlv_TEXCOORD4 = (((
    -(tmpvar_13.z)
   / tmpvar_13.w) - LIGHT_CAMERA_LINEARPARAM.x) * LIGHT_CAMERA_LINEARPARAM.y);
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : require

#line 20
struct LightInput {
    highp vec3 lightColor;
    highp vec3 viewDir;
    highp vec3 lightDir;
    highp vec3 normalDir;
    highp float atten;
    highp vec3 emission;
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
};
#line 9
struct SurfaceInput {
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
    highp vec3 emission;
    highp vec3 worldNormal;
    highp vec3 worldPos;
    highp float atten;
};
#line 29
struct v2f {
    highp vec2 uv;
    highp vec4 vertex;
    highp vec4 worldnormal;
    highp vec3 viewDirection;
    highp vec3 lightDirection;
    highp vec3 LightCoord;
    highp float OrigDepth;
};
#line 21
struct appdata {
    highp vec4 vertex;
    highp vec2 uv;
    highp vec3 normal;
};
#line 5
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
#line 9
uniform highp mat4 CAMERA_PROJECTION;
uniform highp mat4 LOCALSCREEN_TRANSVIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
#line 13
uniform highp vec3 LIGHT_POSITION;
uniform highp vec3 WORLD_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
#line 17
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
#line 21
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp vec2 CAMERA_RESOLUTION;
#line 25
uniform highp vec2 CAMERA_RESOLUTION_INV;
uniform highp vec2 CAMERA_RESOLUTION_HALF_INV;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform sampler2D TEXTURE_GRAP;
#line 32
uniform highp float DEVICE_COORDINATE_Y_FLIP;
#line 86
#line 92
#line 97
#line 102
#line 107
#line 112
#line 117
#line 124
#line 129
#line 144
#line 8
#line 18
#line 27
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
#line 35
#line 40
#line 58
#line 79
#line 95
#line 118
#line 154
#line 196
#line 245
#line 318
#line 33
#line 91
#line 41
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
#line 84
highp vec4 frag( in v2f i ) {
    #line 87
    highp vec4 col = texture2D( TEXTURE_DIFFUSE, i.uv);
    highp vec3 diffuse = vec3( 1.0, 1.0, 1.0);
    #line 91
    highp vec4 depthColor = shadow2D( TEXTURE_SHADOW_DEPTH, vec3( i.uv, 0.0));
    const highp vec4 bitShifts = vec4( 1.0, 0.00390625, 1.525879e-5, 5.960464e-8);
    #line 96
    highp float TexDepth = dot( depthColor, bitShifts);
    #line 188
    return vec4( (diffuse * col.xyz), col.w);
}
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main() {
    highp vec4 xl_retval;
    v2f xlt_i;
    xlt_i.uv = vec2(xlv_TEXCOORD0);
    xlt_i.vertex = vec4(0.0);
    xlt_i.worldnormal = vec4(xlv_TEXCOORD5);
    xlt_i.viewDirection = vec3(xlv_TEXCOORD1);
    xlt_i.lightDirection = vec3(xlv_TEXCOORD2);
    xlt_i.LightCoord = vec3(xlv_TEXCOORD3);
    xlt_i.OrigDepth = float(xlv_TEXCOORD4);
    xl_retval = frag( xlt_i);
    gl_FragData[0] = vec4(xl_retval);
}
/* NOTE: GLSL optimization failed
(92,26): error: no matching function for call to `shadow2D(sampler2DShadow, vec3)'; candidates are:
*/
]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALSCREEN_TRANSVIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "CAMERA_RESOLUTION",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_HALF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_5;
  tmpvar_5[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_5[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_5[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_5 * _glesNormal));
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_6 = (LOCALWORLD_TRANSFORM * tmpvar_7);
  highp mat4 tmpvar_8;
  tmpvar_8[0].x = 0.5;
  tmpvar_8[0].y = 0.0;
  tmpvar_8[0].z = 0.0;
  tmpvar_8[0].w = 0.5;
  tmpvar_8[1].x = 0.0;
  tmpvar_8[1].y = 0.5;
  tmpvar_8[1].z = 0.0;
  tmpvar_8[1].w = 0.5;
  tmpvar_8[2].x = 0.0;
  tmpvar_8[2].y = 0.0;
  tmpvar_8[2].z = 0.5;
  tmpvar_8[2].w = 0.5;
  tmpvar_8[3].x = 0.0;
  tmpvar_8[3].y = 0.0;
  tmpvar_8[3].z = 0.0;
  tmpvar_8[3].w = 1.0;
  highp vec4 tmpvar_9;
  tmpvar_9.w = 0.0;
  tmpvar_9.xyz = tmpvar_6.xyz;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 0.0;
  tmpvar_10.xyz = (0.005 * tmpvar_2.xyz);
  highp vec4 tmpvar_11;
  tmpvar_11 = (tmpvar_9 - tmpvar_10);
  highp vec4 tmpvar_12;
  tmpvar_12 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * tmpvar_11));
  highp vec4 tmpvar_13;
  tmpvar_13 = (LIGHT_CAMERA_VIEW * tmpvar_11);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_4 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3)));
  xlv_TEXCOORD5 = tmpvar_2;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - tmpvar_6.xyz);
  xlv_TEXCOORD2 = (LIGHT_POSITION - tmpvar_6.xyz);
  xlv_TEXCOORD3 = (tmpvar_8 * (tmpvar_12 / tmpvar_12.w)).xyz;
  xlv_TEXCOORD4 = (((
    -(tmpvar_13.z)
   / tmpvar_13.w) - LIGHT_CAMERA_LINEARPARAM.x) * LIGHT_CAMERA_LINEARPARAM.y);
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : require

#line 20
struct LightInput {
    highp vec3 lightColor;
    highp vec3 viewDir;
    highp vec3 lightDir;
    highp vec3 normalDir;
    highp float atten;
    highp vec3 emission;
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
};
#line 9
struct SurfaceInput {
    highp vec3 albedo;
    highp vec3 specular;
    highp float gloss;
    highp vec3 emission;
    highp vec3 worldNormal;
    highp vec3 worldPos;
    highp float atten;
};
#line 29
struct v2f {
    highp vec2 uv;
    highp vec4 vertex;
    highp vec4 worldnormal;
    highp vec3 viewDirection;
    highp vec3 lightDirection;
    highp vec3 LightCoord;
    highp float OrigDepth;
};
#line 21
struct appdata {
    highp vec4 vertex;
    highp vec2 uv;
    highp vec3 normal;
};
#line 5
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
#line 9
uniform highp mat4 CAMERA_PROJECTION;
uniform highp mat4 LOCALSCREEN_TRANSVIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
#line 13
uniform highp vec3 LIGHT_POSITION;
uniform highp vec3 WORLD_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
#line 17
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
#line 21
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp vec2 CAMERA_RESOLUTION;
#line 25
uniform highp vec2 CAMERA_RESOLUTION_INV;
uniform highp vec2 CAMERA_RESOLUTION_HALF_INV;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform sampler2D TEXTURE_GRAP;
#line 32
uniform highp float DEVICE_COORDINATE_Y_FLIP;
#line 86
#line 92
#line 97
#line 102
#line 107
#line 112
#line 117
#line 124
#line 129
#line 144
#line 8
#line 18
#line 27
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
#line 35
#line 40
#line 58
#line 79
#line 95
#line 118
#line 154
#line 196
#line 245
#line 318
#line 33
#line 91
#line 41
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
#line 84
highp vec4 frag( in v2f i ) {
    #line 87
    highp vec4 col = texture2D( TEXTURE_DIFFUSE, i.uv);
    highp vec3 diffuse = vec3( 1.0, 1.0, 1.0);
    #line 91
    highp vec4 depthColor = shadow2D( TEXTURE_SHADOW_DEPTH, vec3( i.uv, 0.0));
    const highp vec4 bitShifts = vec4( 1.0, 0.00390625, 1.525879e-5, 5.960464e-8);
    #line 96
    highp float TexDepth = dot( depthColor, bitShifts);
    #line 188
    return vec4( (diffuse * col.xyz), col.w);
}
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main() {
    highp vec4 xl_retval;
    v2f xlt_i;
    xlt_i.uv = vec2(xlv_TEXCOORD0);
    xlt_i.vertex = vec4(0.0);
    xlt_i.worldnormal = vec4(xlv_TEXCOORD5);
    xlt_i.viewDirection = vec3(xlv_TEXCOORD1);
    xlt_i.lightDirection = vec3(xlv_TEXCOORD2);
    xlt_i.LightCoord = vec3(xlv_TEXCOORD3);
    xlt_i.OrigDepth = float(xlv_TEXCOORD4);
    xl_retval = frag( xlt_i);
    gl_FragData[0] = vec4(xl_retval);
}
/* NOTE: GLSL optimization failed
(92,26): error: no matching function for call to `shadow2D(sampler2DShadow, vec3)'; candidates are:
*/
]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_5;
  tmpvar_5[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_5[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_5[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_5 * _glesNormal));
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_6 = (LOCALWORLD_TRANSFORM * tmpvar_7);
  highp mat4 tmpvar_8;
  tmpvar_8[0].x = 0.5;
  tmpvar_8[0].y = 0.0;
  tmpvar_8[0].z = 0.0;
  tmpvar_8[0].w = 0.5;
  tmpvar_8[1].x = 0.0;
  tmpvar_8[1].y = 0.5;
  tmpvar_8[1].z = 0.0;
  tmpvar_8[1].w = 0.5;
  tmpvar_8[2].x = 0.0;
  tmpvar_8[2].y = 0.0;
  tmpvar_8[2].z = 0.5;
  tmpvar_8[2].w = 0.5;
  tmpvar_8[3].x = 0.0;
  tmpvar_8[3].y = 0.0;
  tmpvar_8[3].z = 0.0;
  tmpvar_8[3].w = 1.0;
  highp vec4 tmpvar_9;
  tmpvar_9.w = 0.0;
  tmpvar_9.xyz = tmpvar_6.xyz;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 0.0;
  tmpvar_10.xyz = (0.005 * tmpvar_2.xyz);
  highp vec4 tmpvar_11;
  tmpvar_11 = (tmpvar_9 - tmpvar_10);
  highp vec4 tmpvar_12;
  tmpvar_12 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * tmpvar_11));
  highp vec4 tmpvar_13;
  tmpvar_13 = (LIGHT_CAMERA_VIEW * tmpvar_11);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_4 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3)));
  xlv_TEXCOORD5 = tmpvar_2;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - tmpvar_6.xyz);
  xlv_TEXCOORD2 = (LIGHT_POSITION - tmpvar_6.xyz);
  xlv_TEXCOORD3 = (tmpvar_8 * (tmpvar_12 / tmpvar_12.w)).xyz;
  xlv_TEXCOORD4 = (((
    -(tmpvar_13.z)
   / tmpvar_13.w) - LIGHT_CAMERA_LINEARPARAM.x) * LIGHT_CAMERA_LINEARPARAM.y);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_DIFFUSE;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 col_1;
  lowp vec4 tmpvar_2;
  tmpvar_2 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  col_1 = tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.xyz = col_1.xyz;
  tmpvar_3.w = col_1.w;
  gl_FragData[0] = tmpvar_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"PointLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec3 tmpvar_3;
  highp float tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_7;
  tmpvar_7[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_7[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_7[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_7 * _glesNormal));
  highp vec4 tmpvar_8;
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = tmpvar_1.xyz;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
  xlv_TEXCOORD5 = tmpvar_2;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - tmpvar_8.xyz);
  xlv_TEXCOORD2 = (LIGHT_POSITION - tmpvar_8.xyz);
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D TEXTURE_DIFFUSE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD2;
void main ()
{
  mediump vec3 vLight_1;
  mediump vec3 vNormal_2;
  lowp float g_fAttenuation_3;
  mediump float disRange_4;
  mediump float dis_5;
  highp vec4 col_6;
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  col_6 = tmpvar_7;
  highp float tmpvar_8;
  tmpvar_8 = sqrt(dot (xlv_TEXCOORD2, xlv_TEXCOORD2));
  dis_5 = tmpvar_8;
  highp float tmpvar_9;
  tmpvar_9 = clamp ((dis_5 * LIGHT_RANGE_INV), 0.0, 1.0);
  disRange_4 = tmpvar_9;
  highp float tmpvar_10;
  tmpvar_10 = ((1.0 - disRange_4) / ((LIGHT_ATTENUATION.x + 
    (disRange_4 * LIGHT_ATTENUATION.y)
  ) + (
    (disRange_4 * disRange_4)
   * LIGHT_ATTENUATION.z)));
  g_fAttenuation_3 = tmpvar_10;
  highp vec3 tmpvar_11;
  tmpvar_11 = normalize(xlv_TEXCOORD5).xyz;
  vNormal_2 = tmpvar_11;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(xlv_TEXCOORD2);
  vLight_1 = tmpvar_12;
  mediump float tmpvar_13;
  tmpvar_13 = clamp (dot (vLight_1, vNormal_2), 0.0, 1.0);
  highp vec4 tmpvar_14;
  tmpvar_14.xyz = ((AMBIENT_COLOR + (
    (tmpvar_13 * g_fAttenuation_3)
   * LIGHT_COLOR)) * col_6.xyz);
  tmpvar_14.w = col_6.w;
  gl_FragData[0] = tmpvar_14;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"PointLight","ShadowOn"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_LINEARPARAM",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 LIGHT_CAMERA_LINEARPARAM;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp mat3 tmpvar_5;
  tmpvar_5[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_5[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_5[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_5 * _glesNormal));
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_6 = (LOCALWORLD_TRANSFORM * tmpvar_7);
  highp mat4 tmpvar_8;
  tmpvar_8[0].x = 0.5;
  tmpvar_8[0].y = 0.0;
  tmpvar_8[0].z = 0.0;
  tmpvar_8[0].w = 0.5;
  tmpvar_8[1].x = 0.0;
  tmpvar_8[1].y = 0.5;
  tmpvar_8[1].z = 0.0;
  tmpvar_8[1].w = 0.5;
  tmpvar_8[2].x = 0.0;
  tmpvar_8[2].y = 0.0;
  tmpvar_8[2].z = 0.5;
  tmpvar_8[2].w = 0.5;
  tmpvar_8[3].x = 0.0;
  tmpvar_8[3].y = 0.0;
  tmpvar_8[3].z = 0.0;
  tmpvar_8[3].w = 1.0;
  highp vec4 tmpvar_9;
  tmpvar_9.w = 0.0;
  tmpvar_9.xyz = tmpvar_6.xyz;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 0.0;
  tmpvar_10.xyz = (0.005 * tmpvar_2.xyz);
  highp vec4 tmpvar_11;
  tmpvar_11 = (tmpvar_9 - tmpvar_10);
  highp vec4 tmpvar_12;
  tmpvar_12 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * tmpvar_11));
  highp vec4 tmpvar_13;
  tmpvar_13 = (LIGHT_CAMERA_VIEW * tmpvar_11);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_4 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3)));
  xlv_TEXCOORD5 = tmpvar_2;
  xlv_TEXCOORD1 = (CAMERA_WORLDPOSITION - tmpvar_6.xyz);
  xlv_TEXCOORD2 = (LIGHT_POSITION - tmpvar_6.xyz);
  xlv_TEXCOORD3 = (tmpvar_8 * (tmpvar_12 / tmpvar_12.w)).xyz;
  xlv_TEXCOORD4 = (((
    -(tmpvar_13.z)
   / tmpvar_13.w) - LIGHT_CAMERA_LINEARPARAM.x) * LIGHT_CAMERA_LINEARPARAM.y);
}

]===],
		psShader = [===[uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D TEXTURE_DIFFUSE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD4;
void main ()
{
  highp float expFactor_1;
  lowp float attenAngle_2;
  mediump vec3 vLight_3;
  mediump vec3 vNormal_4;
  lowp float g_fAttenuation_5;
  mediump float disRange_6;
  mediump float dis_7;
  highp vec3 diffuse_8;
  highp vec4 col_9;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  col_9 = tmpvar_10;
  diffuse_8 = vec3(1.0, 1.0, 1.0);
  highp float tmpvar_11;
  tmpvar_11 = sqrt(dot (xlv_TEXCOORD2, xlv_TEXCOORD2));
  dis_7 = tmpvar_11;
  highp float tmpvar_12;
  tmpvar_12 = clamp ((dis_7 * LIGHT_RANGE_INV), 0.0, 1.0);
  disRange_6 = tmpvar_12;
  highp float tmpvar_13;
  tmpvar_13 = ((1.0 - disRange_6) / ((LIGHT_ATTENUATION.x + 
    (disRange_6 * LIGHT_ATTENUATION.y)
  ) + (
    (disRange_6 * disRange_6)
   * LIGHT_ATTENUATION.z)));
  g_fAttenuation_5 = tmpvar_13;
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(xlv_TEXCOORD5).xyz;
  vNormal_4 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(xlv_TEXCOORD2);
  vLight_3 = tmpvar_15;
  mediump float tmpvar_16;
  tmpvar_16 = clamp (dot (vLight_3, vNormal_4), 0.0, 1.0);
  highp float tmpvar_17;
  tmpvar_17 = clamp ((1.0 - (
    (LIGHT_INNER_DIFF_INV.x - dot (vLight_3, -(LIGHT_GIVEN_DIRECTION)))
   * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0);
  attenAngle_2 = tmpvar_17;
  g_fAttenuation_5 = (g_fAttenuation_5 * attenAngle_2);
  highp float tmpvar_18;
  tmpvar_18 = exp((60.0 * (
    dot (texture2D (TEXTURE_SHADOW_DEPTH, xlv_TEXCOORD0), vec4(1.0, 0.00390625, 1.525879e-5, 5.960464e-8))
   - xlv_TEXCOORD4)));
  expFactor_1 = tmpvar_18;
  if ((tmpvar_18 > 1.0)) {
    expFactor_1 = 1.0;
  };
  diffuse_8 = (AMBIENT_COLOR + ((
    (tmpvar_16 * g_fAttenuation_5)
   * LIGHT_COLOR) * expFactor_1));
  highp vec4 tmpvar_19;
  tmpvar_19.xyz = (diffuse_8 * col_9.xyz);
  tmpvar_19.w = col_9.w;
  gl_FragData[0] = tmpvar_19;
}

]===],
	},
}

end

function Depth()

	COLOR_MASK = COLOR_RGBA
	ALPAH_MODE = { ALPAH_OFF }
	DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
	STENCIL_MODE = { STENCIL_OFF }
	LIGHT_MODE = { DEPTHPASS }

	
Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_LINEARPARAMBIAS",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			},
		vsShader = [===[attribute vec4 _glesVertex;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 CAMERA_LINEARPARAMBIAS;
varying highp float xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  tmpvar_2.w = 1.0;
  tmpvar_2.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_3;
  tmpvar_3.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_3.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = (LOCALWORLD_TRANSFORM * tmpvar_4).xyz;
  highp vec4 tmpvar_6;
  tmpvar_6 = (CAMERA_VIEW * tmpvar_5);
  gl_Position = (tmpvar_3 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_2)));
  xlv_TEXCOORD0 = ((-(
    (tmpvar_6.xyz / tmpvar_6.w)
  .z) - CAMERA_LINEARPARAMBIAS.x) * CAMERA_LINEARPARAMBIAS.y);
}

]===],
		psShader = [===[varying highp float xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.x = xlv_TEXCOORD0;
  tmpvar_1.y = fract((xlv_TEXCOORD0 * 256.0));
  tmpvar_1.z = fract((xlv_TEXCOORD0 * 65536.0));
  tmpvar_1.w = fract((xlv_TEXCOORD0 * 1.677722e+7));
  highp vec4 tmpvar_2;
  tmpvar_2 = (tmpvar_1 - (tmpvar_1.yzww * vec4(0.003921569, 0.003921569, 0.003921569, 0.0)));
  gl_FragData[0] = tmpvar_2;
}

]===],
	},
}

end
