#SHADER_DEFINE MosaicVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
   
	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    gl_Position = in_Position;
    vec2 out_TexCooridate = in_TexCooridate.xy;
#END_CODE
#END_DEFINE

#SHADER_DEFINE MosaicFragment

	FUNCTION_INPUT = 
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"uniCurrentTexture" },
        { TARGETSIZE,            HIGH, VEC2,   "texture_size"},
		{ ATTRIBUTE_COORDNATE0,		HIGH,	VEC2,		"textureCoordinate"},
		{ MOSAIC_SIZE,              HIGH,   VEC2,        "mosaicSize"},
		{ MOSAIC_CENTER,         HIGH,    VEC2,         "mosaicCenter"},
	}
  
#SHADER_CODE
    vec2 singleMosaic = texture_size/mosaicSize;
    vec2 realCenter = mosaicCenter * texture_size;
    vec2 uv = textureCoordinate * texture_size ;//将纹理坐标映射到分辨率的大小
    uv = floor( (uv - realCenter) / singleMosaic) * singleMosaic + realCenter;//根据马赛克块大小进行取整
    vec2 output_uv = uv / texture_size;//把坐标重新映射回0,1的范围之内
    if(mosaicSize.x <= 1.0){
        output_uv.x = textureCoordinate.x;
    }
    if(mosaicSize.y <= 1.0){
        output_uv.y = textureCoordinate.y;
    }
    vec4 output_color = texture2D(uniCurrentTexture, output_uv);
    gl_FragColor = output_color;
#END_CODE
#END_DEFINE


   
   