//////////////////////////////////////////////////////////////////////////////////////
//
//						The Bohge Engine License (BEL)
//
//	Copyright (c) 2011-2014 Peng Zhao
//
//	Permission is hereby granted, free of charge, to any person obtaining a copy
//	of this software and associated documentation files (the "Software"), to deal
//	in the Software without restriction, including without limitation the rights
//	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//	copies of the Software, and to permit persons to whom the Software is
//	furnished to do so, subject to the following conditions:
//
//	The above copyright notice and this permission notice shall be included in
//	all copies or substantial portions of the Software. And the logo of
//	Bohge Engine shall be displayed full screen for more than 3 seconds
//	when the software is started. Copyright holders are allowed to develop
//	game edit based on Bohge Engine, The edit must be released under the MIT
//	open source license if it is going to be published. In no event shall
//	copyright holders be prohibited from using any code of Bohge Engine
//	to develop any other analogous game engines.
//
//	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//
//////////////////////////////////////////////////////////////////////////////////////



#SHADER_DEFINE Texture2DSampling

  FUNCTION_INPUT =
  {
      { TANGENT_DIRECTION,        MEDIUM, VEC3,   "tangentDir"},
      { ATTRIBUTE_COORDNATE0,			MEDIUM,		VEC2,					"in_Coordinate" },
    { TANGENTSPACE_VIEWDIRECTION,	HIGH, 	VEC3,	  "viewDirection" },
    { TANGENTSPACE_LIGHTDIRECTION,    MEDIUM,		VEC3,		"lightDirection"},
      { LIGHT_COLOR, 							MEDIUM,		VEC3,					"lightColor"},
      { TEXTURE_DIFFUSE,			  NONE,			TEXTURE2D,		"diffuseMap" },
      { TEXTURE_LOOKUP1,			  NONE,			TEXTURE2D,		"lookup1" },
      { TEXTURE_LOOKUP2,			  NONE,			TEXTURE2D,		"lookup2" },
  }
  FUNCTION_OUTPUT =
  {
      { LIGHTING_DIFFUSE,          MEDIUM,   VEC3,         "diffuseColor"},
      { M_COMPONENT,          MEDIUM,   VEC4,         "M"},
      { N_COMPONENT,          MEDIUM,   VEC4,         "N"},
  }

#SHADER_CODE
  lightDirection = -lightDirection;

  vec3 diffuseColor = texture2D(diffuseMap, in_Coordinate).rgb;

  vec3 tangent = tangentDir;

  float sini = dot(lightDirection, tangent);
  float sino = dot(viewDirection, tangent);
  vec2 uv1 = vec2(sini, sino);
  uv1 = uv1*0.5 + 0.5;

  vec3 lightPerp = lightDirection - sini * tangent;
  vec3 eyePerp = viewDirection - sino * tangent;
  float cosPhi = dot(eyePerp, lightPerp) / sqrt(dot(lightPerp,lightPerp) + dot(eyePerp,eyePerp));
  cosPhi = cosPhi * 0.5 + 0.5;

  vec4 M = texture2D(lookup1, uv1);
  float costhetaD = M.a;
  vec2 uv2 = vec2(costhetaD, cosPhi);
  vec4 N = texture2D(lookup2, uv2);

  diffuseColor = sqrt(max(0.0001, 1.0 - uv1.x*uv1.x)) * diffuseColor * lightColor;

#END_CODE
#END_DEFINE


//计算头发的直接光照
#SHADER_DEFINE HairLighting

  FUNCTION_INPUT =
  {
    { M_COMPONENT,          MEDIUM,   VEC4,         "M"},
    { N_COMPONENT,          MEDIUM,   VEC4,         "N"},
    { LIGHT_COLOR, 							MEDIUM,		VEC3,					"lightColor"},
    { AMBIENT_COLOR,          LOW,  VEC3,           "ambientColor"},
  }
  FUNCTION_OUTPUT =
  {
    { LIGHTING_SPECULAR,			MEDIUM,	VEC3,	    	"light_Specular" },
    { LIGHTING_AMBIENT,          LOW,  VEC3,           "ambient"},
  }
#SHADER_CODE

  costhetaD = (M.a-0.5) * 2.0;

  vec3 light_Specular = vec3(( M.r * N.r + M.g * N.g + M.b * N.b ) / (costhetaD * costhetaD));

  vec3 ambient = ambientColor * lightColor;

#END_CODE
#END_DEFINE


//输出到片元
#SHADER_DEFINE FragmentOutput

    FUNCTION_INPUT =
    {
			{ LIGHTING_DIFFUSE,				MEDIUM,	VEC3,		"light_Diffuse" },
			{ LIGHTING_SPECULAR,			MEDIUM,	VEC3,		"light_Specular" },
      { LIGHTING_AMBIENT,          LOW,  VEC3,   "light_Ambient"},
      { DIFFUSE_SCALE,          MEDIUM,   FLOAT,        "diffuseScale" },
      { SPECULAR_SCALE,          MEDIUM,   FLOAT,        "specScale" },
    }
    FUNCTION_OUTPUT = { }

#SHADER_CODE
		vec3 color =  light_Specular * specScale + light_Diffuse * diffuseScale + light_Ambient;

		gl_FragColor = vec4(color, 1.0);

#END_CODE
#END_DEFINE


//=============================================================================================加入阴影

#SHADER_DEFINE Texture2DSamplingShadow

  FUNCTION_INPUT =
  {
      { TANGENT_DIRECTION,        MEDIUM, VEC3,   "tangentDir"},
      { ATTRIBUTE_COORDNATE0,			MEDIUM,		VEC2,					"in_Coordinate" },
    { TANGENTSPACE_VIEWDIRECTION,	HIGH, 	VEC3,	  "viewDirection" },
    { TANGENTSPACE_LIGHTDIRECTION,    MEDIUM,		VEC3,		"lightDirection"},
      { LIGHT_COLOR, 							MEDIUM,		VEC3,					"lightColor"},
      { TEXTURE_DIFFUSE,			  NONE,			TEXTURE2D,		"diffuseMap" },
      { TEXTURE_LOOKUP1,			  NONE,			TEXTURE2D,		"lookup1" },
      { TEXTURE_LOOKUP2,			  NONE,			TEXTURE2D,		"lookup2" },
      { SHADOWMAP_COLOR,				HIGH,	VEC4,		"in_TransparentColor" },
  }
  FUNCTION_OUTPUT =
  {
      { LIGHTING_DIFFUSE,          MEDIUM,   VEC3,         "diffuseColor"},
      { M_COMPONENT,          MEDIUM,   VEC4,         "M"},
      { N_COMPONENT,          MEDIUM,   VEC4,         "N"},
  }

#SHADER_CODE
  lightDirection = -lightDirection;

  vec3 diffuseColor = texture2D(diffuseMap, in_Coordinate).rgb;

  vec3 tangent = tangentDir;

  float sini = dot(lightDirection, tangent);
  float sino = dot(viewDirection, tangent);
  vec2 uv1 = vec2(sini, sino);
  uv1 = uv1*0.5 + 0.5;

  vec3 lightPerp = lightDirection - sini * tangent;
  vec3 eyePerp = viewDirection - sino * tangent;
  float cosPhi = dot(eyePerp, lightPerp) / sqrt(dot(lightPerp,lightPerp) + dot(eyePerp,eyePerp));
  cosPhi = cosPhi * 0.5 + 0.5;

  vec4 M = texture2D(lookup1, uv1);
  float costhetaD = M.a;
  vec2 uv2 = vec2(costhetaD, cosPhi);
  vec4 N = texture2D(lookup2, uv2);

  diffuseColor = sqrt(max(0.0001, 1.0 - uv1.x*uv1.x)) * diffuseColor * mix(lightColor,in_TransparentColor.xyz,in_TransparentColor.a);

#END_CODE
#END_DEFINE

//计算头发的直接光照
#SHADER_DEFINE HairLightingShadow

  FUNCTION_INPUT =
  {
    { M_COMPONENT,          MEDIUM,   VEC4,         "M"},
    { N_COMPONENT,          MEDIUM,   VEC4,         "N"},
    { LIGHT_COLOR, 							MEDIUM,		VEC3,					"lightColor"},
    { AMBIENT_COLOR,          LOW,  VEC3,           "ambientColor"},
    { SHADOWMAP_COLOR,				HIGH,	VEC4,		"in_TransparentColor" },
  }
  FUNCTION_OUTPUT =
  {
    { LIGHTING_SPECULAR,			MEDIUM,	VEC3,	    	"light_Specular" },
    { LIGHTING_AMBIENT,          LOW,  VEC3,           "ambient"},
  }
#SHADER_CODE

  costhetaD = (M.a-0.5) * 2.0;

  vec3 light_Specular = vec3(( M.r * N.r + M.g * N.g + M.b * N.b ) / (costhetaD * costhetaD));

  vec3 ambient = ambientColor * mix(lightColor,in_TransparentColor.xyz,in_TransparentColor.a);

#END_CODE
#END_DEFINE

