#SHADER_DEFINE CharaSkinVertex

  FUNCTION_INPUT = 
	{
		{ ANIMATION_MATRIX_ARRAY,	HIGH,	VEC4_ARRAY,	"in_BoneMatrixArray", "300" },
		{ ATTRIBUTE_BONE_INEX,		HIGH,	VEC4,		"in_BoneIndex" },
		{ ATTRIBUTE_BONE_WEIGHT,	HIGH,	VEC4,		"in_Boneweight" },
		{ ATTRIBUTE_POSITION,		HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_NORMAL, 		HIGH,	VEC3,		"in_Normal" },
		{ ATTRIBUTE_TANGENT,		HIGH,	VEC4,		"in_Tangent" },

    
	}

	FUNCTION_OUTPUT = 
	{
		{ ATTRIBUTE_POSITION,	HIGH,	VEC4,		"out_Position" },
		{ ATTRIBUTE_NORMAL, 	HIGH,	VEC3,		"out_Normal" },
		{ ATTRIBUTE_TANGENT, 	HIGH,	VEC3,		"out_Tangent" },
	}
	
	#SHADER_CODE
		vec3 blendPos = vec3(0.0, 0.0, 0.0);
		vec3 blendNorm = vec3(0.0, 0.0, 0.0);
		vec3 blendTangent = vec3(0.0, 0.0, 0.0);

		for (int bone = 0; bone < 4; ++bone)
		{
      int idx = int(in_BoneIndex[bone]) * 3;

			float weight = in_Boneweight[bone];
      
      mat4 worldMatrix;
      worldMatrix[0] = vec4(in_BoneMatrixArray[idx]);
      worldMatrix[1] = vec4(in_BoneMatrixArray[idx + 1]);
      worldMatrix[2] = vec4(in_BoneMatrixArray[idx + 2]);
      worldMatrix[3] = vec4(0.0);
      
      blendPos += (in_Position * worldMatrix).xyz * weight;

      mat3 worldRotMtrix = mat3(worldMatrix[0].xyz,worldMatrix[1].xyz,worldMatrix[2].xyz);
      blendNorm += (in_Normal * worldRotMtrix) * weight;
			
      blendTangent += (worldRotMtrix * in_Tangent.xyz) * weight;
		}

		blendNorm = normalize(blendNorm);
		
		vec4 out_Position = vec4(blendPos,1.0);
		vec3 out_Normal	= blendNorm;
		vec3 out_Tangent = blendTangent;
	
	#END_CODE
#END_DEFINE



#SHADER_DEFINE CharaSkinFragmentOutput

	FUNCTION_INPUT = 
	{
		{ SURFACE_COLOR,	LOW,	VEC4,	"in_SurfaceColor" }
	}
	FUNCTION_OUTPUT = { }

#SHADER_CODE
    gl_FragColor = in_SurfaceColor;
    //gl_FragColor = vec4(1.0,0.0,0.0,1.0);
    
#END_CODE
#END_DEFINE



#SHADER_DEFINE CharaSkinVertexDir

	FUNCTION_INPUT = 
	{
    {CAMERA_WORLDPOSITION,HIGH,VEC3,"in_CameraPos"},
    { WORLDSPACE_POSITION,		HIGH,	VEC4,		"in_PositionWS" },
    {LIGHT_POSITION,HIGH,VEC4,"in_LightPos"},
    {LIGHT_GIVEN_DIRECTION,HIGH,VEC3,"in_LightDirection"},
     
    
	}
	
	FUNCTION_OUTPUT =
	{
		{ INTERNAL_EYETOOBJDIR,			HIGH,	VEC4,		"Out_EyeToObjDir" },
    { INTERNAL_LightTOOBJDIR,			HIGH,	VEC4,		"Out_LightToObjDir" },
	}
#SHADER_CODE

	// Eye direction vector
	vec4 Out_EyeToObjDir= normalize( vec4(in_CameraPos.xyz,1.0) - vec4(in_PositionWS.xyz/in_PositionWS.w,1.0) );
  vec4 Out_LightToObjDir= normalize( vec4(in_LightDirection.xyz,0.0));
#END_CODE
#END_DEFINE


#SHADER_DEFINE CharaSkinFragment
	FUNCTION_INPUT = 
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
		{ ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		"in_Coordinate" },
    { INTERNAL_EYETOOBJDIR,			MEDIUM,	VEC4,		"In_EyeToObjDir" },
    { INTERNAL_LightTOOBJDIR,			MEDIUM,	VEC4,		"In_LightToObjDir" },
    { WORLDSPACE_NORMAL, 		MEDIUM,	VEC3,		"In_Normal" },
    { TEXTURE_SKIN,		NONE,	TEXTURE2D,	"in_SkinTexture" },
    { TEXTURE_RIM,		NONE,	TEXTURE2D,	"in_RimTexture" },
    {LIGHT_COLOR,MEDIUM,VEC3,"in_LightColorIn"},
    {Main_Color,MEDIUM ,VEC4,"in_MainColor"},
    {Shadow_Color,MEDIUM,VEC4,"in_ShadowColor"},
    {Gamma_Value,MEDIUM,FLOAT,"in_GammaValue"},
    {FallofPower_Value,MEDIUM,FLOAT,"in_FallofPowerValue"},
    
    
	}
  FUNCTION_OUTPUT = 
	{
		{ SURFACE_COLOR,	LOW,	VEC4,		"out_TextureColor" },
	}
#SHADER_CODE

  vec3 In_NoramlStd = normalize(In_Normal);
 	vec4 diffSamplerColor = texture2D( in_DiffuseTexture, in_Coordinate  );
  float gamma =in_GammaValue;
  diffSamplerColor = vec4(pow(diffSamplerColor.rgb,vec3(gamma,gamma,gamma)),diffSamplerColor.a);
	float normalDotEye = dot( In_NoramlStd, In_EyeToObjDir.xyz );
	float falloffU = clamp( 1.0 - abs( normalDotEye ), 0.02, 0.98 );
  float FALLOFF_POWER = in_FallofPowerValue;
  vec4 skinTexColor = texture2D( in_SkinTexture, vec2( falloffU, 0.25));
  skinTexColor =  vec4(pow(skinTexColor.rgb, vec3(gamma,gamma,gamma) ),skinTexColor.a);
  vec4 falloffSamplerColor = FALLOFF_POWER * skinTexColor;
  vec3 combinedColor = (1.0-falloffSamplerColor.a)*diffSamplerColor.rgb+falloffSamplerColor.a*falloffSamplerColor.rgb * diffSamplerColor.rgb;
  
	// Rimlight
  float rimlightDot = clamp( 0.5 * ( dot(In_NoramlStd,In_LightToObjDir.xyz ) + 1.0 ) ,0.0,1.0);
  falloffU = clamp( rimlightDot * falloffU,0.0,1.0);
  float rimTexColorr = texture2D( in_RimTexture, vec2( falloffU, 0.25 ) ).r;
  rimTexColorr = pow(rimTexColorr, gamma );
  falloffU = rimTexColorr;
	//falloffU = texture2D( in_RimTexture, vec2( falloffU, 0.25 ) ).r;
	vec3 lightColor = diffSamplerColor.rgb * 0.5; // * 2.0;
	combinedColor = combinedColor +falloffU * lightColor;
  vec4 color =in_MainColor;
  vec4 in_LightColor = vec4(in_LightColorIn.rgb,1.0);

  float outgamma = 1.0/(gamma)*1.0;
  vec4 outColor =  vec4(combinedColor.rgb,diffSamplerColor.a)*color*in_LightColor;
  outColor = vec4(pow(outColor.rgb,vec3(outgamma,outgamma,outgamma)).rgb,outColor.a);
  vec4 out_TextureColor = outColor;
    
#END_CODE
#END_DEFINE