#SHADER_DEFINE OverlayVertex

    FUNCTION_INPUT = 
    {
        { ATTRIBUTE_POSITION,        HIGH,    VEC4,        "in_Position" },
        { ATTRIBUTE_COORDNATE0,      HIGH,    VEC2,        "in_TexCoordinate" },
    }
    FUNCTION_OUTPUT =
    {
        { ATTRIBUTE_COORDNATE0,      HIGH,    VEC2,        "out_TexCoordinate" },
    }

#SHADER_CODE

    gl_Position = in_Position;
    vec2 out_TexCoordinate = in_TexCoordinate.xy;

#END_CODE
#END_DEFINE


#SHADER_DEFINE  OverlayFragment

    FUNCTION_INPUT = 
    {
        { TEXTURE_DIFFUSE,           NONE,      TEXTURE2D,   "in_DiffuseTexture" },
        { TEXTURE_BLEND,             NONE,      TEXTURE2D,   "in_BlendTexture"},
        { ATTRIBUTE_COORDNATE0,      HIGH,      VEC2,        "in_TexCoordinate" },
    }

#SHADER_CODE
    vec3 w = vec3(0.2125,0.7154,0.0721);
    vec3 basecolor = texture2D(in_DiffuseTexture, in_TexCoordinate).rgb;
    vec3 blendcolor = texture2D(in_BlendTexture,  in_TexCoordinate).rgb;
    float l = dot(basecolor,w);
    vec3 rgb = (l < 0.5)? (2.0 * basecolor * blendcolor) : (vec3(1.0) - 2.0*(vec3(1.0) - basecolor)*(vec3(1.0) - blendcolor));
    gl_FragColor = vec4(rgb, 1.0);
#END_CODE
#END_DEFINE



//=====================================================================================后处理嘴部水润提亮
#SHADER_DEFINE OverlayBrightenVertexPe

    FUNCTION_INPUT = 
    {
        { ATTRIBUTE_POSITION,        HIGH,    VEC4,        "in_Position" },
        { ATTRIBUTE_COORDNATE0,      HIGH,    VEC2,        "in_TexCoordinate" },
    }
    FUNCTION_OUTPUT =
    {
        { ATTRIBUTE_COORDNATE0,      HIGH,    VEC2,        "out_TexCoordinate" },
    }

#SHADER_CODE

    gl_Position = in_Position;
    vec2 out_TexCoordinate = in_TexCoordinate.xy;

#END_CODE
#END_DEFINE


#SHADER_DEFINE  OverlayBrightenFragmentPe

    FUNCTION_INPUT = 
    {
        { ATTRIBUTE_COORDNATE0,      HIGH,      VEC2,        "in_TexCoordinate" },
        { TEXTURE_DIFFUSE,           NONE,      TEXTURE2D,   "in_DiffuseTexture" },
        { TEXTURE_BLEND,             NONE,      TEXTURE2D,   "in_BlendTexture"},
    }

#SHADER_CODE
    vec4 oricolor = texture2D(in_DiffuseTexture, in_TexCoordinate);
    vec3 basecolor = oricolor.rgb;
    vec3 blendcolor = texture2D(in_BlendTexture,  vec2(in_TexCoordinate.x,1.0 - in_TexCoordinate.y)).rgb;
   
    if (basecolor.r < 0.5) {
      basecolor.r = 2.0 * blendcolor.g * basecolor.r;
    } 
    else {
      basecolor.r = 1.0 - 2.0 * (1.0 - blendcolor.g) * (1.0 - basecolor.r);
    }
    
    if (basecolor.g < 0.5) {
      basecolor.g = 2.0 * blendcolor.g * basecolor.g;
    } 
    else {
      basecolor.g = 1.0 - 2.0 * (1.0 - blendcolor.g) * (1.0 - basecolor.g);
    }
       
    if (basecolor.b < 0.5) {
      basecolor.b = 2.0 * blendcolor.g * basecolor.b;
    }
    else {
      basecolor.b = 1.0 - 2.0 * (1.0 - blendcolor.g) * (1.0 - basecolor.b);
    }
    
    basecolor = mix(oricolor.rgb,basecolor,blendcolor.r);
    basecolor = vec3(1.0) - (vec3(1.0) - basecolor) * vec3(1.0 - blendcolor.b);
    gl_FragColor = vec4(basecolor, oricolor.a);
#END_CODE
#END_DEFINE



//=====================================================================================利用mask的嘴部水润提亮
#SHADER_DEFINE OverlayBrightenVertex

    FUNCTION_INPUT = 
    {
        { ATTRIBUTE_POSITION,           HIGH,    VEC4,        "in_Position" },
        { ATTRIBUTE_COORDNATE0,         HIGH,    VEC2,        "in_TexCoordinate" },
        { ATTRIBUTE_COORDNATE2,         HIGH,    VEC2,        "in_TexCooridatestd"},
        { UNIFORM_FACETEXPARA,          HIGH,    VEC4,        "in_facetexpara" },
    }
    FUNCTION_OUTPUT =
    {
        { ATTRIBUTE_COORDNATE0,         HIGH,     VEC2,         "out_TexCoordinate" },
        { ATTRIBUTE_COORDNATE1,         HIGH,     VEC2,       "out_TexCooridateBag" },
        { ATTRIBUTE_COORDNATE2,         HIGH,     VEC2,       "out_TexCooridatestd" },
    }

#SHADER_CODE

    gl_Position = in_Position;
    vec2 out_TexCoordinate = vec2(in_TexCoordinate.x,1.0 - in_TexCoordinate.y);
    vec2 out_TexCooridateBag;
    out_TexCooridateBag=(vec2(1.0,1.0)+in_Position.xy)/2.0;
    //out_TexCooridateBag = vec2(out_TexCooridateBag.x,1.0 - out_TexCooridateBag.y);
    vec2 out_TexCooridatestd = in_TexCooridatestd.xy*vec2(in_facetexpara.x,in_facetexpara.y)+vec2(in_facetexpara.z,in_facetexpara.w);
#END_CODE
#END_DEFINE


#SHADER_DEFINE  OverlayBrightenFragment

    FUNCTION_INPUT = 
    {
        { ATTRIBUTE_COORDNATE0,         HIGH,           VEC2,        "in_TexCoordinate" },
        { ATTRIBUTE_COORDNATE1,         HIGH,           VEC2,      "in_TexCooridateBag" },
        { ATTRIBUTE_COORDNATE2,         HIGH,           VEC2,      "in_TexCooridatestd" },
        { TEXTURE_DIFFUSE,              NONE,      TEXTURE2D,       "in_DiffuseTexture" },
        { TEXTURE_BLEND,                NONE,      TEXTURE2D,         "in_BlendTexture" },
        { TEXTURE_MASK,                 NONE,      TEXTURE2D,         "in_MaskTexture"  },
    }

#SHADER_CODE
    vec4 oricolor = texture2D(in_DiffuseTexture, in_TexCooridateBag);
    vec4 MaskColor = texture2D(in_MaskTexture, in_TexCooridatestd);
    vec3 basecolor = oricolor.rgb;
    vec3 blendcolor = texture2D(in_BlendTexture,  vec2(in_TexCooridateBag.x, 1.0  - in_TexCooridateBag.y)).rgb;
   
    if (basecolor.r < 0.5) {
      basecolor.r = 2.0 * blendcolor.g * basecolor.r;
    } 
    else {
      basecolor.r = 1.0 - 2.0 * (1.0 - blendcolor.g) * (1.0 - basecolor.r);
    }
    
    if (basecolor.g < 0.5) {
      basecolor.g = 2.0 * blendcolor.g * basecolor.g;
    } 
    else {
      basecolor.g = 1.0 - 2.0 * (1.0 - blendcolor.g) * (1.0 - basecolor.g);
    }
       
    if (basecolor.b < 0.5) {
      basecolor.b = 2.0 * blendcolor.g * basecolor.b;
    }
    else {
      basecolor.b = 1.0 - 2.0 * (1.0 - blendcolor.g) * (1.0 - basecolor.b);
    }
    
    basecolor = mix(oricolor.rgb,basecolor,MaskColor.a);
    basecolor = vec3(1.0) - (vec3(1.0) - basecolor) * vec3(1.0 - blendcolor.b);
    gl_FragColor = vec4(basecolor, oricolor.a);
#END_CODE
#END_DEFINE




