
#SHADER_DEFINE AlphaChangeVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},

	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
    { ATTRIBUTE_COORDNATE1,			HIGH,	VEC2,		"out_pos" },
	}

#SHADER_CODE
    vec2 out_TexCooridate = in_TexCooridate.xy;
    vec2 out_pos = in_Position.xy;
    gl_Position = in_Position;
#END_CODE
#END_DEFINE


#SHADER_DEFINE AlphaChangeFragment

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_COORDNATE0,		HIGH,	VEC2,		"textureCoordinate"},
    { TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"texture" },
    {ALPHA_ZOOMSCALE,HIGH,	FLOAT,	  "in_zoomscale"},
    { ALPHA_ALPHAVALUE, HIGH,	FLOAT,	  "in_alpha" },
    { ALPHA_XYOFFSET, HIGH,	VEC2,	  "in_offset" },
	}
  
  FUNCTION_OUTPUT = 
	{
	//	{ SURFACE_COLOR,		LOW,	VEC4,		"out_SurfaceColor" },
	}
  
#SHADER_CODE

  float zoomscale = in_zoomscale/100.0;
  float alpha =in_alpha;
  vec2 coord = textureCoordinate-vec2(0.5,0.5);
  coord = coord/zoomscale+vec2(0.5,0.5)+in_offset;
  vec4 out_SurfaceColor =  texture2D(texture,textureCoordinate).rgba*(1.0-alpha)+texture2D(texture,coord).rgba*alpha;
  //out_SurfaceColor = vec4(1.0,0.0,0.0,1.0)*out_SurfaceColor;
  gl_FragColor = out_SurfaceColor;
  
#END_CODE
#END_DEFINE
