

#DEFPARAMS
TEXTURE_DIFFUSE = { "main Color", TEXTURE2D, "white" },
BOLD = {"bold", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName = "sdffont2d"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "light.inc"

struct appdata
{
    float2 vertex : POSITION;
    float2 uv : TEXCOORD0;
    float4 color : COLOR0;
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 vertex : SV_POSITION;
    float4 color : COLOR0;
};

sampler2D TEXTURE_DIFFUSE;
float BOLD;

v2f vert(appdata v)
{
    v2f o;
    float2 in_WorldScale =mul(float4(1.0,1.0,1.0,1.0), LOCALWORLD_TRANSFORM).xy;
    float2 in_WorldPosition = WORLD_POSITION.xy;
    float4 pos = float4(v.vertex * in_WorldScale * CAMERA_RESOLUTION_INV + in_WorldPosition.xy * CAMERA_RESOLUTION_HALF_INV,0.0,1.0);
    o.vertex = UniformNDC(pos);
    o.uv = v.uv.xy;
    o.color = v.color;
    return o;
}

float4 frag(v2f i) : SV_Target
{
    float distance_mark = 0.5;
    float smooth_delta = 0.1;
    float4 col = tex2D(TEXTURE_DIFFUSE, i.uv);
    float distance = col.a + 0.2*BOLD;
    col.a = smoothstep(distance_mark - smooth_delta, distance_mark + smooth_delta, distance);
    col.rgb = i.color.rgb;
    return col;
}
ENDCG
#END
