

function DefineParams()
	Properties = 
	{
		
UNIFORM_SCALE_R = { "ScaleR", VEC2, "1.0, 1.0"},
UNIFORM_SCALE_G = { "ScaleG", VEC2, "1.0, 1.0"},
UNIFORM_SCALE_B = { "ScaleB", VEC2, "1.0, 1.0"},
UNIFORM_OFFSET_R = { "OffsetR", VEC2, "0.0, 0.0"},
UNIFORM_OFFSET_G = { "OffsetG", VEC2, "0.0, 0.0"},
UNIFORM_OFFSET_B = { "OffsetB", VEC2, "0.0, 0.0"},
UNIFORM_USE_BORDER = { "UseBorder", VEC2, "1.0, 1.0"},

POST_EFFECT_ALPHA = {"post_effect_alpha", FLOAT, "0.0"},

	}
	Attributes = 
	{
		POST_EFFECT_ALPHA = "Keywords(POST_EFFECT_ALPHA_ON,POST_EFFECT_ALPHA_OFF)", 
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "rgbseperate"
RenderQueue = "PostEffect"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {"POST_EFFECT_ALPHA_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_SCALE_R",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_SCALE_G",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_SCALE_B",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_OFFSET_R",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_OFFSET_G",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_OFFSET_B",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_SCREEN",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_USE_BORDER",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 UNIFORM_SCALE_R;
uniform highp vec2 UNIFORM_SCALE_G;
uniform highp vec2 UNIFORM_SCALE_B;
uniform highp vec2 UNIFORM_OFFSET_R;
uniform highp vec2 UNIFORM_OFFSET_G;
uniform highp vec2 UNIFORM_OFFSET_B;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_2;
  tmpvar_2 = ((_glesMultiTexCoord0.xy - 0.5) * 2.0);
  gl_Position = (tmpvar_1 * _glesVertex);
  xlv_TEXCOORD0 = (((
    (tmpvar_2 - (UNIFORM_OFFSET_R / 2.0))
   / UNIFORM_SCALE_R) / 2.0) + 0.5);
  xlv_TEXCOORD1 = (((
    (tmpvar_2 - (UNIFORM_OFFSET_G / 2.0))
   / UNIFORM_SCALE_G) / 2.0) + 0.5);
  xlv_TEXCOORD2 = (((
    (tmpvar_2 - (UNIFORM_OFFSET_B / 2.0))
   / UNIFORM_SCALE_B) / 2.0) + 0.5);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_SCREEN;
uniform highp vec2 UNIFORM_USE_BORDER;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec2 tempBA_1;
  highp vec2 tempGA_2;
  highp vec2 tempRA_3;
  highp vec4 color_4;
  lowp vec2 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_SCREEN, xlv_TEXCOORD0).xw;
  tempRA_3 = tmpvar_5;
  highp float tmpvar_6;
  if ((((
    (xlv_TEXCOORD0.x < 0.0)
   || 
    (xlv_TEXCOORD0.x > 1.0)
  ) && (UNIFORM_USE_BORDER.x > 0.0)) || ((
    (xlv_TEXCOORD0.y < 0.0)
   || 
    (xlv_TEXCOORD0.y > 1.0)
  ) && (UNIFORM_USE_BORDER.y > 0.0)))) {
    tmpvar_6 = 0.0;
  } else {
    tmpvar_6 = tempRA_3.x;
  };
  color_4.x = tmpvar_6;
  lowp vec2 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_SCREEN, xlv_TEXCOORD1).yw;
  tempGA_2 = tmpvar_7;
  highp float tmpvar_8;
  if ((((
    (xlv_TEXCOORD1.x < 0.0)
   || 
    (xlv_TEXCOORD1.x > 1.0)
  ) && (UNIFORM_USE_BORDER.x > 0.0)) || ((
    (xlv_TEXCOORD1.y < 0.0)
   || 
    (xlv_TEXCOORD1.y > 1.0)
  ) && (UNIFORM_USE_BORDER.y > 0.0)))) {
    tmpvar_8 = 0.0;
  } else {
    tmpvar_8 = tempGA_2.x;
  };
  color_4.y = tmpvar_8;
  lowp vec2 tmpvar_9;
  tmpvar_9 = texture2D (TEXTURE_SCREEN, xlv_TEXCOORD2).zw;
  tempBA_1 = tmpvar_9;
  highp float tmpvar_10;
  if ((((
    (xlv_TEXCOORD2.x < 0.0)
   || 
    (xlv_TEXCOORD2.x > 1.0)
  ) && (UNIFORM_USE_BORDER.x > 0.0)) || ((
    (xlv_TEXCOORD2.y < 0.0)
   || 
    (xlv_TEXCOORD2.y > 1.0)
  ) && (UNIFORM_USE_BORDER.y > 0.0)))) {
    tmpvar_10 = 0.0;
  } else {
    tmpvar_10 = tempBA_1.x;
  };
  color_4.z = tmpvar_10;
  color_4.w = (1.0 - ((
    (1.0 - tempRA_3.y)
   * 
    (1.0 - tempGA_2.y)
  ) * (1.0 - tempBA_1.y)));
  gl_FragData[0] = color_4;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"POST_EFFECT_ALPHA_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_SCALE_R",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_SCALE_G",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_SCALE_B",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_OFFSET_R",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_OFFSET_G",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_OFFSET_B",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_SCREEN",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_USE_BORDER",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 UNIFORM_SCALE_R;
uniform highp vec2 UNIFORM_SCALE_G;
uniform highp vec2 UNIFORM_SCALE_B;
uniform highp vec2 UNIFORM_OFFSET_R;
uniform highp vec2 UNIFORM_OFFSET_G;
uniform highp vec2 UNIFORM_OFFSET_B;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_2;
  tmpvar_2 = ((_glesMultiTexCoord0.xy - 0.5) * 2.0);
  gl_Position = (tmpvar_1 * _glesVertex);
  xlv_TEXCOORD0 = (((
    (tmpvar_2 - (UNIFORM_OFFSET_R / 2.0))
   / UNIFORM_SCALE_R) / 2.0) + 0.5);
  xlv_TEXCOORD1 = (((
    (tmpvar_2 - (UNIFORM_OFFSET_G / 2.0))
   / UNIFORM_SCALE_G) / 2.0) + 0.5);
  xlv_TEXCOORD2 = (((
    (tmpvar_2 - (UNIFORM_OFFSET_B / 2.0))
   / UNIFORM_SCALE_B) / 2.0) + 0.5);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_SCREEN;
uniform highp vec2 UNIFORM_USE_BORDER;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp float temp_1;
  highp vec4 color_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture2D (TEXTURE_SCREEN, xlv_TEXCOORD0);
  temp_1 = tmpvar_3.x;
  highp float tmpvar_4;
  if ((((
    (xlv_TEXCOORD0.x < 0.0)
   || 
    (xlv_TEXCOORD0.x > 1.0)
  ) && (UNIFORM_USE_BORDER.x > 0.0)) || ((
    (xlv_TEXCOORD0.y < 0.0)
   || 
    (xlv_TEXCOORD0.y > 1.0)
  ) && (UNIFORM_USE_BORDER.y > 0.0)))) {
    tmpvar_4 = 0.0;
  } else {
    tmpvar_4 = temp_1;
  };
  color_2.x = tmpvar_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_SCREEN, xlv_TEXCOORD1);
  temp_1 = tmpvar_5.y;
  highp float tmpvar_6;
  if ((((
    (xlv_TEXCOORD1.x < 0.0)
   || 
    (xlv_TEXCOORD1.x > 1.0)
  ) && (UNIFORM_USE_BORDER.x > 0.0)) || ((
    (xlv_TEXCOORD1.y < 0.0)
   || 
    (xlv_TEXCOORD1.y > 1.0)
  ) && (UNIFORM_USE_BORDER.y > 0.0)))) {
    tmpvar_6 = 0.0;
  } else {
    tmpvar_6 = temp_1;
  };
  color_2.y = tmpvar_6;
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_SCREEN, xlv_TEXCOORD2);
  temp_1 = tmpvar_7.z;
  highp float tmpvar_8;
  if ((((
    (xlv_TEXCOORD2.x < 0.0)
   || 
    (xlv_TEXCOORD2.x > 1.0)
  ) && (UNIFORM_USE_BORDER.x > 0.0)) || ((
    (xlv_TEXCOORD2.y < 0.0)
   || 
    (xlv_TEXCOORD2.y > 1.0)
  ) && (UNIFORM_USE_BORDER.y > 0.0)))) {
    tmpvar_8 = 0.0;
  } else {
    tmpvar_8 = temp_1;
  };
  color_2.z = tmpvar_8;
  color_2.w = 1.0;
  gl_FragData[0] = color_2;
}

]===],
	},
}

end
