

#DEFPARAMS
TEXTURE_ALDEBO = { "aldebo", TEXTURE2D, "white" },
TEXTURE_AMR = { "amr", TEXTURE2D, "white"},
TEXTURE_NORMAL = { "Normal Map", TEXTURE2D, "white" },
#END

#DEFTAG
ShaderName = "pbr_skeleton1bdual"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGB
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
	float3 normal : NORMAL;
	float3 tangent : TANGENT;
  //ANI_ATTRIBUTE
  float4 boneIndices:BLENDINDICES; 
  float4 boneWeight:BLENDWEIGHT;
};

struct v2f
{
	float4 vertex : SV_POSITION;
	float2 uv : TEXCOORD0;
	float3 TBN1 : TEXCOORD1;
	float3 TBN2 : TEXCOORD2;
	float3 TBN3 : TEXCOORD3;
	float3 viewDirection : COLOR0;
  float3 lightDirection : COLOR1; 
	float3 worldnormal : NORMAL;
	float3 worldtangent : TANGENT;
	float3 worldbinormal : BINORMAL;
};

uniform float4x4 ANIMATION_REAL_ARRAY;
uniform float4x4 ANIMATION_DUAL_ARRAY;
uniform float3x3 LOCALWORLD_ROTATION;

uniform sampler2D TEXTURE_ALDEBO;
uniform sampler2D TEXTURE_AMR;
uniform sampler2D TEXTURE_NORMAL;
uniform samplerCUBE SKY_BOX;

v2f vert(appdata v)
{
  int4 BoneIndices;
  BoneIndices.x = int(v.boneIndices.x);
  BoneIndices.y = int(v.boneIndices.y);
  BoneIndices.z = int(v.boneIndices.z);
  BoneIndices.a = int(v.boneIndices.a);
	
	float4 dp0 = ANIMATION_REAL_ARRAY[ BoneIndices[0] ];	
	float4 blend_real = float4(0,0,0,0);
	float4 blend_dual = float4(0,0,0,0);
	for (int i = 0; i < 3; ++ i)
	{
		float4 joint_real = ANIMATION_REAL_ARRAY[BoneIndices[i]];
		float4 joint_dual = ANIMATION_DUAL_ARRAY[BoneIndices[i]];

    if(dot(dp0,joint_real) < 0.0)
    {
      joint_real = -joint_real;
			joint_dual = -joint_dual;
    }
    
		float weight = v.boneWeight[i];
		

		blend_real += joint_real * weight;
		blend_dual += joint_dual * weight;
	}

	float inv_len = 1.0 / length(blend_real);
	blend_real *= inv_len;
	blend_dual *= inv_len;
	
	float3 pos = v.vertex.xyz + 2.0 * cross(blend_real.xyz, cross(blend_real.xyz, v.vertex.xyz) + blend_real.w * v.vertex.xyz);
	float3 trans = 2.0 * (blend_real.w * blend_dual.xyz - blend_dual.w * blend_real.xyz + cross(blend_real.xyz, blend_dual.xyz));
	pos += trans;

  float4 out_Position = float4( pos, v.vertex.w );
  float3 out_PositionWS  = float3(mul(LOCALWORLD_TRANSFORM, out_Position).xyz);
  float3 out_NormalWS = mul(LOCALWORLD_ROTATION, v.normal);
  float3 out_TangentWS =  mul(LOCALWORLD_ROTATION, v.tangent);
  float3 out_BiTangentWS = (cross(out_TangentWS, out_NormalWS));
  //float3x3 T2W_TBN = float3x3(out_TangentWS,out_BiTangentWS,out_NormalWS);//从切线空间转到世界空间的矩阵
  float3x3 W2T_TBN = float3x3(
  float3(out_TangentWS.x,out_BiTangentWS.x,out_NormalWS.x),
  float3(out_TangentWS.y,out_BiTangentWS.y,out_NormalWS.y),
  float3(out_TangentWS.z,out_BiTangentWS.z,out_NormalWS.z));//从世界空间转到切线空间的矩阵

  v2f o;
  o.worldnormal	 = v.normal + 2.0 * cross(blend_real.xyz, cross(blend_real.xyz, v.normal) + blend_real.w * v.normal);
  o.worldtangent = v.tangent.xyz + 2.0 * cross(blend_real.xyz, cross(blend_real.xyz, v.tangent.xyz) + blend_real.w * v.tangent.xyz);	
  //o.worldtangent *= o.worldtangent.w;
  o.vertex = mul(CAMERA_VIEWPROJ, mul(LOCALWORLD_TRANSFORM, float4(out_Position)));
  o.vertex = UniformNDC(o.vertex);
  float3 worldPos = mul(LOCALWORLD_TRANSFORM, float4(v.vertex)).xyz;
	
  o.viewDirection =  mul(W2T_TBN, (CAMERA_WORLDPOSITION - out_PositionWS));
	o.lightDirection = mul(W2T_TBN, LIGHT_GIVEN_DIRECTION);
  o.TBN1 = out_TangentWS;
  o.TBN2 = out_BiTangentWS;
  o.TBN3 = out_NormalWS;

	o.uv = v.uv;

	return o;
}

float4 frag(v2f i) : SV_Target
{
  float3 albedo = pow(tex2D(TEXTURE_ALDEBO, i.uv).rgb, float3(2.2,2.2,2.2));
  float3 ao_roughness_metallic = tex2D(TEXTURE_AMR, i.uv).rgb;
  float ao = ao_roughness_metallic.r;
  float roughness = ao_roughness_metallic.g;
  float metallic = ao_roughness_metallic.b;
	albedo = albedo * ao; //考虑ao 
  float3 Normal_TangentSpace;
  {
    float3 tangentNormal_tmp = tex2D(TEXTURE_NORMAL, i.uv).xyz * 2.0 - 1.0;
    Normal_TangentSpace = normalize(tangentNormal_tmp);
  }
  float3 F0 = float3(0.04,0.04,0.04);
  F0 = lerp(F0, albedo, metallic);

  // 2 #####################################
  const float PI = 3.14159265359;
  // reflectance equation
  // light output
  float3 light_Diffuse;
  float3 light_Specular;
  float3 vNormal = normalize(Normal_TangentSpace);

  float length = sqrt(dot(i.viewDirection, i.viewDirection));
  length = 1.0/length;
  float3 vView = i.viewDirection*length;
  float3 vLight = normalize(-i.lightDirection);
  float3 vHalf = normalize(vView + vLight);
  {
    // Cook-Torrance BRDF
    // DistributionGGX
    float NDF;
    //------------------------------------------
    {
      float a = roughness*roughness;
      float a2 = a*a;
      float NdotH = max( dot(vNormal, vHalf) , 0.0);
      float NdotH2 = NdotH * NdotH;

      float nom	 = a2;
      float denom = (NdotH2 * (a2 - 1.0) + 1.0);
      denom = PI * denom * denom;

      NDF = nom / denom;
    }
    //------------------------------------------

    //GeometrySmith
    float G;
    //------------------------------------------
    {
      float NdotV = max(dot(vNormal, vView), 0.0);
      float NdotL = max(dot(vNormal, vLight), 0.0);

      float a = roughness;
      float lambdaV = NdotL * (NdotV * (1.0 - a) + a);
      float lambdaL = NdotV * (NdotL * (1.0 - a) + a);

      G = 0.5 / (lambdaV + lambdaL + 1e-5f);
    }
    //------------------------------------------

    //fresnelSchlick
    float3  F;
    //------------------------------------------
    {
      float cosTheta = max(dot(vHalf, vView), 0.0);
      F = F0 + (1.0 - F0) * pow(1.0 - cosTheta, 5.0);
    }
    //------------------------------------------
    // Main Physically Based BRDF
    // Derived from Disney work and based on Torrance-Sparrow micro-facet model
    //
    //   BRDF = kD / pi + kS * (D * V * F) / 4
    //   I = BRDF * NdotL
    float3 nominator		= NDF * G * F *3.14;
    float3 specular = nominator;// / denominator;

    // kS is equal to Fresnel
    float3 kS = F;
    // for energy conservation, the diffuse and specular light can't
    // be above 1.0 (unless the surface emits light); to preserve this
    // relationship the diffuse component (kD) should equal 1.0 - kS.
    float3 kD = float3(1.0,1.0,1.0) - kS;
    // multiply kD by the inverse metalness such that only non-metals
    // have diffuse lighting, or a linear blend if partly metal (pure metals
    // have no diffuse light).
    kD *= 1.0 - metallic;

    
    // scale light by NdotL
    float NdotL = max(dot(vNormal, vLight), 0.0);

    light_Diffuse = kD * albedo / PI * NdotL * LIGHT_COLOR;
    light_Specular =  specular * NdotL* LIGHT_COLOR;//(vNormal+float3(1.0,1.0,1.0))/2.0;//
  }

  // 3 #############################################
  float3 kS;// 反射部分 镜面效果 所占的比例
  //------------------------------------------	
  float cosTheta = max(dot(vNormal, vView), 0.0);
  kS = F0 + (max(float3(1.0-roughness,1.0-roughness,1.0-roughness), F0) - F0) * pow(1.0 - cosTheta, 5.0);

  float3x3 T2W_TBN = float3x3(i.TBN1, i.TBN2, i.TBN3);
  float3 worldnormal = mul(T2W_TBN, vNormal);//镜面反射射线
  //------------------------------------------
  float3 kD = 1.0 - kS; // 折射 漫反射效果 所占的比例
  kD *= 1.0 - metallic;// 金属性越强，漫反射越少, 折射越多

  const float MAX_REFLECTION_LOD = 8.0;
  float3 irradiance = SAMPLE_TEXCUBE_LOD(SKY_BOX, mul((T2W_TBN), vNormal), MAX_REFLECTION_LOD).rgb ;
  float3 IBL_diffuse = (kD) * ( albedo ) * irradiance;//漫反射效果

  float3 R = reflect(-vView, vNormal);//镜面反射射线
  float3 prefilteredColor	= SAMPLE_TEXCUBE_LOD(SKY_BOX, mul((T2W_TBN), R) , MAX_REFLECTION_LOD*roughness ).rgb;

  float3 refColor = float3(0.04,0.04,0.04);
  refColor = lerp(refColor, albedo, metallic);

  float smoothness = 1.0-roughness;
  float surfaceReduction = 1.0-0.28*roughness*roughness*roughness; 

  float oneMinusReflectivity = 0.96 - metallic*0.04; 
  oneMinusReflectivity = smoothness + (1.0- oneMinusReflectivity);
  float grazingTerm = clamp(oneMinusReflectivity,0.0,1.0);

  float t = 1.0 - cosTheta;   // ala Schlick interpoliation
  t = t*t*t*t*t;
  refColor = lerp (refColor, float3(grazingTerm,grazingTerm,grazingTerm), t);
  float3 IBL_specular = surfaceReduction * prefilteredColor * refColor;

  // 4 #################################################
  //环境贴图对当前片元颜色的贡献
  float3 ambient =  IBL_diffuse + IBL_specular ;
  //光源对当前片元颜色的贡献
  float3 color = light_Specular + light_Diffuse + ambient;
  // HDR tonemapping
  //color = color / (color + float3(1.0,1.0,1.0));

  // gamma correct
  color = pow(color, float3(1.0/2.2,1.0/2.2,1.0/2.2));
  
	return float4(color, 1.0);
}
ENDCG
#END
