

#DEFPARAMS

#END

#DEFTAG
ShaderName = "Outline"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE;
float2 TARGETSIZE;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
    float2 size= TARGETSIZE;
    float2 uv = i.uv;
    float2 d = 1.0 / size;

    float4 u = ( -1.0 * tex2D(TEXTURE_DIFFUSE, uv + float2(-d.x, -d.y)) + -2.0 * tex2D(TEXTURE_DIFFUSE, uv + float2(-d.x, 0.0)) + -1.0 * tex2D(TEXTURE_DIFFUSE, uv + float2(-d.x, d.y)) + +1.0 * tex2D(TEXTURE_DIFFUSE, uv + float2( d.x, -d.y)) + +2.0 * tex2D(TEXTURE_DIFFUSE, uv + float2( d.x, 0.0)) + +1.0 * tex2D(TEXTURE_DIFFUSE, uv + float2( d.x, d.y)) ) ;
    float4 v = ( -1.0 * tex2D(TEXTURE_DIFFUSE, uv + float2(-d.x, -d.y)) + -2.0 * tex2D(TEXTURE_DIFFUSE, uv + float2( 0.0, -d.y)) + -1.0 * tex2D(TEXTURE_DIFFUSE, uv + float2( d.x, -d.y)) + +1.0 * tex2D(TEXTURE_DIFFUSE, uv + float2(-d.x, d.y)) + +2.0 * tex2D(TEXTURE_DIFFUSE, uv + float2( 0.0, d.y)) + +1.0 * tex2D(TEXTURE_DIFFUSE, uv + float2( d.x, d.y)) ) ;

    float4 finalColor = (1.0*d.y > 1.0)? float4((dot(u.xyz, u.xyz)), ( dot(v.xyz, v.xyz)), 0.5*(1.0+dot(u.xyz, v.xyz)), 1.0): float4((dot(u.xyz, u.xyz)), (dot(v.xyz, v.xyz)), 0.5*(1.0+dot(u.xyz, v.xyz)), 1.0);
    return finalColor;
}
ENDCG
#END
