

function DefineParams()
	Properties = 
	{
		
TEXTURE_DIFFUSE = { "tex diffuse", TEXTURE2D, "white" },
TEXTURE_BLEND = { "tex blend", TEXTURE2D, "white" },

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "Simple"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_BLEND",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * _glesVertex));
  highp vec4 tmpvar_2;
  tmpvar_2.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_2.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_3;
  tmpvar_3 = (tmpvar_2 * tmpvar_1);
  tmpvar_1 = tmpvar_3;
  gl_Position = tmpvar_3;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_BLEND;
in highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 color_1;
  highp vec4 colorBlend_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_BLEND, xlv_TEXCOORD0);
  colorBlend_2 = tmpvar_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  color_1 = tmpvar_4;
  color_1.w = (color_1.w * colorBlend_2.w);
  _glesFragData[0] = color_1;
}

]===],
	},
}

end
