
#DEFPARAMS
TEXTURE_DIFFUSE = { "tex diffuse", TEXTURE2D, "white" },
TEXTURE_REFLECTION = { "reflection tex", TEXTURE2D, "white" },
UNIFORM_REFFACTOR = { "reffactor", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName = "nl_reflectionadv"
RenderQueue = "Opaque+100"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
	float3 normal : NORMAL;
	float3 tangent : TANGENT;
	float3 binoraml : BINORMAL;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float3 worldpos : TEXCOORD2;
	float3 worldnormal : NORMAL;
	float3 worldtangent : TANGENT;
	float3 worldbinormal : BINORMAL;
	float4 vertex : SV_POSITION;
};

uniform float3x3 LOCALWORLD_ROTATION;
sampler2D TEXTURE_DIFFUSE;
sampler2D TEXTURE_NORMAL;
sampler2D TEXTURE_EMSSION;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(o.vertex);
	o.uv = v.uv.xy;
	o.worldpos = ObjectToWorldPos(v.vertex).xyz;
	o.worldnormal = mul(LOCALWORLD_ROTATION, v.normal).xyz;
	o.worldtangent = mul(LOCALWORLD_ROTATION, v.tangent).xyz;
	o.worldbinormal = mul(LOCALWORLD_ROTATION, v.binoraml).xyz;

	return o;
}

float4 frag(v2f i, float FacingSign : VFACE) : SV_Target
{	
	float4 diffTexColor = tex2D(TEXTURE_DIFFUSE, i.uv);
	float4 emssionTexColor = tex2D(TEXTURE_EMSSION, i.uv);
	float4 normalTexColor = tex2D(TEXTURE_NORMAL, i.uv);

	if (diffTexColor.a < 0.5)
		discard;
	float3 normal = normalTexColor.rgb - 0.5;
	normal = normalize(normal);
	if (FacingSign < 0.0)
		normal = -normal;

	float3x3 tangentSpace = float3x3(i.worldtangent,
		i.worldbinormal,
		i.worldnormal);

	float3 v_worldViewDir = normalize(float3(i.worldpos.xyz) - CAMERA_WORLDPOSITION);
	float3 worldNormal = normalize(mul(tangentSpace, normal));
	float3 refCoord = reflect(v_worldViewDir, worldNormal);

	float3 ref = normalize(refCoord) + float3(0.0, 0.0, 1.0);
	float len2 = 2.0*sqrt(ref.x*ref.x + ref.y*ref.y + ref.z*ref.z);
	float2 texCoord = float2(0.5 + ref.x / len2, 0.5 - ref.y / len2);
	
	float4 maincolor;
	maincolor.rgb = diffTexColor.rgb*0.5+float3(texCoord.y, texCoord.y, texCoord.y) + emssionTexColor.rgb;
	maincolor.a = diffTexColor.a;
	return maincolor;
}
ENDCG
#END
