
function DefineParams()
	Properties = 
	{
		
EDGE_WIDTH = { "EDGE_WIDTH", FLOAT, "1.0" },
OFFSET_SCALE = { "OFFSET_SCALE", FLOAT, "1.0" },
MIN_WIDTH = { "MIN_WIDTH", FLOAT, "1.0" },
RANGE_DISTANCE = { "RANGE_DISTANCE", FLOAT, "1.0" },
Main_Color = { "Main_Color", VEC2, "1.0,1.0,1.0,1.0" },

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "nl_4bmatrixoutline_t"
RenderQueue = "Transparent"
end          

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_FRONT, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "EDGE_WIDTH",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OFFSET_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MIN_WIDTH",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RANGE_DISTANCE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "Main_Color",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float EDGE_WIDTH;
uniform highp float OFFSET_SCALE;
uniform highp float MIN_WIDTH;
uniform highp float RANGE_DISTANCE;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
void main ()
{
  highp float zcof_1;
  highp vec4 projSpaceNormal_2;
  highp vec4 out_Position_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[uint(0)].x = row0_6.x;
  tmpvar_11[uint(0)].y = row0_6.y;
  tmpvar_11[uint(0)].z = row0_6.z;
  tmpvar_11[uint(0)].w = row0_6.w;
  tmpvar_11[1u].x = row1_5.x;
  tmpvar_11[1u].y = row1_5.y;
  tmpvar_11[1u].z = row1_5.z;
  tmpvar_11[1u].w = row1_5.w;
  tmpvar_11[2u].x = row2_4.x;
  tmpvar_11[2u].y = row2_4.y;
  tmpvar_11[2u].z = row2_4.z;
  tmpvar_11[2u].w = row2_4.w;
  tmpvar_11[3u].x = 0.0;
  tmpvar_11[3u].y = 0.0;
  tmpvar_11[3u].z = 0.0;
  tmpvar_11[3u].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)));
  out_Position_3 = tmpvar_12;
  highp mat3 tmpvar_13;
  tmpvar_13[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_13[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_13[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_14[1u] = tmpvar_11[1u].xyz;
  tmpvar_14[2u] = tmpvar_11[2u].xyz;
  highp vec4 tmpvar_15;
  tmpvar_15.w = 0.0;
  tmpvar_15.xyz = normalize((tmpvar_13 * (_glesNormal * tmpvar_14)));
  highp vec4 tmpvar_16;
  tmpvar_16 = (CAMERA_VIEWPROJ * tmpvar_15);
  projSpaceNormal_2.zw = tmpvar_16.zw;
  projSpaceNormal_2.xy = normalize(tmpvar_16.xy);
  highp vec4 tmpvar_17;
  tmpvar_17 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11));
  highp float tmpvar_18;
  tmpvar_18 = abs(tmpvar_17.z);
  zcof_1 = tmpvar_18;
  if ((tmpvar_18 > RANGE_DISTANCE)) {
    zcof_1 = RANGE_DISTANCE;
  };
  zcof_1 = (zcof_1 / RANGE_DISTANCE);
  zcof_1 = (1.0 - zcof_1);
  highp float tmpvar_19;
  tmpvar_19 = (MIN_WIDTH / EDGE_WIDTH);
  if ((zcof_1 < tmpvar_19)) {
    zcof_1 = tmpvar_19;
  };
  highp float tmpvar_20;
  tmpvar_20 = min (1.0, zcof_1);
  zcof_1 = tmpvar_20;
  out_Position_3.xy = (tmpvar_12.xy + ((
    ((0.004275 * projSpaceNormal_2) * abs(tmpvar_17.z))
   * tmpvar_20) * EDGE_WIDTH).xy);
  out_Position_3.z = (tmpvar_12.z + (6e-5 * OFFSET_SCALE));
  highp vec4 tmpvar_21;
  tmpvar_21.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_21.y = DEVICE_COORDINATE_Y_FLIP;
  gl_Position = (tmpvar_21 * out_Position_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec4 Main_Color;
void main ()
{
  _glesFragData[0] = Main_Color;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "EDGE_WIDTH",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OFFSET_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MIN_WIDTH",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RANGE_DISTANCE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "Main_Color",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float EDGE_WIDTH;
uniform highp float OFFSET_SCALE;
uniform highp float MIN_WIDTH;
uniform highp float RANGE_DISTANCE;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp float zcof_2;
  highp vec4 projSpaceNormal_3;
  highp vec4 out_Position_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  tmpvar_5 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6));
  out_Position_4 = tmpvar_5;
  highp mat3 tmpvar_7;
  tmpvar_7[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_7[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_7[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 0.0;
  tmpvar_8.xyz = normalize((tmpvar_7 * _glesNormal));
  highp vec4 tmpvar_9;
  tmpvar_9 = (CAMERA_VIEWPROJ * tmpvar_8);
  projSpaceNormal_3.zw = tmpvar_9.zw;
  projSpaceNormal_3.xy = normalize(tmpvar_9.xy);
  highp vec4 tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = tmpvar_1.xyz;
  tmpvar_10 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  highp float tmpvar_12;
  tmpvar_12 = abs(tmpvar_10.z);
  zcof_2 = tmpvar_12;
  if ((tmpvar_12 > RANGE_DISTANCE)) {
    zcof_2 = RANGE_DISTANCE;
  };
  zcof_2 = (zcof_2 / RANGE_DISTANCE);
  zcof_2 = (1.0 - zcof_2);
  highp float tmpvar_13;
  tmpvar_13 = (MIN_WIDTH / EDGE_WIDTH);
  if ((zcof_2 < tmpvar_13)) {
    zcof_2 = tmpvar_13;
  };
  highp float tmpvar_14;
  tmpvar_14 = min (1.0, zcof_2);
  zcof_2 = tmpvar_14;
  out_Position_4.xy = (tmpvar_5.xy + ((
    ((0.004275 * projSpaceNormal_3) * abs(tmpvar_10.z))
   * tmpvar_14) * EDGE_WIDTH).xy);
  out_Position_4.z = (tmpvar_5.z + (6e-5 * OFFSET_SCALE));
  highp vec4 tmpvar_15;
  tmpvar_15.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_15.y = DEVICE_COORDINATE_Y_FLIP;
  gl_Position = (tmpvar_15 * out_Position_4);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec4 Main_Color;
void main ()
{
  _glesFragData[0] = Main_Color;
}

]===],
	},
}

end
