

#DEFPARAMS
ALPHA_FACTOR = { "Alpha Factor", FLOAT, "1.0" },
[Keywords(POST_EFFECT_ALPHA_ON, POST_EFFECT_ALPHA_OFF)]
POST_EFFECT_ALPHA = {"post_effect_alpha", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName = "Mopi"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile POST_EFFECT_ALPHA_ON POST_EFFECT_ALPHA_OFF
#include "common.inc"
#include "utils.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE;
float2 iResolution;
float BSIGMA;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}



float normpdf(float x, float sigma) {
	return 0.39894 * exp(-0.5 * x * x/ (sigma * sigma)) / sigma;
}

float normpdf3(float3 v, float sigma) {
	return 0.39894 * exp(-0.5 * dot(v,v) / (sigma * sigma)) / sigma;
}

float normalizeColorChannel(float value, float min, float max) {
    return (value - min)/(max-min);
}

float4 frag(v2f i) : SV_Target
{
    bool GAMMA_CORRECTION = true; 

    int MSIZE = 5;
    
    float4 color = tex2D(TEXTURE_DIFFUSE, i.uv.xy).rgba;
    float3 c = color.rgb;
    float alpha = color.a;
    int kSize = (MSIZE - 1) / 2;
    float3 final_colour = float3(0.0,0.0,0.0);
    float Z = 0.0;
    

    float kernel[5];
    kernel[0] = kernel[4] = 0.031225216;
    kernel[1] = kernel[3] = 0.036826804;
    kernel[2] = 0.039894000;
    float bZ = 0.2506642602897679;


    float3 cc;
    float factor;
    //read out the texels
    float2 cord = i.uv.xy;
    float2 size = iResolution.xy;
    if (alpha > 0.5){
        for (int i=-kSize; i <= kSize; ++i) {
            for (int j=-kSize; j <= kSize; ++j) {
                cc = tex2D(TEXTURE_DIFFUSE, (cord+float2(float(i),float(j)) / size)).rgb;
                factor = normpdf3(cc-c, BSIGMA) * bZ * kernel[kSize+j] * kernel[kSize+i];
                Z += factor;
                if (GAMMA_CORRECTION) {
                    final_colour += factor * pow(cc, float3(2.2,2.2,2.2));
                } else {
                    final_colour += factor * cc;
                }
            }
        }
    }
    
    
    float4 col;
    if (alpha > 0.5){
        if (GAMMA_CORRECTION) {
    	col = float4(pow(final_colour / Z, float3(1.0/2.2,1.0/2.2,1.0/2.2)), alpha);
        } else {
            col = float4(final_colour / Z, alpha);
        }
    }
    else{
        col = color;
    }
    

    // bool isSkin = false; 
    // float4 rgb = col * 255.0;
    // float4 ycbcr = rgb;
    // ycbcr.x = 16.0 + rgb.x*0.257 + rgb.y*0.504 + rgb.z*0.098;
    // ycbcr.y = 128.0 - rgb.x*0.148 - rgb.y*0.291 + rgb.z*0.439;
    // ycbcr.z = 128.0 + rgb.x*0.439 - rgb.y*0.368 - rgb.z*0.071;
    // if (ycbcr.y > 100.0 && ycbcr.y < 118.0 &&
    //     ycbcr.z > 121.0 && ycbcr.z < 161.0) {
    //  	isSkin = true; 
    // }
    //  if (!isSkin) {
        
    //     col = color; 
    // }
    // float4 col = float4(1,1,1,1);
    return col;

}
ENDCG
#END
