

#DEFPARAMS
#END

#DEFTAG
ShaderName = "Luminance"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE;
float BLOOM_MODE;
float3 BLOOM_COLOR;
float LUMINANCE_THRESHOLD;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
	float4 color = tex2D(TEXTURE_DIFFUSE, i.uv);
	fixed4 out_TextureColor; 
	if (i.uv.x < 0.01 || i.uv.x > 0.99 || i.uv.y < 0.01 || i.uv.y > 0.99)	
	{
		out_TextureColor = float4(0.0, 0.0, 0.0, color.a);
	}
	else
	{
		float illumination = dot(color.xyz, float3(0.3, 0.59, 0.11));
		if (BLOOM_MODE == 1.0)
		{
			//original color
			LUMINANCE_THRESHOLD = pow(LUMINANCE_THRESHOLD, 1.2);
			float4 maskcolor = float4(color.xyz * step(0.0, illumination - LUMINANCE_THRESHOLD), color.a);
			float3 order;
			if (maskcolor.x >= maskcolor.y)
			{
				if (maskcolor.x >= maskcolor.z)
				{
					if (maskcolor.y >= maskcolor.z)
					{
						// x > y > z
						order = float3(0.0, 1.0, 2.0);
					}
					else
					{
						// x > z > y
						order = float3(0.0, 2.0, 1.0);
					}
				}
				else
				{
					// z > x > y
					order = float3(2.0, 0.0, 1.0);
				}
			} 
			else
			{
				if(maskcolor.y >= maskcolor.z)
				{
					if(maskcolor.x >= maskcolor.z)
					{
						// y > x > z
						order = float3(1.0, 0.0, 2.0);
					}
					else
					{
						// y > z > x
						order = float3(1.0, 2.0, 0.0);
					}
				}
				else
				{
					// z > y > x
					order = float3(2.0, 1.0, 0.0);
				}
			}

			float maxvalue = max(max(maskcolor.x, maskcolor.y), maskcolor.z);
			float minvalue = min(min(maskcolor.x, maskcolor.y), maskcolor.z);
			float secondvalue = maskcolor.x + maskcolor.y + maskcolor.z - maxvalue - minvalue;
			float factormax = 1.0;
			float eps = 0.000001;
			float factorsecond = factormax  + 0.05 * (maxvalue / (secondvalue + eps));
			float factormin = factorsecond + 0.001 * (secondvalue / (minvalue + eps));

			float factorx = factormax * float(order.x == 0.0) + factorsecond * float(order.x == 1.0) + factormin * float(order.x == 2.0);
			float factory = factormax * float(order.y == 0.0) + factorsecond * float(order.y == 1.0) + factormin * float(order.y == 2.0);
			float factorz = factormax * float(order.z == 0.0) + factorsecond * float(order.z == 1.0) + factormin * float(order.z == 2.0);

			out_TextureColor = float4(1 * step(0.0, maskcolor.x - factorx * LUMINANCE_THRESHOLD), 1 * step(0.0, maskcolor.y - factory * LUMINANCE_THRESHOLD), 1 * step(0.0, maskcolor.z - factorz * LUMINANCE_THRESHOLD), color.a);

		}
		else
		{
			out_TextureColor = float4(BLOOM_COLOR.xyz * step(0.0, illumination - LUMINANCE_THRESHOLD), color.a);
		}
	}
	return out_TextureColor;
}
ENDCG
#END
