

#DEFPARAMS
FRAME_I    = { "FRAME_I",  TEXTURE2D,  "white"    },
FRAME_II   = { "FRAME_II",  TEXTURE2D,  "white"     },
FRAME_III  = { "FRAME_III",  TEXTURE2D,  "white"     },
WEIGHTS    = { "WEIGHTS",  VEC3, "0.33, 0.33, 0.33"   },
#END

#DEFTAG
ShaderName = "temporal_filter" 
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;

};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D FRAME_I;
sampler2D FRAME_II;
sampler2D FRAME_III;
float3 WEIGHTS;


v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv;

	return o;
}

float4 frag(v2f i) : SV_Target
{
    
    float4 colorI   = tex2D(FRAME_I, i.uv);
    float4 colorII  = tex2D(FRAME_II, i.uv);
    float4 colorIII = tex2D(FRAME_III, i.uv);

    float4 color = colorI * WEIGHTS.x + colorII * WEIGHTS.y + colorIII * WEIGHTS.z;
    return color;
    
}
ENDCG
#END
