

function DefineParams()
	Properties = 
	{
		
FRAME_I    = { "FRAME_I",  TEXTURE2D,  "white"    },
FRAME_II   = { "FRAME_II",  TEXTURE2D,  "white"     },
FRAME_III  = { "FRAME_III",  TEXTURE2D,  "white"     },
WEIGHTS    = { "WEIGHTS",  VEC3, "0.33, 0.33, 0.33"   },

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "temporal_filter" 
RenderQueue = "PostEffect"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "FRAME_I",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FRAME_II",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FRAME_III",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WEIGHTS",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_1 * _glesVertex);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D FRAME_I;
uniform sampler2D FRAME_II;
uniform sampler2D FRAME_III;
uniform highp vec3 WEIGHTS;
in highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 colorIII_1;
  highp vec4 colorII_2;
  highp vec4 colorI_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (FRAME_I, xlv_TEXCOORD0);
  colorI_3 = tmpvar_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture (FRAME_II, xlv_TEXCOORD0);
  colorII_2 = tmpvar_5;
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture (FRAME_III, xlv_TEXCOORD0);
  colorIII_1 = tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (((colorI_3 * WEIGHTS.x) + (colorII_2 * WEIGHTS.y)) + (colorIII_1 * WEIGHTS.z));
  _glesFragData[0] = tmpvar_7;
}

]===],
	},
}

end
