
function DefineParams()
	Properties = 
	{
		
PIXEL_SIZE		= {"PixelSize", VEC2, "1.0,1.0" },
OPACITY 		= {"Opacity", FLOATRANGE, "1, 1, 0" },
_LutMap 		= {"Lut Map", TEXTURE2D, "white" },
COLOR_RANGEA	= {"CustomColor", VEC3, "1.0, 1.0, 1.0"},
COLOR_RANGEB 	= {"CustomColor", VEC3, "1.0, 1.0, 1.0"},
MASK_VALID      = {"MASK_VALID", FLOAT, "0.0"},
MaskTex         = {"MaskTex", TEXTURE2D, "white"},


_ColorMode = {"ColorMode", FLOAT, "0.0"},

_BlendSrc = {"Blend Src", FLOAT, "4.0"},

_BlendDst = {"Blend Dst", FLOAT, "5.0"},

_BlendMode = {"Blend Mode", FLOAT, "0.0"},

	}
	Attributes = 
	{
		_ColorMode = "Keywords(COLOR_ORIGINAL,COLOR_BLEND,COLOR_CUSTOM)", 
		_BlendSrc = "Enum(BlendFactor)", 
		_BlendDst = "Enum(BlendFactor)", 
		_BlendMode = "Keywords(BLEND_NORMAL,BLEND_MULTIPLY,BLEND_SCREEN,BLEND_HUE,BLEND_SATURATION,BLEND_LUMINOSITY,BLEND_COLOR,BLEND_BLEND,BLEND_EXCLUSION,BLEND_HARDLIGHT,BLEND_VIVIDLIGHT,BLEND_OVERLAY,BLEND_COLORBURN,BLEND_COLORDODGE,BLEND_SOFTLIGHT,BLEND_HARDMIX,BLEND_PINLIGHT,BLEND_LINEARLIGHT,BLEND_DIFF,BLEND_LINEARBURN,BLEND_SUB,BLEND_LUT,BLEND_ADD)", 
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName  = "glare_blend_normal"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = {ALPAH_BLEND, "%_BlendSrc", "%_BlendDst", ONE, ONE}
DRAW_MODE    = {CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS}
STENCIL_MODE = {STENCIL_OFF}


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_ORIGINAL","BLEND_NORMAL"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D MaskTex;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 MColor_4;
    lowp vec4 tmpvar_5;
    tmpvar_5 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_4 = tmpvar_5;
    highp vec4 tmpvar_6;
    tmpvar_6.xyz = MColor_4.xyz;
    tmpvar_6.w = (MColor_4.w * OPACITY);
    tmpvar_1 = tmpvar_6;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_BLEND","BLEND_NORMAL"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIXEL_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec2 PIXEL_SIZE;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec3 bot_4;
    highp vec3 top_5;
    highp vec3 right_6;
    highp vec3 left_7;
    highp vec3 Middle_8;
    highp vec4 MColor_9;
    lowp vec4 tmpvar_10;
    tmpvar_10 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_9 = tmpvar_10;
    lowp vec3 tmpvar_11;
    tmpvar_11 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.zw).xyz;
    Middle_8 = tmpvar_11;
    highp vec2 tmpvar_12;
    tmpvar_12.y = 0.0;
    tmpvar_12.x = -(PIXEL_SIZE.x);
    highp vec2 P_13;
    P_13 = (xlv_TEXCOORD1.zw + tmpvar_12);
    lowp vec3 tmpvar_14;
    tmpvar_14 = texture (TEXTURE_GLOSSINESS, P_13).xyz;
    left_7 = tmpvar_14;
    highp vec2 tmpvar_15;
    tmpvar_15.y = 0.0;
    tmpvar_15.x = PIXEL_SIZE.x;
    highp vec2 P_16;
    P_16 = (xlv_TEXCOORD1.zw + tmpvar_15);
    lowp vec3 tmpvar_17;
    tmpvar_17 = texture (TEXTURE_GLOSSINESS, P_16).xyz;
    right_6 = tmpvar_17;
    highp vec2 tmpvar_18;
    tmpvar_18.x = 0.0;
    tmpvar_18.y = -(PIXEL_SIZE.y);
    highp vec2 P_19;
    P_19 = (xlv_TEXCOORD1.zw + tmpvar_18);
    lowp vec3 tmpvar_20;
    tmpvar_20 = texture (TEXTURE_GLOSSINESS, P_19).xyz;
    top_5 = tmpvar_20;
    highp vec2 tmpvar_21;
    tmpvar_21.x = 0.0;
    tmpvar_21.y = PIXEL_SIZE.y;
    highp vec2 P_22;
    P_22 = (xlv_TEXCOORD1.zw + tmpvar_21);
    lowp vec3 tmpvar_23;
    tmpvar_23 = texture (TEXTURE_GLOSSINESS, P_22).xyz;
    bot_4 = tmpvar_23;
    highp vec4 tmpvar_24;
    tmpvar_24.xyz = max (max (Middle_8, left_7), max (max (right_6, top_5), bot_4));
    tmpvar_24.w = (MColor_9.w * OPACITY);
    tmpvar_1 = tmpvar_24;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_CUSTOM","BLEND_NORMAL"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEA",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEB",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D MaskTex;
uniform highp vec3 COLOR_RANGEA;
uniform highp vec3 COLOR_RANGEB;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 MColor_4;
    lowp vec4 tmpvar_5;
    tmpvar_5 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_4 = tmpvar_5;
    highp vec4 tmpvar_6;
    tmpvar_6.xyz = mix (COLOR_RANGEA, COLOR_RANGEB, xlv_TEXCOORD2.xxx);
    tmpvar_6.w = (MColor_4.w * OPACITY);
    tmpvar_1 = tmpvar_6;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_ORIGINAL","BLEND_MULTIPLY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D MaskTex;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 MColor_4;
    lowp vec4 tmpvar_5;
    tmpvar_5 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_4 = tmpvar_5;
    highp float tmpvar_6;
    tmpvar_6 = (MColor_4.w * OPACITY);
    highp vec4 tmpvar_7;
    tmpvar_7.xyz = (vec3(1.0, 1.0, 1.0) - (tmpvar_6 * (vec3(1.0, 1.0, 1.0) - MColor_4.xyz)));
    tmpvar_7.w = tmpvar_6;
    tmpvar_1 = tmpvar_7;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_BLEND","BLEND_MULTIPLY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIXEL_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec2 PIXEL_SIZE;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec3 bot_4;
    highp vec3 top_5;
    highp vec3 right_6;
    highp vec3 left_7;
    highp vec3 Middle_8;
    highp vec4 MColor_9;
    lowp vec4 tmpvar_10;
    tmpvar_10 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_9 = tmpvar_10;
    highp float tmpvar_11;
    tmpvar_11 = (MColor_9.w * OPACITY);
    lowp vec3 tmpvar_12;
    tmpvar_12 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.zw).xyz;
    Middle_8 = tmpvar_12;
    highp vec2 tmpvar_13;
    tmpvar_13.y = 0.0;
    tmpvar_13.x = -(PIXEL_SIZE.x);
    highp vec2 P_14;
    P_14 = (xlv_TEXCOORD1.zw + tmpvar_13);
    lowp vec3 tmpvar_15;
    tmpvar_15 = texture (TEXTURE_GLOSSINESS, P_14).xyz;
    left_7 = tmpvar_15;
    highp vec2 tmpvar_16;
    tmpvar_16.y = 0.0;
    tmpvar_16.x = PIXEL_SIZE.x;
    highp vec2 P_17;
    P_17 = (xlv_TEXCOORD1.zw + tmpvar_16);
    lowp vec3 tmpvar_18;
    tmpvar_18 = texture (TEXTURE_GLOSSINESS, P_17).xyz;
    right_6 = tmpvar_18;
    highp vec2 tmpvar_19;
    tmpvar_19.x = 0.0;
    tmpvar_19.y = -(PIXEL_SIZE.y);
    highp vec2 P_20;
    P_20 = (xlv_TEXCOORD1.zw + tmpvar_19);
    lowp vec3 tmpvar_21;
    tmpvar_21 = texture (TEXTURE_GLOSSINESS, P_20).xyz;
    top_5 = tmpvar_21;
    highp vec2 tmpvar_22;
    tmpvar_22.x = 0.0;
    tmpvar_22.y = PIXEL_SIZE.y;
    highp vec2 P_23;
    P_23 = (xlv_TEXCOORD1.zw + tmpvar_22);
    lowp vec3 tmpvar_24;
    tmpvar_24 = texture (TEXTURE_GLOSSINESS, P_23).xyz;
    bot_4 = tmpvar_24;
    highp vec4 tmpvar_25;
    tmpvar_25.xyz = (vec3(1.0, 1.0, 1.0) - (tmpvar_11 * (vec3(1.0, 1.0, 1.0) - 
      max (max (Middle_8, left_7), max (max (right_6, top_5), bot_4))
    )));
    tmpvar_25.w = tmpvar_11;
    tmpvar_1 = tmpvar_25;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_CUSTOM","BLEND_MULTIPLY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEA",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEB",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D MaskTex;
uniform highp vec3 COLOR_RANGEA;
uniform highp vec3 COLOR_RANGEB;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 MColor_4;
    lowp vec4 tmpvar_5;
    tmpvar_5 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_4 = tmpvar_5;
    highp float tmpvar_6;
    tmpvar_6 = (MColor_4.w * OPACITY);
    highp vec4 tmpvar_7;
    tmpvar_7.xyz = (vec3(1.0, 1.0, 1.0) - (tmpvar_6 * (vec3(1.0, 1.0, 1.0) - 
      mix (COLOR_RANGEA, COLOR_RANGEB, xlv_TEXCOORD2.xxx)
    )));
    tmpvar_7.w = tmpvar_6;
    tmpvar_1 = tmpvar_7;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_ORIGINAL","BLEND_SCREEN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D MaskTex;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 MColor_4;
    lowp vec4 tmpvar_5;
    tmpvar_5 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_4 = tmpvar_5;
    highp float tmpvar_6;
    tmpvar_6 = (MColor_4.w * OPACITY);
    highp vec4 tmpvar_7;
    tmpvar_7.xyz = (tmpvar_6 * MColor_4.xyz);
    tmpvar_7.w = tmpvar_6;
    tmpvar_1 = tmpvar_7;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_BLEND","BLEND_SCREEN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIXEL_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec2 PIXEL_SIZE;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec3 bot_4;
    highp vec3 top_5;
    highp vec3 right_6;
    highp vec3 left_7;
    highp vec3 Middle_8;
    highp vec4 MColor_9;
    lowp vec4 tmpvar_10;
    tmpvar_10 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_9 = tmpvar_10;
    highp float tmpvar_11;
    tmpvar_11 = (MColor_9.w * OPACITY);
    lowp vec3 tmpvar_12;
    tmpvar_12 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.zw).xyz;
    Middle_8 = tmpvar_12;
    highp vec2 tmpvar_13;
    tmpvar_13.y = 0.0;
    tmpvar_13.x = -(PIXEL_SIZE.x);
    highp vec2 P_14;
    P_14 = (xlv_TEXCOORD1.zw + tmpvar_13);
    lowp vec3 tmpvar_15;
    tmpvar_15 = texture (TEXTURE_GLOSSINESS, P_14).xyz;
    left_7 = tmpvar_15;
    highp vec2 tmpvar_16;
    tmpvar_16.y = 0.0;
    tmpvar_16.x = PIXEL_SIZE.x;
    highp vec2 P_17;
    P_17 = (xlv_TEXCOORD1.zw + tmpvar_16);
    lowp vec3 tmpvar_18;
    tmpvar_18 = texture (TEXTURE_GLOSSINESS, P_17).xyz;
    right_6 = tmpvar_18;
    highp vec2 tmpvar_19;
    tmpvar_19.x = 0.0;
    tmpvar_19.y = -(PIXEL_SIZE.y);
    highp vec2 P_20;
    P_20 = (xlv_TEXCOORD1.zw + tmpvar_19);
    lowp vec3 tmpvar_21;
    tmpvar_21 = texture (TEXTURE_GLOSSINESS, P_20).xyz;
    top_5 = tmpvar_21;
    highp vec2 tmpvar_22;
    tmpvar_22.x = 0.0;
    tmpvar_22.y = PIXEL_SIZE.y;
    highp vec2 P_23;
    P_23 = (xlv_TEXCOORD1.zw + tmpvar_22);
    lowp vec3 tmpvar_24;
    tmpvar_24 = texture (TEXTURE_GLOSSINESS, P_23).xyz;
    bot_4 = tmpvar_24;
    highp vec4 tmpvar_25;
    tmpvar_25.xyz = (tmpvar_11 * max (max (Middle_8, left_7), max (
      max (right_6, top_5)
    , bot_4)));
    tmpvar_25.w = tmpvar_11;
    tmpvar_1 = tmpvar_25;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_CUSTOM","BLEND_SCREEN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEA",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEB",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D MaskTex;
uniform highp vec3 COLOR_RANGEA;
uniform highp vec3 COLOR_RANGEB;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 MColor_4;
    lowp vec4 tmpvar_5;
    tmpvar_5 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_4 = tmpvar_5;
    highp float tmpvar_6;
    tmpvar_6 = (MColor_4.w * OPACITY);
    highp vec4 tmpvar_7;
    tmpvar_7.xyz = (tmpvar_6 * mix (COLOR_RANGEA, COLOR_RANGEB, xlv_TEXCOORD2.xxx));
    tmpvar_7.w = tmpvar_6;
    tmpvar_1 = tmpvar_7;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_ORIGINAL","BLEND_HUE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp vec4 MColor_5;
    lowp vec4 tmpvar_6;
    tmpvar_6 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_5 = tmpvar_6;
    highp float tmpvar_7;
    tmpvar_7 = (MColor_5.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp vec3 tmpvar_9;
    tmpvar_9 = RColor_4.xyz;
    highp vec3 tmpvar_10;
    tmpvar_10 = MColor_5.xyz;
    highp vec4 tmpvar_11;
    if ((RColor_4.y < RColor_4.z)) {
      highp vec4 tmpvar_12;
      tmpvar_12.zw = vec2(-1.0, 0.6666667);
      tmpvar_12.xy = tmpvar_9.zy;
      tmpvar_11 = tmpvar_12;
    } else {
      highp vec4 tmpvar_13;
      tmpvar_13.zw = vec2(0.0, -0.3333333);
      tmpvar_13.xy = tmpvar_9.yz;
      tmpvar_11 = tmpvar_13;
    };
    highp vec4 tmpvar_14;
    if ((RColor_4.x < tmpvar_11.x)) {
      highp vec4 tmpvar_15;
      tmpvar_15.xyz = tmpvar_11.xyw;
      tmpvar_15.w = tmpvar_9.x;
      tmpvar_14 = tmpvar_15;
    } else {
      highp vec4 tmpvar_16;
      tmpvar_16.x = tmpvar_9.x;
      tmpvar_16.yzw = tmpvar_11.yzx;
      tmpvar_14 = tmpvar_16;
    };
    highp float tmpvar_17;
    tmpvar_17 = (tmpvar_14.x - min (tmpvar_14.w, tmpvar_14.y));
    highp vec3 tmpvar_18;
    tmpvar_18.x = abs(((
      (tmpvar_14.w - tmpvar_14.y)
     / 
      ((6.0 * tmpvar_17) + 1e-7)
    ) + tmpvar_14.z));
    tmpvar_18.y = tmpvar_17;
    tmpvar_18.z = tmpvar_14.x;
    highp float tmpvar_19;
    tmpvar_19 = (tmpvar_14.x - (tmpvar_17 * 0.5));
    highp vec3 tmpvar_20;
    tmpvar_20.x = tmpvar_18.x;
    tmpvar_20.y = (tmpvar_17 / ((1.0 - 
      abs(((2.0 * tmpvar_19) - 1.0))
    ) + 1e-7));
    tmpvar_20.z = tmpvar_19;
    highp vec4 tmpvar_21;
    if ((MColor_5.y < MColor_5.z)) {
      highp vec4 tmpvar_22;
      tmpvar_22.zw = vec2(-1.0, 0.6666667);
      tmpvar_22.xy = tmpvar_10.zy;
      tmpvar_21 = tmpvar_22;
    } else {
      highp vec4 tmpvar_23;
      tmpvar_23.zw = vec2(0.0, -0.3333333);
      tmpvar_23.xy = tmpvar_10.yz;
      tmpvar_21 = tmpvar_23;
    };
    highp vec4 tmpvar_24;
    if ((MColor_5.x < tmpvar_21.x)) {
      highp vec4 tmpvar_25;
      tmpvar_25.xyz = tmpvar_21.xyw;
      tmpvar_25.w = tmpvar_10.x;
      tmpvar_24 = tmpvar_25;
    } else {
      highp vec4 tmpvar_26;
      tmpvar_26.x = tmpvar_10.x;
      tmpvar_26.yzw = tmpvar_21.yzx;
      tmpvar_24 = tmpvar_26;
    };
    highp float tmpvar_27;
    tmpvar_27 = (tmpvar_24.x - min (tmpvar_24.w, tmpvar_24.y));
    highp vec3 tmpvar_28;
    tmpvar_28.x = abs(((
      (tmpvar_24.w - tmpvar_24.y)
     / 
      ((6.0 * tmpvar_27) + 1e-7)
    ) + tmpvar_24.z));
    tmpvar_28.y = tmpvar_27;
    tmpvar_28.z = tmpvar_24.x;
    highp vec3 tmpvar_29;
    tmpvar_29.x = (abs((
      (6.0 * tmpvar_28.x)
     - 3.0)) - 1.0);
    tmpvar_29.y = (2.0 - abs((
      (6.0 * tmpvar_28.x)
     - 2.0)));
    tmpvar_29.z = (2.0 - abs((
      (6.0 * tmpvar_28.x)
     - 4.0)));
    highp vec4 tmpvar_30;
    tmpvar_30.xyz = mix (RColor_4.xyz, ((
      (clamp (tmpvar_29, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0)) - 0.5)
     * 
      ((1.0 - abs((
        (2.0 * tmpvar_19)
       - 1.0))) * tmpvar_20.y)
    ) + tmpvar_19), vec3(tmpvar_7));
    tmpvar_30.w = tmpvar_7;
    tmpvar_1 = tmpvar_30;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_BLEND","BLEND_HUE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIXEL_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec2 PIXEL_SIZE;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec3 bot_4;
    highp vec3 top_5;
    highp vec3 right_6;
    highp vec3 left_7;
    highp vec3 Middle_8;
    highp vec4 RColor_9;
    highp vec4 MColor_10;
    lowp vec4 tmpvar_11;
    tmpvar_11 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_10 = tmpvar_11;
    highp float tmpvar_12;
    tmpvar_12 = (MColor_10.w * OPACITY);
    lowp vec4 tmpvar_13;
    tmpvar_13 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_9 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = RColor_9.xyz;
    lowp vec3 tmpvar_15;
    tmpvar_15 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.zw).xyz;
    Middle_8 = tmpvar_15;
    highp vec2 tmpvar_16;
    tmpvar_16.y = 0.0;
    tmpvar_16.x = -(PIXEL_SIZE.x);
    highp vec2 P_17;
    P_17 = (xlv_TEXCOORD1.zw + tmpvar_16);
    lowp vec3 tmpvar_18;
    tmpvar_18 = texture (TEXTURE_GLOSSINESS, P_17).xyz;
    left_7 = tmpvar_18;
    highp vec2 tmpvar_19;
    tmpvar_19.y = 0.0;
    tmpvar_19.x = PIXEL_SIZE.x;
    highp vec2 P_20;
    P_20 = (xlv_TEXCOORD1.zw + tmpvar_19);
    lowp vec3 tmpvar_21;
    tmpvar_21 = texture (TEXTURE_GLOSSINESS, P_20).xyz;
    right_6 = tmpvar_21;
    highp vec2 tmpvar_22;
    tmpvar_22.x = 0.0;
    tmpvar_22.y = -(PIXEL_SIZE.y);
    highp vec2 P_23;
    P_23 = (xlv_TEXCOORD1.zw + tmpvar_22);
    lowp vec3 tmpvar_24;
    tmpvar_24 = texture (TEXTURE_GLOSSINESS, P_23).xyz;
    top_5 = tmpvar_24;
    highp vec2 tmpvar_25;
    tmpvar_25.x = 0.0;
    tmpvar_25.y = PIXEL_SIZE.y;
    highp vec2 P_26;
    P_26 = (xlv_TEXCOORD1.zw + tmpvar_25);
    lowp vec3 tmpvar_27;
    tmpvar_27 = texture (TEXTURE_GLOSSINESS, P_26).xyz;
    bot_4 = tmpvar_27;
    highp vec3 tmpvar_28;
    tmpvar_28 = max (max (Middle_8, left_7), max (max (right_6, top_5), bot_4));
    highp vec4 tmpvar_29;
    if ((RColor_9.y < RColor_9.z)) {
      highp vec4 tmpvar_30;
      tmpvar_30.zw = vec2(-1.0, 0.6666667);
      tmpvar_30.xy = tmpvar_14.zy;
      tmpvar_29 = tmpvar_30;
    } else {
      highp vec4 tmpvar_31;
      tmpvar_31.zw = vec2(0.0, -0.3333333);
      tmpvar_31.xy = tmpvar_14.yz;
      tmpvar_29 = tmpvar_31;
    };
    highp vec4 tmpvar_32;
    if ((RColor_9.x < tmpvar_29.x)) {
      highp vec4 tmpvar_33;
      tmpvar_33.xyz = tmpvar_29.xyw;
      tmpvar_33.w = tmpvar_14.x;
      tmpvar_32 = tmpvar_33;
    } else {
      highp vec4 tmpvar_34;
      tmpvar_34.x = tmpvar_14.x;
      tmpvar_34.yzw = tmpvar_29.yzx;
      tmpvar_32 = tmpvar_34;
    };
    highp float tmpvar_35;
    tmpvar_35 = (tmpvar_32.x - min (tmpvar_32.w, tmpvar_32.y));
    highp vec3 tmpvar_36;
    tmpvar_36.x = abs(((
      (tmpvar_32.w - tmpvar_32.y)
     / 
      ((6.0 * tmpvar_35) + 1e-7)
    ) + tmpvar_32.z));
    tmpvar_36.y = tmpvar_35;
    tmpvar_36.z = tmpvar_32.x;
    highp float tmpvar_37;
    tmpvar_37 = (tmpvar_32.x - (tmpvar_35 * 0.5));
    highp vec3 tmpvar_38;
    tmpvar_38.x = tmpvar_36.x;
    tmpvar_38.y = (tmpvar_35 / ((1.0 - 
      abs(((2.0 * tmpvar_37) - 1.0))
    ) + 1e-7));
    tmpvar_38.z = tmpvar_37;
    highp vec4 tmpvar_39;
    if ((tmpvar_28.y < tmpvar_28.z)) {
      highp vec4 tmpvar_40;
      tmpvar_40.zw = vec2(-1.0, 0.6666667);
      tmpvar_40.xy = tmpvar_28.zy;
      tmpvar_39 = tmpvar_40;
    } else {
      highp vec4 tmpvar_41;
      tmpvar_41.zw = vec2(0.0, -0.3333333);
      tmpvar_41.xy = tmpvar_28.yz;
      tmpvar_39 = tmpvar_41;
    };
    highp vec4 tmpvar_42;
    if ((tmpvar_28.x < tmpvar_39.x)) {
      highp vec4 tmpvar_43;
      tmpvar_43.xyz = tmpvar_39.xyw;
      tmpvar_43.w = tmpvar_28.x;
      tmpvar_42 = tmpvar_43;
    } else {
      highp vec4 tmpvar_44;
      tmpvar_44.x = tmpvar_28.x;
      tmpvar_44.yzw = tmpvar_39.yzx;
      tmpvar_42 = tmpvar_44;
    };
    highp float tmpvar_45;
    tmpvar_45 = (tmpvar_42.x - min (tmpvar_42.w, tmpvar_42.y));
    highp vec3 tmpvar_46;
    tmpvar_46.x = abs(((
      (tmpvar_42.w - tmpvar_42.y)
     / 
      ((6.0 * tmpvar_45) + 1e-7)
    ) + tmpvar_42.z));
    tmpvar_46.y = tmpvar_45;
    tmpvar_46.z = tmpvar_42.x;
    highp vec3 tmpvar_47;
    tmpvar_47.x = (abs((
      (6.0 * tmpvar_46.x)
     - 3.0)) - 1.0);
    tmpvar_47.y = (2.0 - abs((
      (6.0 * tmpvar_46.x)
     - 2.0)));
    tmpvar_47.z = (2.0 - abs((
      (6.0 * tmpvar_46.x)
     - 4.0)));
    highp vec4 tmpvar_48;
    tmpvar_48.xyz = mix (RColor_9.xyz, ((
      (clamp (tmpvar_47, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0)) - 0.5)
     * 
      ((1.0 - abs((
        (2.0 * tmpvar_37)
       - 1.0))) * tmpvar_38.y)
    ) + tmpvar_37), vec3(tmpvar_12));
    tmpvar_48.w = tmpvar_12;
    tmpvar_1 = tmpvar_48;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_CUSTOM","BLEND_HUE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEA",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEB",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec3 COLOR_RANGEA;
uniform highp vec3 COLOR_RANGEB;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp vec4 MColor_5;
    lowp vec4 tmpvar_6;
    tmpvar_6 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_5 = tmpvar_6;
    highp float tmpvar_7;
    tmpvar_7 = (MColor_5.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp vec3 tmpvar_9;
    tmpvar_9 = RColor_4.xyz;
    highp vec3 tmpvar_10;
    tmpvar_10 = mix (COLOR_RANGEA, COLOR_RANGEB, xlv_TEXCOORD2.xxx);
    highp vec4 tmpvar_11;
    if ((RColor_4.y < RColor_4.z)) {
      highp vec4 tmpvar_12;
      tmpvar_12.zw = vec2(-1.0, 0.6666667);
      tmpvar_12.xy = tmpvar_9.zy;
      tmpvar_11 = tmpvar_12;
    } else {
      highp vec4 tmpvar_13;
      tmpvar_13.zw = vec2(0.0, -0.3333333);
      tmpvar_13.xy = tmpvar_9.yz;
      tmpvar_11 = tmpvar_13;
    };
    highp vec4 tmpvar_14;
    if ((RColor_4.x < tmpvar_11.x)) {
      highp vec4 tmpvar_15;
      tmpvar_15.xyz = tmpvar_11.xyw;
      tmpvar_15.w = tmpvar_9.x;
      tmpvar_14 = tmpvar_15;
    } else {
      highp vec4 tmpvar_16;
      tmpvar_16.x = tmpvar_9.x;
      tmpvar_16.yzw = tmpvar_11.yzx;
      tmpvar_14 = tmpvar_16;
    };
    highp float tmpvar_17;
    tmpvar_17 = (tmpvar_14.x - min (tmpvar_14.w, tmpvar_14.y));
    highp vec3 tmpvar_18;
    tmpvar_18.x = abs(((
      (tmpvar_14.w - tmpvar_14.y)
     / 
      ((6.0 * tmpvar_17) + 1e-7)
    ) + tmpvar_14.z));
    tmpvar_18.y = tmpvar_17;
    tmpvar_18.z = tmpvar_14.x;
    highp float tmpvar_19;
    tmpvar_19 = (tmpvar_14.x - (tmpvar_17 * 0.5));
    highp vec3 tmpvar_20;
    tmpvar_20.x = tmpvar_18.x;
    tmpvar_20.y = (tmpvar_17 / ((1.0 - 
      abs(((2.0 * tmpvar_19) - 1.0))
    ) + 1e-7));
    tmpvar_20.z = tmpvar_19;
    highp vec4 tmpvar_21;
    if ((tmpvar_10.y < tmpvar_10.z)) {
      highp vec4 tmpvar_22;
      tmpvar_22.zw = vec2(-1.0, 0.6666667);
      tmpvar_22.xy = tmpvar_10.zy;
      tmpvar_21 = tmpvar_22;
    } else {
      highp vec4 tmpvar_23;
      tmpvar_23.zw = vec2(0.0, -0.3333333);
      tmpvar_23.xy = tmpvar_10.yz;
      tmpvar_21 = tmpvar_23;
    };
    highp vec4 tmpvar_24;
    if ((tmpvar_10.x < tmpvar_21.x)) {
      highp vec4 tmpvar_25;
      tmpvar_25.xyz = tmpvar_21.xyw;
      tmpvar_25.w = tmpvar_10.x;
      tmpvar_24 = tmpvar_25;
    } else {
      highp vec4 tmpvar_26;
      tmpvar_26.x = tmpvar_10.x;
      tmpvar_26.yzw = tmpvar_21.yzx;
      tmpvar_24 = tmpvar_26;
    };
    highp float tmpvar_27;
    tmpvar_27 = (tmpvar_24.x - min (tmpvar_24.w, tmpvar_24.y));
    highp vec3 tmpvar_28;
    tmpvar_28.x = abs(((
      (tmpvar_24.w - tmpvar_24.y)
     / 
      ((6.0 * tmpvar_27) + 1e-7)
    ) + tmpvar_24.z));
    tmpvar_28.y = tmpvar_27;
    tmpvar_28.z = tmpvar_24.x;
    highp vec3 tmpvar_29;
    tmpvar_29.x = (abs((
      (6.0 * tmpvar_28.x)
     - 3.0)) - 1.0);
    tmpvar_29.y = (2.0 - abs((
      (6.0 * tmpvar_28.x)
     - 2.0)));
    tmpvar_29.z = (2.0 - abs((
      (6.0 * tmpvar_28.x)
     - 4.0)));
    highp vec4 tmpvar_30;
    tmpvar_30.xyz = mix (RColor_4.xyz, ((
      (clamp (tmpvar_29, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0)) - 0.5)
     * 
      ((1.0 - abs((
        (2.0 * tmpvar_19)
       - 1.0))) * tmpvar_20.y)
    ) + tmpvar_19), vec3(tmpvar_7));
    tmpvar_30.w = tmpvar_7;
    tmpvar_1 = tmpvar_30;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_ORIGINAL","BLEND_SATURATION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp vec4 MColor_5;
    lowp vec4 tmpvar_6;
    tmpvar_6 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_5 = tmpvar_6;
    highp float tmpvar_7;
    tmpvar_7 = (MColor_5.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp vec3 tmpvar_9;
    tmpvar_9 = RColor_4.xyz;
    highp vec3 tmpvar_10;
    tmpvar_10 = MColor_5.xyz;
    highp vec4 tmpvar_11;
    if ((RColor_4.y < RColor_4.z)) {
      highp vec4 tmpvar_12;
      tmpvar_12.zw = vec2(-1.0, 0.6666667);
      tmpvar_12.xy = tmpvar_9.zy;
      tmpvar_11 = tmpvar_12;
    } else {
      highp vec4 tmpvar_13;
      tmpvar_13.zw = vec2(0.0, -0.3333333);
      tmpvar_13.xy = tmpvar_9.yz;
      tmpvar_11 = tmpvar_13;
    };
    highp vec4 tmpvar_14;
    if ((RColor_4.x < tmpvar_11.x)) {
      highp vec4 tmpvar_15;
      tmpvar_15.xyz = tmpvar_11.xyw;
      tmpvar_15.w = tmpvar_9.x;
      tmpvar_14 = tmpvar_15;
    } else {
      highp vec4 tmpvar_16;
      tmpvar_16.x = tmpvar_9.x;
      tmpvar_16.yzw = tmpvar_11.yzx;
      tmpvar_14 = tmpvar_16;
    };
    highp float tmpvar_17;
    tmpvar_17 = (tmpvar_14.x - min (tmpvar_14.w, tmpvar_14.y));
    highp vec3 tmpvar_18;
    tmpvar_18.x = abs(((
      (tmpvar_14.w - tmpvar_14.y)
     / 
      ((6.0 * tmpvar_17) + 1e-7)
    ) + tmpvar_14.z));
    tmpvar_18.y = tmpvar_17;
    tmpvar_18.z = tmpvar_14.x;
    highp float tmpvar_19;
    tmpvar_19 = (tmpvar_14.x - (tmpvar_17 * 0.5));
    highp vec4 tmpvar_20;
    if ((MColor_5.y < MColor_5.z)) {
      highp vec4 tmpvar_21;
      tmpvar_21.zw = vec2(-1.0, 0.6666667);
      tmpvar_21.xy = tmpvar_10.zy;
      tmpvar_20 = tmpvar_21;
    } else {
      highp vec4 tmpvar_22;
      tmpvar_22.zw = vec2(0.0, -0.3333333);
      tmpvar_22.xy = tmpvar_10.yz;
      tmpvar_20 = tmpvar_22;
    };
    highp vec4 tmpvar_23;
    if ((MColor_5.x < tmpvar_20.x)) {
      highp vec4 tmpvar_24;
      tmpvar_24.xyz = tmpvar_20.xyw;
      tmpvar_24.w = tmpvar_10.x;
      tmpvar_23 = tmpvar_24;
    } else {
      highp vec4 tmpvar_25;
      tmpvar_25.x = tmpvar_10.x;
      tmpvar_25.yzw = tmpvar_20.yzx;
      tmpvar_23 = tmpvar_25;
    };
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_23.x - min (tmpvar_23.w, tmpvar_23.y));
    highp vec3 tmpvar_27;
    tmpvar_27.x = abs(((
      (tmpvar_23.w - tmpvar_23.y)
     / 
      ((6.0 * tmpvar_26) + 1e-7)
    ) + tmpvar_23.z));
    tmpvar_27.y = tmpvar_26;
    tmpvar_27.z = tmpvar_23.x;
    highp float tmpvar_28;
    tmpvar_28 = (tmpvar_23.x - (tmpvar_26 * 0.5));
    highp vec3 tmpvar_29;
    tmpvar_29.x = tmpvar_27.x;
    tmpvar_29.y = (tmpvar_26 / ((1.0 - 
      abs(((2.0 * tmpvar_28) - 1.0))
    ) + 1e-7));
    tmpvar_29.z = tmpvar_28;
    highp vec3 tmpvar_30;
    tmpvar_30.x = (abs((
      (6.0 * tmpvar_18.x)
     - 3.0)) - 1.0);
    tmpvar_30.y = (2.0 - abs((
      (6.0 * tmpvar_18.x)
     - 2.0)));
    tmpvar_30.z = (2.0 - abs((
      (6.0 * tmpvar_18.x)
     - 4.0)));
    highp vec4 tmpvar_31;
    tmpvar_31.xyz = mix (RColor_4.xyz, ((
      (clamp (tmpvar_30, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0)) - 0.5)
     * 
      ((1.0 - abs((
        (2.0 * tmpvar_19)
       - 1.0))) * tmpvar_29.y)
    ) + tmpvar_19), vec3(tmpvar_7));
    tmpvar_31.w = tmpvar_7;
    tmpvar_1 = tmpvar_31;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_BLEND","BLEND_SATURATION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIXEL_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec2 PIXEL_SIZE;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec3 bot_4;
    highp vec3 top_5;
    highp vec3 right_6;
    highp vec3 left_7;
    highp vec3 Middle_8;
    highp vec4 RColor_9;
    highp vec4 MColor_10;
    lowp vec4 tmpvar_11;
    tmpvar_11 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_10 = tmpvar_11;
    highp float tmpvar_12;
    tmpvar_12 = (MColor_10.w * OPACITY);
    lowp vec4 tmpvar_13;
    tmpvar_13 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_9 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = RColor_9.xyz;
    lowp vec3 tmpvar_15;
    tmpvar_15 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.zw).xyz;
    Middle_8 = tmpvar_15;
    highp vec2 tmpvar_16;
    tmpvar_16.y = 0.0;
    tmpvar_16.x = -(PIXEL_SIZE.x);
    highp vec2 P_17;
    P_17 = (xlv_TEXCOORD1.zw + tmpvar_16);
    lowp vec3 tmpvar_18;
    tmpvar_18 = texture (TEXTURE_GLOSSINESS, P_17).xyz;
    left_7 = tmpvar_18;
    highp vec2 tmpvar_19;
    tmpvar_19.y = 0.0;
    tmpvar_19.x = PIXEL_SIZE.x;
    highp vec2 P_20;
    P_20 = (xlv_TEXCOORD1.zw + tmpvar_19);
    lowp vec3 tmpvar_21;
    tmpvar_21 = texture (TEXTURE_GLOSSINESS, P_20).xyz;
    right_6 = tmpvar_21;
    highp vec2 tmpvar_22;
    tmpvar_22.x = 0.0;
    tmpvar_22.y = -(PIXEL_SIZE.y);
    highp vec2 P_23;
    P_23 = (xlv_TEXCOORD1.zw + tmpvar_22);
    lowp vec3 tmpvar_24;
    tmpvar_24 = texture (TEXTURE_GLOSSINESS, P_23).xyz;
    top_5 = tmpvar_24;
    highp vec2 tmpvar_25;
    tmpvar_25.x = 0.0;
    tmpvar_25.y = PIXEL_SIZE.y;
    highp vec2 P_26;
    P_26 = (xlv_TEXCOORD1.zw + tmpvar_25);
    lowp vec3 tmpvar_27;
    tmpvar_27 = texture (TEXTURE_GLOSSINESS, P_26).xyz;
    bot_4 = tmpvar_27;
    highp vec3 tmpvar_28;
    tmpvar_28 = max (max (Middle_8, left_7), max (max (right_6, top_5), bot_4));
    highp vec4 tmpvar_29;
    if ((RColor_9.y < RColor_9.z)) {
      highp vec4 tmpvar_30;
      tmpvar_30.zw = vec2(-1.0, 0.6666667);
      tmpvar_30.xy = tmpvar_14.zy;
      tmpvar_29 = tmpvar_30;
    } else {
      highp vec4 tmpvar_31;
      tmpvar_31.zw = vec2(0.0, -0.3333333);
      tmpvar_31.xy = tmpvar_14.yz;
      tmpvar_29 = tmpvar_31;
    };
    highp vec4 tmpvar_32;
    if ((RColor_9.x < tmpvar_29.x)) {
      highp vec4 tmpvar_33;
      tmpvar_33.xyz = tmpvar_29.xyw;
      tmpvar_33.w = tmpvar_14.x;
      tmpvar_32 = tmpvar_33;
    } else {
      highp vec4 tmpvar_34;
      tmpvar_34.x = tmpvar_14.x;
      tmpvar_34.yzw = tmpvar_29.yzx;
      tmpvar_32 = tmpvar_34;
    };
    highp float tmpvar_35;
    tmpvar_35 = (tmpvar_32.x - min (tmpvar_32.w, tmpvar_32.y));
    highp vec3 tmpvar_36;
    tmpvar_36.x = abs(((
      (tmpvar_32.w - tmpvar_32.y)
     / 
      ((6.0 * tmpvar_35) + 1e-7)
    ) + tmpvar_32.z));
    tmpvar_36.y = tmpvar_35;
    tmpvar_36.z = tmpvar_32.x;
    highp float tmpvar_37;
    tmpvar_37 = (tmpvar_32.x - (tmpvar_35 * 0.5));
    highp vec4 tmpvar_38;
    if ((tmpvar_28.y < tmpvar_28.z)) {
      highp vec4 tmpvar_39;
      tmpvar_39.zw = vec2(-1.0, 0.6666667);
      tmpvar_39.xy = tmpvar_28.zy;
      tmpvar_38 = tmpvar_39;
    } else {
      highp vec4 tmpvar_40;
      tmpvar_40.zw = vec2(0.0, -0.3333333);
      tmpvar_40.xy = tmpvar_28.yz;
      tmpvar_38 = tmpvar_40;
    };
    highp vec4 tmpvar_41;
    if ((tmpvar_28.x < tmpvar_38.x)) {
      highp vec4 tmpvar_42;
      tmpvar_42.xyz = tmpvar_38.xyw;
      tmpvar_42.w = tmpvar_28.x;
      tmpvar_41 = tmpvar_42;
    } else {
      highp vec4 tmpvar_43;
      tmpvar_43.x = tmpvar_28.x;
      tmpvar_43.yzw = tmpvar_38.yzx;
      tmpvar_41 = tmpvar_43;
    };
    highp float tmpvar_44;
    tmpvar_44 = (tmpvar_41.x - min (tmpvar_41.w, tmpvar_41.y));
    highp vec3 tmpvar_45;
    tmpvar_45.x = abs(((
      (tmpvar_41.w - tmpvar_41.y)
     / 
      ((6.0 * tmpvar_44) + 1e-7)
    ) + tmpvar_41.z));
    tmpvar_45.y = tmpvar_44;
    tmpvar_45.z = tmpvar_41.x;
    highp float tmpvar_46;
    tmpvar_46 = (tmpvar_41.x - (tmpvar_44 * 0.5));
    highp vec3 tmpvar_47;
    tmpvar_47.x = tmpvar_45.x;
    tmpvar_47.y = (tmpvar_44 / ((1.0 - 
      abs(((2.0 * tmpvar_46) - 1.0))
    ) + 1e-7));
    tmpvar_47.z = tmpvar_46;
    highp vec3 tmpvar_48;
    tmpvar_48.x = (abs((
      (6.0 * tmpvar_36.x)
     - 3.0)) - 1.0);
    tmpvar_48.y = (2.0 - abs((
      (6.0 * tmpvar_36.x)
     - 2.0)));
    tmpvar_48.z = (2.0 - abs((
      (6.0 * tmpvar_36.x)
     - 4.0)));
    highp vec4 tmpvar_49;
    tmpvar_49.xyz = mix (RColor_9.xyz, ((
      (clamp (tmpvar_48, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0)) - 0.5)
     * 
      ((1.0 - abs((
        (2.0 * tmpvar_37)
       - 1.0))) * tmpvar_47.y)
    ) + tmpvar_37), vec3(tmpvar_12));
    tmpvar_49.w = tmpvar_12;
    tmpvar_1 = tmpvar_49;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_CUSTOM","BLEND_SATURATION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEA",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEB",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec3 COLOR_RANGEA;
uniform highp vec3 COLOR_RANGEB;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp vec4 MColor_5;
    lowp vec4 tmpvar_6;
    tmpvar_6 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_5 = tmpvar_6;
    highp float tmpvar_7;
    tmpvar_7 = (MColor_5.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp vec3 tmpvar_9;
    tmpvar_9 = RColor_4.xyz;
    highp vec3 tmpvar_10;
    tmpvar_10 = mix (COLOR_RANGEA, COLOR_RANGEB, xlv_TEXCOORD2.xxx);
    highp vec4 tmpvar_11;
    if ((RColor_4.y < RColor_4.z)) {
      highp vec4 tmpvar_12;
      tmpvar_12.zw = vec2(-1.0, 0.6666667);
      tmpvar_12.xy = tmpvar_9.zy;
      tmpvar_11 = tmpvar_12;
    } else {
      highp vec4 tmpvar_13;
      tmpvar_13.zw = vec2(0.0, -0.3333333);
      tmpvar_13.xy = tmpvar_9.yz;
      tmpvar_11 = tmpvar_13;
    };
    highp vec4 tmpvar_14;
    if ((RColor_4.x < tmpvar_11.x)) {
      highp vec4 tmpvar_15;
      tmpvar_15.xyz = tmpvar_11.xyw;
      tmpvar_15.w = tmpvar_9.x;
      tmpvar_14 = tmpvar_15;
    } else {
      highp vec4 tmpvar_16;
      tmpvar_16.x = tmpvar_9.x;
      tmpvar_16.yzw = tmpvar_11.yzx;
      tmpvar_14 = tmpvar_16;
    };
    highp float tmpvar_17;
    tmpvar_17 = (tmpvar_14.x - min (tmpvar_14.w, tmpvar_14.y));
    highp vec3 tmpvar_18;
    tmpvar_18.x = abs(((
      (tmpvar_14.w - tmpvar_14.y)
     / 
      ((6.0 * tmpvar_17) + 1e-7)
    ) + tmpvar_14.z));
    tmpvar_18.y = tmpvar_17;
    tmpvar_18.z = tmpvar_14.x;
    highp float tmpvar_19;
    tmpvar_19 = (tmpvar_14.x - (tmpvar_17 * 0.5));
    highp vec4 tmpvar_20;
    if ((tmpvar_10.y < tmpvar_10.z)) {
      highp vec4 tmpvar_21;
      tmpvar_21.zw = vec2(-1.0, 0.6666667);
      tmpvar_21.xy = tmpvar_10.zy;
      tmpvar_20 = tmpvar_21;
    } else {
      highp vec4 tmpvar_22;
      tmpvar_22.zw = vec2(0.0, -0.3333333);
      tmpvar_22.xy = tmpvar_10.yz;
      tmpvar_20 = tmpvar_22;
    };
    highp vec4 tmpvar_23;
    if ((tmpvar_10.x < tmpvar_20.x)) {
      highp vec4 tmpvar_24;
      tmpvar_24.xyz = tmpvar_20.xyw;
      tmpvar_24.w = tmpvar_10.x;
      tmpvar_23 = tmpvar_24;
    } else {
      highp vec4 tmpvar_25;
      tmpvar_25.x = tmpvar_10.x;
      tmpvar_25.yzw = tmpvar_20.yzx;
      tmpvar_23 = tmpvar_25;
    };
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_23.x - min (tmpvar_23.w, tmpvar_23.y));
    highp vec3 tmpvar_27;
    tmpvar_27.x = abs(((
      (tmpvar_23.w - tmpvar_23.y)
     / 
      ((6.0 * tmpvar_26) + 1e-7)
    ) + tmpvar_23.z));
    tmpvar_27.y = tmpvar_26;
    tmpvar_27.z = tmpvar_23.x;
    highp float tmpvar_28;
    tmpvar_28 = (tmpvar_23.x - (tmpvar_26 * 0.5));
    highp vec3 tmpvar_29;
    tmpvar_29.x = tmpvar_27.x;
    tmpvar_29.y = (tmpvar_26 / ((1.0 - 
      abs(((2.0 * tmpvar_28) - 1.0))
    ) + 1e-7));
    tmpvar_29.z = tmpvar_28;
    highp vec3 tmpvar_30;
    tmpvar_30.x = (abs((
      (6.0 * tmpvar_18.x)
     - 3.0)) - 1.0);
    tmpvar_30.y = (2.0 - abs((
      (6.0 * tmpvar_18.x)
     - 2.0)));
    tmpvar_30.z = (2.0 - abs((
      (6.0 * tmpvar_18.x)
     - 4.0)));
    highp vec4 tmpvar_31;
    tmpvar_31.xyz = mix (RColor_4.xyz, ((
      (clamp (tmpvar_30, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0)) - 0.5)
     * 
      ((1.0 - abs((
        (2.0 * tmpvar_19)
       - 1.0))) * tmpvar_29.y)
    ) + tmpvar_19), vec3(tmpvar_7));
    tmpvar_31.w = tmpvar_7;
    tmpvar_1 = tmpvar_31;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_ORIGINAL","BLEND_LUMINOSITY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp vec4 MColor_5;
    lowp vec4 tmpvar_6;
    tmpvar_6 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_5 = tmpvar_6;
    highp float tmpvar_7;
    tmpvar_7 = (MColor_5.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp vec3 tmpvar_9;
    tmpvar_9 = RColor_4.xyz;
    highp vec3 tmpvar_10;
    tmpvar_10 = MColor_5.xyz;
    highp vec4 tmpvar_11;
    if ((RColor_4.y < RColor_4.z)) {
      highp vec4 tmpvar_12;
      tmpvar_12.zw = vec2(-1.0, 0.6666667);
      tmpvar_12.xy = tmpvar_9.zy;
      tmpvar_11 = tmpvar_12;
    } else {
      highp vec4 tmpvar_13;
      tmpvar_13.zw = vec2(0.0, -0.3333333);
      tmpvar_13.xy = tmpvar_9.yz;
      tmpvar_11 = tmpvar_13;
    };
    highp vec4 tmpvar_14;
    if ((RColor_4.x < tmpvar_11.x)) {
      highp vec4 tmpvar_15;
      tmpvar_15.xyz = tmpvar_11.xyw;
      tmpvar_15.w = tmpvar_9.x;
      tmpvar_14 = tmpvar_15;
    } else {
      highp vec4 tmpvar_16;
      tmpvar_16.x = tmpvar_9.x;
      tmpvar_16.yzw = tmpvar_11.yzx;
      tmpvar_14 = tmpvar_16;
    };
    highp float tmpvar_17;
    tmpvar_17 = (tmpvar_14.x - min (tmpvar_14.w, tmpvar_14.y));
    highp vec3 tmpvar_18;
    tmpvar_18.x = abs(((
      (tmpvar_14.w - tmpvar_14.y)
     / 
      ((6.0 * tmpvar_17) + 1e-7)
    ) + tmpvar_14.z));
    tmpvar_18.y = tmpvar_17;
    tmpvar_18.z = tmpvar_14.x;
    highp float tmpvar_19;
    tmpvar_19 = (tmpvar_14.x - (tmpvar_17 * 0.5));
    highp vec3 tmpvar_20;
    tmpvar_20.x = tmpvar_18.x;
    tmpvar_20.y = (tmpvar_17 / ((1.0 - 
      abs(((2.0 * tmpvar_19) - 1.0))
    ) + 1e-7));
    tmpvar_20.z = tmpvar_19;
    highp vec4 tmpvar_21;
    if ((MColor_5.y < MColor_5.z)) {
      highp vec4 tmpvar_22;
      tmpvar_22.zw = vec2(-1.0, 0.6666667);
      tmpvar_22.xy = tmpvar_10.zy;
      tmpvar_21 = tmpvar_22;
    } else {
      highp vec4 tmpvar_23;
      tmpvar_23.zw = vec2(0.0, -0.3333333);
      tmpvar_23.xy = tmpvar_10.yz;
      tmpvar_21 = tmpvar_23;
    };
    highp vec4 tmpvar_24;
    if ((MColor_5.x < tmpvar_21.x)) {
      highp vec4 tmpvar_25;
      tmpvar_25.xyz = tmpvar_21.xyw;
      tmpvar_25.w = tmpvar_10.x;
      tmpvar_24 = tmpvar_25;
    } else {
      highp vec4 tmpvar_26;
      tmpvar_26.x = tmpvar_10.x;
      tmpvar_26.yzw = tmpvar_21.yzx;
      tmpvar_24 = tmpvar_26;
    };
    highp float tmpvar_27;
    tmpvar_27 = (tmpvar_24.x - ((tmpvar_24.x - 
      min (tmpvar_24.w, tmpvar_24.y)
    ) * 0.5));
    highp vec3 tmpvar_28;
    tmpvar_28.x = (abs((
      (6.0 * tmpvar_18.x)
     - 3.0)) - 1.0);
    tmpvar_28.y = (2.0 - abs((
      (6.0 * tmpvar_18.x)
     - 2.0)));
    tmpvar_28.z = (2.0 - abs((
      (6.0 * tmpvar_18.x)
     - 4.0)));
    highp vec4 tmpvar_29;
    tmpvar_29.xyz = mix (RColor_4.xyz, ((
      (clamp (tmpvar_28, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0)) - 0.5)
     * 
      ((1.0 - abs((
        (2.0 * tmpvar_27)
       - 1.0))) * tmpvar_20.y)
    ) + tmpvar_27), vec3(tmpvar_7));
    tmpvar_29.w = tmpvar_7;
    tmpvar_1 = tmpvar_29;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_BLEND","BLEND_LUMINOSITY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIXEL_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec2 PIXEL_SIZE;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec3 bot_4;
    highp vec3 top_5;
    highp vec3 right_6;
    highp vec3 left_7;
    highp vec3 Middle_8;
    highp vec4 RColor_9;
    highp vec4 MColor_10;
    lowp vec4 tmpvar_11;
    tmpvar_11 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_10 = tmpvar_11;
    highp float tmpvar_12;
    tmpvar_12 = (MColor_10.w * OPACITY);
    lowp vec4 tmpvar_13;
    tmpvar_13 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_9 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = RColor_9.xyz;
    lowp vec3 tmpvar_15;
    tmpvar_15 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.zw).xyz;
    Middle_8 = tmpvar_15;
    highp vec2 tmpvar_16;
    tmpvar_16.y = 0.0;
    tmpvar_16.x = -(PIXEL_SIZE.x);
    highp vec2 P_17;
    P_17 = (xlv_TEXCOORD1.zw + tmpvar_16);
    lowp vec3 tmpvar_18;
    tmpvar_18 = texture (TEXTURE_GLOSSINESS, P_17).xyz;
    left_7 = tmpvar_18;
    highp vec2 tmpvar_19;
    tmpvar_19.y = 0.0;
    tmpvar_19.x = PIXEL_SIZE.x;
    highp vec2 P_20;
    P_20 = (xlv_TEXCOORD1.zw + tmpvar_19);
    lowp vec3 tmpvar_21;
    tmpvar_21 = texture (TEXTURE_GLOSSINESS, P_20).xyz;
    right_6 = tmpvar_21;
    highp vec2 tmpvar_22;
    tmpvar_22.x = 0.0;
    tmpvar_22.y = -(PIXEL_SIZE.y);
    highp vec2 P_23;
    P_23 = (xlv_TEXCOORD1.zw + tmpvar_22);
    lowp vec3 tmpvar_24;
    tmpvar_24 = texture (TEXTURE_GLOSSINESS, P_23).xyz;
    top_5 = tmpvar_24;
    highp vec2 tmpvar_25;
    tmpvar_25.x = 0.0;
    tmpvar_25.y = PIXEL_SIZE.y;
    highp vec2 P_26;
    P_26 = (xlv_TEXCOORD1.zw + tmpvar_25);
    lowp vec3 tmpvar_27;
    tmpvar_27 = texture (TEXTURE_GLOSSINESS, P_26).xyz;
    bot_4 = tmpvar_27;
    highp vec3 tmpvar_28;
    tmpvar_28 = max (max (Middle_8, left_7), max (max (right_6, top_5), bot_4));
    highp vec4 tmpvar_29;
    if ((RColor_9.y < RColor_9.z)) {
      highp vec4 tmpvar_30;
      tmpvar_30.zw = vec2(-1.0, 0.6666667);
      tmpvar_30.xy = tmpvar_14.zy;
      tmpvar_29 = tmpvar_30;
    } else {
      highp vec4 tmpvar_31;
      tmpvar_31.zw = vec2(0.0, -0.3333333);
      tmpvar_31.xy = tmpvar_14.yz;
      tmpvar_29 = tmpvar_31;
    };
    highp vec4 tmpvar_32;
    if ((RColor_9.x < tmpvar_29.x)) {
      highp vec4 tmpvar_33;
      tmpvar_33.xyz = tmpvar_29.xyw;
      tmpvar_33.w = tmpvar_14.x;
      tmpvar_32 = tmpvar_33;
    } else {
      highp vec4 tmpvar_34;
      tmpvar_34.x = tmpvar_14.x;
      tmpvar_34.yzw = tmpvar_29.yzx;
      tmpvar_32 = tmpvar_34;
    };
    highp float tmpvar_35;
    tmpvar_35 = (tmpvar_32.x - min (tmpvar_32.w, tmpvar_32.y));
    highp vec3 tmpvar_36;
    tmpvar_36.x = abs(((
      (tmpvar_32.w - tmpvar_32.y)
     / 
      ((6.0 * tmpvar_35) + 1e-7)
    ) + tmpvar_32.z));
    tmpvar_36.y = tmpvar_35;
    tmpvar_36.z = tmpvar_32.x;
    highp float tmpvar_37;
    tmpvar_37 = (tmpvar_32.x - (tmpvar_35 * 0.5));
    highp vec3 tmpvar_38;
    tmpvar_38.x = tmpvar_36.x;
    tmpvar_38.y = (tmpvar_35 / ((1.0 - 
      abs(((2.0 * tmpvar_37) - 1.0))
    ) + 1e-7));
    tmpvar_38.z = tmpvar_37;
    highp vec4 tmpvar_39;
    if ((tmpvar_28.y < tmpvar_28.z)) {
      highp vec4 tmpvar_40;
      tmpvar_40.zw = vec2(-1.0, 0.6666667);
      tmpvar_40.xy = tmpvar_28.zy;
      tmpvar_39 = tmpvar_40;
    } else {
      highp vec4 tmpvar_41;
      tmpvar_41.zw = vec2(0.0, -0.3333333);
      tmpvar_41.xy = tmpvar_28.yz;
      tmpvar_39 = tmpvar_41;
    };
    highp vec4 tmpvar_42;
    if ((tmpvar_28.x < tmpvar_39.x)) {
      highp vec4 tmpvar_43;
      tmpvar_43.xyz = tmpvar_39.xyw;
      tmpvar_43.w = tmpvar_28.x;
      tmpvar_42 = tmpvar_43;
    } else {
      highp vec4 tmpvar_44;
      tmpvar_44.x = tmpvar_28.x;
      tmpvar_44.yzw = tmpvar_39.yzx;
      tmpvar_42 = tmpvar_44;
    };
    highp float tmpvar_45;
    tmpvar_45 = (tmpvar_42.x - ((tmpvar_42.x - 
      min (tmpvar_42.w, tmpvar_42.y)
    ) * 0.5));
    highp vec3 tmpvar_46;
    tmpvar_46.x = (abs((
      (6.0 * tmpvar_36.x)
     - 3.0)) - 1.0);
    tmpvar_46.y = (2.0 - abs((
      (6.0 * tmpvar_36.x)
     - 2.0)));
    tmpvar_46.z = (2.0 - abs((
      (6.0 * tmpvar_36.x)
     - 4.0)));
    highp vec4 tmpvar_47;
    tmpvar_47.xyz = mix (RColor_9.xyz, ((
      (clamp (tmpvar_46, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0)) - 0.5)
     * 
      ((1.0 - abs((
        (2.0 * tmpvar_45)
       - 1.0))) * tmpvar_38.y)
    ) + tmpvar_45), vec3(tmpvar_12));
    tmpvar_47.w = tmpvar_12;
    tmpvar_1 = tmpvar_47;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_CUSTOM","BLEND_LUMINOSITY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEA",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEB",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec3 COLOR_RANGEA;
uniform highp vec3 COLOR_RANGEB;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp vec4 MColor_5;
    lowp vec4 tmpvar_6;
    tmpvar_6 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_5 = tmpvar_6;
    highp float tmpvar_7;
    tmpvar_7 = (MColor_5.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp vec3 tmpvar_9;
    tmpvar_9 = RColor_4.xyz;
    highp vec3 tmpvar_10;
    tmpvar_10 = mix (COLOR_RANGEA, COLOR_RANGEB, xlv_TEXCOORD2.xxx);
    highp vec4 tmpvar_11;
    if ((RColor_4.y < RColor_4.z)) {
      highp vec4 tmpvar_12;
      tmpvar_12.zw = vec2(-1.0, 0.6666667);
      tmpvar_12.xy = tmpvar_9.zy;
      tmpvar_11 = tmpvar_12;
    } else {
      highp vec4 tmpvar_13;
      tmpvar_13.zw = vec2(0.0, -0.3333333);
      tmpvar_13.xy = tmpvar_9.yz;
      tmpvar_11 = tmpvar_13;
    };
    highp vec4 tmpvar_14;
    if ((RColor_4.x < tmpvar_11.x)) {
      highp vec4 tmpvar_15;
      tmpvar_15.xyz = tmpvar_11.xyw;
      tmpvar_15.w = tmpvar_9.x;
      tmpvar_14 = tmpvar_15;
    } else {
      highp vec4 tmpvar_16;
      tmpvar_16.x = tmpvar_9.x;
      tmpvar_16.yzw = tmpvar_11.yzx;
      tmpvar_14 = tmpvar_16;
    };
    highp float tmpvar_17;
    tmpvar_17 = (tmpvar_14.x - min (tmpvar_14.w, tmpvar_14.y));
    highp vec3 tmpvar_18;
    tmpvar_18.x = abs(((
      (tmpvar_14.w - tmpvar_14.y)
     / 
      ((6.0 * tmpvar_17) + 1e-7)
    ) + tmpvar_14.z));
    tmpvar_18.y = tmpvar_17;
    tmpvar_18.z = tmpvar_14.x;
    highp float tmpvar_19;
    tmpvar_19 = (tmpvar_14.x - (tmpvar_17 * 0.5));
    highp vec3 tmpvar_20;
    tmpvar_20.x = tmpvar_18.x;
    tmpvar_20.y = (tmpvar_17 / ((1.0 - 
      abs(((2.0 * tmpvar_19) - 1.0))
    ) + 1e-7));
    tmpvar_20.z = tmpvar_19;
    highp vec4 tmpvar_21;
    if ((tmpvar_10.y < tmpvar_10.z)) {
      highp vec4 tmpvar_22;
      tmpvar_22.zw = vec2(-1.0, 0.6666667);
      tmpvar_22.xy = tmpvar_10.zy;
      tmpvar_21 = tmpvar_22;
    } else {
      highp vec4 tmpvar_23;
      tmpvar_23.zw = vec2(0.0, -0.3333333);
      tmpvar_23.xy = tmpvar_10.yz;
      tmpvar_21 = tmpvar_23;
    };
    highp vec4 tmpvar_24;
    if ((tmpvar_10.x < tmpvar_21.x)) {
      highp vec4 tmpvar_25;
      tmpvar_25.xyz = tmpvar_21.xyw;
      tmpvar_25.w = tmpvar_10.x;
      tmpvar_24 = tmpvar_25;
    } else {
      highp vec4 tmpvar_26;
      tmpvar_26.x = tmpvar_10.x;
      tmpvar_26.yzw = tmpvar_21.yzx;
      tmpvar_24 = tmpvar_26;
    };
    highp float tmpvar_27;
    tmpvar_27 = (tmpvar_24.x - ((tmpvar_24.x - 
      min (tmpvar_24.w, tmpvar_24.y)
    ) * 0.5));
    highp vec3 tmpvar_28;
    tmpvar_28.x = (abs((
      (6.0 * tmpvar_18.x)
     - 3.0)) - 1.0);
    tmpvar_28.y = (2.0 - abs((
      (6.0 * tmpvar_18.x)
     - 2.0)));
    tmpvar_28.z = (2.0 - abs((
      (6.0 * tmpvar_18.x)
     - 4.0)));
    highp vec4 tmpvar_29;
    tmpvar_29.xyz = mix (RColor_4.xyz, ((
      (clamp (tmpvar_28, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0)) - 0.5)
     * 
      ((1.0 - abs((
        (2.0 * tmpvar_27)
       - 1.0))) * tmpvar_20.y)
    ) + tmpvar_27), vec3(tmpvar_7));
    tmpvar_29.w = tmpvar_7;
    tmpvar_1 = tmpvar_29;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_ORIGINAL","BLEND_COLOR"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp vec4 MColor_5;
    lowp vec4 tmpvar_6;
    tmpvar_6 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_5 = tmpvar_6;
    highp float tmpvar_7;
    tmpvar_7 = (MColor_5.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp vec3 tmpvar_9;
    tmpvar_9 = RColor_4.xyz;
    highp vec3 tmpvar_10;
    tmpvar_10 = MColor_5.xyz;
    highp vec4 tmpvar_11;
    if ((RColor_4.y < RColor_4.z)) {
      highp vec4 tmpvar_12;
      tmpvar_12.zw = vec2(-1.0, 0.6666667);
      tmpvar_12.xy = tmpvar_9.zy;
      tmpvar_11 = tmpvar_12;
    } else {
      highp vec4 tmpvar_13;
      tmpvar_13.zw = vec2(0.0, -0.3333333);
      tmpvar_13.xy = tmpvar_9.yz;
      tmpvar_11 = tmpvar_13;
    };
    highp vec4 tmpvar_14;
    if ((RColor_4.x < tmpvar_11.x)) {
      highp vec4 tmpvar_15;
      tmpvar_15.xyz = tmpvar_11.xyw;
      tmpvar_15.w = tmpvar_9.x;
      tmpvar_14 = tmpvar_15;
    } else {
      highp vec4 tmpvar_16;
      tmpvar_16.x = tmpvar_9.x;
      tmpvar_16.yzw = tmpvar_11.yzx;
      tmpvar_14 = tmpvar_16;
    };
    highp float tmpvar_17;
    tmpvar_17 = (tmpvar_14.x - ((tmpvar_14.x - 
      min (tmpvar_14.w, tmpvar_14.y)
    ) * 0.5));
    highp vec4 tmpvar_18;
    if ((MColor_5.y < MColor_5.z)) {
      highp vec4 tmpvar_19;
      tmpvar_19.zw = vec2(-1.0, 0.6666667);
      tmpvar_19.xy = tmpvar_10.zy;
      tmpvar_18 = tmpvar_19;
    } else {
      highp vec4 tmpvar_20;
      tmpvar_20.zw = vec2(0.0, -0.3333333);
      tmpvar_20.xy = tmpvar_10.yz;
      tmpvar_18 = tmpvar_20;
    };
    highp vec4 tmpvar_21;
    if ((MColor_5.x < tmpvar_18.x)) {
      highp vec4 tmpvar_22;
      tmpvar_22.xyz = tmpvar_18.xyw;
      tmpvar_22.w = tmpvar_10.x;
      tmpvar_21 = tmpvar_22;
    } else {
      highp vec4 tmpvar_23;
      tmpvar_23.x = tmpvar_10.x;
      tmpvar_23.yzw = tmpvar_18.yzx;
      tmpvar_21 = tmpvar_23;
    };
    highp float tmpvar_24;
    tmpvar_24 = (tmpvar_21.x - min (tmpvar_21.w, tmpvar_21.y));
    highp vec3 tmpvar_25;
    tmpvar_25.x = abs(((
      (tmpvar_21.w - tmpvar_21.y)
     / 
      ((6.0 * tmpvar_24) + 1e-7)
    ) + tmpvar_21.z));
    tmpvar_25.y = tmpvar_24;
    tmpvar_25.z = tmpvar_21.x;
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_21.x - (tmpvar_24 * 0.5));
    highp vec3 tmpvar_27;
    tmpvar_27.x = tmpvar_25.x;
    tmpvar_27.y = (tmpvar_24 / ((1.0 - 
      abs(((2.0 * tmpvar_26) - 1.0))
    ) + 1e-7));
    tmpvar_27.z = tmpvar_26;
    highp vec3 tmpvar_28;
    tmpvar_28.x = (abs((
      (6.0 * tmpvar_25.x)
     - 3.0)) - 1.0);
    tmpvar_28.y = (2.0 - abs((
      (6.0 * tmpvar_25.x)
     - 2.0)));
    tmpvar_28.z = (2.0 - abs((
      (6.0 * tmpvar_25.x)
     - 4.0)));
    highp vec4 tmpvar_29;
    tmpvar_29.xyz = mix (RColor_4.xyz, ((
      (clamp (tmpvar_28, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0)) - 0.5)
     * 
      ((1.0 - abs((
        (2.0 * tmpvar_17)
       - 1.0))) * tmpvar_27.y)
    ) + tmpvar_17), vec3(tmpvar_7));
    tmpvar_29.w = tmpvar_7;
    tmpvar_1 = tmpvar_29;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_BLEND","BLEND_COLOR"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIXEL_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec2 PIXEL_SIZE;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec3 bot_4;
    highp vec3 top_5;
    highp vec3 right_6;
    highp vec3 left_7;
    highp vec3 Middle_8;
    highp vec4 RColor_9;
    highp vec4 MColor_10;
    lowp vec4 tmpvar_11;
    tmpvar_11 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_10 = tmpvar_11;
    highp float tmpvar_12;
    tmpvar_12 = (MColor_10.w * OPACITY);
    lowp vec4 tmpvar_13;
    tmpvar_13 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_9 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = RColor_9.xyz;
    lowp vec3 tmpvar_15;
    tmpvar_15 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.zw).xyz;
    Middle_8 = tmpvar_15;
    highp vec2 tmpvar_16;
    tmpvar_16.y = 0.0;
    tmpvar_16.x = -(PIXEL_SIZE.x);
    highp vec2 P_17;
    P_17 = (xlv_TEXCOORD1.zw + tmpvar_16);
    lowp vec3 tmpvar_18;
    tmpvar_18 = texture (TEXTURE_GLOSSINESS, P_17).xyz;
    left_7 = tmpvar_18;
    highp vec2 tmpvar_19;
    tmpvar_19.y = 0.0;
    tmpvar_19.x = PIXEL_SIZE.x;
    highp vec2 P_20;
    P_20 = (xlv_TEXCOORD1.zw + tmpvar_19);
    lowp vec3 tmpvar_21;
    tmpvar_21 = texture (TEXTURE_GLOSSINESS, P_20).xyz;
    right_6 = tmpvar_21;
    highp vec2 tmpvar_22;
    tmpvar_22.x = 0.0;
    tmpvar_22.y = -(PIXEL_SIZE.y);
    highp vec2 P_23;
    P_23 = (xlv_TEXCOORD1.zw + tmpvar_22);
    lowp vec3 tmpvar_24;
    tmpvar_24 = texture (TEXTURE_GLOSSINESS, P_23).xyz;
    top_5 = tmpvar_24;
    highp vec2 tmpvar_25;
    tmpvar_25.x = 0.0;
    tmpvar_25.y = PIXEL_SIZE.y;
    highp vec2 P_26;
    P_26 = (xlv_TEXCOORD1.zw + tmpvar_25);
    lowp vec3 tmpvar_27;
    tmpvar_27 = texture (TEXTURE_GLOSSINESS, P_26).xyz;
    bot_4 = tmpvar_27;
    highp vec3 tmpvar_28;
    tmpvar_28 = max (max (Middle_8, left_7), max (max (right_6, top_5), bot_4));
    highp vec4 tmpvar_29;
    if ((RColor_9.y < RColor_9.z)) {
      highp vec4 tmpvar_30;
      tmpvar_30.zw = vec2(-1.0, 0.6666667);
      tmpvar_30.xy = tmpvar_14.zy;
      tmpvar_29 = tmpvar_30;
    } else {
      highp vec4 tmpvar_31;
      tmpvar_31.zw = vec2(0.0, -0.3333333);
      tmpvar_31.xy = tmpvar_14.yz;
      tmpvar_29 = tmpvar_31;
    };
    highp vec4 tmpvar_32;
    if ((RColor_9.x < tmpvar_29.x)) {
      highp vec4 tmpvar_33;
      tmpvar_33.xyz = tmpvar_29.xyw;
      tmpvar_33.w = tmpvar_14.x;
      tmpvar_32 = tmpvar_33;
    } else {
      highp vec4 tmpvar_34;
      tmpvar_34.x = tmpvar_14.x;
      tmpvar_34.yzw = tmpvar_29.yzx;
      tmpvar_32 = tmpvar_34;
    };
    highp float tmpvar_35;
    tmpvar_35 = (tmpvar_32.x - ((tmpvar_32.x - 
      min (tmpvar_32.w, tmpvar_32.y)
    ) * 0.5));
    highp vec4 tmpvar_36;
    if ((tmpvar_28.y < tmpvar_28.z)) {
      highp vec4 tmpvar_37;
      tmpvar_37.zw = vec2(-1.0, 0.6666667);
      tmpvar_37.xy = tmpvar_28.zy;
      tmpvar_36 = tmpvar_37;
    } else {
      highp vec4 tmpvar_38;
      tmpvar_38.zw = vec2(0.0, -0.3333333);
      tmpvar_38.xy = tmpvar_28.yz;
      tmpvar_36 = tmpvar_38;
    };
    highp vec4 tmpvar_39;
    if ((tmpvar_28.x < tmpvar_36.x)) {
      highp vec4 tmpvar_40;
      tmpvar_40.xyz = tmpvar_36.xyw;
      tmpvar_40.w = tmpvar_28.x;
      tmpvar_39 = tmpvar_40;
    } else {
      highp vec4 tmpvar_41;
      tmpvar_41.x = tmpvar_28.x;
      tmpvar_41.yzw = tmpvar_36.yzx;
      tmpvar_39 = tmpvar_41;
    };
    highp float tmpvar_42;
    tmpvar_42 = (tmpvar_39.x - min (tmpvar_39.w, tmpvar_39.y));
    highp vec3 tmpvar_43;
    tmpvar_43.x = abs(((
      (tmpvar_39.w - tmpvar_39.y)
     / 
      ((6.0 * tmpvar_42) + 1e-7)
    ) + tmpvar_39.z));
    tmpvar_43.y = tmpvar_42;
    tmpvar_43.z = tmpvar_39.x;
    highp float tmpvar_44;
    tmpvar_44 = (tmpvar_39.x - (tmpvar_42 * 0.5));
    highp vec3 tmpvar_45;
    tmpvar_45.x = tmpvar_43.x;
    tmpvar_45.y = (tmpvar_42 / ((1.0 - 
      abs(((2.0 * tmpvar_44) - 1.0))
    ) + 1e-7));
    tmpvar_45.z = tmpvar_44;
    highp vec3 tmpvar_46;
    tmpvar_46.x = (abs((
      (6.0 * tmpvar_43.x)
     - 3.0)) - 1.0);
    tmpvar_46.y = (2.0 - abs((
      (6.0 * tmpvar_43.x)
     - 2.0)));
    tmpvar_46.z = (2.0 - abs((
      (6.0 * tmpvar_43.x)
     - 4.0)));
    highp vec4 tmpvar_47;
    tmpvar_47.xyz = mix (RColor_9.xyz, ((
      (clamp (tmpvar_46, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0)) - 0.5)
     * 
      ((1.0 - abs((
        (2.0 * tmpvar_35)
       - 1.0))) * tmpvar_45.y)
    ) + tmpvar_35), vec3(tmpvar_12));
    tmpvar_47.w = tmpvar_12;
    tmpvar_1 = tmpvar_47;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_CUSTOM","BLEND_COLOR"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEA",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEB",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec3 COLOR_RANGEA;
uniform highp vec3 COLOR_RANGEB;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp vec4 MColor_5;
    lowp vec4 tmpvar_6;
    tmpvar_6 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_5 = tmpvar_6;
    highp float tmpvar_7;
    tmpvar_7 = (MColor_5.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp vec3 tmpvar_9;
    tmpvar_9 = RColor_4.xyz;
    highp vec3 tmpvar_10;
    tmpvar_10 = mix (COLOR_RANGEA, COLOR_RANGEB, xlv_TEXCOORD2.xxx);
    highp vec4 tmpvar_11;
    if ((RColor_4.y < RColor_4.z)) {
      highp vec4 tmpvar_12;
      tmpvar_12.zw = vec2(-1.0, 0.6666667);
      tmpvar_12.xy = tmpvar_9.zy;
      tmpvar_11 = tmpvar_12;
    } else {
      highp vec4 tmpvar_13;
      tmpvar_13.zw = vec2(0.0, -0.3333333);
      tmpvar_13.xy = tmpvar_9.yz;
      tmpvar_11 = tmpvar_13;
    };
    highp vec4 tmpvar_14;
    if ((RColor_4.x < tmpvar_11.x)) {
      highp vec4 tmpvar_15;
      tmpvar_15.xyz = tmpvar_11.xyw;
      tmpvar_15.w = tmpvar_9.x;
      tmpvar_14 = tmpvar_15;
    } else {
      highp vec4 tmpvar_16;
      tmpvar_16.x = tmpvar_9.x;
      tmpvar_16.yzw = tmpvar_11.yzx;
      tmpvar_14 = tmpvar_16;
    };
    highp float tmpvar_17;
    tmpvar_17 = (tmpvar_14.x - ((tmpvar_14.x - 
      min (tmpvar_14.w, tmpvar_14.y)
    ) * 0.5));
    highp vec4 tmpvar_18;
    if ((tmpvar_10.y < tmpvar_10.z)) {
      highp vec4 tmpvar_19;
      tmpvar_19.zw = vec2(-1.0, 0.6666667);
      tmpvar_19.xy = tmpvar_10.zy;
      tmpvar_18 = tmpvar_19;
    } else {
      highp vec4 tmpvar_20;
      tmpvar_20.zw = vec2(0.0, -0.3333333);
      tmpvar_20.xy = tmpvar_10.yz;
      tmpvar_18 = tmpvar_20;
    };
    highp vec4 tmpvar_21;
    if ((tmpvar_10.x < tmpvar_18.x)) {
      highp vec4 tmpvar_22;
      tmpvar_22.xyz = tmpvar_18.xyw;
      tmpvar_22.w = tmpvar_10.x;
      tmpvar_21 = tmpvar_22;
    } else {
      highp vec4 tmpvar_23;
      tmpvar_23.x = tmpvar_10.x;
      tmpvar_23.yzw = tmpvar_18.yzx;
      tmpvar_21 = tmpvar_23;
    };
    highp float tmpvar_24;
    tmpvar_24 = (tmpvar_21.x - min (tmpvar_21.w, tmpvar_21.y));
    highp vec3 tmpvar_25;
    tmpvar_25.x = abs(((
      (tmpvar_21.w - tmpvar_21.y)
     / 
      ((6.0 * tmpvar_24) + 1e-7)
    ) + tmpvar_21.z));
    tmpvar_25.y = tmpvar_24;
    tmpvar_25.z = tmpvar_21.x;
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_21.x - (tmpvar_24 * 0.5));
    highp vec3 tmpvar_27;
    tmpvar_27.x = tmpvar_25.x;
    tmpvar_27.y = (tmpvar_24 / ((1.0 - 
      abs(((2.0 * tmpvar_26) - 1.0))
    ) + 1e-7));
    tmpvar_27.z = tmpvar_26;
    highp vec3 tmpvar_28;
    tmpvar_28.x = (abs((
      (6.0 * tmpvar_25.x)
     - 3.0)) - 1.0);
    tmpvar_28.y = (2.0 - abs((
      (6.0 * tmpvar_25.x)
     - 2.0)));
    tmpvar_28.z = (2.0 - abs((
      (6.0 * tmpvar_25.x)
     - 4.0)));
    highp vec4 tmpvar_29;
    tmpvar_29.xyz = mix (RColor_4.xyz, ((
      (clamp (tmpvar_28, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0)) - 0.5)
     * 
      ((1.0 - abs((
        (2.0 * tmpvar_17)
       - 1.0))) * tmpvar_27.y)
    ) + tmpvar_17), vec3(tmpvar_7));
    tmpvar_29.w = tmpvar_7;
    tmpvar_1 = tmpvar_29;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_ORIGINAL","BLEND_BLEND"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp vec4 MColor_5;
    lowp vec4 tmpvar_6;
    tmpvar_6 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_5 = tmpvar_6;
    highp float tmpvar_7;
    tmpvar_7 = (MColor_5.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp vec4 tmpvar_9;
    tmpvar_9.xyz = mix (RColor_4.xyz, ((
      dot (vec3(0.299, 0.587, 0.114), RColor_4.xyz)
     * 1.68) * MColor_5.xyz), vec3(tmpvar_7));
    tmpvar_9.w = tmpvar_7;
    tmpvar_1 = tmpvar_9;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_BLEND","BLEND_BLEND"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIXEL_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec2 PIXEL_SIZE;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec3 bot_4;
    highp vec3 top_5;
    highp vec3 right_6;
    highp vec3 left_7;
    highp vec3 Middle_8;
    highp vec4 RColor_9;
    highp vec4 MColor_10;
    lowp vec4 tmpvar_11;
    tmpvar_11 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_10 = tmpvar_11;
    highp float tmpvar_12;
    tmpvar_12 = (MColor_10.w * OPACITY);
    lowp vec4 tmpvar_13;
    tmpvar_13 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_9 = tmpvar_13;
    lowp vec3 tmpvar_14;
    tmpvar_14 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.zw).xyz;
    Middle_8 = tmpvar_14;
    highp vec2 tmpvar_15;
    tmpvar_15.y = 0.0;
    tmpvar_15.x = -(PIXEL_SIZE.x);
    highp vec2 P_16;
    P_16 = (xlv_TEXCOORD1.zw + tmpvar_15);
    lowp vec3 tmpvar_17;
    tmpvar_17 = texture (TEXTURE_GLOSSINESS, P_16).xyz;
    left_7 = tmpvar_17;
    highp vec2 tmpvar_18;
    tmpvar_18.y = 0.0;
    tmpvar_18.x = PIXEL_SIZE.x;
    highp vec2 P_19;
    P_19 = (xlv_TEXCOORD1.zw + tmpvar_18);
    lowp vec3 tmpvar_20;
    tmpvar_20 = texture (TEXTURE_GLOSSINESS, P_19).xyz;
    right_6 = tmpvar_20;
    highp vec2 tmpvar_21;
    tmpvar_21.x = 0.0;
    tmpvar_21.y = -(PIXEL_SIZE.y);
    highp vec2 P_22;
    P_22 = (xlv_TEXCOORD1.zw + tmpvar_21);
    lowp vec3 tmpvar_23;
    tmpvar_23 = texture (TEXTURE_GLOSSINESS, P_22).xyz;
    top_5 = tmpvar_23;
    highp vec2 tmpvar_24;
    tmpvar_24.x = 0.0;
    tmpvar_24.y = PIXEL_SIZE.y;
    highp vec2 P_25;
    P_25 = (xlv_TEXCOORD1.zw + tmpvar_24);
    lowp vec3 tmpvar_26;
    tmpvar_26 = texture (TEXTURE_GLOSSINESS, P_25).xyz;
    bot_4 = tmpvar_26;
    highp vec4 tmpvar_27;
    tmpvar_27.xyz = mix (RColor_9.xyz, ((
      dot (vec3(0.299, 0.587, 0.114), RColor_9.xyz)
     * 1.68) * max (
      max (Middle_8, left_7)
    , 
      max (max (right_6, top_5), bot_4)
    )), vec3(tmpvar_12));
    tmpvar_27.w = tmpvar_12;
    tmpvar_1 = tmpvar_27;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_CUSTOM","BLEND_BLEND"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEA",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEB",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec3 COLOR_RANGEA;
uniform highp vec3 COLOR_RANGEB;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp vec4 MColor_5;
    lowp vec4 tmpvar_6;
    tmpvar_6 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_5 = tmpvar_6;
    highp float tmpvar_7;
    tmpvar_7 = (MColor_5.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp vec4 tmpvar_9;
    tmpvar_9.xyz = mix (RColor_4.xyz, ((
      dot (vec3(0.299, 0.587, 0.114), RColor_4.xyz)
     * 1.68) * mix (COLOR_RANGEA, COLOR_RANGEB, xlv_TEXCOORD2.xxx)), vec3(tmpvar_7));
    tmpvar_9.w = tmpvar_7;
    tmpvar_1 = tmpvar_9;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_ORIGINAL","BLEND_EXCLUSION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp vec4 MColor_5;
    lowp vec4 tmpvar_6;
    tmpvar_6 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_5 = tmpvar_6;
    highp float tmpvar_7;
    tmpvar_7 = (MColor_5.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp vec4 tmpvar_9;
    tmpvar_9.xyz = mix (RColor_4.xyz, ((RColor_4.xyz + MColor_5.xyz) - (
      (2.0 * RColor_4.xyz)
     * MColor_5.xyz)), vec3(tmpvar_7));
    tmpvar_9.w = tmpvar_7;
    tmpvar_1 = tmpvar_9;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_BLEND","BLEND_EXCLUSION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIXEL_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec2 PIXEL_SIZE;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec3 bot_4;
    highp vec3 top_5;
    highp vec3 right_6;
    highp vec3 left_7;
    highp vec3 Middle_8;
    highp vec4 RColor_9;
    highp vec4 MColor_10;
    lowp vec4 tmpvar_11;
    tmpvar_11 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_10 = tmpvar_11;
    highp float tmpvar_12;
    tmpvar_12 = (MColor_10.w * OPACITY);
    lowp vec4 tmpvar_13;
    tmpvar_13 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_9 = tmpvar_13;
    lowp vec3 tmpvar_14;
    tmpvar_14 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.zw).xyz;
    Middle_8 = tmpvar_14;
    highp vec2 tmpvar_15;
    tmpvar_15.y = 0.0;
    tmpvar_15.x = -(PIXEL_SIZE.x);
    highp vec2 P_16;
    P_16 = (xlv_TEXCOORD1.zw + tmpvar_15);
    lowp vec3 tmpvar_17;
    tmpvar_17 = texture (TEXTURE_GLOSSINESS, P_16).xyz;
    left_7 = tmpvar_17;
    highp vec2 tmpvar_18;
    tmpvar_18.y = 0.0;
    tmpvar_18.x = PIXEL_SIZE.x;
    highp vec2 P_19;
    P_19 = (xlv_TEXCOORD1.zw + tmpvar_18);
    lowp vec3 tmpvar_20;
    tmpvar_20 = texture (TEXTURE_GLOSSINESS, P_19).xyz;
    right_6 = tmpvar_20;
    highp vec2 tmpvar_21;
    tmpvar_21.x = 0.0;
    tmpvar_21.y = -(PIXEL_SIZE.y);
    highp vec2 P_22;
    P_22 = (xlv_TEXCOORD1.zw + tmpvar_21);
    lowp vec3 tmpvar_23;
    tmpvar_23 = texture (TEXTURE_GLOSSINESS, P_22).xyz;
    top_5 = tmpvar_23;
    highp vec2 tmpvar_24;
    tmpvar_24.x = 0.0;
    tmpvar_24.y = PIXEL_SIZE.y;
    highp vec2 P_25;
    P_25 = (xlv_TEXCOORD1.zw + tmpvar_24);
    lowp vec3 tmpvar_26;
    tmpvar_26 = texture (TEXTURE_GLOSSINESS, P_25).xyz;
    bot_4 = tmpvar_26;
    highp vec3 tmpvar_27;
    tmpvar_27 = max (max (Middle_8, left_7), max (max (right_6, top_5), bot_4));
    highp vec4 tmpvar_28;
    tmpvar_28.xyz = mix (RColor_9.xyz, ((RColor_9.xyz + tmpvar_27) - (
      (2.0 * RColor_9.xyz)
     * tmpvar_27)), vec3(tmpvar_12));
    tmpvar_28.w = tmpvar_12;
    tmpvar_1 = tmpvar_28;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_CUSTOM","BLEND_EXCLUSION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEA",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEB",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec3 COLOR_RANGEA;
uniform highp vec3 COLOR_RANGEB;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp vec4 MColor_5;
    lowp vec4 tmpvar_6;
    tmpvar_6 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_5 = tmpvar_6;
    highp float tmpvar_7;
    tmpvar_7 = (MColor_5.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp vec3 tmpvar_9;
    tmpvar_9 = mix (COLOR_RANGEA, COLOR_RANGEB, xlv_TEXCOORD2.xxx);
    highp vec4 tmpvar_10;
    tmpvar_10.xyz = mix (RColor_4.xyz, ((RColor_4.xyz + tmpvar_9) - (
      (2.0 * RColor_4.xyz)
     * tmpvar_9)), vec3(tmpvar_7));
    tmpvar_10.w = tmpvar_7;
    tmpvar_1 = tmpvar_10;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_ORIGINAL","BLEND_HARDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp vec4 MColor_5;
    lowp vec4 tmpvar_6;
    tmpvar_6 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_5 = tmpvar_6;
    highp float tmpvar_7;
    tmpvar_7 = (MColor_5.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp float tmpvar_9;
    if ((MColor_5.x < 0.5)) {
      tmpvar_9 = ((2.0 * MColor_5.x) * RColor_4.x);
    } else {
      tmpvar_9 = (1.0 - ((2.0 * 
        (1.0 - MColor_5.x)
      ) * (1.0 - RColor_4.x)));
    };
    highp float tmpvar_10;
    if ((MColor_5.y < 0.5)) {
      tmpvar_10 = ((2.0 * MColor_5.y) * RColor_4.y);
    } else {
      tmpvar_10 = (1.0 - ((2.0 * 
        (1.0 - MColor_5.y)
      ) * (1.0 - RColor_4.y)));
    };
    highp float tmpvar_11;
    if ((MColor_5.z < 0.5)) {
      tmpvar_11 = ((2.0 * MColor_5.z) * RColor_4.z);
    } else {
      tmpvar_11 = (1.0 - ((2.0 * 
        (1.0 - MColor_5.z)
      ) * (1.0 - RColor_4.z)));
    };
    highp vec3 tmpvar_12;
    tmpvar_12.x = tmpvar_9;
    tmpvar_12.y = tmpvar_10;
    tmpvar_12.z = tmpvar_11;
    highp vec4 tmpvar_13;
    tmpvar_13.xyz = mix (RColor_4.xyz, tmpvar_12, vec3(tmpvar_7));
    tmpvar_13.w = tmpvar_7;
    tmpvar_1 = tmpvar_13;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_BLEND","BLEND_HARDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIXEL_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec2 PIXEL_SIZE;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec3 bot_4;
    highp vec3 top_5;
    highp vec3 right_6;
    highp vec3 left_7;
    highp vec3 Middle_8;
    highp vec4 RColor_9;
    highp vec4 MColor_10;
    lowp vec4 tmpvar_11;
    tmpvar_11 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_10 = tmpvar_11;
    highp float tmpvar_12;
    tmpvar_12 = (MColor_10.w * OPACITY);
    lowp vec4 tmpvar_13;
    tmpvar_13 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_9 = tmpvar_13;
    lowp vec3 tmpvar_14;
    tmpvar_14 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.zw).xyz;
    Middle_8 = tmpvar_14;
    highp vec2 tmpvar_15;
    tmpvar_15.y = 0.0;
    tmpvar_15.x = -(PIXEL_SIZE.x);
    highp vec2 P_16;
    P_16 = (xlv_TEXCOORD1.zw + tmpvar_15);
    lowp vec3 tmpvar_17;
    tmpvar_17 = texture (TEXTURE_GLOSSINESS, P_16).xyz;
    left_7 = tmpvar_17;
    highp vec2 tmpvar_18;
    tmpvar_18.y = 0.0;
    tmpvar_18.x = PIXEL_SIZE.x;
    highp vec2 P_19;
    P_19 = (xlv_TEXCOORD1.zw + tmpvar_18);
    lowp vec3 tmpvar_20;
    tmpvar_20 = texture (TEXTURE_GLOSSINESS, P_19).xyz;
    right_6 = tmpvar_20;
    highp vec2 tmpvar_21;
    tmpvar_21.x = 0.0;
    tmpvar_21.y = -(PIXEL_SIZE.y);
    highp vec2 P_22;
    P_22 = (xlv_TEXCOORD1.zw + tmpvar_21);
    lowp vec3 tmpvar_23;
    tmpvar_23 = texture (TEXTURE_GLOSSINESS, P_22).xyz;
    top_5 = tmpvar_23;
    highp vec2 tmpvar_24;
    tmpvar_24.x = 0.0;
    tmpvar_24.y = PIXEL_SIZE.y;
    highp vec2 P_25;
    P_25 = (xlv_TEXCOORD1.zw + tmpvar_24);
    lowp vec3 tmpvar_26;
    tmpvar_26 = texture (TEXTURE_GLOSSINESS, P_25).xyz;
    bot_4 = tmpvar_26;
    highp vec3 tmpvar_27;
    tmpvar_27 = max (max (Middle_8, left_7), max (max (right_6, top_5), bot_4));
    highp float tmpvar_28;
    if ((tmpvar_27.x < 0.5)) {
      tmpvar_28 = ((2.0 * tmpvar_27.x) * RColor_9.x);
    } else {
      tmpvar_28 = (1.0 - ((2.0 * 
        (1.0 - tmpvar_27.x)
      ) * (1.0 - RColor_9.x)));
    };
    highp float tmpvar_29;
    if ((tmpvar_27.y < 0.5)) {
      tmpvar_29 = ((2.0 * tmpvar_27.y) * RColor_9.y);
    } else {
      tmpvar_29 = (1.0 - ((2.0 * 
        (1.0 - tmpvar_27.y)
      ) * (1.0 - RColor_9.y)));
    };
    highp float tmpvar_30;
    if ((tmpvar_27.z < 0.5)) {
      tmpvar_30 = ((2.0 * tmpvar_27.z) * RColor_9.z);
    } else {
      tmpvar_30 = (1.0 - ((2.0 * 
        (1.0 - tmpvar_27.z)
      ) * (1.0 - RColor_9.z)));
    };
    highp vec3 tmpvar_31;
    tmpvar_31.x = tmpvar_28;
    tmpvar_31.y = tmpvar_29;
    tmpvar_31.z = tmpvar_30;
    highp vec4 tmpvar_32;
    tmpvar_32.xyz = mix (RColor_9.xyz, tmpvar_31, vec3(tmpvar_12));
    tmpvar_32.w = tmpvar_12;
    tmpvar_1 = tmpvar_32;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_CUSTOM","BLEND_HARDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEA",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEB",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec3 COLOR_RANGEA;
uniform highp vec3 COLOR_RANGEB;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp vec4 MColor_5;
    lowp vec4 tmpvar_6;
    tmpvar_6 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_5 = tmpvar_6;
    highp float tmpvar_7;
    tmpvar_7 = (MColor_5.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp vec3 tmpvar_9;
    tmpvar_9 = mix (COLOR_RANGEA, COLOR_RANGEB, xlv_TEXCOORD2.xxx);
    highp float tmpvar_10;
    if ((tmpvar_9.x < 0.5)) {
      tmpvar_10 = ((2.0 * tmpvar_9.x) * RColor_4.x);
    } else {
      tmpvar_10 = (1.0 - ((2.0 * 
        (1.0 - tmpvar_9.x)
      ) * (1.0 - RColor_4.x)));
    };
    highp float tmpvar_11;
    if ((tmpvar_9.y < 0.5)) {
      tmpvar_11 = ((2.0 * tmpvar_9.y) * RColor_4.y);
    } else {
      tmpvar_11 = (1.0 - ((2.0 * 
        (1.0 - tmpvar_9.y)
      ) * (1.0 - RColor_4.y)));
    };
    highp float tmpvar_12;
    if ((tmpvar_9.z < 0.5)) {
      tmpvar_12 = ((2.0 * tmpvar_9.z) * RColor_4.z);
    } else {
      tmpvar_12 = (1.0 - ((2.0 * 
        (1.0 - tmpvar_9.z)
      ) * (1.0 - RColor_4.z)));
    };
    highp vec3 tmpvar_13;
    tmpvar_13.x = tmpvar_10;
    tmpvar_13.y = tmpvar_11;
    tmpvar_13.z = tmpvar_12;
    highp vec4 tmpvar_14;
    tmpvar_14.xyz = mix (RColor_4.xyz, tmpvar_13, vec3(tmpvar_7));
    tmpvar_14.w = tmpvar_7;
    tmpvar_1 = tmpvar_14;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_ORIGINAL","BLEND_VIVIDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp float alpha_5;
    highp vec4 MColor_6;
    lowp vec4 tmpvar_7;
    tmpvar_7 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_6 = tmpvar_7;
    alpha_5 = (MColor_6.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp float tmpvar_9;
    if ((MColor_6.x < 0.5)) {
      highp float blend_10;
      blend_10 = (2.0 * MColor_6.x);
      highp float tmpvar_11;
      if ((blend_10 == 0.0)) {
        tmpvar_11 = blend_10;
      } else {
        tmpvar_11 = max ((1.0 - (
          (1.0 - RColor_4.x)
         / blend_10)), 0.0);
      };
      tmpvar_9 = tmpvar_11;
    } else {
      highp float blend_12;
      blend_12 = (2.0 * (MColor_6.x - 0.5));
      highp float tmpvar_13;
      if ((blend_12 == 1.0)) {
        tmpvar_13 = blend_12;
      } else {
        tmpvar_13 = min ((RColor_4.x / (1.0 - blend_12)), 1.0);
      };
      tmpvar_9 = tmpvar_13;
    };
    highp float tmpvar_14;
    if ((MColor_6.y < 0.5)) {
      highp float blend_15;
      blend_15 = (2.0 * MColor_6.y);
      highp float tmpvar_16;
      if ((blend_15 == 0.0)) {
        tmpvar_16 = blend_15;
      } else {
        tmpvar_16 = max ((1.0 - (
          (1.0 - RColor_4.y)
         / blend_15)), 0.0);
      };
      tmpvar_14 = tmpvar_16;
    } else {
      highp float blend_17;
      blend_17 = (2.0 * (MColor_6.y - 0.5));
      highp float tmpvar_18;
      if ((blend_17 == 1.0)) {
        tmpvar_18 = blend_17;
      } else {
        tmpvar_18 = min ((RColor_4.y / (1.0 - blend_17)), 1.0);
      };
      tmpvar_14 = tmpvar_18;
    };
    highp float tmpvar_19;
    if ((MColor_6.z < 0.5)) {
      highp float blend_20;
      blend_20 = (2.0 * MColor_6.z);
      highp float tmpvar_21;
      if ((blend_20 == 0.0)) {
        tmpvar_21 = blend_20;
      } else {
        tmpvar_21 = max ((1.0 - (
          (1.0 - RColor_4.z)
         / blend_20)), 0.0);
      };
      tmpvar_19 = tmpvar_21;
    } else {
      highp float blend_22;
      blend_22 = (2.0 * (MColor_6.z - 0.5));
      highp float tmpvar_23;
      if ((blend_22 == 1.0)) {
        tmpvar_23 = blend_22;
      } else {
        tmpvar_23 = min ((RColor_4.z / (1.0 - blend_22)), 1.0);
      };
      tmpvar_19 = tmpvar_23;
    };
    highp vec3 tmpvar_24;
    tmpvar_24.x = tmpvar_9;
    tmpvar_24.y = tmpvar_14;
    tmpvar_24.z = tmpvar_19;
    highp vec4 tmpvar_25;
    tmpvar_25.xyz = mix (RColor_4.xyz, tmpvar_24, vec3(alpha_5));
    tmpvar_25.w = alpha_5;
    tmpvar_1 = tmpvar_25;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_BLEND","BLEND_VIVIDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIXEL_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec2 PIXEL_SIZE;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec3 bot_4;
    highp vec3 top_5;
    highp vec3 right_6;
    highp vec3 left_7;
    highp vec3 Middle_8;
    highp vec4 RColor_9;
    highp float alpha_10;
    highp vec4 MColor_11;
    lowp vec4 tmpvar_12;
    tmpvar_12 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_11 = tmpvar_12;
    alpha_10 = (MColor_11.w * OPACITY);
    lowp vec4 tmpvar_13;
    tmpvar_13 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_9 = tmpvar_13;
    lowp vec3 tmpvar_14;
    tmpvar_14 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.zw).xyz;
    Middle_8 = tmpvar_14;
    highp vec2 tmpvar_15;
    tmpvar_15.y = 0.0;
    tmpvar_15.x = -(PIXEL_SIZE.x);
    highp vec2 P_16;
    P_16 = (xlv_TEXCOORD1.zw + tmpvar_15);
    lowp vec3 tmpvar_17;
    tmpvar_17 = texture (TEXTURE_GLOSSINESS, P_16).xyz;
    left_7 = tmpvar_17;
    highp vec2 tmpvar_18;
    tmpvar_18.y = 0.0;
    tmpvar_18.x = PIXEL_SIZE.x;
    highp vec2 P_19;
    P_19 = (xlv_TEXCOORD1.zw + tmpvar_18);
    lowp vec3 tmpvar_20;
    tmpvar_20 = texture (TEXTURE_GLOSSINESS, P_19).xyz;
    right_6 = tmpvar_20;
    highp vec2 tmpvar_21;
    tmpvar_21.x = 0.0;
    tmpvar_21.y = -(PIXEL_SIZE.y);
    highp vec2 P_22;
    P_22 = (xlv_TEXCOORD1.zw + tmpvar_21);
    lowp vec3 tmpvar_23;
    tmpvar_23 = texture (TEXTURE_GLOSSINESS, P_22).xyz;
    top_5 = tmpvar_23;
    highp vec2 tmpvar_24;
    tmpvar_24.x = 0.0;
    tmpvar_24.y = PIXEL_SIZE.y;
    highp vec2 P_25;
    P_25 = (xlv_TEXCOORD1.zw + tmpvar_24);
    lowp vec3 tmpvar_26;
    tmpvar_26 = texture (TEXTURE_GLOSSINESS, P_25).xyz;
    bot_4 = tmpvar_26;
    highp vec3 tmpvar_27;
    tmpvar_27 = max (max (Middle_8, left_7), max (max (right_6, top_5), bot_4));
    highp float tmpvar_28;
    if ((tmpvar_27.x < 0.5)) {
      highp float blend_29;
      blend_29 = (2.0 * tmpvar_27.x);
      highp float tmpvar_30;
      if ((blend_29 == 0.0)) {
        tmpvar_30 = blend_29;
      } else {
        tmpvar_30 = max ((1.0 - (
          (1.0 - RColor_9.x)
         / blend_29)), 0.0);
      };
      tmpvar_28 = tmpvar_30;
    } else {
      highp float blend_31;
      blend_31 = (2.0 * (tmpvar_27.x - 0.5));
      highp float tmpvar_32;
      if ((blend_31 == 1.0)) {
        tmpvar_32 = blend_31;
      } else {
        tmpvar_32 = min ((RColor_9.x / (1.0 - blend_31)), 1.0);
      };
      tmpvar_28 = tmpvar_32;
    };
    highp float tmpvar_33;
    if ((tmpvar_27.y < 0.5)) {
      highp float blend_34;
      blend_34 = (2.0 * tmpvar_27.y);
      highp float tmpvar_35;
      if ((blend_34 == 0.0)) {
        tmpvar_35 = blend_34;
      } else {
        tmpvar_35 = max ((1.0 - (
          (1.0 - RColor_9.y)
         / blend_34)), 0.0);
      };
      tmpvar_33 = tmpvar_35;
    } else {
      highp float blend_36;
      blend_36 = (2.0 * (tmpvar_27.y - 0.5));
      highp float tmpvar_37;
      if ((blend_36 == 1.0)) {
        tmpvar_37 = blend_36;
      } else {
        tmpvar_37 = min ((RColor_9.y / (1.0 - blend_36)), 1.0);
      };
      tmpvar_33 = tmpvar_37;
    };
    highp float tmpvar_38;
    if ((tmpvar_27.z < 0.5)) {
      highp float blend_39;
      blend_39 = (2.0 * tmpvar_27.z);
      highp float tmpvar_40;
      if ((blend_39 == 0.0)) {
        tmpvar_40 = blend_39;
      } else {
        tmpvar_40 = max ((1.0 - (
          (1.0 - RColor_9.z)
         / blend_39)), 0.0);
      };
      tmpvar_38 = tmpvar_40;
    } else {
      highp float blend_41;
      blend_41 = (2.0 * (tmpvar_27.z - 0.5));
      highp float tmpvar_42;
      if ((blend_41 == 1.0)) {
        tmpvar_42 = blend_41;
      } else {
        tmpvar_42 = min ((RColor_9.z / (1.0 - blend_41)), 1.0);
      };
      tmpvar_38 = tmpvar_42;
    };
    highp vec3 tmpvar_43;
    tmpvar_43.x = tmpvar_28;
    tmpvar_43.y = tmpvar_33;
    tmpvar_43.z = tmpvar_38;
    highp vec4 tmpvar_44;
    tmpvar_44.xyz = mix (RColor_9.xyz, tmpvar_43, vec3(alpha_10));
    tmpvar_44.w = alpha_10;
    tmpvar_1 = tmpvar_44;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_CUSTOM","BLEND_VIVIDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEA",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEB",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec3 COLOR_RANGEA;
uniform highp vec3 COLOR_RANGEB;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp float alpha_5;
    highp vec4 MColor_6;
    lowp vec4 tmpvar_7;
    tmpvar_7 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_6 = tmpvar_7;
    alpha_5 = (MColor_6.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp vec3 tmpvar_9;
    tmpvar_9 = mix (COLOR_RANGEA, COLOR_RANGEB, xlv_TEXCOORD2.xxx);
    highp float tmpvar_10;
    if ((tmpvar_9.x < 0.5)) {
      highp float blend_11;
      blend_11 = (2.0 * tmpvar_9.x);
      highp float tmpvar_12;
      if ((blend_11 == 0.0)) {
        tmpvar_12 = blend_11;
      } else {
        tmpvar_12 = max ((1.0 - (
          (1.0 - RColor_4.x)
         / blend_11)), 0.0);
      };
      tmpvar_10 = tmpvar_12;
    } else {
      highp float blend_13;
      blend_13 = (2.0 * (tmpvar_9.x - 0.5));
      highp float tmpvar_14;
      if ((blend_13 == 1.0)) {
        tmpvar_14 = blend_13;
      } else {
        tmpvar_14 = min ((RColor_4.x / (1.0 - blend_13)), 1.0);
      };
      tmpvar_10 = tmpvar_14;
    };
    highp float tmpvar_15;
    if ((tmpvar_9.y < 0.5)) {
      highp float blend_16;
      blend_16 = (2.0 * tmpvar_9.y);
      highp float tmpvar_17;
      if ((blend_16 == 0.0)) {
        tmpvar_17 = blend_16;
      } else {
        tmpvar_17 = max ((1.0 - (
          (1.0 - RColor_4.y)
         / blend_16)), 0.0);
      };
      tmpvar_15 = tmpvar_17;
    } else {
      highp float blend_18;
      blend_18 = (2.0 * (tmpvar_9.y - 0.5));
      highp float tmpvar_19;
      if ((blend_18 == 1.0)) {
        tmpvar_19 = blend_18;
      } else {
        tmpvar_19 = min ((RColor_4.y / (1.0 - blend_18)), 1.0);
      };
      tmpvar_15 = tmpvar_19;
    };
    highp float tmpvar_20;
    if ((tmpvar_9.z < 0.5)) {
      highp float blend_21;
      blend_21 = (2.0 * tmpvar_9.z);
      highp float tmpvar_22;
      if ((blend_21 == 0.0)) {
        tmpvar_22 = blend_21;
      } else {
        tmpvar_22 = max ((1.0 - (
          (1.0 - RColor_4.z)
         / blend_21)), 0.0);
      };
      tmpvar_20 = tmpvar_22;
    } else {
      highp float blend_23;
      blend_23 = (2.0 * (tmpvar_9.z - 0.5));
      highp float tmpvar_24;
      if ((blend_23 == 1.0)) {
        tmpvar_24 = blend_23;
      } else {
        tmpvar_24 = min ((RColor_4.z / (1.0 - blend_23)), 1.0);
      };
      tmpvar_20 = tmpvar_24;
    };
    highp vec3 tmpvar_25;
    tmpvar_25.x = tmpvar_10;
    tmpvar_25.y = tmpvar_15;
    tmpvar_25.z = tmpvar_20;
    highp vec4 tmpvar_26;
    tmpvar_26.xyz = mix (RColor_4.xyz, tmpvar_25, vec3(alpha_5));
    tmpvar_26.w = alpha_5;
    tmpvar_1 = tmpvar_26;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_ORIGINAL","BLEND_OVERLAY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp vec4 MColor_5;
    lowp vec4 tmpvar_6;
    tmpvar_6 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_5 = tmpvar_6;
    highp float tmpvar_7;
    tmpvar_7 = (MColor_5.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp float tmpvar_9;
    if ((RColor_4.x < 0.5)) {
      tmpvar_9 = ((2.0 * RColor_4.x) * MColor_5.x);
    } else {
      tmpvar_9 = (1.0 - ((2.0 * 
        (1.0 - RColor_4.x)
      ) * (1.0 - MColor_5.x)));
    };
    highp float tmpvar_10;
    if ((RColor_4.y < 0.5)) {
      tmpvar_10 = ((2.0 * RColor_4.y) * MColor_5.y);
    } else {
      tmpvar_10 = (1.0 - ((2.0 * 
        (1.0 - RColor_4.y)
      ) * (1.0 - MColor_5.y)));
    };
    highp float tmpvar_11;
    if ((RColor_4.z < 0.5)) {
      tmpvar_11 = ((2.0 * RColor_4.z) * MColor_5.z);
    } else {
      tmpvar_11 = (1.0 - ((2.0 * 
        (1.0 - RColor_4.z)
      ) * (1.0 - MColor_5.z)));
    };
    highp vec3 tmpvar_12;
    tmpvar_12.x = tmpvar_9;
    tmpvar_12.y = tmpvar_10;
    tmpvar_12.z = tmpvar_11;
    highp vec4 tmpvar_13;
    tmpvar_13.xyz = mix (RColor_4.xyz, tmpvar_12, vec3(tmpvar_7));
    tmpvar_13.w = tmpvar_7;
    tmpvar_1 = tmpvar_13;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_BLEND","BLEND_OVERLAY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIXEL_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec2 PIXEL_SIZE;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec3 bot_4;
    highp vec3 top_5;
    highp vec3 right_6;
    highp vec3 left_7;
    highp vec3 Middle_8;
    highp vec4 RColor_9;
    highp vec4 MColor_10;
    lowp vec4 tmpvar_11;
    tmpvar_11 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_10 = tmpvar_11;
    highp float tmpvar_12;
    tmpvar_12 = (MColor_10.w * OPACITY);
    lowp vec4 tmpvar_13;
    tmpvar_13 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_9 = tmpvar_13;
    lowp vec3 tmpvar_14;
    tmpvar_14 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.zw).xyz;
    Middle_8 = tmpvar_14;
    highp vec2 tmpvar_15;
    tmpvar_15.y = 0.0;
    tmpvar_15.x = -(PIXEL_SIZE.x);
    highp vec2 P_16;
    P_16 = (xlv_TEXCOORD1.zw + tmpvar_15);
    lowp vec3 tmpvar_17;
    tmpvar_17 = texture (TEXTURE_GLOSSINESS, P_16).xyz;
    left_7 = tmpvar_17;
    highp vec2 tmpvar_18;
    tmpvar_18.y = 0.0;
    tmpvar_18.x = PIXEL_SIZE.x;
    highp vec2 P_19;
    P_19 = (xlv_TEXCOORD1.zw + tmpvar_18);
    lowp vec3 tmpvar_20;
    tmpvar_20 = texture (TEXTURE_GLOSSINESS, P_19).xyz;
    right_6 = tmpvar_20;
    highp vec2 tmpvar_21;
    tmpvar_21.x = 0.0;
    tmpvar_21.y = -(PIXEL_SIZE.y);
    highp vec2 P_22;
    P_22 = (xlv_TEXCOORD1.zw + tmpvar_21);
    lowp vec3 tmpvar_23;
    tmpvar_23 = texture (TEXTURE_GLOSSINESS, P_22).xyz;
    top_5 = tmpvar_23;
    highp vec2 tmpvar_24;
    tmpvar_24.x = 0.0;
    tmpvar_24.y = PIXEL_SIZE.y;
    highp vec2 P_25;
    P_25 = (xlv_TEXCOORD1.zw + tmpvar_24);
    lowp vec3 tmpvar_26;
    tmpvar_26 = texture (TEXTURE_GLOSSINESS, P_25).xyz;
    bot_4 = tmpvar_26;
    highp vec3 tmpvar_27;
    tmpvar_27 = max (max (Middle_8, left_7), max (max (right_6, top_5), bot_4));
    highp float tmpvar_28;
    if ((RColor_9.x < 0.5)) {
      tmpvar_28 = ((2.0 * RColor_9.x) * tmpvar_27.x);
    } else {
      tmpvar_28 = (1.0 - ((2.0 * 
        (1.0 - RColor_9.x)
      ) * (1.0 - tmpvar_27.x)));
    };
    highp float tmpvar_29;
    if ((RColor_9.y < 0.5)) {
      tmpvar_29 = ((2.0 * RColor_9.y) * tmpvar_27.y);
    } else {
      tmpvar_29 = (1.0 - ((2.0 * 
        (1.0 - RColor_9.y)
      ) * (1.0 - tmpvar_27.y)));
    };
    highp float tmpvar_30;
    if ((RColor_9.z < 0.5)) {
      tmpvar_30 = ((2.0 * RColor_9.z) * tmpvar_27.z);
    } else {
      tmpvar_30 = (1.0 - ((2.0 * 
        (1.0 - RColor_9.z)
      ) * (1.0 - tmpvar_27.z)));
    };
    highp vec3 tmpvar_31;
    tmpvar_31.x = tmpvar_28;
    tmpvar_31.y = tmpvar_29;
    tmpvar_31.z = tmpvar_30;
    highp vec4 tmpvar_32;
    tmpvar_32.xyz = mix (RColor_9.xyz, tmpvar_31, vec3(tmpvar_12));
    tmpvar_32.w = tmpvar_12;
    tmpvar_1 = tmpvar_32;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_CUSTOM","BLEND_OVERLAY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEA",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEB",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec3 COLOR_RANGEA;
uniform highp vec3 COLOR_RANGEB;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp vec4 MColor_5;
    lowp vec4 tmpvar_6;
    tmpvar_6 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_5 = tmpvar_6;
    highp float tmpvar_7;
    tmpvar_7 = (MColor_5.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp vec3 tmpvar_9;
    tmpvar_9 = mix (COLOR_RANGEA, COLOR_RANGEB, xlv_TEXCOORD2.xxx);
    highp float tmpvar_10;
    if ((RColor_4.x < 0.5)) {
      tmpvar_10 = ((2.0 * RColor_4.x) * tmpvar_9.x);
    } else {
      tmpvar_10 = (1.0 - ((2.0 * 
        (1.0 - RColor_4.x)
      ) * (1.0 - tmpvar_9.x)));
    };
    highp float tmpvar_11;
    if ((RColor_4.y < 0.5)) {
      tmpvar_11 = ((2.0 * RColor_4.y) * tmpvar_9.y);
    } else {
      tmpvar_11 = (1.0 - ((2.0 * 
        (1.0 - RColor_4.y)
      ) * (1.0 - tmpvar_9.y)));
    };
    highp float tmpvar_12;
    if ((RColor_4.z < 0.5)) {
      tmpvar_12 = ((2.0 * RColor_4.z) * tmpvar_9.z);
    } else {
      tmpvar_12 = (1.0 - ((2.0 * 
        (1.0 - RColor_4.z)
      ) * (1.0 - tmpvar_9.z)));
    };
    highp vec3 tmpvar_13;
    tmpvar_13.x = tmpvar_10;
    tmpvar_13.y = tmpvar_11;
    tmpvar_13.z = tmpvar_12;
    highp vec4 tmpvar_14;
    tmpvar_14.xyz = mix (RColor_4.xyz, tmpvar_13, vec3(tmpvar_7));
    tmpvar_14.w = tmpvar_7;
    tmpvar_1 = tmpvar_14;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_ORIGINAL","BLEND_COLORBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp vec4 MColor_5;
    lowp vec4 tmpvar_6;
    tmpvar_6 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_5 = tmpvar_6;
    highp float tmpvar_7;
    tmpvar_7 = (MColor_5.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp vec3 tmpvar_9;
    tmpvar_9 = MColor_5.xyz;
    highp float blend_10;
    blend_10 = tmpvar_9.x;
    highp float tmpvar_11;
    if ((MColor_5.x == 0.0)) {
      tmpvar_11 = blend_10;
    } else {
      tmpvar_11 = max ((1.0 - (
        (1.0 - RColor_4.x)
       / MColor_5.x)), 0.0);
    };
    highp float blend_12;
    blend_12 = tmpvar_9.y;
    highp float tmpvar_13;
    if ((MColor_5.y == 0.0)) {
      tmpvar_13 = blend_12;
    } else {
      tmpvar_13 = max ((1.0 - (
        (1.0 - RColor_4.y)
       / MColor_5.y)), 0.0);
    };
    highp float blend_14;
    blend_14 = tmpvar_9.z;
    highp float tmpvar_15;
    if ((MColor_5.z == 0.0)) {
      tmpvar_15 = blend_14;
    } else {
      tmpvar_15 = max ((1.0 - (
        (1.0 - RColor_4.z)
       / MColor_5.z)), 0.0);
    };
    highp vec3 tmpvar_16;
    tmpvar_16.x = tmpvar_11;
    tmpvar_16.y = tmpvar_13;
    tmpvar_16.z = tmpvar_15;
    highp vec4 tmpvar_17;
    tmpvar_17.xyz = mix (RColor_4.xyz, tmpvar_16, vec3(tmpvar_7));
    tmpvar_17.w = tmpvar_7;
    tmpvar_1 = tmpvar_17;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_BLEND","BLEND_COLORBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIXEL_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec2 PIXEL_SIZE;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec3 bot_4;
    highp vec3 top_5;
    highp vec3 right_6;
    highp vec3 left_7;
    highp vec3 Middle_8;
    highp vec4 RColor_9;
    highp vec4 MColor_10;
    lowp vec4 tmpvar_11;
    tmpvar_11 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_10 = tmpvar_11;
    highp float tmpvar_12;
    tmpvar_12 = (MColor_10.w * OPACITY);
    lowp vec4 tmpvar_13;
    tmpvar_13 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_9 = tmpvar_13;
    lowp vec3 tmpvar_14;
    tmpvar_14 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.zw).xyz;
    Middle_8 = tmpvar_14;
    highp vec2 tmpvar_15;
    tmpvar_15.y = 0.0;
    tmpvar_15.x = -(PIXEL_SIZE.x);
    highp vec2 P_16;
    P_16 = (xlv_TEXCOORD1.zw + tmpvar_15);
    lowp vec3 tmpvar_17;
    tmpvar_17 = texture (TEXTURE_GLOSSINESS, P_16).xyz;
    left_7 = tmpvar_17;
    highp vec2 tmpvar_18;
    tmpvar_18.y = 0.0;
    tmpvar_18.x = PIXEL_SIZE.x;
    highp vec2 P_19;
    P_19 = (xlv_TEXCOORD1.zw + tmpvar_18);
    lowp vec3 tmpvar_20;
    tmpvar_20 = texture (TEXTURE_GLOSSINESS, P_19).xyz;
    right_6 = tmpvar_20;
    highp vec2 tmpvar_21;
    tmpvar_21.x = 0.0;
    tmpvar_21.y = -(PIXEL_SIZE.y);
    highp vec2 P_22;
    P_22 = (xlv_TEXCOORD1.zw + tmpvar_21);
    lowp vec3 tmpvar_23;
    tmpvar_23 = texture (TEXTURE_GLOSSINESS, P_22).xyz;
    top_5 = tmpvar_23;
    highp vec2 tmpvar_24;
    tmpvar_24.x = 0.0;
    tmpvar_24.y = PIXEL_SIZE.y;
    highp vec2 P_25;
    P_25 = (xlv_TEXCOORD1.zw + tmpvar_24);
    lowp vec3 tmpvar_26;
    tmpvar_26 = texture (TEXTURE_GLOSSINESS, P_25).xyz;
    bot_4 = tmpvar_26;
    highp vec3 tmpvar_27;
    tmpvar_27 = max (max (Middle_8, left_7), max (max (right_6, top_5), bot_4));
    highp float blend_28;
    blend_28 = tmpvar_27.x;
    highp float tmpvar_29;
    if ((tmpvar_27.x == 0.0)) {
      tmpvar_29 = blend_28;
    } else {
      tmpvar_29 = max ((1.0 - (
        (1.0 - RColor_9.x)
       / tmpvar_27.x)), 0.0);
    };
    highp float blend_30;
    blend_30 = tmpvar_27.y;
    highp float tmpvar_31;
    if ((tmpvar_27.y == 0.0)) {
      tmpvar_31 = blend_30;
    } else {
      tmpvar_31 = max ((1.0 - (
        (1.0 - RColor_9.y)
       / tmpvar_27.y)), 0.0);
    };
    highp float blend_32;
    blend_32 = tmpvar_27.z;
    highp float tmpvar_33;
    if ((tmpvar_27.z == 0.0)) {
      tmpvar_33 = blend_32;
    } else {
      tmpvar_33 = max ((1.0 - (
        (1.0 - RColor_9.z)
       / tmpvar_27.z)), 0.0);
    };
    highp vec3 tmpvar_34;
    tmpvar_34.x = tmpvar_29;
    tmpvar_34.y = tmpvar_31;
    tmpvar_34.z = tmpvar_33;
    highp vec4 tmpvar_35;
    tmpvar_35.xyz = mix (RColor_9.xyz, tmpvar_34, vec3(tmpvar_12));
    tmpvar_35.w = tmpvar_12;
    tmpvar_1 = tmpvar_35;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_CUSTOM","BLEND_COLORBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEA",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEB",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec3 COLOR_RANGEA;
uniform highp vec3 COLOR_RANGEB;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp vec4 MColor_5;
    lowp vec4 tmpvar_6;
    tmpvar_6 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_5 = tmpvar_6;
    highp float tmpvar_7;
    tmpvar_7 = (MColor_5.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp vec3 tmpvar_9;
    tmpvar_9 = mix (COLOR_RANGEA, COLOR_RANGEB, xlv_TEXCOORD2.xxx);
    highp float blend_10;
    blend_10 = tmpvar_9.x;
    highp float tmpvar_11;
    if ((tmpvar_9.x == 0.0)) {
      tmpvar_11 = blend_10;
    } else {
      tmpvar_11 = max ((1.0 - (
        (1.0 - RColor_4.x)
       / tmpvar_9.x)), 0.0);
    };
    highp float blend_12;
    blend_12 = tmpvar_9.y;
    highp float tmpvar_13;
    if ((tmpvar_9.y == 0.0)) {
      tmpvar_13 = blend_12;
    } else {
      tmpvar_13 = max ((1.0 - (
        (1.0 - RColor_4.y)
       / tmpvar_9.y)), 0.0);
    };
    highp float blend_14;
    blend_14 = tmpvar_9.z;
    highp float tmpvar_15;
    if ((tmpvar_9.z == 0.0)) {
      tmpvar_15 = blend_14;
    } else {
      tmpvar_15 = max ((1.0 - (
        (1.0 - RColor_4.z)
       / tmpvar_9.z)), 0.0);
    };
    highp vec3 tmpvar_16;
    tmpvar_16.x = tmpvar_11;
    tmpvar_16.y = tmpvar_13;
    tmpvar_16.z = tmpvar_15;
    highp vec4 tmpvar_17;
    tmpvar_17.xyz = mix (RColor_4.xyz, tmpvar_16, vec3(tmpvar_7));
    tmpvar_17.w = tmpvar_7;
    tmpvar_1 = tmpvar_17;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_ORIGINAL","BLEND_COLORDODGE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp vec4 MColor_5;
    lowp vec4 tmpvar_6;
    tmpvar_6 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_5 = tmpvar_6;
    highp float tmpvar_7;
    tmpvar_7 = (MColor_5.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp vec3 tmpvar_9;
    tmpvar_9 = MColor_5.xyz;
    highp float blend_10;
    blend_10 = tmpvar_9.x;
    highp float tmpvar_11;
    if ((MColor_5.x == 1.0)) {
      tmpvar_11 = blend_10;
    } else {
      tmpvar_11 = min ((RColor_4.x / (1.0 - MColor_5.x)), 1.0);
    };
    highp float blend_12;
    blend_12 = tmpvar_9.y;
    highp float tmpvar_13;
    if ((MColor_5.y == 1.0)) {
      tmpvar_13 = blend_12;
    } else {
      tmpvar_13 = min ((RColor_4.y / (1.0 - MColor_5.y)), 1.0);
    };
    highp float blend_14;
    blend_14 = tmpvar_9.z;
    highp float tmpvar_15;
    if ((MColor_5.z == 1.0)) {
      tmpvar_15 = blend_14;
    } else {
      tmpvar_15 = min ((RColor_4.z / (1.0 - MColor_5.z)), 1.0);
    };
    highp vec3 tmpvar_16;
    tmpvar_16.x = tmpvar_11;
    tmpvar_16.y = tmpvar_13;
    tmpvar_16.z = tmpvar_15;
    highp vec4 tmpvar_17;
    tmpvar_17.xyz = mix (RColor_4.xyz, tmpvar_16, vec3(tmpvar_7));
    tmpvar_17.w = tmpvar_7;
    tmpvar_1 = tmpvar_17;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_BLEND","BLEND_COLORDODGE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIXEL_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec2 PIXEL_SIZE;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec3 bot_4;
    highp vec3 top_5;
    highp vec3 right_6;
    highp vec3 left_7;
    highp vec3 Middle_8;
    highp vec4 RColor_9;
    highp vec4 MColor_10;
    lowp vec4 tmpvar_11;
    tmpvar_11 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_10 = tmpvar_11;
    highp float tmpvar_12;
    tmpvar_12 = (MColor_10.w * OPACITY);
    lowp vec4 tmpvar_13;
    tmpvar_13 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_9 = tmpvar_13;
    lowp vec3 tmpvar_14;
    tmpvar_14 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.zw).xyz;
    Middle_8 = tmpvar_14;
    highp vec2 tmpvar_15;
    tmpvar_15.y = 0.0;
    tmpvar_15.x = -(PIXEL_SIZE.x);
    highp vec2 P_16;
    P_16 = (xlv_TEXCOORD1.zw + tmpvar_15);
    lowp vec3 tmpvar_17;
    tmpvar_17 = texture (TEXTURE_GLOSSINESS, P_16).xyz;
    left_7 = tmpvar_17;
    highp vec2 tmpvar_18;
    tmpvar_18.y = 0.0;
    tmpvar_18.x = PIXEL_SIZE.x;
    highp vec2 P_19;
    P_19 = (xlv_TEXCOORD1.zw + tmpvar_18);
    lowp vec3 tmpvar_20;
    tmpvar_20 = texture (TEXTURE_GLOSSINESS, P_19).xyz;
    right_6 = tmpvar_20;
    highp vec2 tmpvar_21;
    tmpvar_21.x = 0.0;
    tmpvar_21.y = -(PIXEL_SIZE.y);
    highp vec2 P_22;
    P_22 = (xlv_TEXCOORD1.zw + tmpvar_21);
    lowp vec3 tmpvar_23;
    tmpvar_23 = texture (TEXTURE_GLOSSINESS, P_22).xyz;
    top_5 = tmpvar_23;
    highp vec2 tmpvar_24;
    tmpvar_24.x = 0.0;
    tmpvar_24.y = PIXEL_SIZE.y;
    highp vec2 P_25;
    P_25 = (xlv_TEXCOORD1.zw + tmpvar_24);
    lowp vec3 tmpvar_26;
    tmpvar_26 = texture (TEXTURE_GLOSSINESS, P_25).xyz;
    bot_4 = tmpvar_26;
    highp vec3 tmpvar_27;
    tmpvar_27 = max (max (Middle_8, left_7), max (max (right_6, top_5), bot_4));
    highp float blend_28;
    blend_28 = tmpvar_27.x;
    highp float tmpvar_29;
    if ((tmpvar_27.x == 1.0)) {
      tmpvar_29 = blend_28;
    } else {
      tmpvar_29 = min ((RColor_9.x / (1.0 - tmpvar_27.x)), 1.0);
    };
    highp float blend_30;
    blend_30 = tmpvar_27.y;
    highp float tmpvar_31;
    if ((tmpvar_27.y == 1.0)) {
      tmpvar_31 = blend_30;
    } else {
      tmpvar_31 = min ((RColor_9.y / (1.0 - tmpvar_27.y)), 1.0);
    };
    highp float blend_32;
    blend_32 = tmpvar_27.z;
    highp float tmpvar_33;
    if ((tmpvar_27.z == 1.0)) {
      tmpvar_33 = blend_32;
    } else {
      tmpvar_33 = min ((RColor_9.z / (1.0 - tmpvar_27.z)), 1.0);
    };
    highp vec3 tmpvar_34;
    tmpvar_34.x = tmpvar_29;
    tmpvar_34.y = tmpvar_31;
    tmpvar_34.z = tmpvar_33;
    highp vec4 tmpvar_35;
    tmpvar_35.xyz = mix (RColor_9.xyz, tmpvar_34, vec3(tmpvar_12));
    tmpvar_35.w = tmpvar_12;
    tmpvar_1 = tmpvar_35;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_CUSTOM","BLEND_COLORDODGE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEA",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEB",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec3 COLOR_RANGEA;
uniform highp vec3 COLOR_RANGEB;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp vec4 MColor_5;
    lowp vec4 tmpvar_6;
    tmpvar_6 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_5 = tmpvar_6;
    highp float tmpvar_7;
    tmpvar_7 = (MColor_5.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp vec3 tmpvar_9;
    tmpvar_9 = mix (COLOR_RANGEA, COLOR_RANGEB, xlv_TEXCOORD2.xxx);
    highp float blend_10;
    blend_10 = tmpvar_9.x;
    highp float tmpvar_11;
    if ((tmpvar_9.x == 1.0)) {
      tmpvar_11 = blend_10;
    } else {
      tmpvar_11 = min ((RColor_4.x / (1.0 - tmpvar_9.x)), 1.0);
    };
    highp float blend_12;
    blend_12 = tmpvar_9.y;
    highp float tmpvar_13;
    if ((tmpvar_9.y == 1.0)) {
      tmpvar_13 = blend_12;
    } else {
      tmpvar_13 = min ((RColor_4.y / (1.0 - tmpvar_9.y)), 1.0);
    };
    highp float blend_14;
    blend_14 = tmpvar_9.z;
    highp float tmpvar_15;
    if ((tmpvar_9.z == 1.0)) {
      tmpvar_15 = blend_14;
    } else {
      tmpvar_15 = min ((RColor_4.z / (1.0 - tmpvar_9.z)), 1.0);
    };
    highp vec3 tmpvar_16;
    tmpvar_16.x = tmpvar_11;
    tmpvar_16.y = tmpvar_13;
    tmpvar_16.z = tmpvar_15;
    highp vec4 tmpvar_17;
    tmpvar_17.xyz = mix (RColor_4.xyz, tmpvar_16, vec3(tmpvar_7));
    tmpvar_17.w = tmpvar_7;
    tmpvar_1 = tmpvar_17;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_ORIGINAL","BLEND_SOFTLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp vec4 MColor_5;
    lowp vec4 tmpvar_6;
    tmpvar_6 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_5 = tmpvar_6;
    highp float tmpvar_7;
    tmpvar_7 = (MColor_5.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp vec4 tmpvar_9;
    tmpvar_9.xyz = mix (RColor_4.xyz, ((
      ((vec3(1.0, 1.0, 1.0) - (vec3(2.0, 2.0, 2.0) * MColor_5.xyz)) * RColor_4.xyz)
     * RColor_4.xyz) + (
      (vec3(2.0, 2.0, 2.0) * RColor_4.xyz)
     * MColor_5.xyz)), vec3(tmpvar_7));
    tmpvar_9.w = tmpvar_7;
    tmpvar_1 = tmpvar_9;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_BLEND","BLEND_SOFTLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIXEL_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec2 PIXEL_SIZE;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec3 bot_4;
    highp vec3 top_5;
    highp vec3 right_6;
    highp vec3 left_7;
    highp vec3 Middle_8;
    highp vec4 RColor_9;
    highp vec4 MColor_10;
    lowp vec4 tmpvar_11;
    tmpvar_11 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_10 = tmpvar_11;
    highp float tmpvar_12;
    tmpvar_12 = (MColor_10.w * OPACITY);
    lowp vec4 tmpvar_13;
    tmpvar_13 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_9 = tmpvar_13;
    lowp vec3 tmpvar_14;
    tmpvar_14 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.zw).xyz;
    Middle_8 = tmpvar_14;
    highp vec2 tmpvar_15;
    tmpvar_15.y = 0.0;
    tmpvar_15.x = -(PIXEL_SIZE.x);
    highp vec2 P_16;
    P_16 = (xlv_TEXCOORD1.zw + tmpvar_15);
    lowp vec3 tmpvar_17;
    tmpvar_17 = texture (TEXTURE_GLOSSINESS, P_16).xyz;
    left_7 = tmpvar_17;
    highp vec2 tmpvar_18;
    tmpvar_18.y = 0.0;
    tmpvar_18.x = PIXEL_SIZE.x;
    highp vec2 P_19;
    P_19 = (xlv_TEXCOORD1.zw + tmpvar_18);
    lowp vec3 tmpvar_20;
    tmpvar_20 = texture (TEXTURE_GLOSSINESS, P_19).xyz;
    right_6 = tmpvar_20;
    highp vec2 tmpvar_21;
    tmpvar_21.x = 0.0;
    tmpvar_21.y = -(PIXEL_SIZE.y);
    highp vec2 P_22;
    P_22 = (xlv_TEXCOORD1.zw + tmpvar_21);
    lowp vec3 tmpvar_23;
    tmpvar_23 = texture (TEXTURE_GLOSSINESS, P_22).xyz;
    top_5 = tmpvar_23;
    highp vec2 tmpvar_24;
    tmpvar_24.x = 0.0;
    tmpvar_24.y = PIXEL_SIZE.y;
    highp vec2 P_25;
    P_25 = (xlv_TEXCOORD1.zw + tmpvar_24);
    lowp vec3 tmpvar_26;
    tmpvar_26 = texture (TEXTURE_GLOSSINESS, P_25).xyz;
    bot_4 = tmpvar_26;
    highp vec3 tmpvar_27;
    tmpvar_27 = max (max (Middle_8, left_7), max (max (right_6, top_5), bot_4));
    highp vec4 tmpvar_28;
    tmpvar_28.xyz = mix (RColor_9.xyz, ((
      ((vec3(1.0, 1.0, 1.0) - (vec3(2.0, 2.0, 2.0) * tmpvar_27)) * RColor_9.xyz)
     * RColor_9.xyz) + (
      (vec3(2.0, 2.0, 2.0) * RColor_9.xyz)
     * tmpvar_27)), vec3(tmpvar_12));
    tmpvar_28.w = tmpvar_12;
    tmpvar_1 = tmpvar_28;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_CUSTOM","BLEND_SOFTLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEA",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEB",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec3 COLOR_RANGEA;
uniform highp vec3 COLOR_RANGEB;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp vec4 MColor_5;
    lowp vec4 tmpvar_6;
    tmpvar_6 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_5 = tmpvar_6;
    highp float tmpvar_7;
    tmpvar_7 = (MColor_5.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp vec3 tmpvar_9;
    tmpvar_9 = mix (COLOR_RANGEA, COLOR_RANGEB, xlv_TEXCOORD2.xxx);
    highp vec4 tmpvar_10;
    tmpvar_10.xyz = mix (RColor_4.xyz, ((
      ((vec3(1.0, 1.0, 1.0) - (vec3(2.0, 2.0, 2.0) * tmpvar_9)) * RColor_4.xyz)
     * RColor_4.xyz) + (
      (vec3(2.0, 2.0, 2.0) * RColor_4.xyz)
     * tmpvar_9)), vec3(tmpvar_7));
    tmpvar_10.w = tmpvar_7;
    tmpvar_1 = tmpvar_10;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_ORIGINAL","BLEND_HARDMIX"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp float alpha_5;
    highp vec4 MColor_6;
    lowp vec4 tmpvar_7;
    tmpvar_7 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_6 = tmpvar_7;
    alpha_5 = (MColor_6.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp float tmpvar_9;
    highp float tmpvar_10;
    if ((MColor_6.x < 0.5)) {
      highp float blend_11;
      blend_11 = (2.0 * MColor_6.x);
      highp float tmpvar_12;
      if ((blend_11 == 0.0)) {
        tmpvar_12 = blend_11;
      } else {
        tmpvar_12 = max ((1.0 - (
          (1.0 - RColor_4.x)
         / blend_11)), 0.0);
      };
      tmpvar_10 = tmpvar_12;
    } else {
      highp float blend_13;
      blend_13 = (2.0 * (MColor_6.x - 0.5));
      highp float tmpvar_14;
      if ((blend_13 == 1.0)) {
        tmpvar_14 = blend_13;
      } else {
        tmpvar_14 = min ((RColor_4.x / (1.0 - blend_13)), 1.0);
      };
      tmpvar_10 = tmpvar_14;
    };
    if ((tmpvar_10 < 0.5)) {
      tmpvar_9 = 0.0;
    } else {
      tmpvar_9 = 1.0;
    };
    highp float tmpvar_15;
    highp float tmpvar_16;
    if ((MColor_6.y < 0.5)) {
      highp float blend_17;
      blend_17 = (2.0 * MColor_6.y);
      highp float tmpvar_18;
      if ((blend_17 == 0.0)) {
        tmpvar_18 = blend_17;
      } else {
        tmpvar_18 = max ((1.0 - (
          (1.0 - RColor_4.y)
         / blend_17)), 0.0);
      };
      tmpvar_16 = tmpvar_18;
    } else {
      highp float blend_19;
      blend_19 = (2.0 * (MColor_6.y - 0.5));
      highp float tmpvar_20;
      if ((blend_19 == 1.0)) {
        tmpvar_20 = blend_19;
      } else {
        tmpvar_20 = min ((RColor_4.y / (1.0 - blend_19)), 1.0);
      };
      tmpvar_16 = tmpvar_20;
    };
    if ((tmpvar_16 < 0.5)) {
      tmpvar_15 = 0.0;
    } else {
      tmpvar_15 = 1.0;
    };
    highp float tmpvar_21;
    highp float tmpvar_22;
    if ((MColor_6.z < 0.5)) {
      highp float blend_23;
      blend_23 = (2.0 * MColor_6.z);
      highp float tmpvar_24;
      if ((blend_23 == 0.0)) {
        tmpvar_24 = blend_23;
      } else {
        tmpvar_24 = max ((1.0 - (
          (1.0 - RColor_4.z)
         / blend_23)), 0.0);
      };
      tmpvar_22 = tmpvar_24;
    } else {
      highp float blend_25;
      blend_25 = (2.0 * (MColor_6.z - 0.5));
      highp float tmpvar_26;
      if ((blend_25 == 1.0)) {
        tmpvar_26 = blend_25;
      } else {
        tmpvar_26 = min ((RColor_4.z / (1.0 - blend_25)), 1.0);
      };
      tmpvar_22 = tmpvar_26;
    };
    if ((tmpvar_22 < 0.5)) {
      tmpvar_21 = 0.0;
    } else {
      tmpvar_21 = 1.0;
    };
    highp vec3 tmpvar_27;
    tmpvar_27.x = tmpvar_9;
    tmpvar_27.y = tmpvar_15;
    tmpvar_27.z = tmpvar_21;
    highp vec4 tmpvar_28;
    tmpvar_28.xyz = mix (RColor_4.xyz, tmpvar_27, vec3(alpha_5));
    tmpvar_28.w = alpha_5;
    tmpvar_1 = tmpvar_28;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_BLEND","BLEND_HARDMIX"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIXEL_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec2 PIXEL_SIZE;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec3 bot_4;
    highp vec3 top_5;
    highp vec3 right_6;
    highp vec3 left_7;
    highp vec3 Middle_8;
    highp vec4 RColor_9;
    highp float alpha_10;
    highp vec4 MColor_11;
    lowp vec4 tmpvar_12;
    tmpvar_12 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_11 = tmpvar_12;
    alpha_10 = (MColor_11.w * OPACITY);
    lowp vec4 tmpvar_13;
    tmpvar_13 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_9 = tmpvar_13;
    lowp vec3 tmpvar_14;
    tmpvar_14 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.zw).xyz;
    Middle_8 = tmpvar_14;
    highp vec2 tmpvar_15;
    tmpvar_15.y = 0.0;
    tmpvar_15.x = -(PIXEL_SIZE.x);
    highp vec2 P_16;
    P_16 = (xlv_TEXCOORD1.zw + tmpvar_15);
    lowp vec3 tmpvar_17;
    tmpvar_17 = texture (TEXTURE_GLOSSINESS, P_16).xyz;
    left_7 = tmpvar_17;
    highp vec2 tmpvar_18;
    tmpvar_18.y = 0.0;
    tmpvar_18.x = PIXEL_SIZE.x;
    highp vec2 P_19;
    P_19 = (xlv_TEXCOORD1.zw + tmpvar_18);
    lowp vec3 tmpvar_20;
    tmpvar_20 = texture (TEXTURE_GLOSSINESS, P_19).xyz;
    right_6 = tmpvar_20;
    highp vec2 tmpvar_21;
    tmpvar_21.x = 0.0;
    tmpvar_21.y = -(PIXEL_SIZE.y);
    highp vec2 P_22;
    P_22 = (xlv_TEXCOORD1.zw + tmpvar_21);
    lowp vec3 tmpvar_23;
    tmpvar_23 = texture (TEXTURE_GLOSSINESS, P_22).xyz;
    top_5 = tmpvar_23;
    highp vec2 tmpvar_24;
    tmpvar_24.x = 0.0;
    tmpvar_24.y = PIXEL_SIZE.y;
    highp vec2 P_25;
    P_25 = (xlv_TEXCOORD1.zw + tmpvar_24);
    lowp vec3 tmpvar_26;
    tmpvar_26 = texture (TEXTURE_GLOSSINESS, P_25).xyz;
    bot_4 = tmpvar_26;
    highp vec3 tmpvar_27;
    tmpvar_27 = max (max (Middle_8, left_7), max (max (right_6, top_5), bot_4));
    highp float tmpvar_28;
    highp float tmpvar_29;
    if ((tmpvar_27.x < 0.5)) {
      highp float blend_30;
      blend_30 = (2.0 * tmpvar_27.x);
      highp float tmpvar_31;
      if ((blend_30 == 0.0)) {
        tmpvar_31 = blend_30;
      } else {
        tmpvar_31 = max ((1.0 - (
          (1.0 - RColor_9.x)
         / blend_30)), 0.0);
      };
      tmpvar_29 = tmpvar_31;
    } else {
      highp float blend_32;
      blend_32 = (2.0 * (tmpvar_27.x - 0.5));
      highp float tmpvar_33;
      if ((blend_32 == 1.0)) {
        tmpvar_33 = blend_32;
      } else {
        tmpvar_33 = min ((RColor_9.x / (1.0 - blend_32)), 1.0);
      };
      tmpvar_29 = tmpvar_33;
    };
    if ((tmpvar_29 < 0.5)) {
      tmpvar_28 = 0.0;
    } else {
      tmpvar_28 = 1.0;
    };
    highp float tmpvar_34;
    highp float tmpvar_35;
    if ((tmpvar_27.y < 0.5)) {
      highp float blend_36;
      blend_36 = (2.0 * tmpvar_27.y);
      highp float tmpvar_37;
      if ((blend_36 == 0.0)) {
        tmpvar_37 = blend_36;
      } else {
        tmpvar_37 = max ((1.0 - (
          (1.0 - RColor_9.y)
         / blend_36)), 0.0);
      };
      tmpvar_35 = tmpvar_37;
    } else {
      highp float blend_38;
      blend_38 = (2.0 * (tmpvar_27.y - 0.5));
      highp float tmpvar_39;
      if ((blend_38 == 1.0)) {
        tmpvar_39 = blend_38;
      } else {
        tmpvar_39 = min ((RColor_9.y / (1.0 - blend_38)), 1.0);
      };
      tmpvar_35 = tmpvar_39;
    };
    if ((tmpvar_35 < 0.5)) {
      tmpvar_34 = 0.0;
    } else {
      tmpvar_34 = 1.0;
    };
    highp float tmpvar_40;
    highp float tmpvar_41;
    if ((tmpvar_27.z < 0.5)) {
      highp float blend_42;
      blend_42 = (2.0 * tmpvar_27.z);
      highp float tmpvar_43;
      if ((blend_42 == 0.0)) {
        tmpvar_43 = blend_42;
      } else {
        tmpvar_43 = max ((1.0 - (
          (1.0 - RColor_9.z)
         / blend_42)), 0.0);
      };
      tmpvar_41 = tmpvar_43;
    } else {
      highp float blend_44;
      blend_44 = (2.0 * (tmpvar_27.z - 0.5));
      highp float tmpvar_45;
      if ((blend_44 == 1.0)) {
        tmpvar_45 = blend_44;
      } else {
        tmpvar_45 = min ((RColor_9.z / (1.0 - blend_44)), 1.0);
      };
      tmpvar_41 = tmpvar_45;
    };
    if ((tmpvar_41 < 0.5)) {
      tmpvar_40 = 0.0;
    } else {
      tmpvar_40 = 1.0;
    };
    highp vec3 tmpvar_46;
    tmpvar_46.x = tmpvar_28;
    tmpvar_46.y = tmpvar_34;
    tmpvar_46.z = tmpvar_40;
    highp vec4 tmpvar_47;
    tmpvar_47.xyz = mix (RColor_9.xyz, tmpvar_46, vec3(alpha_10));
    tmpvar_47.w = alpha_10;
    tmpvar_1 = tmpvar_47;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_CUSTOM","BLEND_HARDMIX"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEA",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEB",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec3 COLOR_RANGEA;
uniform highp vec3 COLOR_RANGEB;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp float alpha_5;
    highp vec4 MColor_6;
    lowp vec4 tmpvar_7;
    tmpvar_7 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_6 = tmpvar_7;
    alpha_5 = (MColor_6.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp vec3 tmpvar_9;
    tmpvar_9 = mix (COLOR_RANGEA, COLOR_RANGEB, xlv_TEXCOORD2.xxx);
    highp float tmpvar_10;
    highp float tmpvar_11;
    if ((tmpvar_9.x < 0.5)) {
      highp float blend_12;
      blend_12 = (2.0 * tmpvar_9.x);
      highp float tmpvar_13;
      if ((blend_12 == 0.0)) {
        tmpvar_13 = blend_12;
      } else {
        tmpvar_13 = max ((1.0 - (
          (1.0 - RColor_4.x)
         / blend_12)), 0.0);
      };
      tmpvar_11 = tmpvar_13;
    } else {
      highp float blend_14;
      blend_14 = (2.0 * (tmpvar_9.x - 0.5));
      highp float tmpvar_15;
      if ((blend_14 == 1.0)) {
        tmpvar_15 = blend_14;
      } else {
        tmpvar_15 = min ((RColor_4.x / (1.0 - blend_14)), 1.0);
      };
      tmpvar_11 = tmpvar_15;
    };
    if ((tmpvar_11 < 0.5)) {
      tmpvar_10 = 0.0;
    } else {
      tmpvar_10 = 1.0;
    };
    highp float tmpvar_16;
    highp float tmpvar_17;
    if ((tmpvar_9.y < 0.5)) {
      highp float blend_18;
      blend_18 = (2.0 * tmpvar_9.y);
      highp float tmpvar_19;
      if ((blend_18 == 0.0)) {
        tmpvar_19 = blend_18;
      } else {
        tmpvar_19 = max ((1.0 - (
          (1.0 - RColor_4.y)
         / blend_18)), 0.0);
      };
      tmpvar_17 = tmpvar_19;
    } else {
      highp float blend_20;
      blend_20 = (2.0 * (tmpvar_9.y - 0.5));
      highp float tmpvar_21;
      if ((blend_20 == 1.0)) {
        tmpvar_21 = blend_20;
      } else {
        tmpvar_21 = min ((RColor_4.y / (1.0 - blend_20)), 1.0);
      };
      tmpvar_17 = tmpvar_21;
    };
    if ((tmpvar_17 < 0.5)) {
      tmpvar_16 = 0.0;
    } else {
      tmpvar_16 = 1.0;
    };
    highp float tmpvar_22;
    highp float tmpvar_23;
    if ((tmpvar_9.z < 0.5)) {
      highp float blend_24;
      blend_24 = (2.0 * tmpvar_9.z);
      highp float tmpvar_25;
      if ((blend_24 == 0.0)) {
        tmpvar_25 = blend_24;
      } else {
        tmpvar_25 = max ((1.0 - (
          (1.0 - RColor_4.z)
         / blend_24)), 0.0);
      };
      tmpvar_23 = tmpvar_25;
    } else {
      highp float blend_26;
      blend_26 = (2.0 * (tmpvar_9.z - 0.5));
      highp float tmpvar_27;
      if ((blend_26 == 1.0)) {
        tmpvar_27 = blend_26;
      } else {
        tmpvar_27 = min ((RColor_4.z / (1.0 - blend_26)), 1.0);
      };
      tmpvar_23 = tmpvar_27;
    };
    if ((tmpvar_23 < 0.5)) {
      tmpvar_22 = 0.0;
    } else {
      tmpvar_22 = 1.0;
    };
    highp vec3 tmpvar_28;
    tmpvar_28.x = tmpvar_10;
    tmpvar_28.y = tmpvar_16;
    tmpvar_28.z = tmpvar_22;
    highp vec4 tmpvar_29;
    tmpvar_29.xyz = mix (RColor_4.xyz, tmpvar_28, vec3(alpha_5));
    tmpvar_29.w = alpha_5;
    tmpvar_1 = tmpvar_29;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_ORIGINAL","BLEND_PINLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp float alpha_5;
    highp vec4 MColor_6;
    lowp vec4 tmpvar_7;
    tmpvar_7 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_6 = tmpvar_7;
    alpha_5 = (MColor_6.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp float tmpvar_9;
    if ((MColor_6.x < 0.5)) {
      tmpvar_9 = min ((2.0 * MColor_6.x), RColor_4.x);
    } else {
      tmpvar_9 = max ((2.0 * (MColor_6.x - 0.5)), RColor_4.x);
    };
    highp float tmpvar_10;
    if ((MColor_6.y < 0.5)) {
      tmpvar_10 = min ((2.0 * MColor_6.y), RColor_4.y);
    } else {
      tmpvar_10 = max ((2.0 * (MColor_6.y - 0.5)), RColor_4.y);
    };
    highp float tmpvar_11;
    if ((MColor_6.z < 0.5)) {
      tmpvar_11 = min ((2.0 * MColor_6.z), RColor_4.z);
    } else {
      tmpvar_11 = max ((2.0 * (MColor_6.z - 0.5)), RColor_4.z);
    };
    highp vec3 tmpvar_12;
    tmpvar_12.x = tmpvar_9;
    tmpvar_12.y = tmpvar_10;
    tmpvar_12.z = tmpvar_11;
    highp vec4 tmpvar_13;
    tmpvar_13.xyz = mix (RColor_4.xyz, tmpvar_12, vec3(alpha_5));
    tmpvar_13.w = alpha_5;
    tmpvar_1 = tmpvar_13;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_BLEND","BLEND_PINLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIXEL_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec2 PIXEL_SIZE;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec3 bot_4;
    highp vec3 top_5;
    highp vec3 right_6;
    highp vec3 left_7;
    highp vec3 Middle_8;
    highp vec4 RColor_9;
    highp float alpha_10;
    highp vec4 MColor_11;
    lowp vec4 tmpvar_12;
    tmpvar_12 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_11 = tmpvar_12;
    alpha_10 = (MColor_11.w * OPACITY);
    lowp vec4 tmpvar_13;
    tmpvar_13 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_9 = tmpvar_13;
    lowp vec3 tmpvar_14;
    tmpvar_14 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.zw).xyz;
    Middle_8 = tmpvar_14;
    highp vec2 tmpvar_15;
    tmpvar_15.y = 0.0;
    tmpvar_15.x = -(PIXEL_SIZE.x);
    highp vec2 P_16;
    P_16 = (xlv_TEXCOORD1.zw + tmpvar_15);
    lowp vec3 tmpvar_17;
    tmpvar_17 = texture (TEXTURE_GLOSSINESS, P_16).xyz;
    left_7 = tmpvar_17;
    highp vec2 tmpvar_18;
    tmpvar_18.y = 0.0;
    tmpvar_18.x = PIXEL_SIZE.x;
    highp vec2 P_19;
    P_19 = (xlv_TEXCOORD1.zw + tmpvar_18);
    lowp vec3 tmpvar_20;
    tmpvar_20 = texture (TEXTURE_GLOSSINESS, P_19).xyz;
    right_6 = tmpvar_20;
    highp vec2 tmpvar_21;
    tmpvar_21.x = 0.0;
    tmpvar_21.y = -(PIXEL_SIZE.y);
    highp vec2 P_22;
    P_22 = (xlv_TEXCOORD1.zw + tmpvar_21);
    lowp vec3 tmpvar_23;
    tmpvar_23 = texture (TEXTURE_GLOSSINESS, P_22).xyz;
    top_5 = tmpvar_23;
    highp vec2 tmpvar_24;
    tmpvar_24.x = 0.0;
    tmpvar_24.y = PIXEL_SIZE.y;
    highp vec2 P_25;
    P_25 = (xlv_TEXCOORD1.zw + tmpvar_24);
    lowp vec3 tmpvar_26;
    tmpvar_26 = texture (TEXTURE_GLOSSINESS, P_25).xyz;
    bot_4 = tmpvar_26;
    highp vec3 tmpvar_27;
    tmpvar_27 = max (max (Middle_8, left_7), max (max (right_6, top_5), bot_4));
    highp float tmpvar_28;
    if ((tmpvar_27.x < 0.5)) {
      tmpvar_28 = min ((2.0 * tmpvar_27.x), RColor_9.x);
    } else {
      tmpvar_28 = max ((2.0 * (tmpvar_27.x - 0.5)), RColor_9.x);
    };
    highp float tmpvar_29;
    if ((tmpvar_27.y < 0.5)) {
      tmpvar_29 = min ((2.0 * tmpvar_27.y), RColor_9.y);
    } else {
      tmpvar_29 = max ((2.0 * (tmpvar_27.y - 0.5)), RColor_9.y);
    };
    highp float tmpvar_30;
    if ((tmpvar_27.z < 0.5)) {
      tmpvar_30 = min ((2.0 * tmpvar_27.z), RColor_9.z);
    } else {
      tmpvar_30 = max ((2.0 * (tmpvar_27.z - 0.5)), RColor_9.z);
    };
    highp vec3 tmpvar_31;
    tmpvar_31.x = tmpvar_28;
    tmpvar_31.y = tmpvar_29;
    tmpvar_31.z = tmpvar_30;
    highp vec4 tmpvar_32;
    tmpvar_32.xyz = mix (RColor_9.xyz, tmpvar_31, vec3(alpha_10));
    tmpvar_32.w = alpha_10;
    tmpvar_1 = tmpvar_32;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_CUSTOM","BLEND_PINLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEA",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEB",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec3 COLOR_RANGEA;
uniform highp vec3 COLOR_RANGEB;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp float alpha_5;
    highp vec4 MColor_6;
    lowp vec4 tmpvar_7;
    tmpvar_7 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_6 = tmpvar_7;
    alpha_5 = (MColor_6.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp vec3 tmpvar_9;
    tmpvar_9 = mix (COLOR_RANGEA, COLOR_RANGEB, xlv_TEXCOORD2.xxx);
    highp float tmpvar_10;
    if ((tmpvar_9.x < 0.5)) {
      tmpvar_10 = min ((2.0 * tmpvar_9.x), RColor_4.x);
    } else {
      tmpvar_10 = max ((2.0 * (tmpvar_9.x - 0.5)), RColor_4.x);
    };
    highp float tmpvar_11;
    if ((tmpvar_9.y < 0.5)) {
      tmpvar_11 = min ((2.0 * tmpvar_9.y), RColor_4.y);
    } else {
      tmpvar_11 = max ((2.0 * (tmpvar_9.y - 0.5)), RColor_4.y);
    };
    highp float tmpvar_12;
    if ((tmpvar_9.z < 0.5)) {
      tmpvar_12 = min ((2.0 * tmpvar_9.z), RColor_4.z);
    } else {
      tmpvar_12 = max ((2.0 * (tmpvar_9.z - 0.5)), RColor_4.z);
    };
    highp vec3 tmpvar_13;
    tmpvar_13.x = tmpvar_10;
    tmpvar_13.y = tmpvar_11;
    tmpvar_13.z = tmpvar_12;
    highp vec4 tmpvar_14;
    tmpvar_14.xyz = mix (RColor_4.xyz, tmpvar_13, vec3(alpha_5));
    tmpvar_14.w = alpha_5;
    tmpvar_1 = tmpvar_14;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_ORIGINAL","BLEND_LINEARLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp float alpha_5;
    highp vec4 MColor_6;
    lowp vec4 tmpvar_7;
    tmpvar_7 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_6 = tmpvar_7;
    alpha_5 = (MColor_6.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp float tmpvar_9;
    if ((MColor_6.x < 0.5)) {
      tmpvar_9 = max (((RColor_4.x + 
        (2.0 * MColor_6.x)
      ) - 1.0), 0.0);
    } else {
      tmpvar_9 = min ((RColor_4.x + (2.0 * 
        (MColor_6.x - 0.5)
      )), 1.0);
    };
    highp float tmpvar_10;
    if ((MColor_6.y < 0.5)) {
      tmpvar_10 = max (((RColor_4.y + 
        (2.0 * MColor_6.y)
      ) - 1.0), 0.0);
    } else {
      tmpvar_10 = min ((RColor_4.y + (2.0 * 
        (MColor_6.y - 0.5)
      )), 1.0);
    };
    highp float tmpvar_11;
    if ((MColor_6.z < 0.5)) {
      tmpvar_11 = max (((RColor_4.z + 
        (2.0 * MColor_6.z)
      ) - 1.0), 0.0);
    } else {
      tmpvar_11 = min ((RColor_4.z + (2.0 * 
        (MColor_6.z - 0.5)
      )), 1.0);
    };
    highp vec3 tmpvar_12;
    tmpvar_12.x = tmpvar_9;
    tmpvar_12.y = tmpvar_10;
    tmpvar_12.z = tmpvar_11;
    highp vec4 tmpvar_13;
    tmpvar_13.xyz = mix (RColor_4.xyz, tmpvar_12, vec3(alpha_5));
    tmpvar_13.w = alpha_5;
    tmpvar_1 = tmpvar_13;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_BLEND","BLEND_LINEARLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIXEL_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec2 PIXEL_SIZE;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec3 bot_4;
    highp vec3 top_5;
    highp vec3 right_6;
    highp vec3 left_7;
    highp vec3 Middle_8;
    highp vec4 RColor_9;
    highp float alpha_10;
    highp vec4 MColor_11;
    lowp vec4 tmpvar_12;
    tmpvar_12 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_11 = tmpvar_12;
    alpha_10 = (MColor_11.w * OPACITY);
    lowp vec4 tmpvar_13;
    tmpvar_13 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_9 = tmpvar_13;
    lowp vec3 tmpvar_14;
    tmpvar_14 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.zw).xyz;
    Middle_8 = tmpvar_14;
    highp vec2 tmpvar_15;
    tmpvar_15.y = 0.0;
    tmpvar_15.x = -(PIXEL_SIZE.x);
    highp vec2 P_16;
    P_16 = (xlv_TEXCOORD1.zw + tmpvar_15);
    lowp vec3 tmpvar_17;
    tmpvar_17 = texture (TEXTURE_GLOSSINESS, P_16).xyz;
    left_7 = tmpvar_17;
    highp vec2 tmpvar_18;
    tmpvar_18.y = 0.0;
    tmpvar_18.x = PIXEL_SIZE.x;
    highp vec2 P_19;
    P_19 = (xlv_TEXCOORD1.zw + tmpvar_18);
    lowp vec3 tmpvar_20;
    tmpvar_20 = texture (TEXTURE_GLOSSINESS, P_19).xyz;
    right_6 = tmpvar_20;
    highp vec2 tmpvar_21;
    tmpvar_21.x = 0.0;
    tmpvar_21.y = -(PIXEL_SIZE.y);
    highp vec2 P_22;
    P_22 = (xlv_TEXCOORD1.zw + tmpvar_21);
    lowp vec3 tmpvar_23;
    tmpvar_23 = texture (TEXTURE_GLOSSINESS, P_22).xyz;
    top_5 = tmpvar_23;
    highp vec2 tmpvar_24;
    tmpvar_24.x = 0.0;
    tmpvar_24.y = PIXEL_SIZE.y;
    highp vec2 P_25;
    P_25 = (xlv_TEXCOORD1.zw + tmpvar_24);
    lowp vec3 tmpvar_26;
    tmpvar_26 = texture (TEXTURE_GLOSSINESS, P_25).xyz;
    bot_4 = tmpvar_26;
    highp vec3 tmpvar_27;
    tmpvar_27 = max (max (Middle_8, left_7), max (max (right_6, top_5), bot_4));
    highp float tmpvar_28;
    if ((tmpvar_27.x < 0.5)) {
      tmpvar_28 = max (((RColor_9.x + 
        (2.0 * tmpvar_27.x)
      ) - 1.0), 0.0);
    } else {
      tmpvar_28 = min ((RColor_9.x + (2.0 * 
        (tmpvar_27.x - 0.5)
      )), 1.0);
    };
    highp float tmpvar_29;
    if ((tmpvar_27.y < 0.5)) {
      tmpvar_29 = max (((RColor_9.y + 
        (2.0 * tmpvar_27.y)
      ) - 1.0), 0.0);
    } else {
      tmpvar_29 = min ((RColor_9.y + (2.0 * 
        (tmpvar_27.y - 0.5)
      )), 1.0);
    };
    highp float tmpvar_30;
    if ((tmpvar_27.z < 0.5)) {
      tmpvar_30 = max (((RColor_9.z + 
        (2.0 * tmpvar_27.z)
      ) - 1.0), 0.0);
    } else {
      tmpvar_30 = min ((RColor_9.z + (2.0 * 
        (tmpvar_27.z - 0.5)
      )), 1.0);
    };
    highp vec3 tmpvar_31;
    tmpvar_31.x = tmpvar_28;
    tmpvar_31.y = tmpvar_29;
    tmpvar_31.z = tmpvar_30;
    highp vec4 tmpvar_32;
    tmpvar_32.xyz = mix (RColor_9.xyz, tmpvar_31, vec3(alpha_10));
    tmpvar_32.w = alpha_10;
    tmpvar_1 = tmpvar_32;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_CUSTOM","BLEND_LINEARLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEA",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEB",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec3 COLOR_RANGEA;
uniform highp vec3 COLOR_RANGEB;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp float alpha_5;
    highp vec4 MColor_6;
    lowp vec4 tmpvar_7;
    tmpvar_7 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_6 = tmpvar_7;
    alpha_5 = (MColor_6.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp vec3 tmpvar_9;
    tmpvar_9 = mix (COLOR_RANGEA, COLOR_RANGEB, xlv_TEXCOORD2.xxx);
    highp float tmpvar_10;
    if ((tmpvar_9.x < 0.5)) {
      tmpvar_10 = max (((RColor_4.x + 
        (2.0 * tmpvar_9.x)
      ) - 1.0), 0.0);
    } else {
      tmpvar_10 = min ((RColor_4.x + (2.0 * 
        (tmpvar_9.x - 0.5)
      )), 1.0);
    };
    highp float tmpvar_11;
    if ((tmpvar_9.y < 0.5)) {
      tmpvar_11 = max (((RColor_4.y + 
        (2.0 * tmpvar_9.y)
      ) - 1.0), 0.0);
    } else {
      tmpvar_11 = min ((RColor_4.y + (2.0 * 
        (tmpvar_9.y - 0.5)
      )), 1.0);
    };
    highp float tmpvar_12;
    if ((tmpvar_9.z < 0.5)) {
      tmpvar_12 = max (((RColor_4.z + 
        (2.0 * tmpvar_9.z)
      ) - 1.0), 0.0);
    } else {
      tmpvar_12 = min ((RColor_4.z + (2.0 * 
        (tmpvar_9.z - 0.5)
      )), 1.0);
    };
    highp vec3 tmpvar_13;
    tmpvar_13.x = tmpvar_10;
    tmpvar_13.y = tmpvar_11;
    tmpvar_13.z = tmpvar_12;
    highp vec4 tmpvar_14;
    tmpvar_14.xyz = mix (RColor_4.xyz, tmpvar_13, vec3(alpha_5));
    tmpvar_14.w = alpha_5;
    tmpvar_1 = tmpvar_14;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_ORIGINAL","BLEND_DIFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp vec4 MColor_5;
    lowp vec4 tmpvar_6;
    tmpvar_6 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_5 = tmpvar_6;
    highp float tmpvar_7;
    tmpvar_7 = (MColor_5.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp vec4 tmpvar_9;
    tmpvar_9.xyz = mix (RColor_4.xyz, abs((RColor_4.xyz - MColor_5.xyz)), vec3(tmpvar_7));
    tmpvar_9.w = tmpvar_7;
    tmpvar_1 = tmpvar_9;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_BLEND","BLEND_DIFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIXEL_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec2 PIXEL_SIZE;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec3 bot_4;
    highp vec3 top_5;
    highp vec3 right_6;
    highp vec3 left_7;
    highp vec3 Middle_8;
    highp vec4 RColor_9;
    highp vec4 MColor_10;
    lowp vec4 tmpvar_11;
    tmpvar_11 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_10 = tmpvar_11;
    highp float tmpvar_12;
    tmpvar_12 = (MColor_10.w * OPACITY);
    lowp vec4 tmpvar_13;
    tmpvar_13 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_9 = tmpvar_13;
    lowp vec3 tmpvar_14;
    tmpvar_14 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.zw).xyz;
    Middle_8 = tmpvar_14;
    highp vec2 tmpvar_15;
    tmpvar_15.y = 0.0;
    tmpvar_15.x = -(PIXEL_SIZE.x);
    highp vec2 P_16;
    P_16 = (xlv_TEXCOORD1.zw + tmpvar_15);
    lowp vec3 tmpvar_17;
    tmpvar_17 = texture (TEXTURE_GLOSSINESS, P_16).xyz;
    left_7 = tmpvar_17;
    highp vec2 tmpvar_18;
    tmpvar_18.y = 0.0;
    tmpvar_18.x = PIXEL_SIZE.x;
    highp vec2 P_19;
    P_19 = (xlv_TEXCOORD1.zw + tmpvar_18);
    lowp vec3 tmpvar_20;
    tmpvar_20 = texture (TEXTURE_GLOSSINESS, P_19).xyz;
    right_6 = tmpvar_20;
    highp vec2 tmpvar_21;
    tmpvar_21.x = 0.0;
    tmpvar_21.y = -(PIXEL_SIZE.y);
    highp vec2 P_22;
    P_22 = (xlv_TEXCOORD1.zw + tmpvar_21);
    lowp vec3 tmpvar_23;
    tmpvar_23 = texture (TEXTURE_GLOSSINESS, P_22).xyz;
    top_5 = tmpvar_23;
    highp vec2 tmpvar_24;
    tmpvar_24.x = 0.0;
    tmpvar_24.y = PIXEL_SIZE.y;
    highp vec2 P_25;
    P_25 = (xlv_TEXCOORD1.zw + tmpvar_24);
    lowp vec3 tmpvar_26;
    tmpvar_26 = texture (TEXTURE_GLOSSINESS, P_25).xyz;
    bot_4 = tmpvar_26;
    highp vec4 tmpvar_27;
    tmpvar_27.xyz = mix (RColor_9.xyz, abs((RColor_9.xyz - 
      max (max (Middle_8, left_7), max (max (right_6, top_5), bot_4))
    )), vec3(tmpvar_12));
    tmpvar_27.w = tmpvar_12;
    tmpvar_1 = tmpvar_27;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_CUSTOM","BLEND_DIFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEA",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEB",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec3 COLOR_RANGEA;
uniform highp vec3 COLOR_RANGEB;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp vec4 MColor_5;
    lowp vec4 tmpvar_6;
    tmpvar_6 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_5 = tmpvar_6;
    highp float tmpvar_7;
    tmpvar_7 = (MColor_5.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp vec4 tmpvar_9;
    tmpvar_9.xyz = mix (RColor_4.xyz, abs((RColor_4.xyz - 
      mix (COLOR_RANGEA, COLOR_RANGEB, xlv_TEXCOORD2.xxx)
    )), vec3(tmpvar_7));
    tmpvar_9.w = tmpvar_7;
    tmpvar_1 = tmpvar_9;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_ORIGINAL","BLEND_LINEARBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp vec4 MColor_5;
    lowp vec4 tmpvar_6;
    tmpvar_6 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_5 = tmpvar_6;
    highp float tmpvar_7;
    tmpvar_7 = (MColor_5.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp vec4 tmpvar_9;
    tmpvar_9.xyz = mix (RColor_4.xyz, max ((
      (RColor_4.xyz + MColor_5.xyz)
     - vec3(1.0, 1.0, 1.0)), vec3(0.0, 0.0, 0.0)), vec3(tmpvar_7));
    tmpvar_9.w = tmpvar_7;
    tmpvar_1 = tmpvar_9;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_BLEND","BLEND_LINEARBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIXEL_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec2 PIXEL_SIZE;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec3 bot_4;
    highp vec3 top_5;
    highp vec3 right_6;
    highp vec3 left_7;
    highp vec3 Middle_8;
    highp vec4 RColor_9;
    highp vec4 MColor_10;
    lowp vec4 tmpvar_11;
    tmpvar_11 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_10 = tmpvar_11;
    highp float tmpvar_12;
    tmpvar_12 = (MColor_10.w * OPACITY);
    lowp vec4 tmpvar_13;
    tmpvar_13 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_9 = tmpvar_13;
    lowp vec3 tmpvar_14;
    tmpvar_14 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.zw).xyz;
    Middle_8 = tmpvar_14;
    highp vec2 tmpvar_15;
    tmpvar_15.y = 0.0;
    tmpvar_15.x = -(PIXEL_SIZE.x);
    highp vec2 P_16;
    P_16 = (xlv_TEXCOORD1.zw + tmpvar_15);
    lowp vec3 tmpvar_17;
    tmpvar_17 = texture (TEXTURE_GLOSSINESS, P_16).xyz;
    left_7 = tmpvar_17;
    highp vec2 tmpvar_18;
    tmpvar_18.y = 0.0;
    tmpvar_18.x = PIXEL_SIZE.x;
    highp vec2 P_19;
    P_19 = (xlv_TEXCOORD1.zw + tmpvar_18);
    lowp vec3 tmpvar_20;
    tmpvar_20 = texture (TEXTURE_GLOSSINESS, P_19).xyz;
    right_6 = tmpvar_20;
    highp vec2 tmpvar_21;
    tmpvar_21.x = 0.0;
    tmpvar_21.y = -(PIXEL_SIZE.y);
    highp vec2 P_22;
    P_22 = (xlv_TEXCOORD1.zw + tmpvar_21);
    lowp vec3 tmpvar_23;
    tmpvar_23 = texture (TEXTURE_GLOSSINESS, P_22).xyz;
    top_5 = tmpvar_23;
    highp vec2 tmpvar_24;
    tmpvar_24.x = 0.0;
    tmpvar_24.y = PIXEL_SIZE.y;
    highp vec2 P_25;
    P_25 = (xlv_TEXCOORD1.zw + tmpvar_24);
    lowp vec3 tmpvar_26;
    tmpvar_26 = texture (TEXTURE_GLOSSINESS, P_25).xyz;
    bot_4 = tmpvar_26;
    highp vec4 tmpvar_27;
    tmpvar_27.xyz = mix (RColor_9.xyz, max ((
      (RColor_9.xyz + max (max (Middle_8, left_7), max (max (right_6, top_5), bot_4)))
     - vec3(1.0, 1.0, 1.0)), vec3(0.0, 0.0, 0.0)), vec3(tmpvar_12));
    tmpvar_27.w = tmpvar_12;
    tmpvar_1 = tmpvar_27;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_CUSTOM","BLEND_LINEARBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEA",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEB",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec3 COLOR_RANGEA;
uniform highp vec3 COLOR_RANGEB;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp vec4 MColor_5;
    lowp vec4 tmpvar_6;
    tmpvar_6 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_5 = tmpvar_6;
    highp float tmpvar_7;
    tmpvar_7 = (MColor_5.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp vec4 tmpvar_9;
    tmpvar_9.xyz = mix (RColor_4.xyz, max ((
      (RColor_4.xyz + mix (COLOR_RANGEA, COLOR_RANGEB, xlv_TEXCOORD2.xxx))
     - vec3(1.0, 1.0, 1.0)), vec3(0.0, 0.0, 0.0)), vec3(tmpvar_7));
    tmpvar_9.w = tmpvar_7;
    tmpvar_1 = tmpvar_9;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_ORIGINAL","BLEND_SUB"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp vec4 MColor_5;
    lowp vec4 tmpvar_6;
    tmpvar_6 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_5 = tmpvar_6;
    highp float tmpvar_7;
    tmpvar_7 = (MColor_5.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp vec4 tmpvar_9;
    tmpvar_9.xyz = mix (RColor_4.xyz, max ((RColor_4.xyz - MColor_5.xyz), vec3(0.0, 0.0, 0.0)), vec3(tmpvar_7));
    tmpvar_9.w = tmpvar_7;
    tmpvar_1 = tmpvar_9;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_BLEND","BLEND_SUB"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIXEL_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec2 PIXEL_SIZE;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec3 bot_4;
    highp vec3 top_5;
    highp vec3 right_6;
    highp vec3 left_7;
    highp vec3 Middle_8;
    highp vec4 RColor_9;
    highp vec4 MColor_10;
    lowp vec4 tmpvar_11;
    tmpvar_11 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_10 = tmpvar_11;
    highp float tmpvar_12;
    tmpvar_12 = (MColor_10.w * OPACITY);
    lowp vec4 tmpvar_13;
    tmpvar_13 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_9 = tmpvar_13;
    lowp vec3 tmpvar_14;
    tmpvar_14 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.zw).xyz;
    Middle_8 = tmpvar_14;
    highp vec2 tmpvar_15;
    tmpvar_15.y = 0.0;
    tmpvar_15.x = -(PIXEL_SIZE.x);
    highp vec2 P_16;
    P_16 = (xlv_TEXCOORD1.zw + tmpvar_15);
    lowp vec3 tmpvar_17;
    tmpvar_17 = texture (TEXTURE_GLOSSINESS, P_16).xyz;
    left_7 = tmpvar_17;
    highp vec2 tmpvar_18;
    tmpvar_18.y = 0.0;
    tmpvar_18.x = PIXEL_SIZE.x;
    highp vec2 P_19;
    P_19 = (xlv_TEXCOORD1.zw + tmpvar_18);
    lowp vec3 tmpvar_20;
    tmpvar_20 = texture (TEXTURE_GLOSSINESS, P_19).xyz;
    right_6 = tmpvar_20;
    highp vec2 tmpvar_21;
    tmpvar_21.x = 0.0;
    tmpvar_21.y = -(PIXEL_SIZE.y);
    highp vec2 P_22;
    P_22 = (xlv_TEXCOORD1.zw + tmpvar_21);
    lowp vec3 tmpvar_23;
    tmpvar_23 = texture (TEXTURE_GLOSSINESS, P_22).xyz;
    top_5 = tmpvar_23;
    highp vec2 tmpvar_24;
    tmpvar_24.x = 0.0;
    tmpvar_24.y = PIXEL_SIZE.y;
    highp vec2 P_25;
    P_25 = (xlv_TEXCOORD1.zw + tmpvar_24);
    lowp vec3 tmpvar_26;
    tmpvar_26 = texture (TEXTURE_GLOSSINESS, P_25).xyz;
    bot_4 = tmpvar_26;
    highp vec4 tmpvar_27;
    tmpvar_27.xyz = mix (RColor_9.xyz, max ((RColor_9.xyz - 
      max (max (Middle_8, left_7), max (max (right_6, top_5), bot_4))
    ), vec3(0.0, 0.0, 0.0)), vec3(tmpvar_12));
    tmpvar_27.w = tmpvar_12;
    tmpvar_1 = tmpvar_27;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_CUSTOM","BLEND_SUB"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEA",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEB",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec3 COLOR_RANGEA;
uniform highp vec3 COLOR_RANGEB;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 RColor_4;
    highp vec4 MColor_5;
    lowp vec4 tmpvar_6;
    tmpvar_6 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_5 = tmpvar_6;
    highp float tmpvar_7;
    tmpvar_7 = (MColor_5.w * OPACITY);
    lowp vec4 tmpvar_8;
    tmpvar_8 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_4 = tmpvar_8;
    highp vec4 tmpvar_9;
    tmpvar_9.xyz = mix (RColor_4.xyz, max ((RColor_4.xyz - 
      mix (COLOR_RANGEA, COLOR_RANGEB, xlv_TEXCOORD2.xxx)
    ), vec3(0.0, 0.0, 0.0)), vec3(tmpvar_7));
    tmpvar_9.w = tmpvar_7;
    tmpvar_1 = tmpvar_9;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_ORIGINAL","BLEND_LUT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_LutMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D _LutMap;
uniform sampler2D MaskTex;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec3 resColor_4;
    highp vec4 RColor_5;
    highp vec4 MColor_6;
    lowp vec4 tmpvar_7;
    tmpvar_7 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_6 = tmpvar_7;
    highp float tmpvar_8;
    tmpvar_8 = (MColor_6.w * OPACITY);
    lowp vec4 tmpvar_9;
    tmpvar_9 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_5 = tmpvar_9;
    highp vec3 tmpvar_10;
    tmpvar_10 = RColor_5.xyz;
    highp vec3 tmpvar_11;
    tmpvar_11 = MColor_6.xyz;
    highp vec2 tmpvar_12;
    tmpvar_12.x = tmpvar_11.x;
    tmpvar_12.y = tmpvar_10.x;
    lowp vec4 tmpvar_13;
    tmpvar_13 = texture (_LutMap, tmpvar_12);
    resColor_4.x = tmpvar_13.x;
    highp vec2 tmpvar_14;
    tmpvar_14.x = tmpvar_11.y;
    tmpvar_14.y = tmpvar_10.y;
    lowp vec4 tmpvar_15;
    tmpvar_15 = texture (_LutMap, tmpvar_14);
    resColor_4.y = tmpvar_15.y;
    highp vec2 tmpvar_16;
    tmpvar_16.x = tmpvar_11.z;
    tmpvar_16.y = tmpvar_10.z;
    lowp vec4 tmpvar_17;
    tmpvar_17 = texture (_LutMap, tmpvar_16);
    resColor_4.z = tmpvar_17.z;
    highp vec4 tmpvar_18;
    tmpvar_18.xyz = mix (RColor_5.xyz, resColor_4, vec3(tmpvar_8));
    tmpvar_18.w = tmpvar_8;
    tmpvar_1 = tmpvar_18;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_BLEND","BLEND_LUT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_LutMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIXEL_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D _LutMap;
uniform sampler2D MaskTex;
uniform highp vec2 PIXEL_SIZE;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec3 resColor_4;
    highp vec3 bot_5;
    highp vec3 top_6;
    highp vec3 right_7;
    highp vec3 left_8;
    highp vec3 Middle_9;
    highp vec4 RColor_10;
    highp vec4 MColor_11;
    lowp vec4 tmpvar_12;
    tmpvar_12 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_11 = tmpvar_12;
    highp float tmpvar_13;
    tmpvar_13 = (MColor_11.w * OPACITY);
    lowp vec4 tmpvar_14;
    tmpvar_14 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_10 = tmpvar_14;
    highp vec3 tmpvar_15;
    tmpvar_15 = RColor_10.xyz;
    lowp vec3 tmpvar_16;
    tmpvar_16 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.zw).xyz;
    Middle_9 = tmpvar_16;
    highp vec2 tmpvar_17;
    tmpvar_17.y = 0.0;
    tmpvar_17.x = -(PIXEL_SIZE.x);
    highp vec2 P_18;
    P_18 = (xlv_TEXCOORD1.zw + tmpvar_17);
    lowp vec3 tmpvar_19;
    tmpvar_19 = texture (TEXTURE_GLOSSINESS, P_18).xyz;
    left_8 = tmpvar_19;
    highp vec2 tmpvar_20;
    tmpvar_20.y = 0.0;
    tmpvar_20.x = PIXEL_SIZE.x;
    highp vec2 P_21;
    P_21 = (xlv_TEXCOORD1.zw + tmpvar_20);
    lowp vec3 tmpvar_22;
    tmpvar_22 = texture (TEXTURE_GLOSSINESS, P_21).xyz;
    right_7 = tmpvar_22;
    highp vec2 tmpvar_23;
    tmpvar_23.x = 0.0;
    tmpvar_23.y = -(PIXEL_SIZE.y);
    highp vec2 P_24;
    P_24 = (xlv_TEXCOORD1.zw + tmpvar_23);
    lowp vec3 tmpvar_25;
    tmpvar_25 = texture (TEXTURE_GLOSSINESS, P_24).xyz;
    top_6 = tmpvar_25;
    highp vec2 tmpvar_26;
    tmpvar_26.x = 0.0;
    tmpvar_26.y = PIXEL_SIZE.y;
    highp vec2 P_27;
    P_27 = (xlv_TEXCOORD1.zw + tmpvar_26);
    lowp vec3 tmpvar_28;
    tmpvar_28 = texture (TEXTURE_GLOSSINESS, P_27).xyz;
    bot_5 = tmpvar_28;
    highp vec3 tmpvar_29;
    tmpvar_29 = max (max (Middle_9, left_8), max (max (right_7, top_6), bot_5));
    highp vec2 tmpvar_30;
    tmpvar_30.x = tmpvar_29.x;
    tmpvar_30.y = tmpvar_15.x;
    lowp vec4 tmpvar_31;
    tmpvar_31 = texture (_LutMap, tmpvar_30);
    resColor_4.x = tmpvar_31.x;
    highp vec2 tmpvar_32;
    tmpvar_32.x = tmpvar_29.y;
    tmpvar_32.y = tmpvar_15.y;
    lowp vec4 tmpvar_33;
    tmpvar_33 = texture (_LutMap, tmpvar_32);
    resColor_4.y = tmpvar_33.y;
    highp vec2 tmpvar_34;
    tmpvar_34.x = tmpvar_29.z;
    tmpvar_34.y = tmpvar_15.z;
    lowp vec4 tmpvar_35;
    tmpvar_35 = texture (_LutMap, tmpvar_34);
    resColor_4.z = tmpvar_35.z;
    highp vec4 tmpvar_36;
    tmpvar_36.xyz = mix (RColor_10.xyz, resColor_4, vec3(tmpvar_13));
    tmpvar_36.w = tmpvar_13;
    tmpvar_1 = tmpvar_36;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_CUSTOM","BLEND_LUT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_LutMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEA",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEB",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D _LutMap;
uniform sampler2D MaskTex;
uniform highp vec3 COLOR_RANGEA;
uniform highp vec3 COLOR_RANGEB;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec3 resColor_4;
    highp vec4 RColor_5;
    highp vec4 MColor_6;
    lowp vec4 tmpvar_7;
    tmpvar_7 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_6 = tmpvar_7;
    highp float tmpvar_8;
    tmpvar_8 = (MColor_6.w * OPACITY);
    lowp vec4 tmpvar_9;
    tmpvar_9 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.xy);
    RColor_5 = tmpvar_9;
    highp vec3 tmpvar_10;
    tmpvar_10 = RColor_5.xyz;
    highp vec3 tmpvar_11;
    tmpvar_11 = mix (COLOR_RANGEA, COLOR_RANGEB, xlv_TEXCOORD2.xxx);
    highp vec2 tmpvar_12;
    tmpvar_12.x = tmpvar_11.x;
    tmpvar_12.y = tmpvar_10.x;
    lowp vec4 tmpvar_13;
    tmpvar_13 = texture (_LutMap, tmpvar_12);
    resColor_4.x = tmpvar_13.x;
    highp vec2 tmpvar_14;
    tmpvar_14.x = tmpvar_11.y;
    tmpvar_14.y = tmpvar_10.y;
    lowp vec4 tmpvar_15;
    tmpvar_15 = texture (_LutMap, tmpvar_14);
    resColor_4.y = tmpvar_15.y;
    highp vec2 tmpvar_16;
    tmpvar_16.x = tmpvar_11.z;
    tmpvar_16.y = tmpvar_10.z;
    lowp vec4 tmpvar_17;
    tmpvar_17 = texture (_LutMap, tmpvar_16);
    resColor_4.z = tmpvar_17.z;
    highp vec4 tmpvar_18;
    tmpvar_18.xyz = mix (RColor_5.xyz, resColor_4, vec3(tmpvar_8));
    tmpvar_18.w = tmpvar_8;
    tmpvar_1 = tmpvar_18;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_ORIGINAL","BLEND_ADD"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D MaskTex;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 MColor_4;
    lowp vec4 tmpvar_5;
    tmpvar_5 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_4 = tmpvar_5;
    highp float tmpvar_6;
    tmpvar_6 = (MColor_4.w * OPACITY);
    highp vec4 tmpvar_7;
    tmpvar_7.xyz = (MColor_4.xyz * tmpvar_6);
    tmpvar_7.w = tmpvar_6;
    tmpvar_1 = tmpvar_7;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_BLEND","BLEND_ADD"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_GLOSSINESS",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIXEL_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_GLOSSINESS;
uniform sampler2D MaskTex;
uniform highp vec2 PIXEL_SIZE;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec3 bot_4;
    highp vec3 top_5;
    highp vec3 right_6;
    highp vec3 left_7;
    highp vec3 Middle_8;
    highp vec4 MColor_9;
    lowp vec4 tmpvar_10;
    tmpvar_10 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_9 = tmpvar_10;
    highp float tmpvar_11;
    tmpvar_11 = (MColor_9.w * OPACITY);
    lowp vec3 tmpvar_12;
    tmpvar_12 = texture (TEXTURE_GLOSSINESS, xlv_TEXCOORD1.zw).xyz;
    Middle_8 = tmpvar_12;
    highp vec2 tmpvar_13;
    tmpvar_13.y = 0.0;
    tmpvar_13.x = -(PIXEL_SIZE.x);
    highp vec2 P_14;
    P_14 = (xlv_TEXCOORD1.zw + tmpvar_13);
    lowp vec3 tmpvar_15;
    tmpvar_15 = texture (TEXTURE_GLOSSINESS, P_14).xyz;
    left_7 = tmpvar_15;
    highp vec2 tmpvar_16;
    tmpvar_16.y = 0.0;
    tmpvar_16.x = PIXEL_SIZE.x;
    highp vec2 P_17;
    P_17 = (xlv_TEXCOORD1.zw + tmpvar_16);
    lowp vec3 tmpvar_18;
    tmpvar_18 = texture (TEXTURE_GLOSSINESS, P_17).xyz;
    right_6 = tmpvar_18;
    highp vec2 tmpvar_19;
    tmpvar_19.x = 0.0;
    tmpvar_19.y = -(PIXEL_SIZE.y);
    highp vec2 P_20;
    P_20 = (xlv_TEXCOORD1.zw + tmpvar_19);
    lowp vec3 tmpvar_21;
    tmpvar_21 = texture (TEXTURE_GLOSSINESS, P_20).xyz;
    top_5 = tmpvar_21;
    highp vec2 tmpvar_22;
    tmpvar_22.x = 0.0;
    tmpvar_22.y = PIXEL_SIZE.y;
    highp vec2 P_23;
    P_23 = (xlv_TEXCOORD1.zw + tmpvar_22);
    lowp vec3 tmpvar_24;
    tmpvar_24 = texture (TEXTURE_GLOSSINESS, P_23).xyz;
    bot_4 = tmpvar_24;
    highp vec4 tmpvar_25;
    tmpvar_25.xyz = (max (max (Middle_8, left_7), max (
      max (right_6, top_5)
    , bot_4)) * tmpvar_11);
    tmpvar_25.w = tmpvar_11;
    tmpvar_1 = tmpvar_25;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"COLOR_CUSTOM","BLEND_ADD"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEA",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_RANGEB",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OPACITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.x = _glesMultiTexCoord0.x;
  tmpvar_5.y = (1.0 - _glesMultiTexCoord0.y);
  highp vec2 tmpvar_6;
  tmpvar_6.x = _glesMultiTexCoord1.x;
  tmpvar_6.y = (1.0 - _glesMultiTexCoord1.y);
  tmpvar_2.xy = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_1.z;
  tmpvar_7.y = -(_glesVertex.w);
  tmpvar_2.zw = ((tmpvar_7 / 2.0) + 0.5);
  xlv_TEXCOORD0 = tmpvar_5;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord2.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D MaskTex;
uniform highp vec3 COLOR_RANGEA;
uniform highp vec3 COLOR_RANGEB;
uniform highp float OPACITY;
uniform highp float MASK_VALID;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  highp float MaskAlpha_2;
  lowp float tmpvar_3;
  if ((MASK_VALID > 0.0)) {
    tmpvar_3 = texture (MaskTex, xlv_TEXCOORD1.zw).w;
  } else {
    tmpvar_3 = 1.0;
  };
  MaskAlpha_2 = tmpvar_3;
  if (((MASK_VALID > 0.0) && (MaskAlpha_2 < 1.0))) {
    tmpvar_1 = vec4(0.0, 0.0, 0.0, 0.0);
  } else {
    highp vec4 MColor_4;
    lowp vec4 tmpvar_5;
    tmpvar_5 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
    MColor_4 = tmpvar_5;
    highp float tmpvar_6;
    tmpvar_6 = (MColor_4.w * OPACITY);
    highp vec4 tmpvar_7;
    tmpvar_7.xyz = (mix (COLOR_RANGEA, COLOR_RANGEB, xlv_TEXCOORD2.xxx) * tmpvar_6);
    tmpvar_7.w = tmpvar_6;
    tmpvar_1 = tmpvar_7;
  };
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
}

end
