

function DefineParams()
	Properties = 
	{
		
PIXEL_SIZE = { "PixelSize", VEC2, "1.0,1.0" },
DOWNSAMPLE_FACTOR = { "Downsample Factor", VEC2, "1.0,1.0" },
THRESHOLD = { "THRESHOLD", FLOAT, "1.0" },

OUT_TYPE = {"OUT_TYPE", FLOAT, "0.0"},

	}
	Attributes = 
	{
		OUT_TYPE = "Keywords(RGB,GRAY,BINARY)", 
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "downsample"
RenderQueue = "PostEffect"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {"RGB"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIXEL_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DOWNSAMPLE_FACTOR",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_1 * _glesVertex);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_DIFFUSE;
uniform highp vec2 PIXEL_SIZE;
uniform highp vec2 DOWNSAMPLE_FACTOR;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1 = xlv_TEXCOORD0;
  highp vec4 color_3;
  highp vec2 texcoord_sample_4;
  highp int patchSize_y_5;
  highp int patchSize_x_6;
  highp int tmpvar_7;
  tmpvar_7 = int((1.0/(DOWNSAMPLE_FACTOR.x)));
  patchSize_x_6 = tmpvar_7;
  highp int tmpvar_8;
  tmpvar_8 = int((1.0/(DOWNSAMPLE_FACTOR.y)));
  patchSize_y_5 = tmpvar_8;
  color_3 = vec4(0.0, 0.0, 0.0, 0.0);
  for (highp int col_2 = 0; col_2 < patchSize_x_6; col_2++) {
    texcoord_sample_4.x = (tmpvar_1.x + (float(
(col_2 - (patchSize_x_6 / 2))
) * PIXEL_SIZE.x));
    if ((texcoord_sample_4.x < 0.0)) {
      texcoord_sample_4.x = 0.0;
    };
    if ((texcoord_sample_4.x > 1.0)) {
      texcoord_sample_4.x = 1.0;
    };
    for (highp int row_9 = 0; row_9 < patchSize_y_5; row_9++) {
      texcoord_sample_4.y = (tmpvar_1.y + (float(
        (row_9 - (patchSize_y_5 / 2))
      ) * PIXEL_SIZE.y));
      if ((texcoord_sample_4.y < 0.0)) {
        texcoord_sample_4.y = 0.0;
      };
      if ((texcoord_sample_4.y > 1.0)) {
        texcoord_sample_4.y = 1.0;
      };
      lowp vec4 tmpvar_10;
      tmpvar_10 = texture2D (TEXTURE_DIFFUSE, texcoord_sample_4);
      color_3 = (color_3 + tmpvar_10);
    };
  };
  color_3 = (color_3 / float((tmpvar_7 * tmpvar_8)));
  gl_FragData[0] = color_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GRAY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIXEL_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DOWNSAMPLE_FACTOR",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_1 * _glesVertex);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_DIFFUSE;
uniform highp vec2 PIXEL_SIZE;
uniform highp vec2 DOWNSAMPLE_FACTOR;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1 = xlv_TEXCOORD0;
  highp vec4 color_3;
  highp vec2 texcoord_sample_4;
  highp int patchSize_y_5;
  highp int patchSize_x_6;
  highp int tmpvar_7;
  tmpvar_7 = int((1.0/(DOWNSAMPLE_FACTOR.x)));
  patchSize_x_6 = tmpvar_7;
  highp int tmpvar_8;
  tmpvar_8 = int((1.0/(DOWNSAMPLE_FACTOR.y)));
  patchSize_y_5 = tmpvar_8;
  color_3 = vec4(0.0, 0.0, 0.0, 0.0);
  for (highp int col_2 = 0; col_2 < patchSize_x_6; col_2++) {
    texcoord_sample_4.x = (tmpvar_1.x + (float(
(col_2 - (patchSize_x_6 / 2))
) * PIXEL_SIZE.x));
    if ((texcoord_sample_4.x < 0.0)) {
      texcoord_sample_4.x = 0.0;
    };
    if ((texcoord_sample_4.x > 1.0)) {
      texcoord_sample_4.x = 1.0;
    };
    for (highp int row_9 = 0; row_9 < patchSize_y_5; row_9++) {
      texcoord_sample_4.y = (tmpvar_1.y + (float(
        (row_9 - (patchSize_y_5 / 2))
      ) * PIXEL_SIZE.y));
      if ((texcoord_sample_4.y < 0.0)) {
        texcoord_sample_4.y = 0.0;
      };
      if ((texcoord_sample_4.y > 1.0)) {
        texcoord_sample_4.y = 1.0;
      };
      lowp vec4 tmpvar_10;
      tmpvar_10 = texture2D (TEXTURE_DIFFUSE, texcoord_sample_4);
      highp float tmpvar_11;
      tmpvar_11 = dot (tmpvar_10.xyz, vec3(0.2125, 0.7154, 0.0721));
      highp vec4 tmpvar_12;
      tmpvar_12.w = 1.0;
      tmpvar_12.x = tmpvar_11;
      tmpvar_12.y = tmpvar_11;
      tmpvar_12.z = tmpvar_11;
      color_3 = (color_3 + tmpvar_12);
    };
  };
  color_3 = (color_3 / float((tmpvar_7 * tmpvar_8)));
  gl_FragData[0] = color_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BINARY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIXEL_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DOWNSAMPLE_FACTOR",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "THRESHOLD",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_1 * _glesVertex);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_DIFFUSE;
uniform highp vec2 PIXEL_SIZE;
uniform highp vec2 DOWNSAMPLE_FACTOR;
uniform highp float THRESHOLD;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1 = xlv_TEXCOORD0;
  highp vec4 color_3;
  highp vec2 texcoord_sample_4;
  highp int patchSize_y_5;
  highp int patchSize_x_6;
  highp int tmpvar_7;
  tmpvar_7 = int((1.0/(DOWNSAMPLE_FACTOR.x)));
  patchSize_x_6 = tmpvar_7;
  highp int tmpvar_8;
  tmpvar_8 = int((1.0/(DOWNSAMPLE_FACTOR.y)));
  patchSize_y_5 = tmpvar_8;
  color_3 = vec4(0.0, 0.0, 0.0, 0.0);
  for (highp int col_2 = 0; col_2 < patchSize_x_6; col_2++) {
    texcoord_sample_4.x = (tmpvar_1.x + (float(
(col_2 - (patchSize_x_6 / 2))
) * PIXEL_SIZE.x));
    if ((texcoord_sample_4.x < 0.0)) {
      texcoord_sample_4.x = 0.0;
    };
    if ((texcoord_sample_4.x > 1.0)) {
      texcoord_sample_4.x = 1.0;
    };
    for (highp int row_9 = 0; row_9 < patchSize_y_5; row_9++) {
      texcoord_sample_4.y = (tmpvar_1.y + (float(
        (row_9 - (patchSize_y_5 / 2))
      ) * PIXEL_SIZE.y));
      if ((texcoord_sample_4.y < 0.0)) {
        texcoord_sample_4.y = 0.0;
      };
      if ((texcoord_sample_4.y > 1.0)) {
        texcoord_sample_4.y = 1.0;
      };
      lowp vec4 tmpvar_10;
      tmpvar_10 = texture2D (TEXTURE_DIFFUSE, texcoord_sample_4);
      highp float tmpvar_11;
      tmpvar_11 = dot (tmpvar_10.xyz, vec3(0.2125, 0.7154, 0.0721));
      highp vec4 tmpvar_12;
      tmpvar_12.w = 1.0;
      tmpvar_12.x = tmpvar_11;
      tmpvar_12.y = tmpvar_11;
      tmpvar_12.z = tmpvar_11;
      color_3 = (color_3 + tmpvar_12);
    };
  };
  color_3 = (color_3 / float((tmpvar_7 * tmpvar_8)));
  highp float tmpvar_13;
  tmpvar_13 = float((color_3.x >= THRESHOLD));
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.x = tmpvar_13;
  tmpvar_14.y = tmpvar_13;
  tmpvar_14.z = tmpvar_13;
  color_3 = tmpvar_14;
  gl_FragData[0] = tmpvar_14;
}

]===],
	},
}

end
