

#DEFPARAMS
POINT_COLOR = { "Color ", VEC4, "1.0, 1.0, 1.0, 1.0" },
#END

#DEFTAG
ShaderName = "gizmo"
RenderQueue = "Transparent"
#END

#DEFPASS ForwardBase
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA , SRC_ALPHA, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS } 
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { FORWARDBASE }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata   
{
	float4 vertex : POSITION;
};

struct v2f
{
	float4 vertex : SV_POSITION;
};

float4 POINT_COLOR;


v2f vert(appdata v)
{
	v2f o;
	o.vertex = WorldToClipPos(v.vertex);
  o.vertex = UniformNDC(o.vertex);
	return o;
}

float4 frag(v2f i) : SV_Target
{
    return POINT_COLOR;
}
ENDCG
#END
