

#DEFPARAMS

#END

#DEFTAG
ShaderName = "Gauss"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE;
float SIGMA;  
float2 GAUSSIAN_STEP;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
    float halfWidth = min(SIGMA * 5, 100);
    float sigma = 0.5 + SIGMA;
    float twoSigma2 = 5.0 * sigma;

    float2 inCoord = i.uv;
    float3 acum = tex2D(TEXTURE_DIFFUSE, inCoord).rgb;
    float norm = 1.0;
    for ( float k = 1.0; k <= halfWidth; k++ )
    {
        float kern = exp( -k*k/ twoSigma2 );
        float2 step = GAUSSIAN_STEP * k;
        float3 loca = tex2D(TEXTURE_DIFFUSE, inCoord + step).rgb+tex2D(TEXTURE_DIFFUSE, inCoord - step).rgb;
        norm += 2.0*kern;
        acum += kern * loca;
    }
    acum = acum/norm;
    float4 finalColor = float4(acum, tex2D(TEXTURE_DIFFUSE, inCoord ).w);
    return finalColor;
}
ENDCG
#END
