#DEFPARAMS
COLOR = { "COLOR", VEC3, "0.2, 0.9, 0.2" },
#END

#DEFTAG
ShaderName = "DebugPhysics"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};


struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

float3 COLOR;
v2f vert(appdata v)
{
	v2f o;
	float4 in_Position = v.vertex;
    float4x4 in_Transfrom = LOCALWORLD_TRANSFORM;
    float4x4 in_ViewPorj = CAMERA_VIEWPROJ;
    float4x4 in_ViewMatrix = CAMERA_VIEW;
    float4 out_PositionWS  = mul(in_Transfrom, in_Position);
	float4 out_Position = mul(in_ViewPorj, out_PositionWS);
	o.vertex = UniformNDC(out_Position);
	o.uv = v.uv.xy;
	return o;
}

float4 frag(v2f i) : SV_Target
{
    return float4(COLOR, 1.0);
}
ENDCG
#END