

#DEFPARAMS
ALPHA_ZOOMSCALE = { "ZoomScale", FLOAT, "100.0" },
ALPHA_ALPHAVALUE = { "AlphaValue", FLOAT, "0.0" },
ALPHA_XYOFFSET = { "XYOffset", VEC2, "0.0,0.0" },
#END

#DEFTAG
ShaderName = "AlphaChange"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE;
float ALPHA_ZOOMSCALE;
float ALPHA_ALPHAVALUE;
float2 ALPHA_XYOFFSET;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
	float zoomScale = ALPHA_ZOOMSCALE * 0.01f;
	float alpha = ALPHA_ALPHAVALUE;
	float2 coord = i.uv - float2(0.5,0.5);
	coord = coord / zoomScale + float2(0.5,0.5) + ALPHA_XYOFFSET;
	float4 color1 = tex2D(TEXTURE_DIFFUSE, i.uv).rgba;
	float4 color2 = tex2D(TEXTURE_DIFFUSE, coord);
	return color1 * (1.0 - alpha) + color2 * alpha;
}
ENDCG
#END
