#SHADER_DEFINE SoulhitVertex

	FUNCTION_INPUT = 
	{
    { ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    gl_Position = in_Position;
    vec2 out_TexCooridate = in_TexCooridate.xy;
#END_CODE
#END_DEFINE


#SHADER_DEFINE SoulhitFragment  

	FUNCTION_INPUT = 
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"uniCurrentTexture" },
    { ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
    { COUNT, 		HIGH,	FLOAT,		"count"},
    { AMPLIFY_SCALE, 		HIGH,	FLOAT,		"amplify_scale"},
	}

#SHADER_CODE

    float time = (count + 1.0)/5.0;
    float scale1 = time*amplify_scale;  
    float alpha1 = max(0.0,0.5 - (time/0.3)*0.5);
    //vec2 newCoord1 = (in_TexCooridate - vec2(0.5))*scale1+ vec2(0.5);   //收张的效果
    vec2 newCoord1 = (in_TexCooridate - vec2(0.5))/(1.0+scale1)+ vec2(0.5); //放大的效果
    vec3 newrgb1 = texture2D(uniCurrentTexture,newCoord1).rgb;
    vec3 rgb = texture2D(uniCurrentTexture,in_TexCooridate).rgb;
    rgb = mix(rgb,newrgb1,alpha1);
    gl_FragColor = vec4(rgb,1.0);
    
    
    
#END_CODE
#END_DEFINE